/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.web.http;

import java.io.OutputStream;
import java.net.URLDecoder;
import java.util.Iterator;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.engine.IParameterProvider;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.engine.core.solution.SimpleParameterProvider;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.SimpleContentGenerator;
import org.pentaho.platform.engine.services.solution.SimpleParameterSetter;
import org.pentaho.platform.util.messages.LocaleHelper;
import org.pentaho.platform.web.http.ActionSequenceContentGenerator;
import org.pentaho.platform.web.http.api.resources.XactionUtil;

public class ActionSequenceParameterUiContentGenerator
extends SimpleContentGenerator {
    private static final long serialVersionUID = 458870144807597675L;
    private IParameterProvider requestParameters;
    private IParameterProvider pathParameters;
    private String path = null;

    public void createContent(OutputStream outputStream) throws Exception {
        IParameterProvider requestParams = this.getRequestParameters();
        IParameterProvider pathParams = this.getPathParameters();
        if (requestParams != null && requestParams.getStringParameter("path", null) != null) {
            this.path = URLDecoder.decode(requestParams.getStringParameter("path", ""), "UTF-8");
        } else if (pathParams != null && pathParams.getStringParameter("path", null) != null) {
            this.path = URLDecoder.decode(pathParams.getStringParameter("path", ""), "UTF-8");
        }
        if (this.path != null && this.path.length() > 0) {
            IUnifiedRepository unifiedRepository = (IUnifiedRepository)PentahoSystem.get(IUnifiedRepository.class, null);
            RepositoryFile file = unifiedRepository.getFile(this.path);
            HttpServletRequest httpRequest = (HttpServletRequest)pathParams.getParameter("httprequest");
            HttpServletResponse httpResponse = (HttpServletResponse)pathParams.getParameter("httpresponse");
            String buffer = XactionUtil.executeScheduleUi(file, httpRequest, httpResponse, PentahoSessionHolder.getSession(), this.outputHandler.getMimeTypeListener());
            outputStream.write(buffer.toString().getBytes(LocaleHelper.getSystemEncoding()));
        }
    }

    public String getMimeType() {
        return "text/html";
    }

    public Log getLogger() {
        return LogFactory.getLog(ActionSequenceContentGenerator.class);
    }

    private IParameterProvider getRequestParameters() {
        if (this.requestParameters != null) {
            return this.requestParameters;
        }
        if (this.parameterProviders == null) {
            return new SimpleParameterProvider();
        }
        IParameterProvider requestParams = (IParameterProvider)this.parameterProviders.get("request");
        SimpleParameterSetter parameters = new SimpleParameterSetter();
        Iterator requestParamIterator = requestParams.getParameterNames();
        while (requestParamIterator.hasNext()) {
            String param = (String)requestParamIterator.next();
            parameters.setParameter(param, requestParams.getParameter(param));
        }
        this.requestParameters = parameters;
        return parameters;
    }

    public IParameterProvider getPathParameters() {
        if (this.pathParameters != null) {
            return this.pathParameters;
        }
        IParameterProvider pathParams = (IParameterProvider)this.parameterProviders.get("path");
        SimpleParameterSetter parameters = new SimpleParameterSetter();
        Iterator pathParamIterator = pathParams.getParameterNames();
        while (pathParamIterator.hasNext()) {
            String param = (String)pathParamIterator.next();
            parameters.setParameter(param, pathParams.getParameter(param));
        }
        this.pathParameters = parameters;
        return parameters;
    }
}

