/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.security.userrole.ldap;

import org.pentaho.platform.api.engine.security.IAuthenticationRoleMapper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.springframework.ldap.core.DirContextOperations;
import org.springframework.security.Authentication;
import org.springframework.security.AuthenticationException;
import org.springframework.security.AuthenticationServiceException;
import org.springframework.security.GrantedAuthority;
import org.springframework.security.GrantedAuthorityImpl;
import org.springframework.security.ldap.LdapAuthoritiesPopulator;
import org.springframework.security.providers.ldap.LdapAuthenticationProvider;
import org.springframework.security.providers.ldap.LdapAuthenticator;

public class DefaultLdapAuthenticationProvider
extends LdapAuthenticationProvider {
    private IAuthenticationRoleMapper roleMapper;
    private String authenticatedRole;

    public DefaultLdapAuthenticationProvider(LdapAuthenticator authenticator, IAuthenticationRoleMapper roleMapper) {
        super(authenticator);
        this.roleMapper = roleMapper;
        this.setAuthenticatedRole(null);
    }

    public DefaultLdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator, IAuthenticationRoleMapper roleMapper) {
        super(authenticator, authoritiesPopulator);
        this.roleMapper = roleMapper;
        this.setAuthenticatedRole(null);
    }

    public DefaultLdapAuthenticationProvider(LdapAuthenticator authenticator, LdapAuthoritiesPopulator authoritiesPopulator, IAuthenticationRoleMapper roleMapper, String authenticatedRole) {
        super(authenticator, authoritiesPopulator);
        this.roleMapper = roleMapper;
        this.setAuthenticatedRole(authenticatedRole);
    }

    protected GrantedAuthority[] loadUserAuthorities(DirContextOperations userData, String username, String password) {
        GrantedAuthority[] authorities = super.loadUserAuthorities(userData, username, password);
        if (this.roleMapper != null) {
            for (int i = 0; i < authorities.length; ++i) {
                if (authorities[i] == null) continue;
                authorities[i] = new GrantedAuthorityImpl(this.roleMapper.toPentahoRole(authorities[i].getAuthority()));
            }
        }
        return authorities;
    }

    public Authentication authenticate(Authentication authentication) throws AuthenticationException {
        Authentication authenticate = super.authenticate(authentication);
        for (GrantedAuthority authority : authenticate.getAuthorities()) {
            if (!authority.getAuthority().equals(this.authenticatedRole)) continue;
            return authenticate;
        }
        throw new AuthenticationServiceException("The user doesn't have '" + this.authenticatedRole + "' role.");
    }

    private void setAuthenticatedRole(String authenticatedRole) {
        this.authenticatedRole = authenticatedRole == null ? (String)PentahoSystem.get(String.class, (String)"singleTenantAuthenticatedAuthorityName", null) : authenticatedRole;
    }
}

