/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.api.repository2.unified.RepositoryFile;
import org.pentaho.platform.plugin.services.importexport.BaseExportProcessor;
import org.pentaho.platform.plugin.services.importexport.ExportException;
import org.pentaho.platform.plugin.services.importexport.ExportHandler;

public class SimpleExportProcessor
extends BaseExportProcessor {
    private static final Log log = LogFactory.getLog(SimpleExportProcessor.class);
    private String path;
    IUnifiedRepository unifiedRepository;

    public SimpleExportProcessor(String path, IUnifiedRepository repository) {
        this.path = StringUtils.isEmpty((String)path) ? "/" : path;
        this.unifiedRepository = repository;
    }

    @Override
    public File performExport(RepositoryFile exportRepositoryFile) throws ExportException, IOException {
        File exportFile = null;
        exportFile = File.createTempFile("repoExport", ".zip");
        exportFile.deleteOnExit();
        String filePath = new File(this.path).getParent();
        if (exportRepositoryFile == null) {
            throw new FileNotFoundException("JCR file not found: " + this.path);
        }
        FileOutputStream os = new FileOutputStream(exportFile);
        try {
            this.exportFile(exportRepositoryFile, os, filePath);
        }
        catch (Exception e) {
            log.error((Object)e.getMessage());
            throw new ExportException();
        }
        finally {
            ((OutputStream)os).close();
        }
        os = null;
        return exportFile;
    }

    @Override
    public void exportDirectory(RepositoryFile repositoryDir, OutputStream outputStream, String filePath) throws ExportException, IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public void exportFile(RepositoryFile repositoryFile, OutputStream outputStream, String filePath) throws ExportException, IOException {
        for (ExportHandler exportHandler : this.exportHandlerList) {
            InputStream is = exportHandler.doExport(repositoryFile, filePath);
            if (is == null) continue;
            IOUtils.copy((InputStream)is, (OutputStream)outputStream);
            is.close();
        }
    }
}

