/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importexport;

import com.sun.jersey.api.client.Client;
import com.sun.jersey.api.client.ClientResponse;
import com.sun.jersey.api.client.WebResource;
import com.sun.jersey.api.client.config.ClientConfig;
import com.sun.jersey.api.client.config.DefaultClientConfig;
import com.sun.jersey.api.client.filter.ClientFilter;
import com.sun.jersey.api.client.filter.HTTPBasicAuthFilter;
import com.sun.jersey.core.header.ContentDisposition;
import com.sun.jersey.core.header.FormDataContentDisposition;
import com.sun.jersey.multipart.FormDataMultiPart;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import javax.ws.rs.core.MediaType;
import javax.xml.namespace.QName;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.Service;
import javax.xml.ws.soap.SOAPBinding;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.PosixParser;
import org.apache.commons.io.FileUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.plugin.services.importexport.InitializationException;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository2.unified.webservices.jaxws.IUnifiedRepositoryJaxwsWebService;
import org.pentaho.platform.repository2.unified.webservices.jaxws.UnifiedRepositoryToWebServiceAdapter;
import org.pentaho.platform.util.RepositoryPathEncoder;

public class CommandLineProcessor {
    private static final String API_REPO_FILES_IMPORT = "/api/repo/files/import";
    private static final String ANALYSIS_DATASOURCE_IMPORT = "/plugin/data-access/api/mondrian/postAnalysis";
    private static final String METADATA_DATASOURCE_IMPORT = "/plugin/data-access/api/metadata/postimport";
    private static final String METADATA_DATASOURCE_EXT = "xmi";
    private static final String ZIP_EXT = "zip";
    private static final Log log = LogFactory.getLog(CommandLineProcessor.class);
    private static final Options options = new Options();
    private static Exception exception;
    private CommandLine commandLine;
    private RequestType requestType;
    private IUnifiedRepository repository;
    private static Client client;

    public static void main(String[] args) throws Exception {
        try {
            exception = null;
            CommandLineProcessor commandLineProcessor = new CommandLineProcessor(args);
            switch (commandLineProcessor.getRequestType()) {
                case HELP: {
                    CommandLineProcessor.printHelp();
                    break;
                }
                case IMPORT: {
                    commandLineProcessor.performImport();
                    break;
                }
                case EXPORT: {
                    commandLineProcessor.performExport();
                    break;
                }
                case REST: {
                    commandLineProcessor.performREST();
                }
            }
        }
        catch (ParseException parseException) {
            exception = parseException;
            System.err.println(parseException.getLocalizedMessage());
            System.out.println(parseException.getLocalizedMessage());
            CommandLineProcessor.printHelp();
            log.error((Object)parseException.getMessage(), (Throwable)parseException);
        }
        catch (Exception e) {
            exception = e;
            e.printStackTrace();
            log.error((Object)e.getMessage(), (Throwable)e);
        }
    }

    private void performREST() throws ParseException, InitializationException {
        String contextURL = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_NAME"), true, false);
        String path = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PATH_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PATH_NAME"), true, false);
        String logFile = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_LOGFILE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_LOGFILE_NAME"), false, true);
        String exportURL = contextURL + "/api/repo/files/";
        if (path != null) {
            String effPath = RepositoryPathEncoder.encodeRepositoryPath((String)path);
            exportURL = exportURL + effPath;
        }
        String service = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_SERVICE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_SERVICE_NAME"), true, false);
        String params = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PARAMS_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PARAMS_NAME"), false, true);
        exportURL = exportURL + "/" + service;
        if (params != null) {
            exportURL = exportURL + "?params=" + params;
        }
        this.initRestService();
        WebResource resource = client.resource(exportURL);
        WebResource.Builder builder = (WebResource.Builder)resource.type("application/json").type(MediaType.TEXT_XML_TYPE);
        ClientResponse response = (ClientResponse)builder.put(ClientResponse.class);
        if (response != null && response.getStatus() == 200) {
            String message = Messages.getInstance().getString("CommandLineProcessor.INFO_REST_COMPLETED").concat("\n");
            message = message + Messages.getInstance().getString("CommandLineProcessor.INFO_REST_RESPONSE_STATUS", new Object[]{response.getStatus()});
            message = message + "\n";
            if (logFile != null && !"".equals(logFile)) {
                message = message + Messages.getInstance().getString("CommandLineProcessor.INFO_REST_FILE_WRITTEN", new Object[]{logFile});
                System.out.println(message);
                this.writeFile(message, logFile);
            }
        } else {
            System.out.println(Messages.getInstance().getErrorString("CommandLineProcessor.ERROR_0002_INVALID_RESPONSE"));
        }
    }

    private void initRestService() throws ParseException, InitializationException {
        String username = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_USERNAME_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_USERNAME_NAME"), true, false);
        String password = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PASSWORD_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PASSWORD_NAME"), true, false);
        DefaultClientConfig clientConfig = new DefaultClientConfig();
        clientConfig.getFeatures().put("com.sun.jersey.api.json.POJOMappingFeature", Boolean.TRUE);
        client = Client.create((ClientConfig)clientConfig);
        client.addFilter((ClientFilter)new HTTPBasicAuthFilter(username, password));
        String contextURL = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_NAME"), true, false);
        WebResource resource = client.resource(contextURL + "/api/authorization/action/isauthorized?authAction=" + "org.pentaho.security.administerSecurity");
        String response = (String)resource.get(String.class);
        if (!response.equals("true")) {
            throw new InitializationException(Messages.getInstance().getString("CommandLineProcessor.ERROR_0006_NON_ADMIN_CREDENTIALS"));
        }
    }

    public static Exception getException() {
        return exception;
    }

    protected CommandLineProcessor(String[] args) throws ParseException {
        this.commandLine = new PosixParser().parse(options, args);
        if (this.commandLine.hasOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_HELP_NAME")) || this.commandLine.hasOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_HELP_KEY"))) {
            this.requestType = RequestType.HELP;
        } else if (this.commandLine.hasOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_REST_NAME")) || this.commandLine.hasOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_REST_KEY"))) {
            this.requestType = RequestType.REST;
        } else {
            boolean exportRequest;
            boolean importRequest = this.commandLine.hasOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_IMPORT_KEY"));
            if (importRequest == (exportRequest = this.commandLine.hasOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_EXPORT_KEY")))) {
                throw new ParseException(Messages.getInstance().getErrorString("CommandLineProcessor.ERROR_0003_PARSE_EXCEPTION"));
            }
            this.requestType = importRequest ? RequestType.IMPORT : RequestType.EXPORT;
        }
    }

    protected RequestType getRequestType() {
        return this.requestType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performMetadataDatasourceImport(String contextURL, File metadataDatasourceFile, String overwrite) throws ParseException, IOException {
        File metadataFileInZip = null;
        InputStream metadataFileInZipInputStream = null;
        String metadataImportURL = contextURL + METADATA_DATASOURCE_IMPORT;
        String domainId = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_METADATA_DOMAIN_ID_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_METADATA_DOMAIN_ID_NAME"), true, false);
        WebResource resource = client.resource(metadataImportURL);
        FormDataMultiPart part = new FormDataMultiPart();
        String name = RepositoryFilenameUtils.separatorsToRepository((String)metadataDatasourceFile.getName());
        String ext = RepositoryFilenameUtils.getExtension((String)name);
        try {
            if (ext.equals(ZIP_EXT)) {
                ZipInputStream zipInputStream = new ZipInputStream(new FileInputStream(metadataDatasourceFile));
                ZipEntry entry = zipInputStream.getNextEntry();
                while (entry != null) {
                    boolean isDir;
                    String entryName = RepositoryFilenameUtils.separatorsToRepository((String)entry.getName());
                    String extension = RepositoryFilenameUtils.getExtension((String)entryName);
                    File tempFile = null;
                    boolean bl = isDir = entry.getSize() == 0L;
                    if (!isDir) {
                        tempFile = File.createTempFile(ZIP_EXT, null);
                        tempFile.deleteOnExit();
                        FileOutputStream fos = new FileOutputStream(tempFile);
                        IOUtils.copy((InputStream)zipInputStream, (OutputStream)fos);
                        fos.close();
                    }
                    if (extension.equals(METADATA_DATASOURCE_EXT) && metadataFileInZip == null) {
                        metadataFileInZip = new File(entryName);
                        metadataFileInZipInputStream = new FileInputStream(metadataFileInZip);
                    }
                    zipInputStream.closeEntry();
                    entry = zipInputStream.getNextEntry();
                }
                zipInputStream.close();
                part.field("overwrite", (Object)("true".equals(overwrite) ? "true" : "false"), MediaType.MULTIPART_FORM_DATA_TYPE);
                part.field("domainId", (Object)domainId, MediaType.MULTIPART_FORM_DATA_TYPE).field("metadataFile", (Object)metadataFileInZipInputStream, MediaType.MULTIPART_FORM_DATA_TYPE);
                part.getField("metadataFile").setContentDisposition((ContentDisposition)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"metadataFile").fileName(metadataFileInZip.getName())).build());
                ClientResponse response = (ClientResponse)resource.type("multipart/form-data").post(ClientResponse.class, (Object)part);
                if (response != null) {
                    String message = (String)response.getEntity(String.class);
                    System.out.println(Messages.getInstance().getString("CommandLineProcessor.INFO_REST_RESPONSE_RECEIVED", new Object[]{message}));
                }
            } else {
                FileInputStream metadataDatasourceInputStream = new FileInputStream(metadataDatasourceFile);
                part.field("overwrite", (Object)("true".equals(overwrite) ? "true" : "false"), MediaType.MULTIPART_FORM_DATA_TYPE);
                part.field("domainId", (Object)domainId, MediaType.MULTIPART_FORM_DATA_TYPE).field("metadataFile", (Object)metadataDatasourceInputStream, MediaType.MULTIPART_FORM_DATA_TYPE);
                part.getField("metadataFile").setContentDisposition((ContentDisposition)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"metadataFile").fileName(metadataDatasourceFile.getName())).build());
                ClientResponse response = (ClientResponse)resource.type("multipart/form-data").post(ClientResponse.class, (Object)part);
                if (response != null) {
                    String message = (String)response.getEntity(String.class);
                    System.out.println(Messages.getInstance().getString("CommandLineProcessor.INFO_REST_RESPONSE_RECEIVED", new Object[]{message}));
                }
                metadataDatasourceInputStream.close();
            }
        }
        finally {
            metadataFileInZipInputStream.close();
            part.cleanup();
        }
    }

    private void performAnalysisDatasourceImport(String contextURL, File analysisDatasourceFile, String overwrite) throws ParseException, IOException {
        String analysisImportURL = contextURL + ANALYSIS_DATASOURCE_IMPORT;
        String catalogName = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_ANALYSIS_CATALOG_Key"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_ANALYSIS_CATALOG_NAME"), false, true);
        String datasourceName = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_ANALYSIS_DATASOURCE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_ANALYSIS_DATASOURCE_NAME"), false, true);
        String xmlaEnabledFlag = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_ANALYSIS_XMLA_ENABLED_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_DATASOURCE_ANALYSIS_XMLA_ENABLED_NAME"), false, true);
        WebResource resource = client.resource(analysisImportURL);
        FileInputStream inputStream = new FileInputStream(analysisDatasourceFile);
        String parms = "Datasource=" + datasourceName + ";overwrite=" + overwrite;
        FormDataMultiPart part = new FormDataMultiPart();
        part.field("overwrite", (Object)("true".equals(overwrite) ? "true" : "false"), MediaType.MULTIPART_FORM_DATA_TYPE);
        if (catalogName != null) {
            part.field("catalogName", (Object)catalogName, MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        if (datasourceName != null) {
            part.field("datasourceName", (Object)datasourceName, MediaType.MULTIPART_FORM_DATA_TYPE);
        }
        part.field("parameters", (Object)parms, MediaType.MULTIPART_FORM_DATA_TYPE);
        part.field("xmlaEnabledFlag", (Object)("true".equals(xmlaEnabledFlag) ? "true" : "false"), MediaType.MULTIPART_FORM_DATA_TYPE);
        part.field("uploadAnalysis", (Object)inputStream, MediaType.MULTIPART_FORM_DATA_TYPE);
        part.getField("uploadAnalysis").setContentDisposition((ContentDisposition)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"uploadAnalysis").fileName(analysisDatasourceFile.getName())).build());
        ClientResponse response = (ClientResponse)resource.type("multipart/form-data").post(ClientResponse.class, (Object)part);
        if (response != null) {
            String message = (String)response.getEntity(String.class);
            response.close();
            System.out.println(Messages.getInstance().getString("CommandLineProcessor.INFO_REST_RESPONSE_RECEIVED", new Object[]{message}));
        }
        inputStream.close();
        part.cleanup();
    }

    private void performDatasourceImport() throws ParseException, IOException {
        String contextURL = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_Key"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_NAME"), true, false);
        String filePath = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_FILEPATH_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_FILEPATH_NAME"), true, false);
        String datasourceType = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_DATASOURCE_TYPE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_DATASOURCE_TYPE_NAME"), true, false);
        String overwrite = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_OVERWRITE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_OVERWRITE_NAME"), false, true);
        try {
            this.initRestService();
            File file = new File(filePath);
            if (datasourceType != null) {
                if (datasourceType.equals(DatasourceType.ANALYSIS.name())) {
                    this.performAnalysisDatasourceImport(contextURL, file, overwrite);
                } else if (datasourceType.equals(DatasourceType.METADATA.name())) {
                    this.performMetadataDatasourceImport(contextURL, file, overwrite);
                }
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
            log.error((Object)e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void performImport() throws ParseException, IOException {
        String contextURL = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_Key"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_NAME"), true, false);
        String filePath = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_FILEPATH_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_FILEPATH_NAME"), true, false);
        String resourceType = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_RESOURCE_TYPE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_RESOURCE_TYPE_NAME"), false, true);
        if (resourceType != null && resourceType.equals(ResourceType.DATASOURCE.name())) {
            this.performDatasourceImport();
        } else {
            String charSet = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_CHARSET_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_CHARSET_NAME"), false, true);
            String logFile = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_LOGFILE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_LOGFILE_NAME"), false, true);
            String path = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PATH_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PATH_NAME"), true, false);
            String importURL = contextURL + API_REPO_FILES_IMPORT;
            File fileIS = new File(filePath);
            FileInputStream in = new FileInputStream(fileIS);
            FormDataMultiPart part = new FormDataMultiPart();
            try {
                this.initRestService();
                WebResource resource = client.resource(importURL);
                String overwrite = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_OVERWRITE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_OVERWRITE_NAME"), true, false);
                String retainOwnership = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_RETAIN_OWNERSHIP_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_RETAIN_OWNERSHIP_NAME"), true, false);
                String permission = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PERMISSION_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PERMISSION_NAME"), true, false);
                part.field("importDir", (Object)path, MediaType.MULTIPART_FORM_DATA_TYPE);
                part.field("overwriteAclPermissions", (Object)("true".equals(overwrite) ? "true" : "false"), MediaType.MULTIPART_FORM_DATA_TYPE);
                part.field("retainOwnership", (Object)("true".equals(retainOwnership) ? "true" : "false"), MediaType.MULTIPART_FORM_DATA_TYPE);
                part.field("charSet", charSet == null ? "UTF-8" : charSet);
                part.field("applyAclPermissions", (Object)("true".equals(permission) ? "true" : "false"), MediaType.MULTIPART_FORM_DATA_TYPE).field("fileUpload", (Object)in, MediaType.MULTIPART_FORM_DATA_TYPE);
                part.getField("fileUpload").setContentDisposition((ContentDisposition)((FormDataContentDisposition.FormDataContentDispositionBuilder)FormDataContentDisposition.name((String)"fileUpload").fileName(fileIS.getName())).build());
                ClientResponse response = (ClientResponse)resource.type("multipart/form-data").post(ClientResponse.class, (Object)part);
                if (response != null) {
                    String message = (String)response.getEntity(String.class);
                    System.out.println(Messages.getInstance().getString("CommandLineProcessor.INFO_REST_RESPONSE_RECEIVED", new Object[]{message}));
                    if (logFile != null && !"".equals(logFile)) {
                        this.writeFile(message, logFile);
                    }
                    response.close();
                }
            }
            catch (Exception e) {
                System.err.println(e.getMessage());
                log.error((Object)e.getMessage());
                this.writeFile(e.getMessage(), logFile);
            }
            finally {
                client.destroy();
                part.cleanup();
                ((InputStream)in).close();
            }
        }
    }

    private void performExport() throws ParseException, IOException, InitializationException {
        String contextURL = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_NAME"), true, false);
        String path = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PATH_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PATH_NAME"), true, false);
        String withManifest = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_WITH_MANIFEST_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_WITH_MANIFEST_NAME"), false, true);
        String effPath = RepositoryPathEncoder.encodeRepositoryPath((String)path);
        if (effPath.lastIndexOf(":") == effPath.length() - 1 && effPath.length() > 1) {
            effPath = effPath.substring(0, effPath.length() - 1);
        }
        String logFile = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_LOGFILE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_LOGFILE_NAME"), false, true);
        String exportURL = contextURL + "/api/repo/files/" + effPath + "/download?withManifest=" + ("false".equals(withManifest) ? "false" : "true");
        String filepath = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_FILEPATH_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_FILEPATH_NAME"), true, false);
        if (!this.isValidExportPath(filepath, logFile)) {
            throw new ParseException(Messages.getInstance().getString("CommandLineProcessor.ERROR_0005_INVALID_FILE_PATH", new Object[]{filepath}));
        }
        this.initRestService();
        WebResource resource = client.resource(exportURL);
        WebResource.Builder builder = (WebResource.Builder)resource.type("multipart/form-data").accept(new MediaType[]{MediaType.TEXT_HTML_TYPE});
        ClientResponse response = (ClientResponse)builder.get(ClientResponse.class);
        if (response != null && response.getStatus() == 200) {
            String filename = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_FILEPATH_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_FILEPATH_NAME"), true, false);
            InputStream input = response.getEntityInputStream();
            this.createZipFile(filename, input);
            input.close();
            String message = Messages.getInstance().getString("CommandLineProcessor.INFO_EXPORT_COMPLETED").concat("\n");
            message = message + Messages.getInstance().getString("CommandLineProcessor.INFO_RESPONSE_STATUS", new Object[]{response.getStatus()});
            message = message + "\n";
            message = message + Messages.getInstance().getString("CommandLineProcessor.INFO_EXPORT_WRITTEN_TO", new Object[]{filename});
            if (logFile != null && !"".equals(logFile)) {
                System.out.println(message);
                this.writeFile(message, logFile);
            }
        } else {
            System.out.println(Messages.getInstance().getErrorString("CommandLineProcessor.ERROR_0002_INVALID_RESPONSE"));
            if (response != null && response.getStatus() == 404) {
                throw new ParseException(Messages.getInstance().getErrorString("CommandLineProcessor.ERROR_0004_UNKNOWN_SOURCE", new Object[]{path}));
            }
        }
    }

    private boolean isValidExportPath(String filePath, String logFile) {
        String directoryPath;
        File f;
        int fileNameIdx;
        boolean isValid = false;
        if (filePath != null && filePath.toLowerCase().endsWith(".zip") && (fileNameIdx = filePath.replace("\\", "/").lastIndexOf("/")) >= 0 && (f = new File(directoryPath = filePath.substring(0, fileNameIdx))) != null && f.exists() && f.isDirectory()) {
            isValid = true;
        }
        if (!isValid && logFile != null && !"".equals(logFile)) {
            this.writeFile("Invalid file-path:" + filePath, logFile);
        }
        return isValid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createZipFile(String filename, InputStream input) {
        FileOutputStream output = null;
        try {
            int bytesRead;
            output = new FileOutputStream(filename);
            byte[] buffer = new byte[8192];
            while ((bytesRead = input.read(buffer)) != -1) {
                ((OutputStream)output).write(buffer, 0, bytesRead);
            }
            buffer = null;
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        finally {
            if (output != null) {
                try {
                    ((OutputStream)output).close();
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public synchronized void setRepository(IUnifiedRepository repository) {
        if (repository == null) {
            throw new IllegalArgumentException();
        }
        this.repository = repository;
    }

    protected synchronized IUnifiedRepository getRepository() throws ParseException {
        URL url;
        if (this.repository != null) {
            return this.repository;
        }
        String NAMESPACE_URI = "http://www.pentaho.org/ws/1.0";
        String SERVICE_NAME = "unifiedRepository";
        String urlString = this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_NAME"), true, false).trim();
        if (urlString.endsWith("/")) {
            urlString = urlString.substring(0, urlString.length() - 1);
        }
        urlString = urlString + "/webservices/" + "unifiedRepository" + "?wsdl";
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IllegalArgumentException(e);
        }
        Service service = Service.create((URL)url, (QName)new QName("http://www.pentaho.org/ws/1.0", "unifiedRepository"));
        IUnifiedRepositoryJaxwsWebService port = (IUnifiedRepositoryJaxwsWebService)service.getPort(IUnifiedRepositoryJaxwsWebService.class);
        ((BindingProvider)port).getRequestContext().put("javax.xml.ws.security.auth.username", this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_USERNAME_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_USERNAME_NAME"), true, false));
        ((BindingProvider)port).getRequestContext().put("javax.xml.ws.security.auth.password", this.getOptionValue(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PASSWORD_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PASSWORD_NAME"), true, true));
        ((BindingProvider)port).getRequestContext().put("javax.xml.ws.session.maintain", true);
        ((BindingProvider)port).getRequestContext().put("com.sun.xml.ws.transport.http.client.streaming.chunk.size", 8192);
        SOAPBinding binding = (SOAPBinding)((BindingProvider)port).getBinding();
        binding.setMTOMEnabled(true);
        UnifiedRepositoryToWebServiceAdapter unifiedRepositoryToWebServiceAdapter = new UnifiedRepositoryToWebServiceAdapter(port);
        this.repository = unifiedRepositoryToWebServiceAdapter;
        return unifiedRepositoryToWebServiceAdapter;
    }

    protected String getOptionValue(String option, boolean required, boolean emptyOk) throws ParseException {
        String value = StringUtils.trim((String)this.commandLine.getOptionValue(option));
        if (required && StringUtils.isEmpty((String)value)) {
            throw new ParseException(Messages.getInstance().getErrorString("CommandLineProcessor.ERROR_0001_MISSING_ARG", new Object[]{option}));
        }
        if (!emptyOk && StringUtils.isEmpty((String)value)) {
            throw new ParseException(Messages.getInstance().getErrorString("CommandLineProcessor.ERROR_0001_MISSING_ARG", new Object[]{option}));
        }
        return value;
    }

    protected String getOptionValue(String shortOption, String longOption, boolean required, boolean emptyOk) throws ParseException {
        String value = StringUtils.trim((String)this.commandLine.getOptionValue(shortOption));
        if (StringUtils.isEmpty((String)value)) {
            value = StringUtils.trim((String)this.commandLine.getOptionValue(longOption));
        }
        if (required && StringUtils.isEmpty((String)value)) {
            throw new ParseException(Messages.getInstance().getErrorString("CommandLineProcessor.ERROR_0001_MISSING_ARG", new Object[]{longOption}));
        }
        if (!emptyOk && StringUtils.isEmpty((String)value)) {
            throw new ParseException(Messages.getInstance().getErrorString("CommandLineProcessor.ERROR_0001_MISSING_ARG", new Object[]{longOption}));
        }
        return value;
    }

    private void writeFile(String message, String logFile) {
        try {
            File file = new File(logFile);
            FileOutputStream fout = FileUtils.openOutputStream((File)file);
            IOUtils.copy((InputStream)IOUtils.toInputStream((String)message), (OutputStream)fout);
            fout.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    protected static void printHelp() {
        HelpFormatter formatter = new HelpFormatter();
        formatter.printHelp(Messages.getInstance().getString("CommandLineProcessor.INFO_PRINTHELP_CMDLINE"), Messages.getInstance().getString("CommandLineProcessor.INFO_PRINTHELP_HEADER"), options, Messages.getInstance().getString("CommandLineProcessor.INFO_PRINTHELP_FOOTER"));
    }

    static {
        client = null;
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_HELP_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_HELP_NAME"), false, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_HELP_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_IMPORT_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_IMPORT_NAME"), false, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_IMPORT_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_EXPORT_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_EXPORT_NAME"), false, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_EXPORT_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_USERNAME_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_USERNAME_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_USERNAME_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PASSWORD_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PASSWORD_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PASSWORD_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_URL_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_FILEPATH_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_FILEPATH_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_FILEPATH_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_CHARSET_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_CHARSET_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_CHARSET_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_LOGFILE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_LOGFILE_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_LOGFILE_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PATH_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PATH_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PATH_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_OVERWRITE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_OVERWRITE_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_OVERWRITE_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PERMISSION_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PERMISSION_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PERMISSION_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_RETAIN_OWNERSHIP_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_RETAIN_OWNERSHIP_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_RETAIN_OWNERSHIP_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_WITH_MANIFEST_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_WITH_MANIFEST_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_WITH_MANIFEST_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_REST_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_REST_NAME"), false, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_REST_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_SERVICE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_SERVICE_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_SERVICE_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PARAMS_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PARAMS_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_PARAMS_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_RESOURCE_TYPE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_RESOURCE_TYPE_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_RESOURCE_TYPE_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_DATASOURCE_TYPE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_DATASOURCE_TYPE_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_DATASOURCE_TYPE_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_DATASOURCE_TYPE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_DATASOURCE_TYPE_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_RESOURCE_TYPE_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_DATASOURCE_TYPE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_DATASOURCE_TYPE_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_DATASOURCE_TYPE_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_ANALYSIS_CATALOG_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_ANALYSIS_CATALOG_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_ANALYSIS_CATALOG_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_ANALYSIS_DATASOURCE_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_ANALYSIS_DATASOURCE_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_ANALYSIS_DATASOURCE_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_ANALYSIS_XMLA_ENABLED_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_ANALYSIS_XMLA_ENABLED_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_ANALYSIS_XMLA_ENABLED_DESCRIPTION"));
        options.addOption(Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_METADATA_DOMAIN_ID_KEY"), Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_METADATA_DOMAIN_ID_NAME"), true, Messages.getInstance().getString("CommandLineProcessor.INFO_OPTION_METADATA_DOMAIN_ID_DESCRIPTION"));
    }

    private static enum ResourceType {
        SOLUTIONS,
        DATASOURCE;

    }

    private static enum DatasourceType {
        JDBC,
        METADATA,
        ANALYSIS;

    }

    private static enum RequestType {
        HELP,
        IMPORT,
        EXPORT,
        REST;

    }
}

