/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer.mimeType;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import javax.xml.bind.annotation.XmlRootElement;
import javax.xml.bind.annotation.XmlTransient;
import org.pentaho.platform.api.repository2.unified.Converter;

@XmlRootElement
public class MimeType
implements Comparable<MimeType> {
    private String name;
    private List<String> extensions = new ArrayList<String>();
    private boolean hidden;
    private boolean locale;
    @XmlTransient
    private Converter converter;

    public MimeType() {
    }

    public MimeType(String name, List<String> extensions) {
        this.name = name;
        this.setExtensions(extensions);
    }

    public MimeType(String name, String extensions) {
        this(name, Arrays.asList(extensions.split(",")));
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public List<String> getExtensions() {
        return this.extensions;
    }

    public boolean isHidden() {
        return this.hidden;
    }

    public void setHidden(boolean hidden) {
        this.hidden = hidden;
    }

    public boolean isLocale() {
        return this.locale;
    }

    public void setLocale(boolean locale) {
        this.locale = locale;
    }

    @XmlTransient
    public Converter getConverter() {
        return this.converter;
    }

    public void setConverter(Converter converter) {
        this.converter = converter;
    }

    public void setExtensions(List<String> extensions) {
        for (String extension : extensions) {
            this.extensions.add(extension);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("name:").append(this.name);
        sb.append(",extensions:[");
        for (String extension : this.extensions) {
            if (!sb.substring(sb.length() - 1).equals("[")) {
                sb.append(",");
            }
            sb.append(extension);
        }
        sb.append("]");
        sb.append(",hidden:").append(this.hidden);
        sb.append(",locale:").append(this.locale);
        sb.append(",converter:").append(this.converter);
        return sb.toString();
    }

    @Override
    public int compareTo(MimeType o) {
        return this.name.compareTo(o.name);
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        MimeType other = (MimeType)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

