/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.importer;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.platform.plugin.services.importer.IPlatformImportBundle;
import org.pentaho.platform.plugin.services.importer.IPlatformImportHandler;
import org.pentaho.platform.plugin.services.importer.PlatformImportException;
import org.pentaho.platform.plugin.services.importer.mimeType.MimeType;
import org.pentaho.platform.plugin.services.importexport.PentahoMetadataFileInfo;
import org.pentaho.platform.plugin.services.metadata.IPentahoMetadataDomainRepositoryImporter;
import org.pentaho.platform.repository.RepositoryFilenameUtils;
import org.pentaho.platform.repository.messages.Messages;

public class MetadataImportHandler
implements IPlatformImportHandler {
    private static final Log log = LogFactory.getLog(MetadataImportHandler.class);
    private static final Messages messages = Messages.getInstance();
    private static final String DSW_SOURCE_PROPERTY = "AGILE_BI_GENERATED_SCHEMA";
    private List<MimeType> mimeTypes;
    IPentahoMetadataDomainRepositoryImporter metadataRepositoryImporter;

    public MetadataImportHandler(List<MimeType> mimeTypes, IPentahoMetadataDomainRepositoryImporter metadataImporter) {
        this.mimeTypes = mimeTypes;
        if (metadataImporter == null) {
            throw new IllegalArgumentException();
        }
        this.metadataRepositoryImporter = metadataImporter;
    }

    @Override
    public void importFile(IPlatformImportBundle file) throws PlatformImportException {
        String domainId = this.processMetadataFile(file);
        if (file.getChildBundles() != null) {
            for (IPlatformImportBundle child : file.getChildBundles()) {
                this.processLocaleFile(child, domainId);
            }
        }
    }

    protected String processMetadataFile(IPlatformImportBundle bundle) throws PlatformImportException {
        String domainId = (String)bundle.getProperty("domain-id");
        if (domainId == null) {
            throw new PlatformImportException("Bundle missing required domain-id property");
        }
        try {
            log.debug((Object)("Importing as metadata - [domain=" + domainId + "]"));
            InputStream inputStream = bundle.isPreserveDsw() ? this.cloneStream(bundle.getInputStream()) : this.StripDswFromStream(bundle.getInputStream());
            this.metadataRepositoryImporter.storeDomain(inputStream, domainId, bundle.overwriteInRepository());
            return domainId;
        }
        catch (DomainIdNullException dine) {
            throw new PlatformImportException(dine.getMessage(), 1, dine);
        }
        catch (DomainStorageException dse) {
            throw new PlatformImportException(dse.getMessage(), 1, dse);
        }
        catch (DomainAlreadyExistsException daee) {
            throw new PlatformImportException(messages.getString("PentahoPlatformImporter.ERROR_0007_PUBLISH_SCHEMA_EXISTS_ERROR"), 8, daee);
        }
        catch (Exception e) {
            String errorMessage = messages.getErrorString("MetadataImportHandler.ERROR_0001_IMPORTING_METADATA", new Object[]{domainId, e.getLocalizedMessage()});
            log.error((Object)errorMessage, (Throwable)e);
            throw new PlatformImportException(errorMessage, e);
        }
    }

    private InputStream cloneStream(InputStream inputStream) throws Exception {
        byte[] contents = IOUtils.toByteArray((InputStream)inputStream);
        return new ByteArrayInputStream(contents);
    }

    private InputStream StripDswFromStream(InputStream inputStream) throws Exception {
        ByteArrayInputStream inputStream2 = null;
        String xmi = null;
        XmiParser xmiParser = new XmiParser();
        try {
            byte[] is = IOUtils.toByteArray((InputStream)inputStream);
            xmi = new String(is, "UTF-8");
            Domain domain = xmiParser.parseXmi((InputStream)new ByteArrayInputStream(is));
            boolean changed = false;
            if (domain.getLogicalModels().size() > 1) {
                Iterator iterator = domain.getLogicalModels().iterator();
                while (iterator.hasNext()) {
                    LogicalModel logicalModel = (LogicalModel)iterator.next();
                    Object property = logicalModel.getProperty(DSW_SOURCE_PROPERTY);
                    if (property == null) continue;
                    if (logicalModel.getProperty("olap_dimensions") != null) {
                        iterator.remove();
                    } else {
                        logicalModel.removeChildProperty(DSW_SOURCE_PROPERTY);
                        logicalModel.removeChildProperty("AGILE_BI_VERSION");
                    }
                    changed = true;
                }
                if (changed) {
                    xmi = xmiParser.generateXmi(domain);
                }
            }
            inputStream2 = new ByteArrayInputStream(xmi.getBytes("UTF-8"));
        }
        catch (Exception e) {
            throw new PlatformImportException(e.getMessage(), 1, e);
        }
        return inputStream2;
    }

    private void processLocaleFile(IPlatformImportBundle bundle, String domainId) throws PlatformImportException {
        String fullFilename = RepositoryFilenameUtils.concat((String)"/", (String)bundle.getName());
        PentahoMetadataFileInfo info = new PentahoMetadataFileInfo(fullFilename);
        if (domainId == null) {
            domainId = (String)bundle.getProperty("domain-id");
        }
        if (domainId == null) {
            throw new PlatformImportException("Bundle missing required domain-id property");
        }
        try {
            log.debug((Object)("Importing [" + info.getPath() + "] as properties - [domain=" + domainId + " : locale=" + info.getLocale() + "]"));
            this.metadataRepositoryImporter.addLocalizationFile(domainId, info.getLocale(), bundle.getInputStream(), true);
        }
        catch (Exception e) {
            String errorMessage = messages.getErrorString("MetadataImportHandler.ERROR_0002_IMPORTING_LOCALE_FILE", new Object[]{info.getPath(), domainId, info.getLocale(), e.getLocalizedMessage()});
            log.error((Object)errorMessage, (Throwable)e);
            throw new PlatformImportException(errorMessage, e);
        }
    }

    @Override
    public List<MimeType> getMimeTypes() {
        return this.mimeTypes;
    }
}

