/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections.metadata.sql;

import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.di.core.database.DatabaseInterface;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.metadata.model.SqlDataSource;
import org.pentaho.metadata.model.SqlPhysicalModel;
import org.pentaho.metadata.query.BaseMetadataQueryExec;
import org.pentaho.metadata.query.impl.sql.MappedQuery;
import org.pentaho.metadata.query.impl.sql.SqlGenerator;
import org.pentaho.metadata.query.model.Parameter;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.util.DatabaseMetaUtil;
import org.pentaho.metadata.util.ThinModelConverter;
import org.pentaho.platform.api.engine.IConfiguration;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.ISystemConfig;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.plugin.services.connections.sql.SQLConnection;
import org.pentaho.platform.plugin.services.connections.sql.SQLResultSet;
import org.pentaho.platform.plugin.services.messages.Messages;
import org.pentaho.platform.util.logging.SimpleLogger;
import org.pentaho.platform.util.messages.LocaleHelper;

public class SqlMetadataQueryExec
extends BaseMetadataQueryExec {
    static final Log logger = LogFactory.getLog(SqlMetadataQueryExec.class);
    public static final String CONFIG_ID = "sqlmetadataqueryexec";
    public static final String FORCE_DB_META_CLASSES_PROP = "forceDbMetaClasses";
    protected final Set<String> driverClassesToForceMeta;
    private String sqlGeneratorClass = null;

    public SqlMetadataQueryExec() {
        this((ISystemConfig)PentahoSystem.get(ISystemConfig.class));
    }

    public SqlMetadataQueryExec(ISystemConfig systemConfig) {
        String[] forceDbMetaClasses = new String[]{};
        if (systemConfig != null) {
            try {
                Properties props;
                IConfiguration config = systemConfig.getConfiguration(CONFIG_ID);
                if (config != null && (props = config.getProperties()) != null) {
                    forceDbMetaClasses = props.getProperty(FORCE_DB_META_CLASSES_PROP, "").split(",");
                }
            }
            catch (IOException e) {
                logger.error((Object)e);
            }
        }
        this.driverClassesToForceMeta = new HashSet<String>(forceDbMetaClasses.length);
        for (String forceDbMetaClass : forceDbMetaClasses) {
            if (forceDbMetaClass == null || (forceDbMetaClass = forceDbMetaClass.trim()).length() <= 0) continue;
            this.driverClassesToForceMeta.add(forceDbMetaClass);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPentahoResultSet executeQuery(Query queryObject) {
        SqlPhysicalModel sqlModel = (SqlPhysicalModel)queryObject.getLogicalModel().getPhysicalModel();
        DatabaseMeta databaseMeta = ThinModelConverter.convertToLegacy((String)sqlModel.getId(), (SqlDataSource)sqlModel.getDatasource());
        boolean closeConnection = true;
        DatabaseMeta activeDatabaseMeta = this.getActiveDatabaseMeta(databaseMeta);
        SQLConnection sqlConnection = this.getConnection(activeDatabaseMeta);
        String sql = null;
        try {
            Boolean readOnly;
            Integer maxRows;
            if (sqlConnection == null || !sqlConnection.initialized()) {
                logger.error((Object)Messages.getInstance().getErrorString("SQLBaseComponent.ERROR_0007_NO_CONNECTION"));
                IPentahoResultSet iPentahoResultSet = null;
                return iPentahoResultSet;
            }
            for (Parameter param : queryObject.getParameters()) {
                String pName = param.getName();
                if (!this.parameters.containsKey(pName) || this.parameters.get(pName).getClass().isArray()) continue;
                this.parameters.put(pName, this.convertParameterValue(param, this.parameters.get(pName)));
            }
            MappedQuery mappedQuery = null;
            try {
                SqlGenerator sqlGenerator = this.createSqlGenerator();
                mappedQuery = sqlGenerator.generateSql(queryObject, LocaleHelper.getLocale().toString(), this.getMetadataDomainRepository(), activeDatabaseMeta, this.parameters, true);
            }
            catch (Exception e) {
                throw new RuntimeException(e.getLocalizedMessage(), e);
            }
            Integer timeout = this.getTimeout();
            if (timeout != null && timeout >= 0) {
                sqlConnection.setQueryTimeout(timeout);
            }
            if ((maxRows = this.getMaxRows()) != null && maxRows >= 0) {
                sqlConnection.setMaxRows(maxRows);
            }
            if ((readOnly = Boolean.valueOf(this.isReadOnly())) != null && readOnly.booleanValue()) {
                sqlConnection.setReadOnly(true);
            }
            IPentahoResultSet localResultSet = null;
            sql = mappedQuery.getQuery();
            if (logger.isDebugEnabled()) {
                logger.debug((Object)("SQL: " + sql));
            }
            if (this.getDoQueryLog()) {
                logger.info((Object)("SQL: " + sql));
            }
            ArrayList<Object> sqlParams = null;
            if (mappedQuery.getParamList() != null) {
                sqlParams = new ArrayList<Object>();
                for (String param : mappedQuery.getParamList()) {
                    Object sqlParam = this.parameters.get(param);
                    if (sqlParam instanceof Object[]) {
                        Object[] multivaluedParamValues;
                        for (Object p : multivaluedParamValues = (Object[])sqlParam) {
                            sqlParams.add(p);
                        }
                        continue;
                    }
                    sqlParams.add(sqlParam);
                }
            }
            try {
                localResultSet = !this.isForwardOnly() ? (sqlParams != null ? sqlConnection.prepareAndExecuteQuery(sql, sqlParams) : sqlConnection.executeQuery(sql)) : (sqlParams != null ? sqlConnection.prepareAndExecuteQuery(sql, sqlParams, 1003, 1007) : sqlConnection.executeQuery(sql, 1003, 1007));
                IPentahoMetaData metadata = mappedQuery.generateMetadata(localResultSet.getMetaData());
                ((SQLResultSet)localResultSet).setMetaData(metadata);
                closeConnection = false;
            }
            catch (Exception e) {
                logger.error((Object)Messages.getInstance().getErrorString("SqlMetadataQueryExec.ERROR_0002_ERROR_EXECUTING_QUERY", new Object[]{e.getLocalizedMessage(), sql}));
                logger.debug((Object)"error", (Throwable)e);
                IPentahoResultSet iPentahoResultSet = null;
                if (closeConnection && sqlConnection != null) {
                    sqlConnection.close();
                }
                return iPentahoResultSet;
            }
            IPentahoResultSet iPentahoResultSet = localResultSet;
            return iPentahoResultSet;
        }
        finally {
            if (closeConnection && sqlConnection != null) {
                sqlConnection.close();
            }
        }
    }

    public boolean isLive() {
        return true;
    }

    public boolean getForceDbDialect() {
        Object obj = this.inputs.get("forcedbdialect");
        if (obj instanceof String && "true".equalsIgnoreCase((String)obj)) {
            return true;
        }
        return obj instanceof Boolean && (Boolean)obj != false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected DatabaseMeta getActiveDatabaseMeta(DatabaseMeta databaseMeta) {
        if (this.getForceDbDialect() || this.driverClassesToForceMeta.contains(databaseMeta.getDriverClass())) {
            return databaseMeta;
        }
        SQLConnection tempConnection = this.getConnection(databaseMeta);
        try {
            DatabaseInterface di = this.getDatabaseInterface(tempConnection);
            if (di != null && !databaseMeta.getPluginId().equals(di.getPluginId())) {
                DatabaseMeta meta = (DatabaseMeta)databaseMeta.clone();
                DatabaseInterface di2 = (DatabaseInterface)di.clone();
                di2.setAccessType(databaseMeta.getAccessType());
                di2.setDatabaseName(databaseMeta.getDatabaseName());
                di2.setAttributes(databaseMeta.getAttributes());
                di2.setUsername(databaseMeta.getUsername());
                di2.setPassword(databaseMeta.getPassword());
                di2.setHostname(databaseMeta.getHostname());
                meta.setDatabaseInterface(di2);
                DatabaseMeta databaseMeta2 = meta;
                return databaseMeta2;
            }
            DatabaseMeta databaseMeta3 = databaseMeta;
            return databaseMeta3;
        }
        finally {
            if (tempConnection != null) {
                tempConnection.close();
            }
        }
    }

    protected SQLConnection getConnection(DatabaseMeta databaseMeta) {
        SQLConnection localConnection = null;
        try {
            String jndiName;
            IPentahoSession session = PentahoSessionHolder.getSession();
            if (databaseMeta.getAccessType() == 4 && (jndiName = databaseMeta.getDatabaseName()) != null) {
                SimpleLogger simpleLogger = new SimpleLogger((Object)this);
                localConnection = (SQLConnection)PentahoConnectionFactory.getConnection((String)"SQL", (String)jndiName, (IPentahoSession)session, (ILogger)simpleLogger);
            }
            if (localConnection == null) {
                String driver = databaseMeta.getDriverClass();
                String userId = databaseMeta.getUsername();
                String password = databaseMeta.getPassword();
                String connectionInfo = databaseMeta.getURL();
                if (StringUtils.isEmpty((String)databaseMeta.getDatabaseName())) {
                    String genericDBMetaURL;
                    String genericDBMetaDriver = databaseMeta.getAttributes().getProperty("CUSTOM_DRIVER_CLASS", "");
                    if (!StringUtils.isEmpty((String)genericDBMetaDriver)) {
                        driver = genericDBMetaDriver;
                    }
                    if (!StringUtils.isEmpty((String)(genericDBMetaURL = databaseMeta.getAttributes().getProperty("CUSTOM_URL", "")))) {
                        connectionInfo = genericDBMetaURL;
                    }
                }
                SimpleLogger simpleLogger = new SimpleLogger((Object)this);
                localConnection = (SQLConnection)PentahoConnectionFactory.getConnection((String)"SQL", (String)driver, (String)connectionInfo, (String)userId, (String)password, (IPentahoSession)session, (ILogger)simpleLogger);
            }
            return localConnection;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getInstance().getErrorString("MetadataQueryComponent.ERROR_0006_EXECUTE_FAILED"), (Throwable)e);
            return null;
        }
    }

    private SqlGenerator createSqlGenerator() throws Exception {
        SqlGenerator sqlGenerator = null;
        String inputClass = (String)this.inputs.get("sqlgenerator");
        if (inputClass != null) {
            this.sqlGeneratorClass = inputClass;
        }
        if (this.sqlGeneratorClass == null && (sqlGenerator = (SqlGenerator)PentahoSystem.get(SqlGenerator.class, (String)"sqlGenerator", null)) == null) {
            this.sqlGeneratorClass = "org.pentaho.metadata.query.impl.sql.SqlGenerator";
        }
        if (this.sqlGeneratorClass != null) {
            Class<?> clazz = Class.forName(this.sqlGeneratorClass);
            sqlGenerator = (SqlGenerator)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
        }
        return sqlGenerator;
    }

    protected DatabaseInterface getDatabaseInterface(SQLConnection conn) {
        String prod = null;
        try {
            prod = conn.getNativeConnection().getMetaData().getDatabaseProductName();
            DatabaseInterface di = DatabaseMetaUtil.getDatabaseInterface((String)prod);
            if (prod != null && di == null) {
                logger.warn((Object)Messages.getInstance().getString("MQLRelationalDataComponent.WARN_0001_NO_DIALECT_DETECTED", new Object[]{prod}));
            }
            return di;
        }
        catch (SQLException e) {
            logger.warn((Object)Messages.getInstance().getString("MQLRelationalDataComponent.WARN_0002_DIALECT_EXCEPTION", new Object[]{prod}), (Throwable)e);
            return null;
        }
    }
}

