/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.services.connections.javascript;

import java.text.SimpleDateFormat;
import java.util.Date;
import org.mozilla.javascript.Context;
import org.mozilla.javascript.Function;
import org.mozilla.javascript.NativeArray;
import org.mozilla.javascript.NativeJavaObject;
import org.mozilla.javascript.Scriptable;
import org.mozilla.javascript.ScriptableObject;
import org.pentaho.commons.connection.IPeekable;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.commons.connection.memory.MemoryResultSet;

public class JavaScriptResultSet
extends ScriptableObject
implements IPentahoResultSet,
IPeekable {
    private static final long serialVersionUID = -2303805979176976941L;
    private IPentahoResultSet results = null;
    private MemoryResultSet writeableResults;
    protected Object[] peekRow;
    private StringBuffer description = new StringBuffer();

    public void setResultSet(IPentahoResultSet pResults) {
        this.results = pResults;
        if (this.results instanceof MemoryResultSet) {
            this.writeableResults = (MemoryResultSet)this.results;
        }
    }

    public String getClassName() {
        return "JavaScriptResultSet";
    }

    public static Object jsFunction_getColumnCount(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args != null && args.length > 0) {
            return null;
        }
        JavaScriptResultSet resultSet = (JavaScriptResultSet)thisObj;
        return new Integer(resultSet.getColumnCount());
    }

    public static Object jsFunction_getRowCount(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args != null && args.length > 0) {
            return null;
        }
        JavaScriptResultSet resultSet = (JavaScriptResultSet)thisObj;
        return new Integer(resultSet.getRowCount());
    }

    public static Object jsFunction_getValueAt(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        int column;
        int row;
        JavaScriptResultSet resultSet;
        block10: {
            if (args == null) {
                return null;
            }
            if (args.length < 2) {
                return null;
            }
            resultSet = (JavaScriptResultSet)thisObj;
            row = 0;
            column = 0;
            try {
                if (args[0] instanceof Number) {
                    row = ((Number)args[0]).intValue();
                } else if (args[0] instanceof String) {
                    row = Integer.parseInt((String)args[0]);
                } else {
                    return null;
                }
                if (args[1] instanceof Number) {
                    column = ((Number)args[1]).intValue();
                    break block10;
                }
                if (args[1] instanceof String) {
                    column = Integer.parseInt((String)args[1]);
                    break block10;
                }
                return null;
            }
            catch (Exception e) {
                return null;
            }
        }
        return resultSet.getValueAt(row, column);
    }

    public static Object jsFunction_setColumnHeaders(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args == null) {
            return null;
        }
        if (args.length == 0) {
            return null;
        }
        JavaScriptResultSet resultSet = (JavaScriptResultSet)thisObj;
        if (args.length == 1 && args[0] instanceof NativeArray) {
            NativeArray array = (NativeArray)args[0];
            resultSet.setMetaData((IPentahoMetaData)JavaScriptResultSet.createMetadata(array, thisObj));
        } else if (args.length == 2 && args[0] instanceof NativeArray && args[1] instanceof NativeArray) {
            NativeArray array = (NativeArray)args[0];
            MemoryMetaData metaData = JavaScriptResultSet.createMetadata(array, thisObj);
            array = (NativeArray)args[1];
            int length = (int)array.getLength();
            String[] columnTypes = new String[length];
            for (int i = 0; i < length; ++i) {
                columnTypes[i] = array.get(i, thisObj).toString();
            }
            metaData.setColumnTypes(columnTypes);
            resultSet.setMetaData((IPentahoMetaData)metaData);
        } else {
            int length = args.length;
            String[] columnHeaders = new String[length];
            for (int i = 0; i < length; ++i) {
                columnHeaders[i] = args[i].toString();
            }
            MemoryMetaData metaData = new MemoryMetaData((Object[][])new String[][]{columnHeaders}, (Object[][])null);
            resultSet.setMetaData((IPentahoMetaData)metaData);
        }
        return null;
    }

    private static MemoryMetaData createMetadata(NativeArray array, Scriptable thisObj) {
        int length = (int)array.getLength();
        String[] columnHeaders = new String[length];
        for (int i = 0; i < length; ++i) {
            columnHeaders[i] = array.get(i, thisObj).toString();
        }
        return new MemoryMetaData((Object[][])new String[][]{columnHeaders}, (Object[][])null);
    }

    public static Object jsFunction_addRow(Context cx, Scriptable thisObj, Object[] args, Function funObj) {
        if (args == null) {
            return null;
        }
        if (args.length == 0) {
            return null;
        }
        JavaScriptResultSet resultSet = (JavaScriptResultSet)thisObj;
        if (args.length == 1 && args[0] instanceof NativeArray) {
            NativeArray array = (NativeArray)args[0];
            int length = (int)array.getLength();
            Object[] row = new Object[length];
            String[] columnTypes = ((MemoryMetaData)resultSet.getMetaData()).getColumnTypes();
            for (int i = 0; i < length; ++i) {
                Object obj;
                Object data = array.get(i, thisObj);
                if (data == null) {
                    row[i] = null;
                    continue;
                }
                if (columnTypes != null) {
                    if (data instanceof NativeJavaObject) {
                        Class outputClass = null;
                        if ("string".equalsIgnoreCase(columnTypes[i])) {
                            outputClass = String.class;
                        } else if ("date".equalsIgnoreCase(columnTypes[i])) {
                            outputClass = Date.class;
                        } else if ("int".equalsIgnoreCase(columnTypes[i])) {
                            outputClass = Integer.class;
                        } else if ("float".equalsIgnoreCase(columnTypes[i])) {
                            outputClass = Float.class;
                        } else if ("double".equalsIgnoreCase(columnTypes[i])) {
                            outputClass = Double.class;
                        }
                        row[i] = NativeJavaObject.canConvert((Object)data, outputClass.getClass()) ? Context.jsToJava((Object)data, String.class) : null;
                    }
                    if ("string".equalsIgnoreCase(columnTypes[i])) {
                        row[i] = data.toString();
                        continue;
                    }
                    if ("date".equalsIgnoreCase(columnTypes[i]) && data instanceof String) {
                        SimpleDateFormat format = new SimpleDateFormat("yyyy-MM-dd");
                        try {
                            row[i] = format.parse((String)data);
                        }
                        catch (Throwable t) {
                            row[i] = null;
                        }
                        continue;
                    }
                    if ("int".equalsIgnoreCase(columnTypes[i]) && data instanceof Integer) {
                        row[i] = data;
                        continue;
                    }
                    if ("int".equalsIgnoreCase(columnTypes[i]) && data instanceof Double) {
                        row[i] = new Integer(((Double)data).intValue());
                        continue;
                    }
                    if ("int".equalsIgnoreCase(columnTypes[i]) && data instanceof String) {
                        row[i] = new Integer((String)data);
                        continue;
                    }
                    if ("float".equalsIgnoreCase(columnTypes[i]) && data instanceof Double) {
                        row[i] = data;
                        continue;
                    }
                    if ("float".equalsIgnoreCase(columnTypes[i]) && data instanceof Integer) {
                        row[i] = new Double(((Integer)data).floatValue());
                        continue;
                    }
                    if ("float".equalsIgnoreCase(columnTypes[i]) && data instanceof String) {
                        row[i] = new Integer((String)data);
                        continue;
                    }
                    if (!"double".equalsIgnoreCase(columnTypes[i]) || !(data instanceof Double)) continue;
                    row[i] = data;
                    continue;
                }
                row[i] = data instanceof NativeJavaObject ? (obj = ((NativeJavaObject)data).unwrap()) : data;
            }
            resultSet.addRow(row);
        } else {
            int length = args.length;
            String[] row = new String[length];
            for (int i = 0; i < length; ++i) {
                row[i] = args[i].toString();
            }
            resultSet.addRow(row);
        }
        return null;
    }

    public void setMetaData(IPentahoMetaData metaData) {
        this.results = new MemoryResultSet(metaData);
        this.writeableResults = (MemoryResultSet)this.results;
    }

    public void addRow(String[] row) {
        if (this.writeableResults != null) {
            this.writeableResults.addRow((Object[])row);
        }
        if (this.description.length() < 100) {
            this.description.append(row);
        }
    }

    public void addRow(Object[] row) {
        if (this.writeableResults != null) {
            this.writeableResults.addRow(row);
        }
        if (this.description.length() < 100) {
            this.description.append(row);
        }
    }

    public String toString() {
        if (this.results.getMetaData().getColumnHeaders() != null) {
            return this.results.getMetaData().getColumnHeaders().toString() + this.description.toString();
        }
        return this.description.toString();
    }

    public IPentahoMetaData getMetaData() {
        return this.results.getMetaData();
    }

    public Object[] peek() {
        if (this.peekRow == null) {
            this.peekRow = this.next();
        }
        return this.peekRow;
    }

    public Object[] next() {
        if (this.peekRow != null) {
            Object[] row = this.peekRow;
            this.peekRow = null;
            return row;
        }
        return this.results.next();
    }

    public void close() {
        this.results.close();
    }

    public void closeConnection() {
        this.close();
    }

    public void dispose() {
        this.close();
    }

    public boolean isScrollable() {
        return true;
    }

    public int getColumnCount() {
        return this.results.getMetaData().getColumnCount();
    }

    public int getRowCount() {
        return this.results.getRowCount();
    }

    public Object getValueAt(int row, int column) {
        return this.results.getValueAt(row, column);
    }

    public IPentahoResultSet memoryCopy() {
        return this.results.memoryCopy();
    }

    public void beforeFirst() {
        this.results.beforeFirst();
    }

    public Object[] getDataColumn(int column) {
        return this.results.getDataColumn(column);
    }

    public Object[] getDataRow(int row) {
        return this.results.getDataRow(row);
    }
}

