/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.boot;

import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.engine.IPentahoDefinableObjectFactory;
import org.pentaho.platform.api.engine.IPentahoObjectFactory;
import org.pentaho.platform.api.engine.IPentahoSystemListener;
import org.pentaho.platform.api.engine.IPluginManager;
import org.pentaho.platform.api.engine.IPluginProvider;
import org.pentaho.platform.api.engine.IPluginResourceLoader;
import org.pentaho.platform.api.engine.IServiceManager;
import org.pentaho.platform.api.engine.ISolutionEngine;
import org.pentaho.platform.api.repository2.unified.IUnifiedRepository;
import org.pentaho.platform.engine.core.system.boot.PentahoSystemBoot;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.PooledDatasourceSystemListener;
import org.pentaho.platform.engine.services.connection.datasource.dbcp.PooledOrJndiDatasourceService;
import org.pentaho.platform.engine.services.solution.SolutionEngine;
import org.pentaho.platform.plugin.action.jfreereport.JFreeReportSystemListener;
import org.pentaho.platform.plugin.action.kettle.KettleSystemListener;
import org.pentaho.platform.plugin.action.mondrian.MondrianSystemListener;
import org.pentaho.platform.plugin.outputs.FileOutputHandler;
import org.pentaho.platform.plugin.services.connections.mondrian.MDXConnection;
import org.pentaho.platform.plugin.services.connections.sql.SQLConnection;
import org.pentaho.platform.plugin.services.connections.xquery.XQConnection;
import org.pentaho.platform.plugin.services.metadata.CachingPentahoMetadataDomainRepository;
import org.pentaho.platform.plugin.services.pluginmgr.DefaultPluginManager;
import org.pentaho.platform.plugin.services.pluginmgr.PluginAdapter;
import org.pentaho.platform.plugin.services.pluginmgr.PluginResourceLoader;
import org.pentaho.platform.plugin.services.pluginmgr.SystemPathXmlPluginProvider;
import org.pentaho.platform.plugin.services.pluginmgr.servicemgr.DefaultServiceManager;
import org.pentaho.platform.repository2.unified.fs.FileSystemBackedUnifiedRepository;

public class PentahoBoot
extends PentahoSystemBoot {
    protected void configure(String solutionPath, String baseUrl, IPentahoDefinableObjectFactory factory) {
        super.configure(null, null, null);
        IPentahoObjectFactory objectFactory = this.getFactory();
        if (objectFactory instanceof IPentahoDefinableObjectFactory) {
            this.define(ISolutionEngine.class, SolutionEngine.class, IPentahoDefinableObjectFactory.Scope.LOCAL);
            this.define(IUnifiedRepository.class, FileSystemBackedUnifiedRepository.class, IPentahoDefinableObjectFactory.Scope.SESSION);
            this.define("connection-XML", XQConnection.class, IPentahoDefinableObjectFactory.Scope.LOCAL);
            this.define("connection-SQL", SQLConnection.class, IPentahoDefinableObjectFactory.Scope.LOCAL);
            this.define("file", FileOutputHandler.class, IPentahoDefinableObjectFactory.Scope.LOCAL);
        }
    }

    public void enableReporting() {
        this.addLifecycleListener(new JFreeReportSystemListener());
    }

    public void enableOlap() {
        IPentahoObjectFactory objectFactory = this.getFactory();
        if (objectFactory instanceof IPentahoDefinableObjectFactory) {
            this.define("connection-MDX", MDXConnection.class.getName(), IPentahoDefinableObjectFactory.Scope.LOCAL);
        }
        this.addLifecycleListener(new MondrianSystemListener());
    }

    public void enablePluginManager() {
        if (this.getFactory() instanceof IPentahoDefinableObjectFactory) {
            this.define(IPluginProvider.class, SystemPathXmlPluginProvider.class, IPentahoDefinableObjectFactory.Scope.GLOBAL);
            this.define(IPluginManager.class, DefaultPluginManager.class, IPentahoDefinableObjectFactory.Scope.GLOBAL);
            this.define(IServiceManager.class, DefaultServiceManager.class, IPentahoDefinableObjectFactory.Scope.GLOBAL);
            this.define(IPluginResourceLoader.class, PluginResourceLoader.class, IPentahoDefinableObjectFactory.Scope.GLOBAL);
        }
        this.addLifecycleListener(new PluginAdapter());
    }

    public void enablePooledDatasources() {
        IPentahoObjectFactory objectFactory = this.getFactory();
        if (objectFactory instanceof IPentahoDefinableObjectFactory) {
            this.define(IDBDatasourceService.class, PooledOrJndiDatasourceService.class, IPentahoDefinableObjectFactory.Scope.LOCAL);
        }
        this.addLifecycleListener((IPentahoSystemListener)new PooledDatasourceSystemListener());
    }

    public void enableMetadata() {
        IPentahoObjectFactory objectFactory = this.getFactory();
        if (objectFactory instanceof IPentahoDefinableObjectFactory) {
            this.define(IMetadataDomainRepository.class, CachingPentahoMetadataDomainRepository.class, IPentahoDefinableObjectFactory.Scope.GLOBAL);
        }
    }

    public void enableDataIntegration() {
        this.addLifecycleListener(new KettleSystemListener());
    }
}

