/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.pentahometadata;

import java.util.Map;
import java.util.Properties;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.metadata.model.IMetadataQueryExec;
import org.pentaho.metadata.query.model.Parameter;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.util.QueryXmlHelper;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.plugin.action.messages.Messages;

public class MetadataQueryComponent {
    static final Log logger = LogFactory.getLog(MetadataQueryComponent.class);
    Query queryObject;
    String query;
    Integer maxRows;
    Integer timeout;
    boolean readOnly;
    boolean live = false;
    boolean useForwardOnlyResultSet = false;
    boolean logSql = false;
    boolean forceDbDialect = false;
    IPentahoSession session = null;
    IPentahoResultSet resultSet = null;
    String xmlHelperClass = "org.pentaho.metadata.query.model.util.QueryXmlHelper";
    String sqlGeneratorClass = null;
    Map<String, Object> inputs = null;

    public void setInputs(Map<String, Object> inputs) {
        this.inputs = inputs;
    }

    public void setLogSql(boolean logSql) {
        this.logSql = logSql;
    }

    public void setQuery(String query) {
        this.query = query;
    }

    public void setQueryObject(Query queryObject) {
        this.queryObject = queryObject;
    }

    public void setMaxRows(Integer maxRows) {
        this.maxRows = maxRows;
    }

    public void setTimeout(Integer timeout) {
        this.timeout = timeout;
    }

    public void setLive(boolean live) {
        this.live = live;
    }

    public void setReadOnly(Boolean readOnly) {
        this.readOnly = readOnly;
    }

    public void setUseForwardOnlyResultSet(boolean useForwardOnlyResultSet) {
        this.useForwardOnlyResultSet = useForwardOnlyResultSet;
    }

    public void setQueryModelXmlHelper(String xmlHelperClass) {
        this.xmlHelperClass = xmlHelperClass;
    }

    private QueryXmlHelper createQueryXmlHelper() throws Exception {
        Class<?> clazz = Class.forName(this.xmlHelperClass);
        return (QueryXmlHelper)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
    }

    public boolean execute() {
        Class<?> clazz;
        Object maxRowsProperty;
        Object timeoutProperty;
        QueryXmlHelper helper = null;
        try {
            helper = this.createQueryXmlHelper();
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            return false;
        }
        IMetadataDomainRepository repo = (IMetadataDomainRepository)PentahoSystem.get(IMetadataDomainRepository.class, null);
        if (this.queryObject == null) {
            String templatedQuery = null;
            if (this.inputs != null) {
                Properties properties = new Properties();
                for (String name : this.inputs.keySet()) {
                    if (this.inputs.get(name) == null) continue;
                    properties.put(name, this.inputs.get(name).toString());
                }
                templatedQuery = TemplateUtil.applyTemplate((String)this.query, (Properties)properties, null);
            } else {
                templatedQuery = this.query;
            }
            try {
                this.queryObject = helper.fromXML(repo, templatedQuery);
            }
            catch (Exception e) {
                logger.error((Object)"error", (Throwable)e);
                return false;
            }
        }
        if (this.queryObject == null) {
            logger.error((Object)"error query object null");
            return false;
        }
        if (this.timeout == null && (timeoutProperty = this.queryObject.getLogicalModel().getProperty("timeout")) != null && timeoutProperty instanceof Number) {
            int timeoutVal = ((Number)timeoutProperty).intValue();
            this.setTimeout(timeoutVal);
        }
        if (this.maxRows == null && (maxRowsProperty = this.queryObject.getLogicalModel().getProperty("max_rows")) != null && maxRowsProperty instanceof Number) {
            int maxRowsVal = ((Number)maxRowsProperty).intValue();
            this.setMaxRows(maxRowsVal);
        }
        String queryExecName = this.queryObject.getLogicalModel().getPhysicalModel().getQueryExecName();
        String queryExecDefault = this.queryObject.getLogicalModel().getPhysicalModel().getDefaultQueryClassname();
        IMetadataQueryExec executor = (IMetadataQueryExec)PentahoSystem.get(IMetadataQueryExec.class, (String)queryExecName, (IPentahoSession)this.session);
        if (executor == null) {
            try {
                clazz = Class.forName(queryExecDefault, true, this.queryObject.getLogicalModel().getPhysicalModel().getClass().getClassLoader());
                executor = (IMetadataQueryExec)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.warn((Object)Messages.getInstance().getErrorString("MetadataQueryComponent.ERROR_0002_NO_EXECUTOR", new Object[]{queryExecName}));
            }
        }
        if (executor == null) {
            try {
                clazz = Class.forName(queryExecDefault);
                executor = (IMetadataQueryExec)clazz.getConstructor(new Class[0]).newInstance(new Object[0]);
            }
            catch (Exception e) {
                logger.error((Object)Messages.getInstance().getErrorString("MetadataQueryComponent.ERROR_0002_NO_EXECUTOR", new Object[]{queryExecName}));
                return false;
            }
        }
        if (this.queryObject.getParameters() != null) {
            for (Parameter param : this.queryObject.getParameters()) {
                Object value = null;
                if (this.inputs != null) {
                    value = this.inputs.get(param.getName());
                }
                executor.setParameter(param, value);
            }
        }
        try {
            executor.setDoQueryLog(this.logSql);
            executor.setForwardOnly(this.useForwardOnlyResultSet);
            executor.setMaxRows(this.maxRows);
            executor.setMetadataDomainRepository(repo);
            executor.setReadOnly(this.readOnly);
            executor.setTimeout(this.timeout);
            if (this.inputs != null) {
                executor.setInputs(this.inputs);
            }
            this.resultSet = executor.executeQuery(this.queryObject);
            if (this.resultSet != null && !this.live && executor.isLive()) {
                MemoryResultSet cachedResultSet = new MemoryResultSet(this.resultSet.getMetaData());
                Object[] rowObjects = this.resultSet.next();
                while (rowObjects != null) {
                    cachedResultSet.addRow(rowObjects);
                    rowObjects = this.resultSet.next();
                }
                this.resultSet.close();
                this.resultSet.closeConnection();
                this.resultSet = cachedResultSet;
            }
            return this.resultSet != null;
        }
        catch (Exception e) {
            logger.error((Object)"error", (Throwable)e);
            throw new RuntimeException(e.getLocalizedMessage(), e);
        }
    }

    public boolean validate() {
        if (this.query == null) {
            logger.error((Object)"no query specified");
            return false;
        }
        return true;
    }

    public IPentahoResultSet getResultSet() {
        return this.resultSet;
    }
}

