/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.mdx;

import java.util.Map;
import java.util.Properties;
import mondrian.olap.Util;
import mondrian.rolap.RolapConnectionProperties;
import mondrian.util.Pair;
import org.apache.commons.logging.Log;
import org.pentaho.actionsequence.dom.ActionInputConstant;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.actions.MdxConnectionAction;
import org.pentaho.actionsequence.dom.actions.MdxQueryAction;
import org.pentaho.commons.connection.IPentahoConnection;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.data.IDBDatasourceService;
import org.pentaho.platform.api.data.IDataComponent;
import org.pentaho.platform.api.data.IPreparedComponent;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.ILogger;
import org.pentaho.platform.api.engine.IParameterResolver;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.engine.core.system.PentahoSessionHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.connection.PentahoConnectionFactory;
import org.pentaho.platform.engine.services.runtime.MapParameterResolver;
import org.pentaho.platform.engine.services.runtime.TemplateUtil;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.plugin.action.mondrian.catalog.IMondrianCatalogService;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalog;
import org.pentaho.platform.plugin.action.mondrian.catalog.MondrianCatalogHelper;
import org.pentaho.platform.plugin.services.connections.mondrian.MDXConnection;
import org.pentaho.platform.plugin.services.connections.mondrian.MDXResultSet;
import org.pentaho.platform.util.messages.LocaleHelper;

public abstract class MDXBaseComponent
extends ComponentBase
implements IDataComponent,
IPreparedComponent {
    private static final long serialVersionUID = 495868243986115468L;
    public static final String FORMATTED_CELL_VALUES = "formattedCellValues";
    private IPentahoResultSet rSet;
    private boolean connectionOwner = true;
    private IPentahoConnection connection;
    String preparedQuery = null;

    public abstract boolean validateSystemSettings();

    public abstract Log getLogger();

    public IPentahoResultSet getResultSet() {
        return this.rSet;
    }

    protected boolean validateAction() {
        boolean actionValidated = true;
        MdxQueryAction queryAction = null;
        MdxConnectionAction connAction = null;
        try {
            if (this.getActionDefinition() instanceof MdxQueryAction) {
                queryAction = (MdxQueryAction)this.getActionDefinition();
                actionValidated = this.isConnectionInfoSpecified((MdxConnectionAction)queryAction);
                if (actionValidated && queryAction.getQuery() == ActionInputConstant.NULL_INPUT) {
                    this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0001_QUERY_NOT_SPECIFIED", new Object[]{this.getActionName()}));
                    actionValidated = false;
                }
                if (actionValidated && queryAction.getOutputResultSet() == null && queryAction.getOutputPreparedStatement() == null) {
                    this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0003_OUTPUT_NOT_SPECIFIED", new Object[]{this.getActionName()}));
                    actionValidated = false;
                }
            } else if (this.getActionDefinition() instanceof MdxConnectionAction) {
                connAction = (MdxConnectionAction)this.getActionDefinition();
                actionValidated = this.isConnectionInfoSpecified(connAction);
                if (connAction.getOutputConnection() == null) {
                    this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0003_OUTPUT_NOT_SPECIFIED", new Object[]{this.getActionName()}));
                    actionValidated = false;
                }
            }
        }
        catch (Exception e) {
            actionValidated = false;
            this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0004_VALIDATION_FAILED", new Object[]{this.getActionName()}), e);
        }
        return actionValidated;
    }

    private boolean isConnectionInfoSpecified(MdxConnectionAction connAction) {
        boolean value = true;
        if (connAction instanceof MdxQueryAction) {
            if (connAction.getConnection() == ActionInputConstant.NULL_INPUT && connAction.getMdxConnectionString() == null && connAction.getJndi() == ActionInputConstant.NULL_INPUT && connAction.getConnectionProps() == ActionInputConstant.NULL_INPUT && ((MdxQueryAction)connAction).getMdxConnection() == ActionInputConstant.NULL_INPUT) {
                this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0002_CONNECTION_NOT_SPECIFIED", new Object[]{this.getActionName()}));
                value = false;
            }
        } else if (connAction instanceof MdxConnectionAction && connAction.getConnection() == ActionInputConstant.NULL_INPUT && connAction.getMdxConnectionString() == null && connAction.getJndi() == ActionInputConstant.NULL_INPUT && connAction.getConnectionProps() == ActionInputConstant.NULL_INPUT) {
            this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0002_CONNECTION_NOT_SPECIFIED", new Object[]{this.getActionName()}));
            value = false;
        }
        return value;
    }

    public void done() {
    }

    protected boolean executeAction() {
        boolean value = false;
        try {
            if (this.getActionDefinition() instanceof MdxQueryAction) {
                MdxQueryAction queryAction = (MdxQueryAction)this.getActionDefinition();
                if (queryAction.getMdxConnection() != ActionInputConstant.NULL_INPUT) {
                    if (queryAction.getMdxConnection().getValue() != null) {
                        this.connectionOwner = false;
                        IPreparedComponent component = (IPreparedComponent)queryAction.getMdxConnection().getValue();
                        IPentahoConnection conn = component.shareConnection();
                        if (conn.getDatasourceType() == "MDX") {
                            this.connection = conn;
                        } else {
                            this.error(Messages.getInstance().getErrorString("IPreparedComponent.ERROR_0001_INVALID_CONNECTION_TYPE", new Object[]{this.getActionName()}));
                        }
                    } else {
                        this.error(Messages.getInstance().getErrorString("IPreparedComponent.ERROR_0002_CONNECTION_NOT_AVAILABLE", new Object[]{this.getActionName()}));
                    }
                } else {
                    this.dispose();
                    this.connection = this.getDatasourceConnection();
                }
                if (this.connection != null) {
                    String query = queryAction.getQuery().getStringValue();
                    if (queryAction.getOutputPreparedStatement() != null) {
                        this.prepareQuery(query);
                        this.setOutputValue("prepared_component", (Object)this);
                        value = true;
                    } else {
                        value = this.runQuery(this.connection, query);
                    }
                } else {
                    this.error(Messages.getInstance().getErrorString("IPreparedComponent.ERROR_0004_NO_CONNECTION_INFO", new Object[]{this.getActionName()}));
                }
            } else if (this.getActionDefinition() instanceof MdxConnectionAction) {
                this.dispose();
                this.connection = this.getDatasourceConnection();
                if (this.connection != null) {
                    this.setOutputValue("prepared_component", (Object)this);
                    value = true;
                }
            } else {
                this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0004_VALIDATION_FAILED", new Object[]{this.getActionName()}));
            }
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0006_EXECUTE_FAILED", new Object[]{this.getActionName()}), e);
        }
        return value;
    }

    protected boolean prepareQuery(String rawQuery) {
        try {
            if (this.connection == null) {
                this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0008_NO_CONNECTION"));
                return false;
            }
            if (!this.connection.initialized()) {
                this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0008_NO_CONNECTION"));
                return false;
            }
            if (rawQuery != null) {
                this.preparedQuery = this.applyInputsToFormat(rawQuery);
            }
            return true;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0006_EXECUTE_FAILED", new Object[]{this.getActionName()}), e);
            return false;
        }
    }

    public void dispose() {
        if (this.connectionOwner && this.connection != null) {
            this.connection.close();
        }
        this.connection = null;
    }

    public IPentahoConnection shareConnection() {
        return this.connection;
    }

    public IPentahoResultSet executePrepared(Map preparedParams) {
        try {
            IPentahoResultSet resultSet;
            if (this.connection == null) {
                this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0008_NO_CONNECTION"));
                return null;
            }
            if (!this.connection.initialized()) {
                this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0008_NO_CONNECTION"));
                return null;
            }
            if (this.preparedQuery == null) {
                this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0001_QUERY_NOT_SPECIFIED", new Object[]{this.getActionName()}));
                return null;
            }
            String query = TemplateUtil.applyTemplate((String)this.preparedQuery, (IRuntimeContext)this.getRuntimeContext(), (IParameterResolver)new MapParameterResolver(preparedParams, "PREPARELATER", this.getRuntimeContext()));
            this.debug(Messages.getInstance().getString("MDXBaseComponent.DEBUG_RUNNING_QUERY", new Object[]{query}));
            this.rSet = resultSet = this.connection.executeQuery(query);
            return resultSet;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0006_EXECUTE_FAILED", new Object[]{this.getActionName()}), e);
            return null;
        }
    }

    protected boolean runQuery(IPentahoConnection localConnection, String rawQuery) {
        try {
            if (localConnection == null) {
                this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0008_NO_CONNECTION"));
                return false;
            }
            if (!localConnection.initialized()) {
                this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0008_NO_CONNECTION"));
                return false;
            }
            if (rawQuery == null) {
                this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0001_QUERY_NOT_SPECIFIED", new Object[]{this.getActionName()}));
                return false;
            }
            this.debug(Messages.getInstance().getString("MDXBaseComponent.DEBUG_RUNNING_QUERY", new Object[]{rawQuery}));
            IPentahoResultSet resultSet = localConnection.executeQuery(rawQuery);
            if (resultSet != null && resultSet instanceof MDXResultSet) {
                boolean formattedCellValues = false;
                if (this.isDefinedInput(FORMATTED_CELL_VALUES)) {
                    formattedCellValues = this.getInputBooleanValue(FORMATTED_CELL_VALUES, false);
                }
                ((MDXResultSet)resultSet).setFormattedCellValues(formattedCellValues);
            }
            this.rSet = resultSet;
            if (resultSet != null) {
                MdxQueryAction mdxQueryAction = (MdxQueryAction)this.getActionDefinition();
                IActionOutput actionOutput = mdxQueryAction.getOutputResultSet();
                if (actionOutput != null) {
                    actionOutput.setValue((Object)resultSet);
                }
                return true;
            }
            this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0006_EXECUTE_FAILED", new Object[]{this.getActionName()}));
            localConnection.close();
            return false;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0006_EXECUTE_FAILED", new Object[]{this.getActionName()}), e);
            return false;
        }
    }

    public IPentahoConnection getDatasourceConnection() {
        int[] timeouts;
        for (int element : timeouts = new int[]{200, 500, 2000}) {
            try {
                IPentahoConnection con = this.getConnection();
                try {
                    con.clearWarnings();
                }
                catch (Exception ex) {
                    // empty catch block
                }
                return con;
            }
            catch (Exception ex) {
                this.waitFor(element);
            }
        }
        IPentahoConnection con = this.getConnection();
        try {
            con.clearWarnings();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return con;
    }

    protected void waitFor(int millis) {
        try {
            this.debug(Messages.getInstance().getString("MDXBaseComponent.DEBUG_WAITING_FOR_CONNECTION", new Object[]{Integer.toString(millis)}));
            Thread.sleep(millis);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected IPentahoConnection getConnection() {
        MdxConnectionAction connAction = (MdxConnectionAction)this.getActionDefinition();
        String catalogName = connAction.getCatalog().getStringValue();
        IMondrianCatalogService mondrianCatalogService = (IMondrianCatalogService)PentahoSystem.get(IMondrianCatalogService.class, (String)"IMondrianCatalogService", (IPentahoSession)PentahoSessionHolder.getSession());
        MondrianCatalog catalog = mondrianCatalogService.getCatalog(catalogName, PentahoSessionHolder.getSession());
        if (catalog == null) {
            return this.getConnectionOrig();
        }
        Util.PropertyList connectProperties = Util.parseConnectString((String)catalog.getDataSourceInfo());
        Properties properties = new Properties();
        for (Pair pair : connectProperties) {
            properties.put(pair.getKey(), pair.getValue());
        }
        properties.put("Catalog", catalog.getDefinition());
        properties.put("Provider", "mondrian");
        properties.put("PoolNeeded", "false");
        properties.put(RolapConnectionProperties.Locale.name(), LocaleHelper.getLocale().toString());
        this.debug("Mondrian Connection Properties: " + properties.toString());
        MDXConnection mdxConnection = (MDXConnection)PentahoConnectionFactory.getConnection((String)"MDX", (Properties)properties, (IPentahoSession)PentahoSessionHolder.getSession(), (ILogger)this);
        if (connAction != null && connAction.getExtendedColumnNames() != ActionInputConstant.NULL_INPUT) {
            mdxConnection.setUseExtendedColumnNames(connAction.getExtendedColumnNames().getBooleanValue());
        }
        return mdxConnection;
    }

    protected IPentahoConnection getConnectionOrig() {
        IPentahoConnection localConnection = null;
        MdxConnectionAction connAction = (MdxConnectionAction)this.getActionDefinition();
        try {
            String mdxConnectionStr = connAction.getMdxConnectionString().getStringValue();
            Properties mdxConnectionProps = (Properties)connAction.getConnectionProps().getValue();
            String jdbcStr = connAction.getConnection().getStringValue();
            String jndiStr = connAction.getJndi().getStringValue();
            String location = connAction.getLocation().getStringValue();
            String role = connAction.getRole().getStringValue();
            String catalog = connAction.getCatalog().getStringValue();
            if (catalog == null && connAction.getCatalogResource() != null) {
                IActionSequenceResource resource = this.getResource(connAction.getCatalogResource().getName());
                catalog = resource.getAddress();
                if (resource.getSourceType() == 2 && catalog.indexOf("solution:") != 0) {
                    if (!catalog.startsWith("http:")) {
                        catalog = "solution:" + catalog;
                    }
                } else if (!(resource.getSourceType() != 1 && resource.getSourceType() != 3 || catalog.startsWith("solution:"))) {
                    catalog = "solution:" + catalog;
                }
            }
            if (catalog == null) {
                this.warn(Messages.getInstance().getString("MDXBaseComponent.ERROR_0007_CATALOG_NOT_DEFINED", new Object[]{this.getActionName()}));
            } else if (mdxConnectionProps != null) {
                mdxConnectionProps.put("catalog", catalog);
            }
            String userId = connAction.getUserId().getStringValue();
            String password = connAction.getPassword().getStringValue();
            if (mdxConnectionProps != null) {
                localConnection = PentahoConnectionFactory.getConnection((String)"MDX", (Properties)mdxConnectionProps, (IPentahoSession)this.getSession(), (ILogger)this);
            } else {
                if (mdxConnectionStr != null) {
                    localConnection = PentahoConnectionFactory.getConnection((String)"MDX", (String)mdxConnectionStr, (IPentahoSession)this.getSession(), (ILogger)this);
                } else {
                    String connectStr = null;
                    if (jdbcStr != null) {
                        connectStr = jdbcStr + "; Catalog=" + catalog;
                    } else if (jndiStr != null) {
                        IDBDatasourceService datasourceService = (IDBDatasourceService)PentahoSystem.getObjectFactory().get(IDBDatasourceService.class, null);
                        if (datasourceService.getDataSource(jndiStr) == null) {
                            this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0005_INVALID_CONNECTION"));
                            return null;
                        }
                        connectStr = "dataSource=" + jndiStr + "; Catalog=" + catalog;
                        MondrianCatalog mc = MondrianCatalogHelper.getInstance().getCatalog(catalog, this.getSession());
                        try {
                            connectStr = connectStr + ";" + mc.getDataSourceInfo();
                        }
                        catch (Exception e) {
                            // empty catch block
                        }
                    }
                    if (role != null) {
                        connectStr = connectStr + "; Role=" + role;
                    }
                    Properties props = new Properties();
                    props.setProperty("connection", connectStr);
                    props.setProperty("provider", location);
                    if (userId != null) {
                        props.setProperty("userName", userId);
                    }
                    if (password != null) {
                        props.setProperty("password", password);
                    }
                    localConnection = PentahoConnectionFactory.getConnection((String)"MDX", (Properties)props, (IPentahoSession)this.getSession(), (ILogger)this);
                }
                if (localConnection == null) {
                    this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0005_INVALID_CONNECTION"));
                    return null;
                }
            }
            if (localConnection instanceof MDXConnection) {
                MDXConnection mdxConn = (MDXConnection)localConnection;
                if (connAction != null && connAction.getExtendedColumnNames() != ActionInputConstant.NULL_INPUT) {
                    mdxConn.setUseExtendedColumnNames(connAction.getExtendedColumnNames().getBooleanValue());
                }
            }
            return localConnection;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("MDXBaseComponent.ERROR_0006_EXECUTE_FAILED", new Object[]{this.getActionName()}), e);
            return null;
        }
    }

    public boolean init() {
        return true;
    }
}

