/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.kettle;

import java.io.File;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.memory.MemoryMetaData;
import org.pentaho.commons.connection.memory.MemoryResultSet;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.logging.KettleLogStore;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.LoggingObjectInterface;
import org.pentaho.di.core.logging.LoggingRegistry;
import org.pentaho.di.core.parameters.UnknownParamException;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.plugins.RepositoryPluginType;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.xml.XMLHandlerCache;
import org.pentaho.di.job.Job;
import org.pentaho.di.job.JobMeta;
import org.pentaho.di.repository.RepositoriesMeta;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.repository.RepositoryDirectoryInterface;
import org.pentaho.di.repository.RepositoryMeta;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.RowListener;
import org.pentaho.di.trans.step.StepMetaDataCombi;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.engine.services.solution.ComponentBase;
import org.pentaho.platform.plugin.action.kettle.KettleComponentException;
import org.pentaho.platform.plugin.action.kettle.KettleSystemListener;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.xml.w3c.XmlW3CHelper;

public class KettleComponent
extends ComponentBase
implements RowListener {
    private static final long serialVersionUID = 8217343898202366129L;
    private static final String DIRECTORY = "directory";
    private static final String TRANSFORMATION = "transformation";
    private static final String JOB = "job";
    private static final String TRANSFORMFILE = "transformation-file";
    private static final String JOBFILE = "job-file";
    private static final String IMPORTSTEP = "importstep";
    private static final String MONITORSTEP = "monitor-step";
    private static final String KETTLELOGLEVEL = "kettle-logging-level";
    private static final String EXECUTION_STATUS_OUTPUT = "kettle-execution-status";
    private static final String EXECUTION_LOG_OUTPUT = "kettle-execution-log";
    private static final String TRANSFORM_SUCCESS_OUTPUT = "transformation-output-rows";
    private static final String TRANSFORM_ERROR_OUTPUT = "transformation-output-error-rows";
    private static final String TRANSFORM_SUCCESS_COUNT_OUTPUT = "transformation-output-rows-count";
    private static final String TRANSFORM_ERROR_COUNT_OUTPUT = "transformation-output-error-rows-count";
    public static final String PARAMETER_MAP_CMD_ARG = "set-argument";
    public static final String PARAMETER_MAP_VARIABLE = "set-variable";
    public static final String PARAMETER_MAP_PARAMETER = "set-parameter";
    private static final ArrayList<String> outputParams = new ArrayList<String>(Arrays.asList("kettle-execution-status", "kettle-execution-log", "transformation-output-rows", "transformation-output-error-rows", "transformation-output-rows-count", "transformation-output-error-rows-count"));
    private String repositoriesXMLFile;
    private String repositoryName;
    private String username;
    private MemoryResultSet results;
    private MemoryResultSet errorResults;
    private String executionStatus;
    private String executionLog;
    private String password;
    private String logChannelId;

    public Log getLogger() {
        return LogFactory.getLog(KettleComponent.class);
    }

    protected boolean validateSystemSettings() {
        boolean useRepository = PentahoSystem.getSystemSetting((String)"kettle/settings.xml", (String)"repository.type", (String)"files").equals("rdbms");
        if (useRepository) {
            this.repositoriesXMLFile = PentahoSystem.getSystemSetting((String)"kettle/settings.xml", (String)"repositories.xml.file", null);
            this.repositoryName = PentahoSystem.getSystemSetting((String)"kettle/settings.xml", (String)"repository.name", null);
            this.username = PentahoSystem.getSystemSetting((String)"kettle/settings.xml", (String)"repository.userid", (String)"");
            this.password = PentahoSystem.getSystemSetting((String)"kettle/settings.xml", (String)"repository.password", (String)"");
            if ("".equals(this.repositoryName) || this.username.equals("")) {
                this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0001_SERVER_SETTINGS_NOT_SET"));
                return false;
            }
            boolean ok = this.repositoryName != null && this.repositoryName.length() > 0;
            ok = ok || this.username != null && this.username.length() > 0;
            return ok;
        }
        return true;
    }

    public boolean init() {
        LogChannel kettleComponentChannel = new LogChannel((Object)"Kettle platform component");
        this.logChannelId = kettleComponentChannel.getLogChannelId();
        return true;
    }

    private boolean checkMapping(Node name, Node mapping) {
        if (name == null) {
            this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0031_NAME_ELEMENT_MISSING_FROM_MAPPING"));
            return false;
        }
        if (mapping == null) {
            this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0032_MAPPING_ELEMENT_MISSING_FROM_MAPPING"));
            return false;
        }
        if (!this.isDefinedInput(mapping.getText())) {
            this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0033_MAPPING_NOT_FOUND_IN_ACTION_INPUTS", new Object[]{mapping.getText()}));
            return false;
        }
        return true;
    }

    public boolean validateAction() {
        if (this.getComponentDefinition().selectNodes("set-argument | set-variable | set-parameter").size() > 0) {
            HashMap<String, String> argumentMap = null;
            Node name = null;
            Node mapping = null;
            for (Node n : this.getComponentDefinition().selectNodes(PARAMETER_MAP_CMD_ARG)) {
                name = n.selectSingleNode("name");
                if (this.checkMapping(name, mapping = n.selectSingleNode("mapping"))) {
                    if (argumentMap == null) {
                        argumentMap = new HashMap<String, String>();
                    }
                    argumentMap.put(name.getText(), this.applyInputsToFormat(this.getInputStringValue(mapping.getText())));
                    continue;
                }
                return false;
            }
            for (Node n : this.getComponentDefinition().selectNodes(PARAMETER_MAP_VARIABLE)) {
                name = n.selectSingleNode("name");
                if (this.checkMapping(name, mapping = n.selectSingleNode("mapping"))) continue;
                return false;
            }
            for (Node n : this.getComponentDefinition().selectNodes(PARAMETER_MAP_PARAMETER)) {
                name = n.selectSingleNode("name");
                if (this.checkMapping(name, mapping = n.selectSingleNode("mapping"))) continue;
                return false;
            }
            if (argumentMap != null) {
                String val = null;
                for (int i = 1; i <= argumentMap.size(); ++i) {
                    val = (String)argumentMap.get(Integer.toString(i));
                    if (val != null) continue;
                    this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0030_INVALID_ARGUMENT_MAPPING"));
                    return false;
                }
            }
        }
        if (this.isDefinedResource(TRANSFORMFILE) || this.isDefinedResource(JOBFILE)) {
            return true;
        }
        boolean useRepository = PentahoSystem.getSystemSetting((String)"kettle/settings.xml", (String)"repository.type", (String)"files").equals("rdbms");
        if (!useRepository) {
            this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0019_REPOSITORY_TYPE_FILES"));
            return false;
        }
        if (this.isDefinedInput(DIRECTORY) && (this.isDefinedInput(TRANSFORMATION) || this.isDefinedInput(JOB))) {
            return true;
        }
        if (!this.isDefinedInput(DIRECTORY)) {
            this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0002_DIR_OR_FILE__NOT_DEFINED", new Object[]{this.getActionName()}));
            return false;
        }
        if (!this.isDefinedInput(TRANSFORMATION)) {
            this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0003_TRANS_NOT_DEFINED", new Object[]{this.getActionName()}));
            return false;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public boolean executeAction() {
        block143: {
            block144: {
                block140: {
                    block141: {
                        block142: {
                            block138: {
                                block139: {
                                    block136: {
                                        block137: {
                                            block134: {
                                                block135: {
                                                    this.debug(Messages.getInstance().getString("Kettle.DEBUG_START"));
                                                    transMeta = null;
                                                    jobMeta = null;
                                                    argumentMap = new HashMap<String, String>();
                                                    variableMap = new HashMap<String, String>();
                                                    parameterMap = new HashMap<String, String>();
                                                    for (Node n : this.getComponentDefinition().selectNodes("set-argument")) {
                                                        argumentMap.put(n.selectSingleNode("name").getText(), this.applyInputsToFormat(this.getInputStringValue(n.selectSingleNode("mapping").getText())));
                                                    }
                                                    for (Node n : this.getComponentDefinition().selectNodes("set-variable")) {
                                                        variableMap.put(n.selectSingleNode("name").getText(), this.applyInputsToFormat(this.getInputStringValue(n.selectSingleNode("mapping").getText())));
                                                    }
                                                    for (Node n : this.getComponentDefinition().selectNodes("set-parameter")) {
                                                        parameterMap.put(n.selectSingleNode("name").getText(), this.applyInputsToFormat(this.getInputStringValue(n.selectSingleNode("mapping").getText())));
                                                    }
                                                    arguments = null;
                                                    if (argumentMap.size() <= 0 && variableMap.size() <= 0 && parameterMap.size() <= 0) {
                                                        running = true;
                                                        index = 1;
                                                        argumentList = new ArrayList<String>();
                                                        while (running) {
                                                            if (this.isDefinedInput("parameter" + index)) {
                                                                value = null;
                                                                inputName = this.getInputStringValue("parameter" + index);
                                                                if (this.isDefinedInput(inputName)) {
                                                                    value = this.getInputStringValue(inputName);
                                                                }
                                                                argumentList.add(value);
                                                            } else {
                                                                running = false;
                                                            }
                                                            ++index;
                                                        }
                                                        for (String name : this.getInputNames()) {
                                                            argumentList.add(this.getInputStringValue(name));
                                                        }
                                                        arguments = argumentList.toArray(new String[argumentList.size()]);
                                                    } else {
                                                        arguments = new String[argumentMap.size()];
                                                        for (i = 0; i < argumentMap.size(); ++i) {
                                                            arguments[i] = (String)argumentMap.get(Integer.toString(i + 1));
                                                            if (arguments[i] != null) continue;
                                                            this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0030_INVALID_ARGUMENT_MAPPING"));
                                                        }
                                                    }
                                                    try {
                                                        KettleSystemListener.environmentInit(this.getSession());
                                                    }
                                                    catch (KettleException ke) {
                                                        this.error(ke.getMessage(), ke);
                                                    }
                                                    solutionPath = "solution:";
                                                    repository = this.connectToRepository();
                                                    result = false;
                                                    if (!this.isDefinedInput("directory")) ** GOTO lbl178
                                                    directoryName = this.getInputStringValue("directory");
                                                    if (repository != null) break block134;
                                                    name = false;
                                                    if (repository == null) break block135;
                                                    this.debug(Messages.getInstance().getString("Kettle.DEBUG_DISCONNECTING"));
                                                    try {
                                                        repository.disconnect();
                                                    }
                                                    catch (Exception ignored) {
                                                        // empty catch block
                                                    }
                                                }
                                                if (transMeta != null) {
                                                    try {
                                                        this.cleanLogChannel((LoggingObjectInterface)transMeta);
                                                        transMeta.clear();
                                                    }
                                                    catch (Exception ignored) {
                                                        // empty catch block
                                                    }
                                                    transMeta = null;
                                                }
                                                if (jobMeta != null) {
                                                    try {
                                                        this.cleanLogChannel((LoggingObjectInterface)jobMeta);
                                                        jobMeta.clear();
                                                    }
                                                    catch (Exception ignored) {
                                                        // empty catch block
                                                    }
                                                    jobMeta = null;
                                                }
                                                return name;
                                            }
                                            if (!this.isDefinedInput("transformation")) ** GOTO lbl133
                                            transformationName = this.getInputStringValue("transformation");
                                            transMeta = this.loadTransformFromRepository(directoryName, transformationName, repository);
                                            if (transMeta != null) {
                                                try {
                                                    for (String key : parameterMap.keySet()) {
                                                        transMeta.setParameterValue(key, (String)parameterMap.get(key));
                                                    }
                                                    for (String key : variableMap.keySet()) {
                                                        transMeta.setVariable(key, (String)variableMap.get(key));
                                                    }
                                                }
                                                catch (UnknownParamException e) {
                                                    this.error(e.getMessage());
                                                }
                                                transMeta.setArguments(arguments);
                                                break block136;
                                            }
                                            e = false;
                                            if (repository == null) break block137;
                                            this.debug(Messages.getInstance().getString("Kettle.DEBUG_DISCONNECTING"));
                                            try {
                                                repository.disconnect();
                                            }
                                            catch (Exception ignored) {
                                                // empty catch block
                                            }
                                        }
                                        if (transMeta != null) {
                                            try {
                                                this.cleanLogChannel((LoggingObjectInterface)transMeta);
                                                transMeta.clear();
                                            }
                                            catch (Exception ignored) {
                                                // empty catch block
                                            }
                                            transMeta = null;
                                        }
                                        if (jobMeta != null) {
                                            try {
                                                this.cleanLogChannel((LoggingObjectInterface)jobMeta);
                                                jobMeta.clear();
                                            }
                                            catch (Exception ignored) {
                                                // empty catch block
                                            }
                                            jobMeta = null;
                                        }
                                        return e;
                                    }
                                    break block138;
lbl133:
                                    // 1 sources

                                    if (!this.isDefinedInput("job")) break block138;
                                    jobName = this.getInputStringValue("job");
                                    jobMeta = this.loadJobFromRepository(directoryName, jobName, repository);
                                    if (jobMeta != null) {
                                        try {
                                            for (String key : parameterMap.keySet()) {
                                                jobMeta.setParameterValue(key, (String)parameterMap.get(key));
                                            }
                                            for (String key : variableMap.keySet()) {
                                                jobMeta.setVariable(key, (String)variableMap.get(key));
                                            }
                                        }
                                        catch (UnknownParamException e) {
                                            this.error(e.getMessage());
                                        }
                                        jobMeta.setArguments(arguments);
                                        break block138;
                                    }
                                    e = false;
                                    if (repository == null) break block139;
                                    this.debug(Messages.getInstance().getString("Kettle.DEBUG_DISCONNECTING"));
                                    try {
                                        repository.disconnect();
                                    }
                                    catch (Exception ignored) {
                                        // empty catch block
                                    }
                                }
                                if (transMeta != null) {
                                    try {
                                        this.cleanLogChannel((LoggingObjectInterface)transMeta);
                                        transMeta.clear();
                                    }
                                    catch (Exception ignored) {
                                        // empty catch block
                                    }
                                    transMeta = null;
                                }
                                if (jobMeta != null) {
                                    try {
                                        this.cleanLogChannel((LoggingObjectInterface)jobMeta);
                                        jobMeta.clear();
                                    }
                                    catch (Exception ignored) {
                                        // empty catch block
                                    }
                                    jobMeta = null;
                                }
                                return e;
                            }
                            ** GOTO lbl364
lbl178:
                            // 1 sources

                            if (!this.isDefinedResource("transformation-file")) ** GOTO lbl237
                            transformResource = this.getResource("transformation-file");
                            fileAddress = this.getActualFileName(transformResource);
                            try {
                                if (fileAddress != null) {
                                    transMeta = new TransMeta(fileAddress, repository, true);
                                    transMeta.setFilename(fileAddress);
                                } else if (repository != null && repository.isConnected()) {
                                    fileAddress = transformResource.getAddress();
                                    transMeta = this.loadTransformFromRepository(FilenameUtils.getPathNoEndSeparator((String)fileAddress), FilenameUtils.getBaseName((String)fileAddress), repository);
                                } else {
                                    jobXmlStr = this.getResourceAsString(this.getResource("transformation-file"));
                                    jobXmlStr = jobXmlStr.replaceAll("\\$\\{pentaho.solutionpath\\}", solutionPath);
                                    jobXmlStr = jobXmlStr.replaceAll("\\%\\%pentaho.solutionpath\\%\\%", solutionPath);
                                    doc = XmlW3CHelper.getDomFromString((String)jobXmlStr);
                                    transMeta = new TransMeta(doc.getFirstChild(), repository);
                                }
                            }
                            catch (Exception e) {
                                this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0015_BAD_RESOURCE", new Object[]{"transformation-file", fileAddress}), e);
                                doc = false;
                                if (repository != null) {
                                    this.debug(Messages.getInstance().getString("Kettle.DEBUG_DISCONNECTING"));
                                    try {
                                        repository.disconnect();
                                    }
                                    catch (Exception ignored) {
                                        // empty catch block
                                    }
                                }
                                if (transMeta != null) {
                                    try {
                                        this.cleanLogChannel((LoggingObjectInterface)transMeta);
                                        transMeta.clear();
                                    }
                                    catch (Exception ignored) {
                                        // empty catch block
                                    }
                                    transMeta = null;
                                }
                                if (jobMeta != null) {
                                    try {
                                        this.cleanLogChannel((LoggingObjectInterface)jobMeta);
                                        jobMeta.clear();
                                    }
                                    catch (Exception ignored) {
                                        // empty catch block
                                    }
                                    jobMeta = null;
                                }
                                return doc;
                            }
                            try {
                                for (String key : parameterMap.keySet()) {
                                    transMeta.setParameterValue(key, (String)parameterMap.get(key));
                                }
                                for (String key : variableMap.keySet()) {
                                    transMeta.setVariable(key, (String)variableMap.get(key));
                                }
                            }
                            catch (UnknownParamException e) {
                                this.error(e.getMessage());
                            }
                            transMeta.setArguments(arguments);
                            transMeta.setFilename(fileAddress);
                            ** GOTO lbl364
lbl237:
                            // 1 sources

                            if (!this.isDefinedResource("job-file")) ** GOTO lbl364
                            fileAddress = "";
                            fileAddress = this.getResource("job-file").getAddress();
                            if (repository != null && repository.isConnected()) {
                                solutionPath = "";
                                jobMeta = this.loadJobFromRepository(FilenameUtils.getPathNoEndSeparator((String)fileAddress), FilenameUtils.getBaseName((String)fileAddress), repository);
                                break block140;
                            }
                            jobXmlStr = this.getResourceAsString(this.getResource("job-file"));
                            jobXmlStr = jobXmlStr.replaceAll("\\$\\{pentaho.solutionpath\\}", solutionPath);
                            doc = XmlW3CHelper.getDomFromString((String)(jobXmlStr = jobXmlStr.replaceAll("\\%\\%pentaho.solutionpath\\%\\%", solutionPath)));
                            if (doc != null) break block141;
                            this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0015_BAD_RESOURCE", new Object[]{"job-file", fileAddress}));
                            this.debug(this.getKettleLog(true));
                            key = false;
                            if (repository == null) break block142;
                            this.debug(Messages.getInstance().getString("Kettle.DEBUG_DISCONNECTING"));
                            try {
                                repository.disconnect();
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                        }
                        if (transMeta != null) {
                            try {
                                this.cleanLogChannel((LoggingObjectInterface)transMeta);
                                transMeta.clear();
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                            transMeta = null;
                        }
                        if (jobMeta != null) {
                            try {
                                this.cleanLogChannel((LoggingObjectInterface)jobMeta);
                                jobMeta.clear();
                            }
                            catch (Exception ignored) {
                                // empty catch block
                            }
                            jobMeta = null;
                        }
                        return key;
                    }
                    try {
                        repository = this.connectToRepository();
                        jobMeta = new JobMeta(solutionPath + fileAddress, repository);
                        break block140;
                    }
                    catch (Exception e) {
                        this.error(Messages.getInstance().getString("Kettle.ERROR_0023_NO_META"), e);
                        break block140;
                    }
                    finally {
                        if (repository != null) {
                            this.debug(Messages.getInstance().getString("Kettle.DEBUG_DISCONNECTING"));
                            repository.disconnect();
                        }
                    }
                    {
                        catch (Exception e) {
                            this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0015_BAD_RESOURCE", new Object[]{"job-file", fileAddress}), e);
                            doc = false;
                            if (repository != null) {
                                this.debug(Messages.getInstance().getString("Kettle.DEBUG_DISCONNECTING"));
                                try {
                                    repository.disconnect();
                                }
                                catch (Exception ignored) {
                                    // empty catch block
                                }
                            }
                            if (transMeta != null) {
                                try {
                                    this.cleanLogChannel((LoggingObjectInterface)transMeta);
                                    transMeta.clear();
                                }
                                catch (Exception ignored) {
                                    // empty catch block
                                }
                                transMeta = null;
                            }
                            if (jobMeta != null) {
                                try {
                                    this.cleanLogChannel((LoggingObjectInterface)jobMeta);
                                    jobMeta.clear();
                                }
                                catch (Exception ignored) {
                                    // empty catch block
                                }
                                jobMeta = null;
                            }
                            return doc;
                        }
                    }
                }
                if (jobMeta != null) break block143;
                this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0015_BAD_RESOURCE", new Object[]{"job-file", fileAddress}));
                this.debug(this.getKettleLog(true));
                e = false;
                if (repository == null) break block144;
                this.debug(Messages.getInstance().getString("Kettle.DEBUG_DISCONNECTING"));
                try {
                    repository.disconnect();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            if (transMeta != null) {
                try {
                    this.cleanLogChannel((LoggingObjectInterface)transMeta);
                    transMeta.clear();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                transMeta = null;
            }
            if (jobMeta != null) {
                try {
                    this.cleanLogChannel((LoggingObjectInterface)jobMeta);
                    jobMeta.clear();
                }
                catch (Exception ignored) {
                    // empty catch block
                }
                jobMeta = null;
            }
            return e;
        }
        try {
            try {
                for (String key : parameterMap.keySet()) {
                    jobMeta.setParameterValue(key, (String)parameterMap.get(key));
                }
                for (String key : variableMap.keySet()) {
                    jobMeta.setVariable(key, (String)variableMap.get(key));
                }
            }
            catch (UnknownParamException e) {
                this.error(e.getMessage());
            }
            jobMeta.setArguments(arguments);
            jobMeta.setFilename(solutionPath + fileAddress);
lbl364:
            // 4 sources

            if (transMeta != null) {
                result = this.executeTransformation(transMeta);
            }
            if (jobMeta != null) {
                result = this.executeJob(jobMeta, repository);
            }
        }
        catch (Throwable var16_63) {
            throw var16_63;
        }
        finally {
            if (repository != null) {
                this.debug(Messages.getInstance().getString("Kettle.DEBUG_DISCONNECTING"));
                try {
                    repository.disconnect();
                }
                catch (Exception ignored) {}
            }
            if (transMeta != null) {
                try {
                    this.cleanLogChannel((LoggingObjectInterface)transMeta);
                    transMeta.clear();
                }
                catch (Exception ignored) {}
                transMeta = null;
            }
            if (jobMeta != null) {
                try {
                    this.cleanLogChannel((LoggingObjectInterface)jobMeta);
                    jobMeta.clear();
                }
                catch (Exception ignored) {}
                jobMeta = null;
            }
        }
        if (this.isDefinedOutput("kettle-execution-log")) {
            this.setOutputValue("kettle-execution-log", this.executionLog);
        }
        if (this.isDefinedOutput("kettle-execution-status")) {
            this.setOutputValue("kettle-execution-status", this.executionStatus);
        }
        XMLHandlerCache.getInstance().clear();
        return result;
    }

    private void cleanLogChannel(LoggingObjectInterface loi) {
        try {
            this.cleanLogChannelFromMap(loi);
            KettleLogStore.getAppender().removeChannelFromBuffer(loi.getLogChannelId());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    private void cleanLogChannelFromMap(LoggingObjectInterface loi) {
        String logChannelId = loi.getLogChannelId();
        Map logChannelMap = LoggingRegistry.getInstance().getMap();
        if (logChannelMap != null) {
            List logKids = LoggingRegistry.getInstance().getLogChannelChildren(logChannelId);
            if (logKids != null) {
                for (int i = 0; i < logKids.size(); ++i) {
                    logChannelMap.remove(logKids.get(i));
                }
            }
            logChannelMap.remove(logChannelId);
        }
    }

    private String getActualFileName(IActionSequenceResource resource) {
        File file;
        String fileAddress = null;
        if (resource.getSourceType() == 3) {
            fileAddress = resource.getAddress();
        } else if (resource.getSourceType() == 1) {
            fileAddress = resource.getAddress();
        }
        if (!(fileAddress == null || (file = new File(fileAddress)).exists() && file.isFile())) {
            fileAddress = null;
        }
        return fileAddress;
    }

    protected boolean customizeTrans(Trans trans) {
        return true;
    }

    private boolean executeTransformation(TransMeta transMeta) {
        boolean success = true;
        Trans trans = null;
        try {
            if (transMeta != null) {
                try {
                    trans = new Trans(transMeta);
                }
                catch (Exception e) {
                    throw new KettleComponentException(Messages.getInstance().getErrorString("Kettle.ERROR_0010_BAD_TRANSFORMATION_METADATA"), e);
                }
            }
            if (trans == null) {
                throw new KettleComponentException(Messages.getInstance().getErrorString("Kettle.ERROR_0010_BAD_TRANSFORMATION_METADATA"));
            }
            this.logChannelId = trans.getLogChannelId();
            if (!this.customizeTrans(trans)) {
                throw new KettleComponentException(Messages.getInstance().getErrorString("Kettle.ERROR_0028_CUSTOMIZATION_FUNCITON_FAILED"));
            }
            this.debug(Messages.getInstance().getString("Kettle.DEBUG_PREPARING_TRANSFORMATION"));
            try {
                LogLevel lvl = this.getLogLevel();
                trans.setLogLevel(lvl);
                trans.prepareExecution(transMeta.getArguments());
            }
            catch (Exception e) {
                throw new KettleComponentException(Messages.getInstance().getErrorString("Kettle.ERROR_0011_TRANSFORMATION_PREPARATION_FAILED"), e);
            }
            String stepName = null;
            String outputName = null;
            try {
                this.debug(Messages.getInstance().getString("Kettle.DEBUG_FINDING_STEP_IMPORTER"));
                stepName = this.getMonitorStepName();
                outputName = this.getTransformSuccessOutputName();
                if (outputName != null) {
                    this.registerAsStepListener(stepName, trans);
                }
            }
            catch (Exception e) {
                throw new KettleComponentException(Messages.getInstance().getErrorString("Kettle.ERROR_0012_ROW_LISTENER_CREATE_FAILED"), e);
            }
            try {
                this.debug(Messages.getInstance().getString("Kettle.DEBUG_STARTING_TRANSFORMATION"));
                trans.startThreads();
            }
            catch (Exception e) {
                throw new KettleComponentException(Messages.getInstance().getErrorString("Kettle.ERROR_0013_TRANSFORMATION_START_FAILED"), e);
            }
            try {
                this.debug(Messages.getInstance().getString("Kettle.DEBUG_TRANSFORMATION_RUNNING"));
                trans.waitUntilFinished();
                this.cleanLogChannel((LoggingObjectInterface)trans);
                trans.cleanup();
            }
            catch (Exception e) {
                throw new KettleComponentException(Messages.getInstance().getErrorString("Kettle.ERROR_0014_ERROR_DURING_EXECUTE"), e);
            }
            this.debug(this.getKettleLog(false));
            if (this.results != null) {
                if (outputName != null) {
                    this.setOutputValue(outputName, this.results);
                }
                if (this.isDefinedOutput(TRANSFORM_SUCCESS_COUNT_OUTPUT)) {
                    this.setOutputValue(TRANSFORM_SUCCESS_COUNT_OUTPUT, this.results.getRowCount());
                }
            }
            if (this.errorResults != null) {
                if (this.isDefinedOutput(TRANSFORM_ERROR_OUTPUT)) {
                    this.setOutputValue(TRANSFORM_ERROR_OUTPUT, this.errorResults);
                }
                if (this.isDefinedOutput(TRANSFORM_ERROR_COUNT_OUTPUT)) {
                    this.setOutputValue(TRANSFORM_ERROR_COUNT_OUTPUT, this.errorResults.getRowCount());
                }
            }
        }
        catch (KettleComponentException e) {
            success = false;
            this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0008_ERROR_RUNNING", new Object[]{e.toString()}), e);
        }
        this.prepareKettleOutput(trans);
        return success;
    }

    private boolean registerAsStepListener(String stepName, Trans trans) throws KettleComponentException {
        boolean success;
        block4: {
            success = false;
            try {
                if (trans == null) break block4;
                List stepList = trans.getSteps();
                for (StepMetaDataCombi step : stepList) {
                    if (!step.stepname.equals(stepName)) continue;
                    this.debug(Messages.getInstance().getString("Kettle.DEBUG_FOUND_STEP_IMPORTER"));
                    this.debug(Messages.getInstance().getString("Kettle.DEBUG_GETTING_STEP_METADATA"));
                    RowMetaInterface row = trans.getTransMeta().getStepFields(stepName);
                    String[] fieldNames = row.getFieldNames();
                    Object[][] columns = new String[1][fieldNames.length];
                    for (int column = 0; column < fieldNames.length; ++column) {
                        columns[0][column] = fieldNames[column];
                    }
                    this.debug(Messages.getInstance().getString("Kettle.DEBUG_CREATING_RESULTSET_METADATA"));
                    MemoryMetaData metaData = new MemoryMetaData(columns, (Object[][])null);
                    this.results = new MemoryResultSet((IPentahoMetaData)metaData);
                    this.errorResults = new MemoryResultSet((IPentahoMetaData)metaData);
                    step.step.addRowListener((RowListener)this);
                    success = true;
                    break;
                }
            }
            catch (Exception e) {
                throw new KettleComponentException(Messages.getInstance().getString("Kettle.ERROR_0027_ERROR_INIT_STEP", new Object[]{stepName}), e);
            }
        }
        return success;
    }

    private String getMonitorStepName() {
        String result = null;
        if (this.isDefinedInput(IMPORTSTEP)) {
            result = this.getInputStringValue(IMPORTSTEP);
        } else if (this.isDefinedInput(MONITORSTEP)) {
            result = this.getInputStringValue(MONITORSTEP);
        }
        return result;
    }

    private LogLevel getLogLevel() {
        if (this.isDefinedInput(KETTLELOGLEVEL)) {
            String logLevelStr = this.getInputStringValue(KETTLELOGLEVEL);
            try {
                return LogLevel.valueOf((String)logLevelStr);
            }
            catch (Exception ex) {
                this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0024_BAD_LOGGING_LEVEL", new Object[]{logLevelStr}));
                return LogLevel.BASIC;
            }
        }
        switch (this.loggingLevel) {
            case 2: {
                return LogLevel.DEBUG;
            }
            case 5: {
                return LogLevel.ERROR;
            }
            case 6: {
                return LogLevel.ERROR;
            }
            case 3: {
                return LogLevel.MINIMAL;
            }
            case 4: {
                return LogLevel.BASIC;
            }
            case 1: {
                return LogLevel.ROWLEVEL;
            }
        }
        return LogLevel.BASIC;
    }

    private String getTransformSuccessOutputName() {
        String result = null;
        if (this.isDefinedInput(IMPORTSTEP)) {
            if (this.getOutputNames().size() == 1) {
                result = (String)this.getOutputNames().iterator().next();
            } else {
                result = this.getUndefinedOutputParameter(this.getOutputNames().iterator());
                if (result == null && this.isDefinedOutput(TRANSFORM_SUCCESS_OUTPUT)) {
                    result = TRANSFORM_SUCCESS_OUTPUT;
                }
            }
        } else if (this.isDefinedOutput(TRANSFORM_SUCCESS_OUTPUT)) {
            result = TRANSFORM_SUCCESS_OUTPUT;
        }
        return result;
    }

    private void prepareKettleOutput(Trans trans) {
        this.extractKettleStatus(trans);
        this.extractKettleLog();
    }

    private void prepareKettleOutput(Job job) {
        this.extractKettleStatus(job);
        this.extractKettleLog();
    }

    private void extractKettleStatus(Trans trans) {
        this.executionStatus = trans != null ? trans.getStatus() : Messages.getInstance().getErrorString("Kettle.ERROR_0025_TRANSFORMATION_NOT_LOADED");
    }

    private void extractKettleStatus(Job job) {
        this.executionStatus = job != null ? job.getStatus() : Messages.getInstance().getErrorString("Kettle.ERROR_0026_JOB_NOT_LOADED");
    }

    private String getKettleLog(boolean includeGeneral) {
        StringBuffer logText = KettleLogStore.getAppender().getBuffer(this.logChannelId, includeGeneral);
        return logText.toString();
    }

    private void extractKettleLog() {
        this.executionLog = this.getKettleLog(false);
    }

    private String getUndefinedOutputParameter(Iterator<String> outputNames) {
        String tempName = null;
        while (outputNames.hasNext()) {
            tempName = outputNames.next();
            if (outputParams.contains(tempName)) continue;
            return tempName;
        }
        return null;
    }

    private boolean executeJob(JobMeta jobMeta, Repository repository) {
        boolean success = true;
        Job job = null;
        try {
            if (jobMeta != null) {
                try {
                    job = new Job(repository, jobMeta);
                }
                catch (Exception e) {
                    throw new KettleComponentException(Messages.getInstance().getErrorString("Kettle.ERROR_0021_BAD_JOB_METADATA"), e);
                }
            }
            if (job == null) {
                this.debug(this.getKettleLog(true));
                throw new KettleComponentException(Messages.getInstance().getErrorString("Kettle.ERROR_0021_BAD_JOB_METADATA"));
            }
            this.logChannelId = job.getLogChannelId();
            try {
                this.debug(Messages.getInstance().getString("Kettle.DEBUG_STARTING_JOB"));
                LogLevel lvl = this.getLogLevel();
                job.setLogLevel(lvl);
                job.start();
            }
            catch (Exception e) {
                throw new KettleComponentException(Messages.getInstance().getErrorString("Kettle.ERROR_0022_JOB_START_FAILED"), e);
            }
            try {
                this.debug(Messages.getInstance().getString("Kettle.DEBUG_JOB_RUNNING"));
                job.waitUntilFinished();
                if (job.getResult().getNrErrors() > 0L) {
                    this.debug(this.getKettleLog(true));
                    throw new KettleComponentException(Messages.getInstance().getErrorString("Kettle.ERROR_0014_ERROR_DURING_EXECUTE"));
                }
            }
            catch (Exception e) {
                throw new KettleComponentException(Messages.getInstance().getErrorString("Kettle.ERROR_0014_ERROR_DURING_EXECUTE"), e);
            }
            finally {
                if (job != null) {
                    this.cleanLogChannel((LoggingObjectInterface)job);
                }
            }
            this.debug(this.getKettleLog(false));
        }
        catch (KettleComponentException e) {
            success = false;
            this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0008_ERROR_RUNNING", new Object[]{e.toString()}), e);
        }
        this.prepareKettleOutput(job);
        return success;
    }

    private TransMeta loadTransformFromRepository(String directoryName, String transformationName, Repository repository) {
        this.debug(Messages.getInstance().getString("Kettle.DEBUG_DIRECTORY", new Object[]{directoryName}));
        this.debug(Messages.getInstance().getString("Kettle.DEBUG_TRANSFORMATION", new Object[]{transformationName}));
        TransMeta transMeta = null;
        try {
            this.debug(Messages.getInstance().getString("Kettle.DEBUG_FINDING_DIRECTORY"));
            this.debug(Messages.getInstance().getString("Kettle.DEBUG_GETTING_TRANSFORMATION_METADATA"));
            try {
                RepositoryDirectoryInterface repositoryDirectory = repository.loadRepositoryDirectoryTree().findDirectory(directoryName);
                transMeta = repository.loadTransformation(transformationName, repositoryDirectory, null, true, null);
            }
            catch (Exception e) {
                this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0009_TRANSFROMATION_METADATA_NOT_FOUND", new Object[]{directoryName + "/" + transformationName}), e);
                return null;
            }
            if (transMeta == null) {
                this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0009_TRANSFROMATION_METADATA_NOT_FOUND", new Object[]{directoryName + "/" + transformationName}));
                this.debug(this.getKettleLog(true));
                return null;
            }
            return transMeta;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0008_ERROR_RUNNING", new Object[]{e.toString()}), e);
            return null;
        }
    }

    private JobMeta loadJobFromRepository(String directoryName, String jobName, Repository repository) {
        this.debug(Messages.getInstance().getString("Kettle.DEBUG_DIRECTORY", new Object[]{directoryName}));
        this.debug(Messages.getInstance().getString("Kettle.DEBUG_JOB", new Object[]{jobName}));
        JobMeta jobMeta = null;
        try {
            this.debug(Messages.getInstance().getString("Kettle.DEBUG_FINDING_DIRECTORY"));
            this.debug(Messages.getInstance().getString("Kettle.DEBUG_GETTING_JOB_METADATA"));
            try {
                RepositoryDirectoryInterface repositoryDirectory = repository.loadRepositoryDirectoryTree().findDirectory(directoryName);
                jobMeta = repository.loadJob(jobName, repositoryDirectory, null, null);
            }
            catch (Exception e) {
                this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0020_JOB_METADATA_NOT_FOUND", new Object[]{directoryName + "/" + jobName}), e);
                return null;
            }
            if (jobMeta == null) {
                this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0020_JOB_METADATA_NOT_FOUND", new Object[]{directoryName + "/" + jobName}));
                this.debug(this.getKettleLog(true));
                return null;
            }
            return jobMeta;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0008_ERROR_RUNNING", new Object[]{e.toString()}), e);
            return null;
        }
    }

    private Repository connectToRepository() {
        boolean useRepository = PentahoSystem.getSystemSetting((String)"kettle/settings.xml", (String)"repository.type", (String)"files").equals("rdbms");
        if (!useRepository) {
            return null;
        }
        try {
            this.debug(Messages.getInstance().getString("Kettle.DEBUG_META_REPOSITORY"));
            RepositoriesMeta repositoriesMeta = null;
            try {
                repositoriesMeta = new RepositoriesMeta();
            }
            catch (Exception e) {
                this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0007_BAD_META_REPOSITORY"), e);
                return null;
            }
            this.debug(Messages.getInstance().getString("Kettle.DEBUG_POPULATING_META"));
            try {
                repositoriesMeta.readData();
            }
            catch (Exception e) {
                this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0018_META_REPOSITORY_NOT_POPULATED"), e);
                return null;
            }
            if (this.repositoriesXMLFile != null && !"".equals(this.repositoriesXMLFile)) {
                this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0017_XML_REPOSITORY_NOT_SUPPORTED"));
                this.debug(this.getKettleLog(true));
                return null;
            }
            this.debug(Messages.getInstance().getString("Kettle.DEBUG_FINDING_REPOSITORY"));
            RepositoryMeta repositoryMeta = null;
            try {
                repositoryMeta = repositoriesMeta.findRepository(this.repositoryName);
            }
            catch (Exception e) {
                this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0004_REPOSITORY_NOT_FOUND", new Object[]{this.repositoryName}), e);
                return null;
            }
            if (repositoryMeta == null) {
                this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0004_REPOSITORY_NOT_FOUND", new Object[]{this.repositoryName}));
                this.debug(this.getKettleLog(true));
                return null;
            }
            this.debug(Messages.getInstance().getString("Kettle.DEBUG_GETTING_REPOSITORY"));
            Repository repository = null;
            try {
                repository = (Repository)PluginRegistry.getInstance().loadClass(RepositoryPluginType.class, repositoryMeta.getId(), Repository.class);
                repository.init(repositoryMeta);
            }
            catch (Exception e) {
                this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0016_COULD_NOT_GET_REPOSITORY_INSTANCE"), e);
                return null;
            }
            this.debug(Messages.getInstance().getString("Kettle.DEBUG_CONNECTING"));
            repository.connect(this.username, this.password);
            this.debug(Messages.getInstance().getString("Kettle.DEBUG_FINDING_DIRECTORY"));
            return repository;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("Kettle.ERROR_0008_ERROR_RUNNING", new Object[]{e.toString()}), e);
            return null;
        }
    }

    public void done() {
    }

    public void rowReadEvent(RowMetaInterface row, Object[] values) {
    }

    public void rowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        this.processRow(this.results, rowMeta, row);
    }

    public void errorRowWrittenEvent(RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        this.processRow(this.errorResults, rowMeta, row);
    }

    public void processRow(MemoryResultSet memResults, RowMetaInterface rowMeta, Object[] row) throws KettleStepException {
        if (memResults == null) {
            return;
        }
        try {
            Object[] pentahoRow = new Object[memResults.getColumnCount()];
            block11: for (int columnNo = 0; columnNo < memResults.getColumnCount(); ++columnNo) {
                ValueMetaInterface valueMeta = rowMeta.getValueMeta(columnNo);
                switch (valueMeta.getType()) {
                    case 6: {
                        pentahoRow[columnNo] = rowMeta.getBigNumber(row, columnNo);
                        continue block11;
                    }
                    case 4: {
                        pentahoRow[columnNo] = rowMeta.getBoolean(row, columnNo);
                        continue block11;
                    }
                    case 3: {
                        pentahoRow[columnNo] = rowMeta.getDate(row, columnNo);
                        continue block11;
                    }
                    case 5: {
                        pentahoRow[columnNo] = rowMeta.getInteger(row, columnNo);
                        continue block11;
                    }
                    case 0: {
                        pentahoRow[columnNo] = rowMeta.getString(row, columnNo);
                        continue block11;
                    }
                    case 1: {
                        pentahoRow[columnNo] = rowMeta.getNumber(row, columnNo);
                        continue block11;
                    }
                    case 2: {
                        pentahoRow[columnNo] = rowMeta.getString(row, columnNo);
                        continue block11;
                    }
                    default: {
                        pentahoRow[columnNo] = rowMeta.getString(row, columnNo);
                    }
                }
            }
            memResults.addRow(pentahoRow);
        }
        catch (KettleValueException e) {
            throw new KettleStepException((Throwable)e);
        }
    }
}

