/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.jfreereport;

import java.awt.Dialog;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.Window;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.UnsupportedEncodingException;
import java.io.Writer;
import java.net.URL;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import javax.print.DocFlavor;
import javax.print.PrintException;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.swing.table.TableModel;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Element;
import org.jfree.ui.RefineryUtilities;
import org.pentaho.actionsequence.dom.ActionInput;
import org.pentaho.actionsequence.dom.ActionResource;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.actionsequence.dom.IActionInput;
import org.pentaho.actionsequence.dom.IActionOutput;
import org.pentaho.actionsequence.dom.IActionResource;
import org.pentaho.actionsequence.dom.actions.ActionDefinition;
import org.pentaho.actionsequence.dom.actions.ActionFactory;
import org.pentaho.actionsequence.dom.actions.IActionParameterMgr;
import org.pentaho.actionsequence.dom.actions.JFreeReportAction;
import org.pentaho.commons.connection.ActivationHelper;
import org.pentaho.commons.connection.IPentahoMetaData;
import org.pentaho.commons.connection.IPentahoResultSet;
import org.pentaho.platform.api.data.IDataComponent;
import org.pentaho.platform.api.data.IPreparedComponent;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IApplicationContext;
import org.pentaho.platform.api.engine.IComponent;
import org.pentaho.platform.api.engine.IPentahoRequestContext;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.engine.core.system.PentahoRequestContextHolder;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.jfreereport.AbstractJFreeReportComponent;
import org.pentaho.platform.plugin.action.jfreereport.components.JFreeReportValidateParametersComponent;
import org.pentaho.platform.plugin.action.jfreereport.helper.PentahoDataFactory;
import org.pentaho.platform.plugin.action.jfreereport.helper.PentahoResourceBundleFactory;
import org.pentaho.platform.plugin.action.jfreereport.helper.PentahoTableDataFactory;
import org.pentaho.platform.plugin.action.jfreereport.helper.PentahoTableModel;
import org.pentaho.platform.plugin.action.jfreereport.helper.PentahoURLRewriter;
import org.pentaho.platform.plugin.action.jfreereport.helper.ReportUtils;
import org.pentaho.platform.plugin.action.messages.Messages;
import org.pentaho.platform.util.xml.XmlHelper;
import org.pentaho.reporting.engine.classic.core.ClassicEngineBoot;
import org.pentaho.reporting.engine.classic.core.DataFactory;
import org.pentaho.reporting.engine.classic.core.DataRow;
import org.pentaho.reporting.engine.classic.core.MasterReport;
import org.pentaho.reporting.engine.classic.core.ParameterDataRow;
import org.pentaho.reporting.engine.classic.core.ReportProcessingException;
import org.pentaho.reporting.engine.classic.core.ResourceBundleFactory;
import org.pentaho.reporting.engine.classic.core.event.ReportProgressListener;
import org.pentaho.reporting.engine.classic.core.layout.output.OutputProcessor;
import org.pentaho.reporting.engine.classic.core.layout.output.YieldReportListener;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.PreviewDialog;
import org.pentaho.reporting.engine.classic.core.modules.gui.base.ReportController;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.base.PageableReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.pageable.pdf.PdfOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.FlowReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.base.StreamReportProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.csv.StreamCSVOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.AllItemsHtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.HtmlPrinter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.StreamHtmlOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.html.URLRewriter;
import org.pentaho.reporting.engine.classic.core.modules.output.table.rtf.StreamRTFOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.table.xls.FlowExcelOutputProcessor;
import org.pentaho.reporting.engine.classic.core.modules.output.xml.XMLProcessor;
import org.pentaho.reporting.engine.classic.core.modules.parser.base.ReportGenerator;
import org.pentaho.reporting.engine.classic.core.util.ReportParameterValues;
import org.pentaho.reporting.engine.classic.extensions.modules.java14print.Java14PrintUtil;
import org.pentaho.reporting.libraries.base.config.Configuration;
import org.pentaho.reporting.libraries.base.config.ModifiableConfiguration;
import org.pentaho.reporting.libraries.base.util.IOUtils;
import org.pentaho.reporting.libraries.repository.ContentIOException;
import org.pentaho.reporting.libraries.repository.ContentLocation;
import org.pentaho.reporting.libraries.repository.DefaultNameGenerator;
import org.pentaho.reporting.libraries.repository.NameGenerator;
import org.pentaho.reporting.libraries.repository.file.FileRepository;
import org.pentaho.reporting.libraries.repository.stream.StreamRepository;
import org.pentaho.reporting.libraries.resourceloader.FactoryParameterKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceException;
import org.pentaho.reporting.libraries.resourceloader.ResourceKey;
import org.pentaho.reporting.libraries.resourceloader.ResourceManager;
import org.xml.sax.InputSource;

public class JFreeReportComponent
extends AbstractJFreeReportComponent {
    protected static final Log logger = LogFactory.getLog(JFreeReportComponent.class);
    private static final long serialVersionUID = -4185151399689983507L;
    private static final int INIT_REPORT_PARAMS_STATUS_PASSED = 1;
    private static final int INIT_REPORT_PARAMS_STATUS_FAILED = 2;
    private static final int INIT_REPORT_PARAMS_STATUS_PROMPT_PENDING = 3;
    private static final String PROGRESS_DIALOG_ENABLED_KEY = "org.jfree.report.modules.gui.base.ProgressDialogEnabled";
    private static final String PROGRESS_BAR_ENABLED_KEY = "org.jfree.report.modules.gui.base.ProgressBarEnabled";
    private static final boolean DO_NOT_USE_THE_CONTENT_REPOSITORY = true;
    private JFreeReportValidateParametersComponent validateParametersComponent;

    public boolean init() {
        return true;
    }

    public void done() {
    }

    public boolean validateSystemSettings() {
        return true;
    }

    public Log getLogger() {
        return LogFactory.getLog(JFreeReportComponent.class);
    }

    protected boolean initAndValidate(IComponent component) {
        component.setInstanceId(this.getInstanceId());
        component.setActionName(this.getActionName());
        component.setProcessId(this.getProcessId());
        component.setComponentDefinition(this.getComponentDefinition());
        component.setRuntimeContext(this.getRuntimeContext());
        component.setSession(this.getSession());
        component.setLoggingLevel(this.getLoggingLevel());
        component.setMessages(this.getMessages());
        return component.validate() == 1;
    }

    public boolean validateAction() {
        boolean result = true;
        if (!(this.getActionDefinition() instanceof JFreeReportAction)) {
            this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0001_UNKNOWN_ACTION_TYPE", new Object[]{this.getActionDefinition().getElement().asXML()}));
            result = false;
        } else {
            this.validateParametersComponent = new JFreeReportValidateParametersComponent();
            if (!this.initAndValidate((IComponent)this.validateParametersComponent)) {
                this.error(Messages.getInstance().getString("JFreeReportComponent.ERROR_0025_COULD_NOT_VALIDATE"));
                result = false;
            }
        }
        return result;
    }

    private boolean isParameterUIAvailable() {
        if (!this.feedbackAllowed()) {
            this.error(Messages.getInstance().getErrorString("JFreeReport.ERROR_0020_INVALID_FEEDBACK_STREAM"));
            return false;
        }
        this.setFeedbackMimeType("text/html");
        return true;
    }

    private int initReportParams() {
        IActionInput[] actionInputs;
        JFreeReportAction jFreeReportAction = (JFreeReportAction)this.getActionDefinition();
        int result = 1;
        String defaultValue = "";
        for (IActionInput element : actionInputs = jFreeReportAction.getInputs()) {
            Object paramValue = element.getValue();
            String inputName = element.getName();
            if (paramValue != null && !"".equals(paramValue)) continue;
            IActionParameter paramParameter = this.getInputParameter(inputName);
            if (paramParameter.getPromptStatus() == 3) {
                result = 3;
                continue;
            }
            if (this.isParameterUIAvailable()) {
                this.createFeedbackParameter(inputName, inputName, "", "", true);
                result = 3;
                continue;
            }
            result = 2;
        }
        return result;
    }

    public boolean executeAction() {
        int initParamsResult = this.initReportParams();
        boolean result = false;
        if (initParamsResult == 2) {
            result = false;
        } else if (initParamsResult == 3 || this.isPromptPending()) {
            result = true;
        } else if (initParamsResult == 1) {
            result = this.executeReportAction();
        }
        return result;
    }

    protected boolean executeReportAction() {
        boolean result = false;
        try {
            MasterReport report = this.getReport();
            if (report != null) {
                this.addTempParameterObject("_REPORT.OBJECT", report);
                if (this.initReportConfigParameters(report) && this.initReportInputs(report)) {
                    result = this.generateReport(report, this.getDataFactory());
                }
            }
        }
        catch (ClassNotFoundException ex) {
            this.error(Messages.getInstance().getErrorString("JFreeReport.ERROR_0021_DATA_COMPONENT_FAILED"), ex);
        }
        catch (InstantiationException ex) {
            this.error(Messages.getInstance().getErrorString("JFreeReport.ERROR_0021_DATA_COMPONENT_FAILED"), ex);
        }
        catch (IllegalAccessException ex) {
            this.error(Messages.getInstance().getErrorString("JFreeReport.ERROR_0021_DATA_COMPONENT_FAILED"), ex);
        }
        catch (IOException ex) {
            this.error(Messages.getInstance().getErrorString("JFreeReport.ERROR_0008_INVALID_OUTPUT_STREAM"), ex);
        }
        catch (Exception ex) {
            this.error(ex.getMessage());
        }
        return result;
    }

    protected PentahoTableDataFactory getDataFactory() throws ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        PentahoTableDataFactory factory = null;
        factory = this.getQueryComponentDataFactory();
        if (factory == null) {
            factory = this.getInputParamDataFactory();
        }
        if (factory == null) {
            factory = this.getJarDataFactory();
        }
        if (factory == null) {
            throw new Exception(Messages.getInstance().getString("JFreeReport.ERROR_0022_DATA_INPUT_INVALID_OBJECT"));
        }
        return factory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PentahoTableDataFactory getQueryComponentDataFactory() throws ClassNotFoundException, InstantiationException, IllegalAccessException, Exception {
        PentahoTableDataFactory factory;
        block14: {
            JFreeReportAction jFreeReportAction = (JFreeReportAction)this.getActionDefinition();
            factory = null;
            String dataComponentName = jFreeReportAction.getDataComponent().getStringValue();
            String origComponentName = jFreeReportAction.getComponentName();
            if (dataComponentName != null) {
                if ("sql".equalsIgnoreCase(dataComponentName)) {
                    dataComponentName = "org.pentaho.platform.plugin.action.sql.SQLDataComponent";
                } else if ("mdx".equalsIgnoreCase(dataComponentName)) {
                    dataComponentName = "org.pentaho.platform.plugin.action.mdx.MDXDataComponent";
                }
                try {
                    jFreeReportAction.setComponentName(dataComponentName);
                    ActionDefinition tmpActionDefinition = ActionFactory.getActionDefinition((Element)jFreeReportAction.getElement(), (IActionParameterMgr)jFreeReportAction.getActionParameterMgr());
                    Class<?> componentClass = Class.forName(dataComponentName);
                    IDataComponent dataComponent = (IDataComponent)componentClass.newInstance();
                    dataComponent.setInstanceId(this.getInstanceId());
                    dataComponent.setActionName(this.getActionName());
                    dataComponent.setProcessId(this.getProcessId());
                    dataComponent.setActionDefinition((IActionDefinition)tmpActionDefinition);
                    dataComponent.setComponentDefinition(this.getComponentDefinition());
                    dataComponent.setRuntimeContext(this.getRuntimeContext());
                    dataComponent.setSession(this.getSession());
                    dataComponent.setLoggingLevel(this.getLoggingLevel());
                    dataComponent.setMessages(this.getMessages());
                    if (dataComponent.validate() == 1 && dataComponent.init() && dataComponent.execute() == 6) {
                        IPentahoResultSet resultset = dataComponent.getResultSet();
                        factory = new PentahoTableDataFactory("default", new PentahoTableModel(resultset));
                        break block14;
                    }
                    throw new IllegalArgumentException(Messages.getInstance().getErrorString("JFreeReport.ERROR_0021_DATA_COMPONENT_FAILED"));
                }
                catch (ClassNotFoundException e) {
                    logger.error(null, (Throwable)e);
                }
                catch (InstantiationException e) {
                    logger.error(null, (Throwable)e);
                }
                catch (IllegalAccessException e) {
                    logger.error(null, (Throwable)e);
                }
                finally {
                    jFreeReportAction.setComponentName(origComponentName);
                }
            }
        }
        return factory;
    }

    private PentahoTableDataFactory getJarDataFactory() throws Exception {
        PentahoTableDataFactory factory;
        block11: {
            factory = null;
            JFreeReportAction jFreeReportAction = (JFreeReportAction)this.getActionDefinition();
            try {
                IActionResource actionResource = jFreeReportAction.getDataJar().getJar();
                if (actionResource == null) break block11;
                ActivationHelper.PentahoStreamSourceWrapper dataSource = new ActivationHelper.PentahoStreamSourceWrapper(actionResource.getDataSource());
                InputStream in = dataSource.getInputStream();
                try {
                    IActionInput[] actionInputs;
                    if (in.read() == -1) {
                        throw new Exception(Messages.getInstance().getErrorString("JFreeReport.ERROR_0009_REPORT_JAR_UNREADABLE"));
                    }
                    ClassLoader loader = ReportUtils.createJarLoader(this.getSession(), this.getResource(actionResource.getName()));
                    if (loader == null) {
                        throw new Exception(Messages.getInstance().getString("JFreeReportDataComponent.ERROR_0035_COULD_NOT_CREATE_CLASSLOADER"));
                    }
                    if (!this.isDefinedInput("class-location")) {
                        throw new Exception(Messages.getInstance().getErrorString("JFreeReport.ERROR_0012_CLASS_LOCATION_MISSING"));
                    }
                    ReportParameterValues reportProperties = new ReportParameterValues();
                    for (IActionInput element : actionInputs = jFreeReportAction.getInputs()) {
                        Object paramValue = element.getValue();
                        if (paramValue instanceof Object[]) {
                            Object[] values = (Object[])paramValue;
                            StringBuffer valuesBuffer = new StringBuffer();
                            for (int z = 0; z < values.length; ++z) {
                                if (z == 0) {
                                    valuesBuffer.append(values[z].toString());
                                    continue;
                                }
                                valuesBuffer.append(',').append(values[z].toString());
                            }
                            reportProperties.put(element.getName(), (Object)valuesBuffer.toString());
                            continue;
                        }
                        reportProperties.put(element.getName(), paramValue);
                    }
                    PentahoDataFactory dataFactory = new PentahoDataFactory(loader);
                    TableModel model = dataFactory.queryData(jFreeReportAction.getDataJar().getDataClass(), (DataRow)new ParameterDataRow((DataRow)reportProperties));
                    factory = new PentahoTableDataFactory("default", model);
                }
                catch (Exception e) {
                    throw new Exception(Messages.getInstance().getErrorString("JFreeReport.ERROR_0009_REPORT_JAR_UNREADABLE"));
                }
            }
            catch (FileNotFoundException e1) {
                throw new Exception(Messages.getInstance().getErrorString("JFreeReport.ERROR_0010_REPORT_JAR_MISSING", new Object[]{jFreeReportAction.getDataJar().toString()}));
            }
        }
        return factory;
    }

    private PentahoTableDataFactory getInputParamDataFactory() {
        Object dataObject;
        PentahoTableDataFactory factory = null;
        JFreeReportAction jFreeReportAction = (JFreeReportAction)this.getActionDefinition();
        ActionInput reportDataParam = (ActionInput)jFreeReportAction.getData();
        Object object = dataObject = reportDataParam != null ? reportDataParam.getValue() : null;
        if (dataObject instanceof IPentahoResultSet || dataObject instanceof TableModel) {
            ActionInput[] subreportQueries;
            factory = new PentahoTableDataFactory();
            if (dataObject instanceof IPentahoResultSet) {
                IPentahoResultSet resultset = (IPentahoResultSet)dataObject;
                if (resultset.isScrollable()) {
                    resultset.beforeFirst();
                } else {
                    this.debug("ResultSet is not scrollable. Copying into memory");
                    IPentahoResultSet memSet = resultset.memoryCopy();
                    resultset.close();
                    resultset = memSet;
                }
                factory.addTable("default", new PentahoTableModel(resultset));
            } else if (dataObject instanceof TableModel) {
                factory.addTable("default", (TableModel)dataObject);
            }
            for (ActionInput element : subreportQueries = jFreeReportAction.getSubreportQueryParams()) {
                dataObject = element.getValue();
                if (dataObject instanceof IPreparedComponent) {
                    factory.addPreparedComponent(element.getName(), (IPreparedComponent)dataObject);
                    continue;
                }
                if (dataObject instanceof IPentahoResultSet) {
                    IPentahoResultSet resultset = (IPentahoResultSet)dataObject;
                    resultset.beforeFirst();
                    factory.addTable(element.getName(), new PentahoTableModel(resultset));
                    continue;
                }
                if (!(dataObject instanceof TableModel)) continue;
                factory.addTable(element.getName(), (TableModel)dataObject);
            }
        }
        return factory;
    }

    private String getHostColonPort(String pentahoBaseURL) {
        try {
            URL url = new URL(pentahoBaseURL);
            return url.getHost() + ":" + url.getPort();
        }
        catch (Exception exception) {
            return pentahoBaseURL;
        }
    }

    private String getBaseServerURL(String pentahoBaseURL) {
        try {
            URL url = new URL(pentahoBaseURL);
            return url.getProtocol() + "://" + url.getHost() + ":" + url.getPort();
        }
        catch (Exception exception) {
            return pentahoBaseURL;
        }
    }

    private MasterReport parseReport(IActionSequenceResource resource) {
        try {
            String resourceUrl = "solution:/" + resource.getAddress();
            String fullyQualifiedServerURL = PentahoSystem.getApplicationContext().getFullyQualifiedServerURL();
            HashMap<FactoryParameterKey, String> helperObjects = new HashMap<FactoryParameterKey, String>();
            helperObjects.put(new FactoryParameterKey("pentahoBaseURL"), fullyQualifiedServerURL);
            helperObjects.put(new FactoryParameterKey("serverBaseURL"), this.getBaseServerURL(fullyQualifiedServerURL));
            helperObjects.put(new FactoryParameterKey("solutionRoot"), PentahoSystem.getApplicationContext().getSolutionPath(""));
            helperObjects.put(new FactoryParameterKey("hostColonPort"), this.getHostColonPort(fullyQualifiedServerURL));
            helperObjects.put(new FactoryParameterKey("requestContextPath"), PentahoRequestContextHolder.getRequestContext().getContextPath());
            Iterator it = this.getInputNames().iterator();
            while (it.hasNext()) {
                try {
                    String inputName = (String)it.next();
                    if ("data".equals(inputName)) continue;
                    String inputValue = this.getInputStringValue(inputName);
                    helperObjects.put(new FactoryParameterKey(inputName), inputValue);
                }
                catch (Exception e) {}
            }
            ResourceManager resourceManager = new ResourceManager();
            resourceManager.registerDefaults();
            ResourceKey contextKey = resourceManager.createKey((Object)resourceUrl, helperObjects);
            ResourceKey key = resourceManager.createKey((Object)resourceUrl, helperObjects);
            return ReportGenerator.getInstance().parseReport(resourceManager, key, contextKey);
        }
        catch (Exception ex) {
            this.error(Messages.getInstance().getErrorString("JFreeReport.ERROR_0007_COULD_NOT_PARSE", new Object[]{resource.getAddress()}), ex);
            return null;
        }
    }

    public MasterReport getReport() throws Exception {
        JFreeReportAction jFreeReportAction = (JFreeReportAction)this.getActionDefinition();
        MasterReport report = this.getReportFromResource();
        if (report == null && (report = this.getReportFromInputParam()) == null) {
            report = this.getReportFromJar();
        }
        if (report != null && jFreeReportAction.getCreatePrivateCopy().getBooleanValue(false)) {
            report = report.clone();
        }
        return report;
    }

    private MasterReport getReportFromResource() throws ResourceException, IOException {
        JFreeReportAction jFreeReportAction = (JFreeReportAction)this.getActionDefinition();
        MasterReport report = null;
        Object reportDefinition = jFreeReportAction.getReportDefinition();
        IActionSequenceResource resource = null;
        if (reportDefinition instanceof ActionResource) {
            resource = this.getResource(((ActionResource)reportDefinition).getName());
        }
        if (resource != null) {
            if (resource.getSourceType() == 6) {
                String repDef = resource.getAddress();
                ReportGenerator generator = ReportGenerator.createInstance();
                String encoding = XmlHelper.getEncoding((String)repDef, null);
                ByteArrayInputStream inStream = new ByteArrayInputStream(repDef.getBytes(encoding));
                InputSource repDefInputSource = new InputSource(inStream);
                repDefInputSource.setEncoding(encoding);
                report = generator.parseReport(repDefInputSource, this.getDefinedResourceURL(null));
            } else {
                report = this.parseReport(resource);
            }
        }
        return report;
    }

    private MasterReport getReportFromInputParam() throws ResourceException, UnsupportedEncodingException, IOException {
        MasterReport report = null;
        JFreeReportAction jFreeReportAction = (JFreeReportAction)this.getActionDefinition();
        Object reportDefinition = jFreeReportAction.getReportDefinition();
        if (reportDefinition instanceof ActionInput) {
            String repDef = ((ActionInput)reportDefinition).getStringValue();
            report = this.createReport(repDef);
        }
        return report;
    }

    protected MasterReport createReport(String reportDefinition) throws ResourceException, IOException {
        ReportGenerator generator = ReportGenerator.createInstance();
        URL url = null;
        IPentahoRequestContext requestContext = PentahoRequestContextHolder.getRequestContext();
        try {
            url = new URL(requestContext.getContextPath());
        }
        catch (Exception e) {
            this.warn(Messages.getInstance().getString("JFreeReportLoadComponent.WARN_COULD_NOT_CREATE_URL"));
        }
        String encoding = XmlHelper.getEncoding((String)reportDefinition, null);
        ByteArrayInputStream inStream = new ByteArrayInputStream(reportDefinition.getBytes(encoding));
        InputSource reportDefinitionInputSource = new InputSource(inStream);
        reportDefinitionInputSource.setEncoding(encoding);
        return generator.parseReport(reportDefinitionInputSource, this.getDefinedResourceURL(url));
    }

    private MasterReport getReportFromJar() throws Exception {
        MasterReport report;
        JFreeReportAction jFreeReportAction = (JFreeReportAction)this.getActionDefinition();
        IActionResource reportJar = jFreeReportAction.getReportDefinitionJar().getJar();
        IActionSequenceResource resource = this.getResource(reportJar.getName());
        ClassLoader loader = ReportUtils.createJarLoader(this.getSession(), resource);
        if (loader == null) {
            throw new Exception(Messages.getInstance().getString("JFreeReportLoadComponent.ERROR_0035_COULD_NOT_CREATE_CLASSLOADER"));
        }
        String reportLocation = jFreeReportAction.getReportDefinitionJar().getReportLocation();
        URL resourceUrl = loader.getResource(reportLocation);
        if (resourceUrl == null) {
            throw new Exception(Messages.getInstance().getErrorString("JFreeReport.ERROR_0016_REPORT_RESOURCE_INVALID", new Object[]{reportLocation, resource.getAddress()}));
        }
        try {
            ReportGenerator generator = ReportGenerator.getInstance();
            report = generator.parseReport(resourceUrl, this.getDefinedResourceURL(resourceUrl));
        }
        catch (Exception ex) {
            throw new Exception(Messages.getInstance().getErrorString("JFreeReport.ERROR_0007_COULD_NOT_PARSE", new Object[]{reportLocation}), ex);
        }
        return report;
    }

    private URL getDefinedResourceURL(URL defaultValue) {
        if (!this.isDefinedInput("res-url")) {
            return defaultValue;
        }
        try {
            String inputStringValue = this.getInputStringValue(Messages.getInstance().getString("res-url"));
            return new URL(inputStringValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    private boolean initReportConfigParameters(MasterReport report) {
        Object reportConfigParams;
        JFreeReportAction jFreeReportAction = (JFreeReportAction)this.getActionDefinition();
        boolean result = true;
        if (this.isDefinedInput("_REPORT.OBJECT") && (reportConfigParams = jFreeReportAction.getReportConfig().getValue()) != null) {
            if (reportConfigParams instanceof IPentahoResultSet) {
                this.setReportConfigParameters(report, (IPentahoResultSet)reportConfigParams);
            } else if (reportConfigParams instanceof Map) {
                this.setReportConfigParameters(report, (Map)reportConfigParams);
            } else if (reportConfigParams instanceof JFreeReportAction.StaticReportConfig) {
                this.setReportConfigParameters(report, (JFreeReportAction.StaticReportConfig)reportConfigParams);
            } else {
                this.error(Messages.getInstance().getErrorString("JFreeReport.ERROR_0026_UNKNOWN_REPORT_CONFIGURATION_PARAMETERS"));
                result = false;
            }
        }
        return result;
    }

    private void setReportConfigParameters(MasterReport report, JFreeReportAction.StaticReportConfig reportConfig) {
        for (int i = 0; i < reportConfig.size(); ++i) {
            JFreeReportAction.StaticReportConfigItem staticReportConfigItem = (JFreeReportAction.StaticReportConfigItem)reportConfig.get(i);
            String parmName = staticReportConfigItem.getName();
            String parmValue = staticReportConfigItem.getValue();
            if (parmName == null || parmName.length() == 0) {
                this.error(Messages.getInstance().getErrorString("JFreeReport.ERROR_0027_REPORT_CONFIGURATION_PARAMETER_IGNORED"));
                continue;
            }
            if (parmValue != null) {
                if ((parmValue = parmValue.trim()).length() > 0) {
                    report.getReportConfiguration().setConfigProperty(parmName, this.applyInputsToFormat(parmValue));
                    continue;
                }
                this.error(Messages.getInstance().getErrorString("JFreeReport.ERROR_0027_REPORT_CONFIGURATION_PARAMETER_IGNORED"));
                continue;
            }
            this.error(Messages.getInstance().getErrorString("JFreeReport.ERROR_0027_REPORT_CONFIGURATION_PARAMETER_IGNORED"));
        }
    }

    private void setReportConfigParameters(MasterReport report, Map values) {
        ModifiableConfiguration config = report.getReportConfiguration();
        for (Map.Entry ent : values.entrySet()) {
            if (ent.getKey() == null || ent.getValue() == null) continue;
            config.setConfigProperty(ent.getKey().toString(), this.applyInputsToFormat(ent.getValue().toString()));
        }
    }

    private void setReportConfigParameters(MasterReport report, IPentahoResultSet values) {
        int rowCount = values.getRowCount();
        int colCount = values.getColumnCount();
        ModifiableConfiguration config = report.getReportConfiguration();
        if (colCount >= 2) {
            IPentahoMetaData md = values.getMetaData();
            int nameIdx = md.getColumnIndex("name");
            int valIdx = md.getColumnIndex("value");
            if (nameIdx < 0) {
                nameIdx = 0;
            }
            if (valIdx < 0) {
                valIdx = 1;
            }
            for (int i = 0; i < rowCount; ++i) {
                Object[] aRow = values.getDataRow(i);
                if (aRow[nameIdx] == null || aRow[valIdx] == null) continue;
                config.setConfigProperty(aRow[nameIdx].toString(), this.applyInputsToFormat(aRow[valIdx].toString()));
            }
        } else {
            this.error(Messages.getInstance().getErrorString("JFreeReport.ERROR_0025_INVALID_REPORT_CONFIGURATION_PARAMETERS"));
        }
    }

    private boolean initReportInputs(MasterReport report) throws CloneNotSupportedException {
        IActionInput[] actionInputs;
        JFreeReportAction jFreeReportAction = (JFreeReportAction)this.getActionDefinition();
        for (IActionInput element : actionInputs = jFreeReportAction.getInputs()) {
            String paramName = element.getName();
            Object paramValue = element.getValue();
            if (paramValue == null || "".equals(paramValue) || paramValue instanceof IPentahoResultSet || paramValue instanceof TableModel || "_REPORT.OBJECT".equals(paramName) || "_REPORT.DATA".equals(paramName) || "data".equals(paramName)) continue;
            if (paramValue instanceof Object[]) {
                Object[] values = (Object[])paramValue;
                StringBuffer valuesBuffer = new StringBuffer();
                for (int j = 0; j < values.length; ++j) {
                    if (j == 0) {
                        valuesBuffer.append(values[j].toString());
                        continue;
                    }
                    valuesBuffer.append(',').append(values[j].toString());
                }
                report.getParameterValues().put(paramName, (Object)valuesBuffer.toString());
                continue;
            }
            report.getParameterValues().put(paramName, paramValue);
        }
        return true;
    }

    private String getMimeType(String outputFormat) {
        String mimeType = null;
        if ("html".equals(outputFormat)) {
            mimeType = "text/html";
        } else if ("pdf".equals(outputFormat)) {
            mimeType = "application/pdf";
        } else if ("xls".equals(outputFormat)) {
            mimeType = "application/vnd.ms-excel";
        } else if ("csv".equals(outputFormat)) {
            mimeType = "text/csv";
        } else if ("rtf".equals(outputFormat)) {
            mimeType = "application/rtf";
        } else if ("xml".equals(outputFormat)) {
            mimeType = "text/xml";
        }
        return mimeType;
    }

    private String getFileExtension(String outputFormat) {
        String fileExtension = null;
        if ("html".equals(outputFormat)) {
            fileExtension = ".html";
        } else if ("pdf".equals(outputFormat)) {
            fileExtension = ".pdf";
        } else if ("xls".equals(outputFormat)) {
            fileExtension = ".xls";
        } else if ("csv".equals(outputFormat)) {
            fileExtension = ".csv";
        } else if ("rtf".equals(outputFormat)) {
            fileExtension = ".rtf";
        } else if ("xml".equals(outputFormat)) {
            fileExtension = ".xml";
        }
        return fileExtension;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean generateReport(MasterReport report, PentahoTableDataFactory factory) throws IOException {
        JFreeReportAction jFreeReportAction = (JFreeReportAction)this.getActionDefinition();
        boolean result = false;
        try {
            this.applyThreadPriority();
            String baseName = IOUtils.getInstance().stripFileExtension(this.getActionName());
            String path = this.getSolutionPath();
            PentahoResourceBundleFactory bundleFactory = new PentahoResourceBundleFactory(path, baseName, this.getSession());
            report.setResourceBundleFactory((ResourceBundleFactory)bundleFactory);
            report.getReportConfiguration().setConfigProperty("org.pentaho.reporting.engine.classic.core.ResourceBundle", baseName);
            if (factory != null) {
                report.setDataFactory((DataFactory)factory);
            }
            String printerName = jFreeReportAction.getPrinterName().getStringValue();
            String outputFormat = jFreeReportAction.getOutputType().getStringValue();
            if (printerName != null) {
                result = this.print(report, this.getActionTitle(), printerName);
            } else if ("swing-preview".equals(outputFormat)) {
                if (GraphicsEnvironment.isHeadless()) {
                    result = this.writeSwingPreview(report);
                }
                this.warn(Messages.getInstance().getString("JFreeReportAllContentComponent.WARN_HEADLESSMODE_ACTIVE"));
            } else if ("html".equals(outputFormat) || "pdf".equals(outputFormat) || "xls".equals(outputFormat) || "csv".equals(outputFormat) || "rtf".equals(outputFormat) || "xml".equals(outputFormat)) {
                String mimeType = this.getMimeType(outputFormat);
                String fileExtention = this.getFileExtension(outputFormat);
                IContentItem contentItem = this.getContentItem(mimeType, fileExtention);
                OutputStream outputStream = null;
                outputStream = contentItem != null ? contentItem.getOutputStream(this.getActionName()) : this.getDefaultOutputStream(mimeType);
                result = this.writeReport(outputFormat, report, outputStream, jFreeReportAction.getReportGenerationYieldRate().getIntValue(0), jFreeReportAction.getHtmlContentHandlerUrlPattern().getStringValue());
                if (contentItem != null) {
                    contentItem.closeOutputStream();
                }
            } else {
                this.warn(Messages.getInstance().getString("JFreeReportAllContentComponent.WARN_NO_PRINTER_GIVEN"));
            }
        }
        finally {
            if (factory != null) {
                factory.closeTables();
            }
        }
        return result;
    }

    private void applyThreadPriority() {
        String priority = ((JFreeReportAction)this.getActionDefinition()).getReportGenerationPriority().getStringValue();
        try {
            if ("lower".equals(priority)) {
                Thread.currentThread().setPriority(Math.max(Thread.currentThread().getPriority() - 1, 1));
            } else if ("lowest".equals(priority)) {
                Thread.currentThread().setPriority(1);
            }
        }
        catch (Exception e) {
            this.warn(Messages.getInstance().getString("AbstractGenerateContentComponent.JFreeReport.ERROR_0044_UNABLE_T0_SET_THREAD_PRIORITY"));
        }
    }

    protected IContentItem getContentItem(String mimeType, String extension) {
        JFreeReportAction jFreeReportAction = (JFreeReportAction)this.getActionDefinition();
        IContentItem contentItem = null;
        IActionOutput actionOutput = jFreeReportAction.getOutputReport();
        if (actionOutput != null) {
            contentItem = this.getOutputItem(actionOutput.getName(), mimeType, extension);
            contentItem.setMimeType(mimeType);
        } else if (this.getOutputNames().size() == 1) {
            String outputName = (String)this.getOutputNames().iterator().next();
            contentItem = this.getOutputContentItem(outputName, mimeType);
            contentItem.setMimeType(mimeType);
        }
        return contentItem;
    }

    private boolean writeReport(String outputFormat, MasterReport report, OutputStream outputStream, int yieldRate, String htmlContentHandlerUrlPattern) {
        boolean result = false;
        if ("html".equals(outputFormat)) {
            result = this.writeHtml(report, outputStream, yieldRate, htmlContentHandlerUrlPattern);
        } else if ("pdf".equals(outputFormat)) {
            result = this.writePdf(report, outputStream, yieldRate);
        } else if ("xls".equals(outputFormat)) {
            result = this.writeXls(report, outputStream, yieldRate);
        } else if ("csv".equals(outputFormat)) {
            result = this.writeCsv(report, outputStream, yieldRate);
        } else if ("rtf".equals(outputFormat)) {
            result = this.writeRtf(report, outputStream, yieldRate);
        } else if ("xml".equals(outputFormat)) {
            result = this.writeXml(report, outputStream);
        }
        return result;
    }

    public boolean writeHtml(MasterReport report, OutputStream outputStream, int yieldRate, String htmlContentHandlerUrlPattern) {
        try {
            PentahoURLRewriter rewriter;
            DefaultNameGenerator dataNameGenerator;
            ContentLocation dataLocation;
            IApplicationContext ctx;
            if (htmlContentHandlerUrlPattern == null) {
                Configuration globalConfig = ClassicEngineBoot.getInstance().getGlobalConfig();
                htmlContentHandlerUrlPattern = PentahoRequestContextHolder.getRequestContext().getContextPath();
                htmlContentHandlerUrlPattern = htmlContentHandlerUrlPattern + globalConfig.getConfigProperty("org.pentaho.web.ContentHandler");
            }
            if ((ctx = PentahoSystem.getApplicationContext()) != null) {
                File dataDirectory = new File(ctx.getFileOutputPath("system/tmp/"));
                if (dataDirectory.exists() && !dataDirectory.isDirectory()) {
                    if (!(dataDirectory = dataDirectory.getParentFile()).isDirectory()) {
                        throw new ReportProcessingException(Messages.getInstance().getErrorString("JFreeReportDirectoryComponent.ERROR_0001_INVALID_DIR", new Object[]{dataDirectory.getPath()}));
                    }
                } else if (!dataDirectory.exists()) {
                    dataDirectory.mkdirs();
                }
                FileRepository dataRepository = new FileRepository(dataDirectory);
                dataLocation = dataRepository.getRoot();
                dataNameGenerator = new DefaultNameGenerator(dataLocation);
                rewriter = new PentahoURLRewriter(htmlContentHandlerUrlPattern);
            } else {
                dataLocation = null;
                dataNameGenerator = null;
                rewriter = new PentahoURLRewriter(htmlContentHandlerUrlPattern);
            }
            StreamRepository targetRepository = new StreamRepository(null, outputStream);
            ContentLocation targetRoot = targetRepository.getRoot();
            StreamHtmlOutputProcessor outputProcessor = new StreamHtmlOutputProcessor(report.getConfiguration());
            AllItemsHtmlPrinter printer = new AllItemsHtmlPrinter(report.getResourceManager());
            printer.setContentWriter(targetRoot, (NameGenerator)new DefaultNameGenerator(targetRoot, "index", "html"));
            printer.setDataWriter(dataLocation, (NameGenerator)dataNameGenerator);
            printer.setUrlRewriter((URLRewriter)rewriter);
            outputProcessor.setPrinter((HtmlPrinter)printer);
            StreamReportProcessor sp = new StreamReportProcessor(report, (OutputProcessor)outputProcessor);
            if (yieldRate > 0) {
                sp.addReportProgressListener((ReportProgressListener)new YieldReportListener(yieldRate));
            }
            sp.processReport();
            sp.close();
            outputStream.flush();
            return true;
        }
        catch (ReportProcessingException e) {
            this.error(Messages.getInstance().getString("JFreeReportHtmlComponent.ERROR_0046_FAILED_TO_PROCESS_REPORT"), e);
            return false;
        }
        catch (IOException e) {
            this.error(Messages.getInstance().getString("JFreeReportHtmlComponent.ERROR_0046_FAILED_TO_PROCESS_REPORT"), e);
            return false;
        }
        catch (ContentIOException e) {
            this.error(Messages.getInstance().getString("JFreeReportHtmlComponent.ERROR_0046_FAILED_TO_PROCESS_REPORT"), e);
            return false;
        }
    }

    protected boolean writeXls(MasterReport report, OutputStream outputStream, int yieldRate) {
        boolean result = false;
        try {
            FlowExcelOutputProcessor target = new FlowExcelOutputProcessor(report.getConfiguration(), outputStream, report.getResourceManager());
            FlowReportProcessor reportProcessor = new FlowReportProcessor(report, (OutputProcessor)target);
            if (this.isDefinedInput("workbook")) {
                target.setTemplateInputStream(this.getInputStream("workbook"));
            }
            if (yieldRate > 0) {
                reportProcessor.addReportProgressListener((ReportProgressListener)new YieldReportListener(yieldRate));
            }
            reportProcessor.processReport();
            reportProcessor.close();
            outputStream.flush();
            result = true;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getString("JFreeReportExcelComponent.ERROR_0037_ERROR_READING_REPORT_INPUT"), e);
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected boolean writePdf(MasterReport report, OutputStream outputStream, int yieldRate) {
        PageableReportProcessor proc = null;
        boolean result = false;
        try {
            PdfOutputProcessor outputProcessor = new PdfOutputProcessor(report.getConfiguration(), outputStream);
            proc = new PageableReportProcessor(report, (PageableOutputProcessor)outputProcessor);
            if (yieldRate > 0) {
                proc.addReportProgressListener((ReportProgressListener)new YieldReportListener(yieldRate));
            }
            proc.processReport();
            proc.close();
            proc = null;
            result = true;
        }
        catch (Exception e) {
            this.error(Messages.getInstance().getErrorString("JFreeReportPdfComponent.ERROR_0001_WRITING_PDF_FAILED", new Object[]{e.getLocalizedMessage()}), e);
        }
        finally {
            if (proc != null) {
                proc.close();
            }
        }
        return result;
    }

    public boolean print(MasterReport report, String jobName, String printerName) {
        PrintService[] services;
        boolean result = false;
        if (jobName != null) {
            report.getReportConfiguration().setConfigProperty("org.pentaho.reporting.engine.classic.core.modules.output.pageable.graphics.print.JobName", String.valueOf(jobName));
        }
        PrintService printer = null;
        for (PrintService service : services = PrintServiceLookup.lookupPrintServices(DocFlavor.SERVICE_FORMATTED.PAGEABLE, null)) {
            if (!service.getName().equals(printerName)) continue;
            printer = service;
        }
        if (printer == null && services.length > 0) {
            printer = services[0];
        }
        try {
            Java14PrintUtil.printDirectly((MasterReport)report, printer);
            result = true;
        }
        catch (PrintException e) {
        }
        catch (ReportProcessingException e) {
            // empty catch block
        }
        return result;
    }

    protected boolean writeCsv(MasterReport report, OutputStream outputStream, int yieldRate) {
        boolean result = false;
        try {
            StreamCSVOutputProcessor target = new StreamCSVOutputProcessor(outputStream);
            StreamReportProcessor reportProcessor = new StreamReportProcessor(report, (OutputProcessor)target);
            if (yieldRate > 0) {
                reportProcessor.addReportProgressListener((ReportProgressListener)new YieldReportListener(yieldRate));
            }
            reportProcessor.processReport();
            reportProcessor.close();
            outputStream.flush();
            result = true;
        }
        catch (ReportProcessingException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    protected boolean writeRtf(MasterReport report, OutputStream outputStream, int yieldRate) {
        boolean result = false;
        try {
            StreamRTFOutputProcessor target = new StreamRTFOutputProcessor(report.getConfiguration(), outputStream, report.getResourceManager());
            StreamReportProcessor proc = new StreamReportProcessor(report, (OutputProcessor)target);
            if (yieldRate > 0) {
                proc.addReportProgressListener((ReportProgressListener)new YieldReportListener(yieldRate));
            }
            proc.processReport();
            proc.close();
            outputStream.close();
            result = true;
        }
        catch (ReportProcessingException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return result;
    }

    protected boolean writeXml(MasterReport report, OutputStream outputStream) {
        boolean result = false;
        try {
            XMLProcessor processor = new XMLProcessor(report);
            OutputStreamWriter writer = new OutputStreamWriter(outputStream);
            processor.setWriter((Writer)writer);
            processor.processReport();
            writer.close();
            result = true;
        }
        catch (ReportProcessingException e) {
            this.error(Messages.getInstance().getString("JFreeReportXmlComponent.ERROR_0046_FAILED_TO_PROCESS_REPORT"), e);
        }
        catch (IOException e) {
            this.error(Messages.getInstance().getString("JFreeReportXmlComponent.ERROR_0046_FAILED_TO_PROCESS_REPORT"), e);
        }
        return result;
    }

    protected boolean writeSwingPreview(MasterReport report) {
        ModifiableConfiguration reportConfiguration = report.getReportConfiguration();
        boolean progressBar = this.getInputBooleanValue("progress-bar", "true".equals(reportConfiguration.getConfigProperty(PROGRESS_BAR_ENABLED_KEY)));
        boolean progressDialog = this.getInputBooleanValue("progress-dialog", "true".equals(reportConfiguration.getConfigProperty(PROGRESS_DIALOG_ENABLED_KEY)));
        reportConfiguration.setConfigProperty(PROGRESS_DIALOG_ENABLED_KEY, String.valueOf(progressDialog));
        reportConfiguration.setConfigProperty(PROGRESS_BAR_ENABLED_KEY, String.valueOf(progressBar));
        PreviewDialog dialog = this.createDialog(report);
        ReportController reportController = this.getReportController();
        if (reportController != null) {
            dialog.setReportController(reportController);
        }
        dialog.pack();
        if (dialog.getParent() != null) {
            RefineryUtilities.centerDialogInParent((Dialog)dialog);
        } else {
            RefineryUtilities.centerFrameOnScreen((Window)dialog);
        }
        dialog.setVisible(true);
        return true;
    }

    private ReportController getReportController() {
        Object controller;
        if (this.isDefinedInput("report-controler") && (controller = this.getInputValue("report-controler")) instanceof ReportController) {
            return (ReportController)controller;
        }
        return null;
    }

    private PreviewDialog createDialog(MasterReport report) {
        boolean modal = this.getInputBooleanValue("modal", true);
        if (this.isDefinedInput("parent-dialog")) {
            Object parent = this.getInputValue("parent-dialog");
            if (parent instanceof Dialog) {
                return new PreviewDialog(report, (Dialog)parent, modal);
            }
            if (parent instanceof Frame) {
                return new PreviewDialog(report, (Frame)parent, modal);
            }
        }
        PreviewDialog previewDialog = new PreviewDialog(report);
        previewDialog.setModal(modal);
        return previewDialog;
    }
}

