/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.plugin.action.examples;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dom4j.Node;
import org.pentaho.actionsequence.dom.IActionDefinition;
import org.pentaho.commons.connection.IPentahoStreamSource;
import org.pentaho.platform.api.engine.IActionParameter;
import org.pentaho.platform.api.engine.IActionSequenceResource;
import org.pentaho.platform.api.engine.IComponent;
import org.pentaho.platform.api.engine.IPentahoSession;
import org.pentaho.platform.api.engine.IRuntimeContext;
import org.pentaho.platform.api.engine.ISelectionMapper;
import org.pentaho.platform.api.repository.IContentItem;
import org.pentaho.platform.api.util.IVersionHelper;
import org.pentaho.platform.engine.core.system.PentahoSystem;
import org.pentaho.platform.plugin.action.messages.Messages;

public class ComponentImplementationExample
implements IComponent {
    protected int loggingLevel = 100;
    public static final String LOGID_MASK1 = "{0}:{1}:{2}: ";
    public static final String LOGID_MASK2 = "{0}:{1}:{2}:{3} ";
    public static final String LOGID_SEPARATOR = ":";
    public String EMPTYLOGID;
    private String logId = this.EMPTYLOGID = "::: ";
    protected static final boolean debug = true;
    private IRuntimeContext runtimeContext;
    private IPentahoSession sessionContext;
    private String processId;
    private String actionName;
    private String instanceId;
    private String id;
    private boolean baseInitOk;
    private boolean componentInitOk;
    private Node componentDefinition;
    private Map<String, String> componentDefinitionMap;
    private HashMap settings;
    private IActionDefinition actionDefinition;
    private List messages;

    protected boolean executeAction() throws Throwable {
        return false;
    }

    public boolean validateAction() {
        return false;
    }

    protected boolean validateSystemSettings() {
        return false;
    }

    public void done() {
    }

    public boolean init() {
        return false;
    }

    public void setLogId(String lId) {
        this.logId = lId;
    }

    public Log getLogger() {
        return LogFactory.getLog(this.getClass());
    }

    public void genLogIdFromSession(IPentahoSession sess) {
        this.genLogIdFromInfo(sess.getId() != null ? sess.getId() : "", sess.getProcessId() != null ? sess.getProcessId() : "", sess.getActionName() != null ? sess.getActionName() : "");
    }

    public void genLogIdFromInfo(String sessId, String procId, String actName) {
        Object[] args = new Object[]{sessId, procId, actName};
        this.setLogId(MessageFormat.format(LOGID_MASK1, args));
    }

    public void genLogIdFromInfo(String sessId, String procId, String actName, String instId) {
        Object[] args = new Object[]{sessId, procId, actName, instId};
        this.setLogId(MessageFormat.format(LOGID_MASK2, args));
    }

    public String getObjectName() {
        return this.getClass().getName();
    }

    public int getLoggingLevel() {
        return this.loggingLevel;
    }

    public void setLoggingLevel(int logLevel) {
        this.loggingLevel = logLevel;
    }

    public List getMessages() {
        return this.messages;
    }

    public void setMessages(List messages) {
        this.messages = messages;
    }

    public void trace(String message) {
        if (this.loggingLevel <= 1) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_DEBUG", new Object[]{message, this.getClass().getName()}));
            }
            this.getLogger().trace((Object)(this.getLogId() + message));
        }
    }

    public void debug(String message) {
        if (this.loggingLevel <= 2) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_DEBUG", new Object[]{message, this.getClass().getName()}));
            }
            this.getLogger().debug((Object)(this.getLogId() + message));
        }
    }

    public void info(String message) {
        if (this.loggingLevel <= 3) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_INFO", new Object[]{message, this.getClass().getName()}));
            }
            this.getLogger().info((Object)(this.getLogId() + message));
        }
    }

    public void warn(String message) {
        if (this.loggingLevel <= 4) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_WARNING", new Object[]{message, this.getClass().getName()}));
            }
            this.getLogger().warn((Object)(this.getLogId() + message));
        }
    }

    public void error(String message) {
        if (this.loggingLevel <= 5) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_ERROR", new Object[]{message, this.getClass().getName()}));
            }
            this.getLogger().error((Object)(this.getLogId() + message));
        }
    }

    public void fatal(String message) {
        if (this.loggingLevel <= 6) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_ERROR", new Object[]{message, this.getClass().getName()}));
            }
            this.getLogger().fatal((Object)(this.getLogId() + message));
        }
    }

    public void trace(String message, Throwable error) {
        if (this.loggingLevel <= 1) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_DEBUG", new Object[]{message, this.getClass().getName()}));
            }
            this.getLogger().trace((Object)(this.getLogId() + message), error);
        }
    }

    public void debug(String message, Throwable error) {
        if (this.loggingLevel <= 2) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_DEBUG", new Object[]{message, this.getClass().getName()}));
            }
            this.getLogger().debug((Object)(this.getLogId() + message), error);
        }
    }

    public void info(String message, Throwable error) {
        if (this.loggingLevel <= 3) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_INFO", new Object[]{message, this.getClass().getName()}));
            }
            this.getLogger().info((Object)(this.getLogId() + message), error);
        }
    }

    public void warn(String message, Throwable error) {
        if (this.loggingLevel <= 4) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_WARNING", new Object[]{message, this.getClass().getName()}));
            }
            this.getLogger().warn((Object)(this.getLogId() + message), error);
        }
    }

    public void error(String message, Throwable error) {
        if (this.loggingLevel <= 5) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_ERROR", new Object[]{message, this.getClass().getName()}));
            }
            IVersionHelper versionHelper = (IVersionHelper)PentahoSystem.get(IVersionHelper.class, null);
            this.getLogger().error((Object)("Error Start: Pentaho " + versionHelper.getVersionInformation(this.getClass())));
            this.getLogger().error((Object)(this.getLogId() + message), error);
            this.getLogger().error((Object)"Error end:");
        }
    }

    public void fatal(String message, Throwable error) {
        if (this.loggingLevel <= 6) {
            if (this.messages != null) {
                this.messages.add(Messages.getInstance().getString("Message.USER_ERROR", new Object[]{message, this.getClass().getName()}));
            }
            IVersionHelper versionHelper = (IVersionHelper)PentahoSystem.get(IVersionHelper.class, null);
            this.getLogger().error((Object)("Error: Pentaho " + versionHelper.getVersionInformation(this.getClass())));
            this.getLogger().fatal((Object)(this.getLogId() + message), error);
            this.getLogger().error((Object)"Error end:");
        }
    }

    public static String getUserString(String type) {
        return Messages.getInstance().getString("Message.USER_" + type);
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public String getInstanceId() {
        return this.instanceId;
    }

    public void setActionName(String actionName) {
        this.actionName = actionName;
    }

    public String getActionName() {
        return this.actionName;
    }

    public void setProcessId(String processId) {
        this.processId = processId;
    }

    public String getProcessId() {
        return this.processId;
    }

    public void setComponentDefinitionMap(Map<String, String> componentDefinitionMap) {
        this.componentDefinitionMap = componentDefinitionMap;
    }

    public void setComponentDefinition(Node componentDefinition) {
        this.componentDefinition = componentDefinition;
    }

    public Node getComponentDefinition() {
        return this.componentDefinition;
    }

    public void setRuntimeContext(IRuntimeContext runtimeContext) {
        this.runtimeContext = runtimeContext;
    }

    public IRuntimeContext getRuntimeContext() {
        return this.runtimeContext;
    }

    public void setSession(IPentahoSession session) {
        this.sessionContext = session;
    }

    public IPentahoSession getSession() {
        return this.sessionContext;
    }

    protected void saveSetting(String name, Object value) {
        this.settings.put(name, value);
    }

    protected Object getSetting(String name) {
        return this.settings.get(name);
    }

    protected String getStringSetting(String name) {
        Object value = this.settings.get(name);
        if (value == null) {
            return null;
        }
        if (value instanceof String) {
            return (String)value;
        }
        return value.toString();
    }

    public String getLogId() {
        return this.logId;
    }

    protected boolean isDefinedInput(String inputName) {
        if (this.runtimeContext.getInputNames().contains(inputName)) {
            return true;
        }
        return this.getComponentSetting(inputName) != null;
    }

    protected boolean isDefinedOutput(String outputName) {
        return this.runtimeContext.getOutputNames().contains(outputName);
    }

    protected boolean isDefinedResource(String resourceName) {
        return this.runtimeContext.getResourceNames().contains(resourceName);
    }

    public final int validate() {
        this.logId = Messages.getInstance().getString("Base.CODE_LOG_ID", new Object[]{this.instanceId, this.runtimeContext.getHandle(), this.actionName});
        this.debug(Messages.getInstance().getString("Base.DEBUG_VALIDATING_COMPONENT", new Object[]{this.actionName}));
        this.id = Messages.getInstance().getString("Base.CODE_COMPONENT_ID", new Object[]{this.processId, this.actionName});
        this.baseInitOk = this.instanceId != null && this.sessionContext != null && this.processId != null && this.actionName != null;
        boolean systemSettingsValidate = this.validateSystemSettings();
        if (this.baseInitOk && systemSettingsValidate) {
            this.componentInitOk = this.validateAction();
        }
        if (this.getInitOk()) {
            return 1;
        }
        return 0;
    }

    public boolean getInitOk() {
        return this.baseInitOk && this.componentInitOk;
    }

    protected Set getOutputNames() {
        return this.runtimeContext.getOutputNames();
    }

    protected Set getInputNames() {
        return this.runtimeContext.getInputNames();
    }

    protected Set getResourceNames() {
        return this.runtimeContext.getResourceNames();
    }

    protected boolean feedbackAllowed() {
        return this.runtimeContext.feedbackAllowed();
    }

    protected IActionSequenceResource getResource(String resourceName) {
        return this.runtimeContext.getResourceDefintion(resourceName);
    }

    protected InputStream getResourceInputStream(IActionSequenceResource resource) throws FileNotFoundException {
        return this.runtimeContext.getResourceInputStream(resource);
    }

    protected InputStream getInputStream(String inputName) {
        return this.runtimeContext.getInputStream(inputName);
    }

    protected int getOutputPreference() {
        return this.runtimeContext.getOutputPreference();
    }

    protected IContentItem getOutputItem(String outputName, String mimeType, String extension) {
        return this.runtimeContext.getOutputItem(outputName, mimeType, extension);
    }

    protected void audit(String messageType, String message, String value, int duration) {
        this.runtimeContext.audit(messageType, message, value, (long)duration);
    }

    protected boolean getInputBooleanValue(String inputName, boolean defaultValue) {
        String strValue = this.getInputStringValue(inputName);
        if (strValue == null) {
            return defaultValue;
        }
        if ("true".equalsIgnoreCase(strValue)) {
            return true;
        }
        if ("false".equalsIgnoreCase(strValue)) {
            return false;
        }
        return defaultValue;
    }

    protected long getInputLongValue(String inputName, long defaultValue) {
        String strValue = this.getInputStringValue(inputName);
        if (strValue == null) {
            return defaultValue;
        }
        try {
            return Long.parseLong(strValue);
        }
        catch (Exception e) {
            return defaultValue;
        }
    }

    protected String getInputStringValue(String inputName) {
        String value = null;
        if (this.runtimeContext.getInputNames().contains(inputName)) {
            value = this.runtimeContext.getInputParameterStringValue(inputName);
        } else if (this.componentDefinitionMap.containsKey(inputName)) {
            value = this.componentDefinitionMap.get(inputName);
        } else {
            Node node = this.componentDefinition.selectSingleNode(inputName);
            if (node == null) {
                return null;
            }
            value = node.getText();
        }
        value = this.applyInputsToFormat(value);
        return value;
    }

    protected Object getInputValue(String inputName) {
        if (this.runtimeContext.getInputNames().contains(inputName)) {
            return this.runtimeContext.getInputParameterValue(inputName);
        }
        Node node = this.componentDefinition.selectSingleNode(inputName);
        if (node == null) {
            return null;
        }
        return node.getText();
    }

    private String getComponentSetting(String path) {
        if (this.runtimeContext.getInputNames().contains(path)) {
            return this.runtimeContext.getInputParameterStringValue(path);
        }
        Node node = this.componentDefinition.selectSingleNode(path);
        if (node == null) {
            return null;
        }
        return node.getText();
    }

    public void promptNeeded() {
        this.runtimeContext.promptNeeded();
    }

    public void promptNow() {
        this.runtimeContext.promptNow();
    }

    public String getResourceAsString(IActionSequenceResource resource) {
        try {
            return this.runtimeContext.getResourceAsString(resource);
        }
        catch (Exception e) {
            return null;
        }
    }

    public String getInitFailMessage() {
        return null;
    }

    public String createNewInstance(boolean persisted, Map parameters, boolean forceImmediateWrite) {
        return this.runtimeContext.createNewInstance(persisted, parameters, forceImmediateWrite);
    }

    public void inputMissingError(String paramName) {
        this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0003_INPUT_PARAM_MISSING", new Object[]{paramName}));
    }

    public void outputMissingError(String paramName) {
        this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0004_OUTPUT_PARAM_MISSING", new Object[]{paramName}));
    }

    public void resourceMissingError(String paramName) {
        this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0005_RESOURCE_PARAM_MISSING", new Object[]{paramName}));
    }

    public void resourceComponentSettingError(String paramName) {
        this.error(Messages.getInstance().getErrorString("ComponentBase.ERROR_0006_COMPONENT_SETTING_PARAM_MISSING", new Object[]{paramName}));
    }

    public int execute() {
        String target;
        String xsl = this.getComponentSetting("xsl");
        if (xsl != null) {
            this.runtimeContext.setParameterXsl(xsl);
        }
        if ((target = this.getComponentSetting("target")) != null) {
            this.runtimeContext.setParameterTarget(target);
        }
        if (this.loggingLevel == 100) {
            this.warn(Messages.getInstance().getString("Base.WARNING_LOGGING_LEVEL_UNKNOWN"));
            this.loggingLevel = 2;
        }
        int result = 7;
        if (this.sessionContext == null) {
            this.error(Messages.getInstance().getErrorString("Base.ERROR_0001_INVALID_SESSION"));
            return result;
        }
        this.debug(Messages.getInstance().getString("Base.DEBUG_VALIDATION_RESULT") + this.getInitOk());
        if (!this.getInitOk()) {
            return result;
        }
        try {
            int n = result = this.executeAction() ? 6 : 7;
            if (result == 6 && this.runtimeContext.isPromptPending() && this.isDefinedInput("handle-all-prompts")) {
                this.runtimeContext.promptNow();
            }
        }
        catch (Throwable e) {
            this.error(Messages.getInstance().getErrorString("Base.ERROR_0002_EXECUTION_FAILED"), e);
        }
        return result;
    }

    public String getId() {
        return this.id;
    }

    public String getActionTitle() {
        return this.runtimeContext.getActionTitle();
    }

    protected IContentItem getOutputContentItem(String mimeType) {
        return this.runtimeContext.getOutputContentItem(mimeType);
    }

    protected IContentItem getOutputContentItem(String outputName, String mimeType) {
        return this.runtimeContext.getOutputContentItem(outputName, mimeType);
    }

    protected void setOutputValue(String outputName, Object value) {
        this.runtimeContext.setOutputValue(outputName, value);
    }

    protected OutputStream getDefaultOutputStream(String mimeType) {
        IContentItem contentItem = this.runtimeContext.getOutputContentItem(mimeType);
        if (contentItem != null) {
            try {
                return contentItem.getOutputStream(this.getActionName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected String applyInputsToFormat(String format) {
        return this.runtimeContext.applyInputsToFormat(format);
    }

    protected IActionParameter getOutputItem(String outputName) {
        return this.runtimeContext.getOutputParameter(outputName);
    }

    protected String getSolutionName() {
        return "";
    }

    protected String getSolutionPath() {
        return this.runtimeContext.getSolutionPath();
    }

    protected IActionParameter getInputParameter(String parameterName) {
        return this.runtimeContext.getInputParameter(parameterName);
    }

    protected boolean isPromptPending() {
        return this.runtimeContext.isPromptPending();
    }

    protected void setFeedbackMimeType(String mimeType) {
        IContentItem feedbackContentItem = this.runtimeContext.getFeedbackContentItem();
        feedbackContentItem.setMimeType(mimeType);
    }

    protected void setOutputMimeType(String mimeType) {
        IContentItem outputContentItem = this.runtimeContext.getOutputContentItem(mimeType);
        outputContentItem.setMimeType(mimeType);
    }

    protected OutputStream getFeedbackOutputStream() {
        IContentItem feedbackContentItem = this.runtimeContext.getFeedbackContentItem();
        if (feedbackContentItem != null) {
            try {
                return feedbackContentItem.getOutputStream(this.getActionName());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return null;
    }

    protected void createFeedbackParameter(IActionParameter actionParam) {
        this.runtimeContext.createFeedbackParameter(actionParam);
        this.runtimeContext.promptNeeded();
    }

    protected void createFeedbackParameter(ISelectionMapper selMap, String fieldName, Object defaultValues) {
        this.runtimeContext.createFeedbackParameter(selMap, fieldName, defaultValues);
        this.runtimeContext.promptNeeded();
    }

    protected void createFeedbackParameter(String fieldName, String displayName, String hint, String defaultValue, boolean visible) {
        this.runtimeContext.createFeedbackParameter(fieldName, displayName, hint, (Object)defaultValue, visible);
        this.runtimeContext.promptNeeded();
    }

    public void createFeedbackParameter(String fieldName, String displayName, String hint, Object defaultValues, List values, Map dispNames, String displayStyle) {
        this.runtimeContext.createFeedbackParameter(fieldName, displayName, hint, defaultValues, values, dispNames, displayStyle);
        this.runtimeContext.promptNeeded();
    }

    protected IPentahoStreamSource getResourceDataSource(IActionSequenceResource resource) throws FileNotFoundException {
        return this.runtimeContext.getResourceDataSource(resource);
    }

    public void setActionDefinition(IActionDefinition actionDefinition) {
        this.actionDefinition = actionDefinition;
    }

    public IActionDefinition getActionDefinition() {
        return this.actionDefinition;
    }
}

