/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.dom4j.DocumentException;
import org.pentaho.platform.config.IMondrianConfig;

public class MondrianConfigProperties
implements IMondrianConfig {
    Properties properties;

    public MondrianConfigProperties(File propertiesFile) throws IOException {
        Properties props = new Properties();
        FileInputStream in = new FileInputStream(propertiesFile);
        props.load(in);
        ((InputStream)in).close();
        this.properties = props;
    }

    public MondrianConfigProperties(Properties properties) throws DocumentException {
        this.properties = properties;
    }

    public MondrianConfigProperties() {
        this.properties = new Properties();
    }

    public Properties getProperties() {
        return this.properties;
    }

    private String getProperty(String name) {
        return this.properties.getProperty(name);
    }

    private void setProperty(String name, String value) {
        if (value == null) {
            this.properties.remove(name);
        } else {
            this.properties.setProperty(name, value);
        }
    }

    @Override
    public Integer getResultLimit() {
        Integer resultLimit = null;
        try {
            resultLimit = Integer.parseInt(this.getProperty("mondrian.result.limit"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return resultLimit;
    }

    @Override
    public void setResultLimit(Integer limit) {
        this.setProperty("mondrian.result.limit", limit != null ? limit.toString() : null);
    }

    @Override
    public Integer getTraceLevel() {
        Integer traceLevel = null;
        try {
            traceLevel = Integer.parseInt(this.getProperty("mondrian.trace.level"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return traceLevel;
    }

    @Override
    public void setTraceLevel(Integer level) {
        this.setProperty("mondrian.trace.level", level != null ? level.toString() : null);
    }

    @Override
    public String getLogFileLocation() {
        return this.getProperty("mondrian.debug.out.file");
    }

    @Override
    public void setLogFileLocation(String location) {
        this.setProperty("mondrian.debug.out.file", location);
    }

    @Override
    public Integer getQueryLimit() {
        Integer queryLimit = null;
        try {
            queryLimit = Integer.parseInt(this.getProperty("mondrian.query.limit"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return queryLimit;
    }

    @Override
    public void setQueryLimit(Integer limit) {
        this.setProperty("mondrian.query.limit", limit != null ? limit.toString() : null);
    }

    @Override
    public Integer getQueryTimeout() {
        Integer queryTimeout = null;
        try {
            queryTimeout = Integer.parseInt(this.getProperty("mondrian.rolap.queryTimeout"));
        }
        catch (Exception exception) {
            // empty catch block
        }
        return queryTimeout;
    }

    @Override
    public void setQueryTimeout(Integer timeout) {
        this.setProperty("mondrian.rolap.queryTimeout", timeout != null ? timeout.toString() : null);
    }

    @Override
    public boolean getIgnoreInvalidMembers() {
        return Boolean.parseBoolean(this.getProperty("mondrian.rolap.ignoreInvalidMembers")) && Boolean.parseBoolean(this.getProperty("mondrian.rolap.ignoreInvalidMembersDuringQuery"));
    }

    @Override
    public void setIgnoreInvalidMembers(boolean ignore) {
        this.setProperty("mondrian.rolap.ignoreInvalidMembers", Boolean.toString(ignore));
        this.setProperty("mondrian.rolap.ignoreInvalidMembersDuringQuery", Boolean.toString(ignore));
    }

    @Override
    public boolean getCacheHitCounters() {
        return Boolean.parseBoolean(this.getProperty("mondrian.rolap.agg.enableCacheHitCounters"));
    }

    public void setCacheHitCounters(boolean enabled) {
        this.setProperty("mondrian.rolap.agg.enableCacheHitCounters", Boolean.toString(enabled));
    }
}

