/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.platform.config;

import java.io.File;
import java.io.IOException;
import org.dom4j.Branch;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.DocumentHelper;
import org.dom4j.Element;
import org.pentaho.platform.api.util.XmlParseException;
import org.pentaho.platform.config.DtdEntityResolver;
import org.pentaho.platform.config.IHibernateSettings;
import org.pentaho.platform.config.messages.Messages;
import org.pentaho.platform.util.xml.dom4j.XmlDom4JHelper;
import org.xml.sax.EntityResolver;

public class HibernateSettingsXml
implements IHibernateSettings {
    Document document;
    private static final String ROOT_ELEMENT = "settings";
    private static final String XPATH_TO_HIBERNATE_CFG_FILE = "settings/config-file";
    private static final String XPATH_TO_HIBERNATE_MANAGED = "settings/managed";

    public HibernateSettingsXml(File hibernateSettingsXmlFile) throws IOException, DocumentException, XmlParseException {
        this(XmlDom4JHelper.getDocFromFile((File)hibernateSettingsXmlFile, (EntityResolver)new DtdEntityResolver()));
    }

    public HibernateSettingsXml(String xml) throws DocumentException, XmlParseException {
        this(XmlDom4JHelper.getDocFromString((String)xml, (EntityResolver)new DtdEntityResolver()));
    }

    public HibernateSettingsXml(Document doc) throws DocumentException {
        Element rootElement = doc.getRootElement();
        if (rootElement != null && !doc.getRootElement().getName().equals(ROOT_ELEMENT)) {
            throw new DocumentException(Messages.getInstance().getErrorString("HibernateSettingsXml.ERROR_0001_INVALID_ROOT_ELEMENT"));
        }
        this.document = doc;
    }

    public HibernateSettingsXml() {
        this.document = DocumentHelper.createDocument();
        this.document.addElement(ROOT_ELEMENT);
    }

    @Override
    public String getHibernateConfigFile() {
        return this.getValue(XPATH_TO_HIBERNATE_CFG_FILE);
    }

    @Override
    public void setHibernateConfigFile(String hibernateConfigFile) {
        this.setValue(XPATH_TO_HIBERNATE_CFG_FILE, hibernateConfigFile);
    }

    @Override
    public boolean getHibernateManaged() {
        return Boolean.parseBoolean(this.getValue(XPATH_TO_HIBERNATE_MANAGED));
    }

    @Override
    public void setHibernateManaged(boolean hibernateManaged) {
        this.setValue(XPATH_TO_HIBERNATE_MANAGED, Boolean.toString(hibernateManaged));
    }

    private void setValue(String xPath, String value) {
        this.setValue(xPath, value, false);
    }

    private void setValue(String xPath, String value, boolean useCData) {
        Element element = (Element)this.document.selectSingleNode(xPath);
        if (element == null) {
            element = DocumentHelper.makeElement((Branch)this.document, (String)xPath);
        }
        if (useCData) {
            element.clearContent();
            element.addCDATA(value);
        } else {
            element.setText(value);
        }
    }

    private String getValue(String xpath) {
        Element element = (Element)this.document.selectSingleNode(xpath);
        return element != null ? element.getText() : null;
    }

    public Document getDocument() {
        return this.document;
    }
}

