/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Optional;
import java.util.OptionalLong;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.CellComparator;
import org.apache.hadoop.hbase.HDFSBlocksDistribution;
import org.apache.hadoop.hbase.io.TimeRange;
import org.apache.hadoop.hbase.io.hfile.BlockType;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.io.hfile.HFile;
import org.apache.hadoop.hbase.regionserver.BloomType;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileInfo;
import org.apache.hadoop.hbase.regionserver.StoreFileReader;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.TimeRangeTracker;
import org.apache.hadoop.hbase.shaded.protobuf.ProtobufUtil;
import org.apache.hadoop.hbase.util.BloomFilterFactory;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hbase.thirdparty.com.google.common.annotations.VisibleForTesting;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
public class HStoreFile
implements StoreFile {
    private static final Logger LOG = LoggerFactory.getLogger((String)HStoreFile.class.getName());
    public static final String STORE_FILE_READER_NO_READAHEAD = "hbase.store.reader.no-readahead";
    private static final boolean DEFAULT_STORE_FILE_READER_NO_READAHEAD = false;
    public static final byte[] MAX_SEQ_ID_KEY = Bytes.toBytes((String)"MAX_SEQ_ID_KEY");
    public static final byte[] MAJOR_COMPACTION_KEY = Bytes.toBytes((String)"MAJOR_COMPACTION_KEY");
    public static final byte[] EXCLUDE_FROM_MINOR_COMPACTION_KEY = Bytes.toBytes((String)"EXCLUDE_FROM_MINOR_COMPACTION");
    public static final byte[] COMPACTION_EVENT_KEY = Bytes.toBytes((String)"COMPACTION_EVENT_KEY");
    public static final byte[] BLOOM_FILTER_TYPE_KEY = Bytes.toBytes((String)"BLOOM_FILTER_TYPE");
    public static final byte[] BLOOM_FILTER_PARAM_KEY = Bytes.toBytes((String)"BLOOM_FILTER_PARAM");
    public static final byte[] DELETE_FAMILY_COUNT = Bytes.toBytes((String)"DELETE_FAMILY_COUNT");
    public static final byte[] LAST_BLOOM_KEY = Bytes.toBytes((String)"LAST_BLOOM_KEY");
    public static final byte[] TIMERANGE_KEY = Bytes.toBytes((String)"TIMERANGE");
    public static final byte[] EARLIEST_PUT_TS = Bytes.toBytes((String)"EARLIEST_PUT_TS");
    public static final byte[] MOB_CELLS_COUNT = Bytes.toBytes((String)"MOB_CELLS_COUNT");
    public static final byte[] NULL_VALUE = new byte[]{0};
    public static final byte[] MOB_FILE_REFS = Bytes.toBytes((String)"MOB_FILE_REFS");
    public static final byte[] BULKLOAD_TASK_KEY = Bytes.toBytes((String)"BULKLOAD_SOURCE_TASK");
    public static final byte[] BULKLOAD_TIME_KEY = Bytes.toBytes((String)"BULKLOAD_TIMESTAMP");
    public static final byte[] SKIP_RESET_SEQ_ID = Bytes.toBytes((String)"SKIP_RESET_SEQ_ID");
    private final StoreFileInfo fileInfo;
    private final FileSystem fs;
    private final CacheConfig cacheConf;
    private final AtomicInteger refCount = new AtomicInteger(0);
    private final boolean noReadahead;
    private final boolean primaryReplica;
    private volatile boolean compactedAway = false;
    private long sequenceid = -1L;
    private long maxMemstoreTS = -1L;
    private Optional<Cell> firstKey;
    private Optional<Cell> lastKey;
    private CellComparator comparator;
    private AtomicBoolean majorCompaction = null;
    private boolean excludeFromMinorCompaction = false;
    private final Set<String> compactedStoreFiles = new HashSet<String>();
    private Map<byte[], byte[]> metadataMap;
    private volatile StoreFileReader reader;
    private final BloomType cfBloomType;

    public CacheConfig getCacheConf() {
        return this.cacheConf;
    }

    @Override
    public Optional<Cell> getFirstKey() {
        return this.firstKey;
    }

    @Override
    public Optional<Cell> getLastKey() {
        return this.lastKey;
    }

    @Override
    public CellComparator getComparator() {
        return this.comparator;
    }

    @Override
    public long getMaxMemStoreTS() {
        return this.maxMemstoreTS;
    }

    public HStoreFile(FileSystem fs, Path p, Configuration conf, CacheConfig cacheConf, BloomType cfBloomType, boolean primaryReplica) throws IOException {
        this(fs, new StoreFileInfo(conf, fs, p), conf, cacheConf, cfBloomType, primaryReplica);
    }

    public HStoreFile(FileSystem fs, StoreFileInfo fileInfo, Configuration conf, CacheConfig cacheConf, BloomType cfBloomType, boolean primaryReplica) {
        this.fs = fs;
        this.fileInfo = fileInfo;
        this.cacheConf = cacheConf;
        this.noReadahead = conf.getBoolean(STORE_FILE_READER_NO_READAHEAD, false);
        if (BloomFilterFactory.isGeneralBloomEnabled(conf)) {
            this.cfBloomType = cfBloomType;
        } else {
            LOG.info("Ignoring bloom filter check for file " + this.getPath() + ": " + "cfBloomType=" + cfBloomType + " (disabled in config)");
            this.cfBloomType = BloomType.NONE;
        }
        this.primaryReplica = primaryReplica;
    }

    public StoreFileInfo getFileInfo() {
        return this.fileInfo;
    }

    @Override
    public Path getPath() {
        return this.fileInfo.getPath();
    }

    @Override
    public Path getEncodedPath() {
        try {
            return new Path(URLEncoder.encode(this.fileInfo.getPath().toString(), "UTF-8"));
        }
        catch (UnsupportedEncodingException ex) {
            throw new RuntimeException("URLEncoder doesn't support UTF-8", ex);
        }
    }

    @Override
    public Path getQualifiedPath() {
        return this.fileInfo.getPath().makeQualified(this.fs.getUri(), this.fs.getWorkingDirectory());
    }

    @Override
    public boolean isReference() {
        return this.fileInfo.isReference();
    }

    @Override
    public boolean isHFile() {
        return StoreFileInfo.isHFile(this.fileInfo.getPath());
    }

    @Override
    public boolean isMajorCompactionResult() {
        if (this.majorCompaction == null) {
            throw new NullPointerException("This has not been set yet");
        }
        return this.majorCompaction.get();
    }

    @Override
    public boolean excludeFromMinorCompaction() {
        return this.excludeFromMinorCompaction;
    }

    @Override
    public long getMaxSequenceId() {
        return this.sequenceid;
    }

    @Override
    public long getModificationTimeStamp() throws IOException {
        return this.getModificationTimestamp();
    }

    @Override
    public long getModificationTimestamp() throws IOException {
        return this.fileInfo.getModificationTime();
    }

    public byte[] getMetadataValue(byte[] key) {
        return this.metadataMap.get(key);
    }

    @Override
    public boolean isBulkLoadResult() {
        boolean bulkLoadedHFile = false;
        String fileName = this.getPath().getName();
        int startPos = fileName.indexOf("SeqId_");
        if (startPos != -1) {
            bulkLoadedHFile = true;
        }
        return bulkLoadedHFile || this.metadataMap != null && this.metadataMap.containsKey(BULKLOAD_TIME_KEY);
    }

    public boolean isCompactedAway() {
        return this.compactedAway;
    }

    @VisibleForTesting
    public int getRefCount() {
        return this.refCount.get();
    }

    public boolean isReferencedInReads() {
        int rc = this.refCount.get();
        assert (rc >= 0);
        return rc > 0;
    }

    @Override
    public OptionalLong getBulkLoadTimestamp() {
        byte[] bulkLoadTimestamp = this.metadataMap.get(BULKLOAD_TIME_KEY);
        return bulkLoadTimestamp == null ? OptionalLong.empty() : OptionalLong.of(Bytes.toLong((byte[])bulkLoadTimestamp));
    }

    public HDFSBlocksDistribution getHDFSBlockDistribution() {
        return this.fileInfo.getHDFSBlockDistribution();
    }

    private void open() throws IOException {
        byte[] data;
        if (this.reader != null) {
            throw new IllegalAccessError("Already open");
        }
        this.reader = this.fileInfo.open(this.fs, this.cacheConf, false, this.noReadahead ? 0L : -1L, this.primaryReplica, this.refCount, true);
        this.metadataMap = Collections.unmodifiableMap(this.reader.loadFileInfo());
        byte[] b = this.metadataMap.get(MAX_SEQ_ID_KEY);
        if (b != null) {
            this.sequenceid = Bytes.toLong((byte[])b);
            if (this.fileInfo.isTopReference()) {
                ++this.sequenceid;
            }
        }
        if (this.isBulkLoadResult()) {
            boolean skipResetSeqId;
            String fileName = this.getPath().getName();
            int startPos = fileName.lastIndexOf("SeqId_");
            if (startPos != -1) {
                this.sequenceid = Long.parseLong(fileName.substring(startPos + 6, fileName.indexOf(95, startPos + 6)));
                if (this.fileInfo.isTopReference()) {
                    ++this.sequenceid;
                }
            }
            if (skipResetSeqId = this.isSkipResetSeqId(this.metadataMap.get(SKIP_RESET_SEQ_ID))) {
                ++this.sequenceid;
            }
            this.reader.setSkipResetSeqId(skipResetSeqId);
            this.reader.setBulkLoaded(true);
        }
        this.reader.setSequenceID(this.sequenceid);
        b = this.metadataMap.get(HFile.Writer.MAX_MEMSTORE_TS_KEY);
        if (b != null) {
            this.maxMemstoreTS = Bytes.toLong((byte[])b);
        }
        if ((b = this.metadataMap.get(MAJOR_COMPACTION_KEY)) != null) {
            boolean mc = Bytes.toBoolean((byte[])b);
            if (this.majorCompaction == null) {
                this.majorCompaction = new AtomicBoolean(mc);
            } else {
                this.majorCompaction.set(mc);
            }
        } else {
            this.majorCompaction = new AtomicBoolean(false);
        }
        b = this.metadataMap.get(EXCLUDE_FROM_MINOR_COMPACTION_KEY);
        this.excludeFromMinorCompaction = b != null && Bytes.toBoolean((byte[])b);
        BloomType hfileBloomType = this.reader.getBloomFilterType();
        if (this.cfBloomType != BloomType.NONE) {
            this.reader.loadBloomfilter(BlockType.GENERAL_BLOOM_META);
            if (hfileBloomType != this.cfBloomType) {
                LOG.info("HFile Bloom filter type for " + this.reader.getHFileReader().getName() + ": " + hfileBloomType + ", but " + this.cfBloomType + " specified in column family " + "configuration");
            }
        } else if (hfileBloomType != BloomType.NONE) {
            LOG.info("Bloom filter turned off by CF config for " + this.reader.getHFileReader().getName());
        }
        this.reader.loadBloomfilter(BlockType.DELETE_FAMILY_BLOOM_META);
        try {
            data = this.metadataMap.get(TIMERANGE_KEY);
            this.reader.timeRange = data == null ? null : TimeRangeTracker.parseFrom(data).toTimeRange();
        }
        catch (IllegalArgumentException e) {
            LOG.error("Error reading timestamp range data from meta -- proceeding without", (Throwable)e);
            this.reader.timeRange = null;
        }
        try {
            data = this.metadataMap.get(COMPACTION_EVENT_KEY);
            this.compactedStoreFiles.addAll(ProtobufUtil.toCompactedStoreFiles((byte[])data));
        }
        catch (IOException e) {
            LOG.error("Error reading compacted storefiles from meta data", (Throwable)e);
        }
        this.firstKey = this.reader.getFirstKey();
        this.lastKey = this.reader.getLastKey();
        this.comparator = this.reader.getComparator();
    }

    public void initReader() throws IOException {
        if (this.reader == null) {
            try {
                this.open();
            }
            catch (Exception e) {
                try {
                    boolean evictOnClose = this.cacheConf != null ? this.cacheConf.shouldEvictOnClose() : true;
                    this.closeStoreFile(evictOnClose);
                }
                catch (IOException ee) {
                    LOG.warn("failed to close reader", (Throwable)ee);
                }
                throw e;
            }
        }
    }

    private StoreFileReader createStreamReader(boolean canUseDropBehind) throws IOException {
        this.initReader();
        StoreFileReader reader = this.fileInfo.open(this.fs, this.cacheConf, canUseDropBehind, -1L, this.primaryReplica, this.refCount, false);
        reader.copyFields(this.reader);
        return reader;
    }

    public StoreFileScanner getPreadScanner(boolean cacheBlocks, long readPt, long scannerOrder, boolean canOptimizeForNonNullColumn) {
        return this.getReader().getStoreFileScanner(cacheBlocks, true, false, readPt, scannerOrder, canOptimizeForNonNullColumn);
    }

    public StoreFileScanner getStreamScanner(boolean canUseDropBehind, boolean cacheBlocks, boolean isCompaction, long readPt, long scannerOrder, boolean canOptimizeForNonNullColumn) throws IOException {
        return this.createStreamReader(canUseDropBehind).getStoreFileScanner(cacheBlocks, false, isCompaction, readPt, scannerOrder, canOptimizeForNonNullColumn);
    }

    public StoreFileReader getReader() {
        return this.reader;
    }

    public synchronized void closeStoreFile(boolean evictOnClose) throws IOException {
        if (this.reader != null) {
            this.reader.close(evictOnClose);
            this.reader = null;
        }
    }

    public void deleteStoreFile() throws IOException {
        boolean evictOnClose = this.cacheConf != null ? this.cacheConf.shouldEvictOnClose() : true;
        this.closeStoreFile(evictOnClose);
        this.fs.delete(this.getPath(), true);
    }

    public void markCompactedAway() {
        this.compactedAway = true;
    }

    public String toString() {
        return this.fileInfo.toString();
    }

    @Override
    public String toStringDetailed() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getPath().toString());
        sb.append(", isReference=").append(this.isReference());
        sb.append(", isBulkLoadResult=").append(this.isBulkLoadResult());
        if (this.isBulkLoadResult()) {
            sb.append(", bulkLoadTS=");
            OptionalLong bulkLoadTS = this.getBulkLoadTimestamp();
            if (bulkLoadTS.isPresent()) {
                sb.append(bulkLoadTS.getAsLong());
            } else {
                sb.append("NotPresent");
            }
        } else {
            sb.append(", seqid=").append(this.getMaxSequenceId());
        }
        sb.append(", majorCompaction=").append(this.isMajorCompactionResult());
        return sb.toString();
    }

    private boolean isSkipResetSeqId(byte[] skipResetSeqId) {
        if (skipResetSeqId != null && skipResetSeqId.length == 1) {
            return Bytes.toBoolean((byte[])skipResetSeqId);
        }
        return false;
    }

    @Override
    public OptionalLong getMinimumTimestamp() {
        TimeRange tr = this.getReader().timeRange;
        return tr != null ? OptionalLong.of(tr.getMin()) : OptionalLong.empty();
    }

    @Override
    public OptionalLong getMaximumTimestamp() {
        TimeRange tr = this.getReader().timeRange;
        return tr != null ? OptionalLong.of(tr.getMax()) : OptionalLong.empty();
    }

    Set<String> getCompactedStoreFiles() {
        return Collections.unmodifiableSet(this.compactedStoreFiles);
    }
}

