/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.mapreduce;

import com.google.common.annotations.VisibleForTesting;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import java.net.MalformedURLException;
import java.net.URISyntaxException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Properties;
import java.util.concurrent.ExecutorService;
import java.util.jar.JarEntry;
import java.util.jar.JarFile;
import java.util.jar.JarInputStream;
import java.util.jar.Manifest;
import org.pentaho.big.data.impl.shim.mapreduce.FutureMapReduceJobSimpleImpl;
import org.pentaho.big.data.impl.shim.mapreduce.MapReduceJobBuilderImpl;
import org.pentaho.big.data.impl.shim.mapreduce.PentahoMapReduceJobBuilderImpl;
import org.pentaho.big.data.impl.shim.mapreduce.TransformationVisitorService;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.osgi.api.NamedClusterSiteFile;
import org.pentaho.di.core.plugins.LifecyclePluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.hadoop.PluginPropertiesUtil;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceExecutionException;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceJarInfo;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceJobBuilder;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceJobSimple;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceService;
import org.pentaho.hadoop.shim.api.mapreduce.PentahoMapReduceJobBuilder;
import org.pentaho.hadoop.shim.spi.HadoopShim;

public class MapReduceServiceImpl
implements MapReduceService {
    public static final Class<?> PKG = MapReduceServiceImpl.class;
    private final NamedCluster namedCluster;
    private final HadoopShim hadoopShim;
    private final ExecutorService executorService;
    private final List<TransformationVisitorService> visitorServices = new ArrayList<TransformationVisitorService>();
    private final PluginPropertiesUtil pluginPropertiesUtil;
    private final PluginRegistry pluginRegistry;

    public MapReduceServiceImpl(NamedCluster namedCluster, HadoopShim hadoopShim, ExecutorService executorService, List<TransformationVisitorService> visitorServices) {
        this(namedCluster, hadoopShim, executorService, new PluginPropertiesUtil(), PluginRegistry.getInstance(), visitorServices);
    }

    public MapReduceServiceImpl(NamedCluster namedCluster, HadoopShim hadoopShim, ExecutorService executorService, PluginPropertiesUtil pluginPropertiesUtil, PluginRegistry pluginRegistry, List<TransformationVisitorService> visitorServices) {
        this.namedCluster = namedCluster;
        this.hadoopShim = hadoopShim;
        this.executorService = executorService;
        this.pluginPropertiesUtil = pluginPropertiesUtil;
        this.pluginRegistry = pluginRegistry;
        this.visitorServices.addAll(visitorServices);
    }

    public MapReduceJobSimple executeSimple(URL resolvedJarUrl, String driverClass, String commandLineArgs) throws MapReduceExecutionException {
        Class<?> mainClass = this.locateDriverClass(driverClass, resolvedJarUrl, this.hadoopShim, true);
        return new FutureMapReduceJobSimpleImpl(this.executorService, mainClass, commandLineArgs);
    }

    public MapReduceJobBuilder createJobBuilder(LogChannelInterface log, VariableSpace variableSpace) {
        return new MapReduceJobBuilderImpl(this.namedCluster, this.hadoopShim, log, variableSpace);
    }

    public PentahoMapReduceJobBuilder createPentahoMapReduceJobBuilder(LogChannelInterface log, VariableSpace variableSpace) throws IOException {
        PluginInterface pluginInterface = this.pluginRegistry.findPluginWithId(LifecyclePluginType.class, "HadoopSpoonPlugin");
        try {
            Properties pmrProperties = this.pluginPropertiesUtil.loadPluginProperties(pluginInterface);
            return new PentahoMapReduceJobBuilderImpl(this.namedCluster, this.hadoopShim, log, variableSpace, pluginInterface, pmrProperties, this.visitorServices);
        }
        catch (KettleFileException e) {
            throw new IOException(e);
        }
    }

    public MapReduceJarInfo getJarInfo(URL resolvedJarUrl) throws IOException, ClassNotFoundException {
        ClassLoader classLoader = this.getClass().getClassLoader();
        List<Class<?>> classesInJarWithMain = this.getClassesInJarWithMain(resolvedJarUrl.toExternalForm());
        ArrayList<String> classNamesInJarWithMain = new ArrayList<String>(classesInJarWithMain.size());
        for (Class<?> aClass : classesInJarWithMain) {
            classNamesInJarWithMain.add(aClass.getCanonicalName());
        }
        final List finalClassNamesInJarWithMain = Collections.unmodifiableList(classNamesInJarWithMain);
        Class<?> mainClassFromManifest = null;
        try {
            mainClassFromManifest = this.getMainClassFromManifest(resolvedJarUrl, classLoader, false);
        }
        catch (Exception exception) {
            // empty catch block
        }
        final String mainClassName = mainClassFromManifest != null ? mainClassFromManifest.getCanonicalName() : null;
        return new MapReduceJarInfo(){

            public List<String> getClassesWithMain() {
                return finalClassNamesInJarWithMain;
            }

            public String getMainClass() {
                return mainClassName;
            }
        };
    }

    public void addTransformationVisitorService(TransformationVisitorService service) {
        this.visitorServices.add(service);
    }

    @VisibleForTesting
    Class<?> locateDriverClass(String driverClass, URL resolvedJarUrl, HadoopShim shim, boolean addConfigFiles) throws MapReduceExecutionException {
        try {
            if (Utils.isEmpty((CharSequence)driverClass)) {
                Class<?> mainClass = this.getMainClassFromManifest(resolvedJarUrl, shim.getClass().getClassLoader(), addConfigFiles);
                if (mainClass == null) {
                    List<Class<?>> mainClasses = this.getClassesInJarWithMain(resolvedJarUrl.toExternalForm());
                    if (mainClasses.size() == 1) {
                        return mainClasses.get(0);
                    }
                    if (mainClasses.isEmpty()) {
                        throw new MapReduceExecutionException(BaseMessages.getString(PKG, (String)"MapReduceServiceImpl.DriverClassNotSpecified", (String[])new String[0]));
                    }
                    throw new MapReduceExecutionException(BaseMessages.getString(PKG, (String)"MapReduceServiceImpl.MultipleDriverClasses", (String[])new String[0]));
                }
                return mainClass;
            }
            return this.getClassByName(driverClass, resolvedJarUrl, shim.getClass().getClassLoader(), addConfigFiles);
        }
        catch (MapReduceExecutionException mrEx) {
            throw mrEx;
        }
        catch (Exception e) {
            throw new MapReduceExecutionException((Throwable)e);
        }
    }

    private List<Class<?>> getClassesInJarWithMain(String jarUrl) throws MalformedURLException {
        ArrayList mainClasses = new ArrayList();
        List<Class<?>> allClasses = this.getClassesInJar(jarUrl);
        for (Class<?> clazz : allClasses) {
            try {
                Method mainMethod = clazz.getMethod("main", String[].class);
                if (!Modifier.isStatic(mainMethod.getModifiers())) continue;
                mainClasses.add(clazz);
            }
            catch (Throwable throwable) {}
        }
        return mainClasses;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getMainClassFromManifest(URL jarUrl, ClassLoader parentClassLoader, boolean addConfigFiles) throws IOException, ClassNotFoundException, URISyntaxException {
        try (JarFile jarFile = this.getJarFile(jarUrl, parentClassLoader);){
            Manifest manifest = jarFile.getManifest();
            String className = manifest == null ? null : manifest.getMainAttributes().getValue("Main-Class");
            Class<?> clazz = this.loadClassByName(className, jarUrl, parentClassLoader, addConfigFiles);
            return clazz;
        }
    }

    private JarFile getJarFile(URL jarUrl, ClassLoader parentClassLoader) throws IOException {
        JarFile jarFile;
        if (jarUrl == null || parentClassLoader == null) {
            throw new NullPointerException();
        }
        try {
            jarFile = new JarFile(new File(jarUrl.toURI()));
        }
        catch (URISyntaxException ex) {
            throw new IOException("Error locating jar: " + jarUrl);
        }
        catch (IOException ex) {
            throw new IOException("Error opening job jar: " + jarUrl, ex);
        }
        return jarFile;
    }

    private Class<?> loadClassByName(String className, URL jarUrl, ClassLoader parentClassLoader, boolean addConfigFiles) throws ClassNotFoundException, IOException, URISyntaxException {
        if (className != null) {
            HashSet<URL> urlSet = new HashSet<URL>();
            if (addConfigFiles) {
                ArrayList<URL> urlList = new ArrayList<URL>();
                List siteFiles = this.namedCluster.getSiteFiles();
                Path tempDir = Files.createTempDirectory("siteFiles", new FileAttribute[0]);
                for (NamedClusterSiteFile siteFile : siteFiles) {
                    String fileContents = siteFile.getSiteFileContents();
                    String fileName = siteFile.getSiteFileName();
                    if (fileContents.length() <= 0) continue;
                    OutputStream outputStream = Files.newOutputStream(tempDir.resolve(fileName), new OpenOption[0]);
                    outputStream.write(fileContents.getBytes());
                    urlList.add(tempDir.resolve(fileName).toUri().toURL());
                }
                for (URL url : urlList) {
                    urlSet.add(Paths.get(url.toURI()).getParent().toUri().toURL());
                }
            }
            urlSet.add(jarUrl);
            URLClassLoader cl = new URLClassLoader(urlSet.toArray(new URL[0]), parentClassLoader);
            return cl.loadClass(className.replace("/", "."));
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Class<?> getClassByName(String className, URL jarUrl, ClassLoader parentClassLoader, boolean addConfigFiles) throws IOException, ClassNotFoundException, URISyntaxException {
        try (JarFile jarFile = this.getJarFile(jarUrl, parentClassLoader);){
            Class<?> clazz = this.loadClassByName(className, jarUrl, parentClassLoader, addConfigFiles);
            return clazz;
        }
    }

    private List<Class<?>> getClassesInJar(String jarUrl) throws MalformedURLException {
        ArrayList classes = new ArrayList();
        URL url = new URL(jarUrl);
        URL[] urls = new URL[]{url};
        try (URLClassLoader loader = new URLClassLoader(urls, this.getClass().getClassLoader());
             JarInputStream jarFile = new JarInputStream(new FileInputStream(new File(url.toURI())));){
            JarEntry jarEntry;
            while ((jarEntry = jarFile.getNextJarEntry()) != null) {
                if (!jarEntry.getName().endsWith(".class")) continue;
                String className = jarEntry.getName().substring(0, jarEntry.getName().indexOf(".class")).replace("/", ".");
                classes.add(loader.loadClass(className));
            }
        }
        catch (IOException iOException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
        }
        catch (URISyntaxException uRISyntaxException) {
            // empty catch block
        }
        return classes;
    }
}

