/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3common;

import com.amazonaws.services.s3.model.AbortMultipartUploadRequest;
import com.amazonaws.services.s3.model.CompleteMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadRequest;
import com.amazonaws.services.s3.model.InitiateMultipartUploadResult;
import com.amazonaws.services.s3.model.PartETag;
import com.amazonaws.services.s3.model.UploadPartRequest;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.ArrayList;
import java.util.concurrent.Callable;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.ThreadPoolExecutor;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.StorageUnitConverter;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.s3common.S3CommonFileSystem;
import org.pentaho.s3common.S3CommonWindowedSubstream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class S3CommonPipedOutputStream
extends PipedOutputStream {
    private static final Class<?> PKG = S3CommonPipedOutputStream.class;
    private static final Logger logger = LoggerFactory.getLogger(S3CommonPipedOutputStream.class);
    private static final LogChannelInterface consoleLog = new LogChannel((Object)BaseMessages.getString(PKG, (String)"TITLE.S3File", (String[])new String[0]));
    private static final int DEFAULT_PART_SIZE = 0x500000;
    private ThreadPoolExecutor executor = (ThreadPoolExecutor)Executors.newFixedThreadPool(1);
    private boolean initialized = false;
    private boolean blockedUntilDone = true;
    private PipedInputStream pipedInputStream = new PipedInputStream();
    private S3AsyncTransferRunner s3AsyncTransferRunner;
    private S3CommonFileSystem fileSystem;
    private Future<Boolean> result = null;
    private String bucketId;
    private String key;
    private int partSize;

    public S3CommonPipedOutputStream(S3CommonFileSystem fileSystem, String bucketId, String key) throws IOException {
        this(fileSystem, bucketId, key, 0x500000);
    }

    public S3CommonPipedOutputStream(S3CommonFileSystem fileSystem, String bucketId, String key, int partSize) throws IOException {
        try {
            this.pipedInputStream.connect(this);
        }
        catch (IOException e) {
            throw new IOException("could not connect to pipedInputStream", e);
        }
        this.s3AsyncTransferRunner = new S3AsyncTransferRunner();
        this.bucketId = bucketId;
        this.key = key;
        this.fileSystem = fileSystem;
        this.partSize = partSize;
    }

    private void initializeWrite() {
        if (!this.initialized) {
            this.initialized = true;
            this.result = this.executor.submit(this.s3AsyncTransferRunner);
        }
    }

    public boolean isBlockedUntilDone() {
        return this.blockedUntilDone;
    }

    public void setBlockedUntilDone(boolean blockedUntilDone) {
        this.blockedUntilDone = blockedUntilDone;
    }

    @Override
    public void write(int b) throws IOException {
        this.initializeWrite();
        super.write(b);
    }

    @Override
    public void write(byte[] b, int off, int len) throws IOException {
        this.initializeWrite();
        super.write(b, off, len);
    }

    @Override
    public void close() throws IOException {
        super.close();
        if (this.initialized && this.isBlockedUntilDone()) {
            while (!this.result.isDone()) {
                try {
                    Thread.sleep(100L);
                }
                catch (InterruptedException e) {
                    logger.error(BaseMessages.getString(PKG, (String)"ERROR.S3MultiPart.ExceptionCaught", (String[])new String[0]), (Throwable)e);
                    Thread.currentThread().interrupt();
                }
            }
        }
        this.executor.shutdown();
    }

    class S3AsyncTransferRunner
    implements Callable<Boolean> {
        S3AsyncTransferRunner() {
        }

        @Override
        public Boolean call() throws Exception {
            boolean returnVal = true;
            ArrayList<PartETag> partETags = new ArrayList<PartETag>();
            InitiateMultipartUploadRequest initRequest = new InitiateMultipartUploadRequest(S3CommonPipedOutputStream.this.bucketId, S3CommonPipedOutputStream.this.key);
            InitiateMultipartUploadResult initResponse = null;
            try (ByteArrayOutputStream baos = new ByteArrayOutputStream(S3CommonPipedOutputStream.this.partSize);
                 BufferedInputStream bis = new BufferedInputStream(S3CommonPipedOutputStream.this.pipedInputStream, S3CommonPipedOutputStream.this.partSize);){
                UploadPartRequest uploadRequest;
                S3CommonWindowedSubstream s3is;
                initResponse = S3CommonPipedOutputStream.this.fileSystem.getS3Client().initiateMultipartUpload(initRequest);
                byte[] tmpBuffer = new byte[S3CommonPipedOutputStream.this.partSize];
                int read = 0;
                long offset = 0L;
                long totalRead = 0L;
                int partNum = 1;
                logger.info(BaseMessages.getString((Class)PKG, (String)"INFO.S3MultiPart.Start", (String[])new String[0]));
                while ((read = bis.read(tmpBuffer)) >= 0) {
                    if (read > 0) {
                        baos.write(tmpBuffer, 0, read);
                        totalRead += (long)read;
                    }
                    if (totalRead <= (long)S3CommonPipedOutputStream.this.partSize) continue;
                    s3is = new S3CommonWindowedSubstream(baos.toByteArray());
                    uploadRequest = new UploadPartRequest().withBucketName(S3CommonPipedOutputStream.this.bucketId).withKey(S3CommonPipedOutputStream.this.key).withUploadId(initResponse.getUploadId()).withPartNumber(partNum++).withFileOffset(offset).withPartSize(totalRead).withInputStream((InputStream)s3is);
                    logger.info(BaseMessages.getString((Class)PKG, (String)"INFO.S3MultiPart.Upload", (Object[])new Object[]{partNum - 1, offset, Long.toString(totalRead)}));
                    partETags.add(S3CommonPipedOutputStream.this.fileSystem.getS3Client().uploadPart(uploadRequest).getPartETag());
                    offset += totalRead;
                    totalRead = 0L;
                    baos.reset();
                }
                s3is = new S3CommonWindowedSubstream(baos.toByteArray());
                uploadRequest = new UploadPartRequest().withBucketName(S3CommonPipedOutputStream.this.bucketId).withKey(S3CommonPipedOutputStream.this.key).withUploadId(initResponse.getUploadId()).withPartNumber(partNum++).withFileOffset(offset).withPartSize(totalRead).withInputStream((InputStream)s3is).withLastPart(true);
                logger.info(BaseMessages.getString((Class)PKG, (String)"INFO.S3MultiPart.Upload", (Object[])new Object[]{partNum - 1, offset, totalRead}));
                partETags.add(S3CommonPipedOutputStream.this.fileSystem.getS3Client().uploadPart(uploadRequest).getPartETag());
                logger.info(BaseMessages.getString((Class)PKG, (String)"INFO.S3MultiPart.Complete", (String[])new String[0]));
                CompleteMultipartUploadRequest compRequest = new CompleteMultipartUploadRequest(S3CommonPipedOutputStream.this.bucketId, S3CommonPipedOutputStream.this.key, initResponse.getUploadId(), partETags);
                S3CommonPipedOutputStream.this.fileSystem.getS3Client().completeMultipartUpload(compRequest);
            }
            catch (OutOfMemoryError oome) {
                consoleLog.logError(BaseMessages.getString((Class)PKG, (String)"ERROR.S3MultiPart.UploadOutOfMemory", (String[])new String[]{new StorageUnitConverter().byteCountToDisplaySize((long)S3CommonPipedOutputStream.this.partSize)}), (Throwable)oome);
                returnVal = false;
            }
            catch (Exception e) {
                logger.error(BaseMessages.getString((Class)PKG, (String)"ERROR.S3MultiPart.ExceptionCaught", (String[])new String[0]), (Throwable)e);
                if (initResponse == null) {
                    S3CommonPipedOutputStream.this.close();
                } else {
                    S3CommonPipedOutputStream.this.fileSystem.getS3Client().abortMultipartUpload(new AbortMultipartUploadRequest(S3CommonPipedOutputStream.this.bucketId, S3CommonPipedOutputStream.this.key, initResponse.getUploadId()));
                    logger.error(BaseMessages.getString((Class)PKG, (String)"ERROR.S3MultiPart.Aborted", (String[])new String[0]));
                }
                returnVal = false;
            }
            return returnVal;
        }
    }
}

