/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3a.vfs;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileType;
import org.apache.commons.vfs2.provider.AbstractFileName;

public class S3AFileName
extends AbstractFileName {
    public static final String DELIMITER = "/";
    private String bucketId;
    private String bucketRelativePath;
    private String keys;

    public S3AFileName(String scheme, String bucketId, String path, FileType type, String keys) {
        this(scheme, bucketId, path, type);
        this.keys = keys;
    }

    public S3AFileName(String scheme, String bucketId, String path, FileType type) {
        super(scheme, path, type);
        this.bucketId = bucketId;
        if (path.length() > 1) {
            this.bucketRelativePath = path.substring(1);
            if (type.equals((Object)FileType.FOLDER)) {
                this.bucketRelativePath = this.bucketRelativePath + DELIMITER;
            }
        } else {
            this.bucketRelativePath = "";
        }
    }

    public String getURI() {
        StringBuilder buffer = new StringBuilder();
        this.appendRootUri(buffer, false);
        buffer.append(this.getPath());
        return buffer.toString();
    }

    public String getBucketId() {
        return this.bucketId;
    }

    public String getBucketRelativePath() {
        return this.bucketRelativePath;
    }

    public FileName createName(String absPath, FileType type) {
        return new S3AFileName(this.getScheme(), this.bucketId, absPath, type);
    }

    protected void appendRootUri(StringBuilder buffer, boolean addPassword) {
        buffer.append(this.getScheme());
        buffer.append("://");
        if (this.keys != null) {
            buffer.append(this.bucketId);
        }
    }

    public boolean equals(Object o) {
        return super.equals(o);
    }

    public int hashCode() {
        return super.hashCode();
    }
}

