/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.s3.vfs;

import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.provider.AbstractFileName;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.util.StorageUnitConverter;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.s3.vfs.S3FileObject;
import org.pentaho.s3common.S3CommonFileSystem;
import org.pentaho.s3common.S3KettleProperty;

public class S3FileSystem
extends S3CommonFileSystem {
    private static final Class<?> PKG = S3FileSystem.class;
    private static final LogChannelInterface consoleLog = new LogChannel((Object)BaseMessages.getString(PKG, (String)"TITLE.S3File", (String[])new String[0]));
    protected StorageUnitConverter storageUnitConverter;
    protected S3KettleProperty s3KettleProperty;
    private static final String MIN_PART_SIZE = "5MB";
    private static final String MAX_PART_SIZE = "5GB";

    protected S3FileSystem(FileName rootName, FileSystemOptions fileSystemOptions) {
        this(rootName, fileSystemOptions, new StorageUnitConverter(), new S3KettleProperty());
    }

    protected S3FileSystem(FileName rootName, FileSystemOptions fileSystemOptions, StorageUnitConverter storageUnitConverter, S3KettleProperty s3KettleProperty) {
        super(rootName, fileSystemOptions);
        this.storageUnitConverter = storageUnitConverter;
        this.s3KettleProperty = s3KettleProperty;
    }

    @Override
    protected FileObject createFile(AbstractFileName name) throws Exception {
        return new S3FileObject(name, this);
    }

    public int getPartSize() {
        long parsedPartSize = this.parsePartSize(this.s3KettleProperty.getPartSize());
        return this.convertToInt(parsedPartSize);
    }

    protected long parsePartSize(String partSizeString) {
        long parsePartSize = this.convertToLong(partSizeString);
        if (parsePartSize < this.convertToLong(MIN_PART_SIZE)) {
            consoleLog.logBasic(BaseMessages.getString(PKG, (String)"WARN.S3MultiPart.DefaultPartSize", (String[])new String[]{partSizeString, MIN_PART_SIZE}));
            parsePartSize = this.convertToLong(MIN_PART_SIZE);
        }
        if (parsePartSize > this.convertToLong(MAX_PART_SIZE)) {
            consoleLog.logBasic(BaseMessages.getString(PKG, (String)"WARN.S3MultiPart.MaximumPartSize", (String[])new String[]{partSizeString, MAX_PART_SIZE}));
        }
        return parsePartSize;
    }

    protected int convertToInt(long parsedPartSize) {
        return (int)Long.min(Integer.MAX_VALUE, parsedPartSize);
    }

    protected long convertToLong(String partSize) {
        return this.storageUnitConverter.displaySizeToByteCount(partSize);
    }
}

