/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie.servlet;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.oozie.ErrorCode;
import org.apache.oozie.client.OozieClient;
import org.apache.oozie.service.CallableQueueService;
import org.apache.oozie.service.Services;
import org.apache.oozie.servlet.BaseAdminServlet;
import org.apache.oozie.servlet.JsonRestServlet;
import org.apache.oozie.servlet.XServletException;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;

public class V1AdminServlet
extends BaseAdminServlet {
    private static final long serialVersionUID = 1L;
    private static final String INSTRUMENTATION_NAME = "v1admin";
    private static final JsonRestServlet.ResourceInfo[] RESOURCES_INFO = new JsonRestServlet.ResourceInfo[7];

    public V1AdminServlet() {
        super(INSTRUMENTATION_NAME, RESOURCES_INFO);
        this.modeTag = "systemmode";
    }

    @Override
    protected void populateOozieMode(JSONObject json) {
        json.put((Object)"systemMode", (Object)Services.get().getSystemMode().toString());
    }

    @Override
    protected void setOozieMode(HttpServletRequest request, HttpServletResponse response, String resourceName) throws XServletException {
        if (!resourceName.equals("status")) {
            throw new XServletException(400, ErrorCode.E0301, resourceName);
        }
        OozieClient.SYSTEM_MODE sysMode = OozieClient.SYSTEM_MODE.valueOf((String)request.getParameter(this.modeTag));
        Services.get().setSystemMode(sysMode);
        response.setStatus(200);
    }

    @Override
    protected void getQueueDump(JSONObject json) throws XServletException {
        List<String> queueDumpList = Services.get().get(CallableQueueService.class).getQueueDump();
        JSONArray queueDumpArray = new JSONArray();
        for (String str : queueDumpList) {
            JSONObject jObject = new JSONObject();
            jObject.put((Object)"callableDump", (Object)str);
            queueDumpArray.add((Object)jObject);
        }
        json.put((Object)"queueDump", (Object)queueDumpArray);
        List<String> uniqueDumpList = Services.get().get(CallableQueueService.class).getUniqueDump();
        JSONArray uniqueDumpArray = new JSONArray();
        for (String str : uniqueDumpList) {
            JSONObject jObject = new JSONObject();
            jObject.put((Object)"uniqueEntryDump", (Object)str);
            uniqueDumpArray.add((Object)jObject);
        }
        json.put((Object)"uniqueMapDump", (Object)uniqueDumpArray);
    }

    static {
        V1AdminServlet.RESOURCES_INFO[0] = new JsonRestServlet.ResourceInfo("status", Arrays.asList("PUT", "GET"), Arrays.asList(new JsonRestServlet.ParameterInfo("systemmode", String.class, true, Arrays.asList("PUT"))));
        V1AdminServlet.RESOURCES_INFO[1] = new JsonRestServlet.ResourceInfo("os-env", Arrays.asList("GET"), Collections.EMPTY_LIST);
        V1AdminServlet.RESOURCES_INFO[2] = new JsonRestServlet.ResourceInfo("java-sys-properties", Arrays.asList("GET"), Collections.EMPTY_LIST);
        V1AdminServlet.RESOURCES_INFO[3] = new JsonRestServlet.ResourceInfo("configuration", Arrays.asList("GET"), Collections.EMPTY_LIST);
        V1AdminServlet.RESOURCES_INFO[4] = new JsonRestServlet.ResourceInfo("instrumentation", Arrays.asList("GET"), Collections.EMPTY_LIST);
        V1AdminServlet.RESOURCES_INFO[5] = new JsonRestServlet.ResourceInfo("build-version", Arrays.asList("GET"), Collections.EMPTY_LIST);
        V1AdminServlet.RESOURCES_INFO[6] = new JsonRestServlet.ResourceInfo("queue-dump", Arrays.asList("GET"), Collections.EMPTY_LIST);
    }
}

