/*
 * Decompiled with CFR 0.152.
 */
package org.apache.oozie;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.sql.Timestamp;
import java.util.Date;
import javax.persistence.Basic;
import javax.persistence.Column;
import javax.persistence.Entity;
import javax.persistence.Lob;
import javax.persistence.NamedQueries;
import javax.persistence.NamedQuery;
import org.apache.hadoop.io.Writable;
import org.apache.oozie.client.WorkflowJob;
import org.apache.oozie.client.rest.JsonWorkflowJob;
import org.apache.oozie.util.DateUtils;
import org.apache.oozie.util.WritableUtils;
import org.apache.oozie.workflow.WorkflowInstance;
import org.apache.oozie.workflow.lite.LiteWorkflowInstance;
import org.apache.openjpa.enhance.PCRegistry;
import org.apache.openjpa.enhance.PersistenceCapable;
import org.apache.openjpa.enhance.StateManager;
import org.apache.openjpa.persistence.jdbc.Index;

@Entity
@NamedQueries(value={@NamedQuery(name="UPDATE_WORKFLOW", query="update WorkflowJobBean w set w.appName = :appName, w.appPath = :appPath, w.conf = :conf, w.group = :groupName, w.run = :run, w.user = :user, w.authToken = :authToken, w.createdTimestamp = :createdTime, w.endTimestamp = :endTime, w.externalId = :externalId, w.lastModifiedTimestamp = :lastModTime, w.logToken = :logToken, w.protoActionConf = :protoActionConf, w.slaXml =:slaXml, w.startTimestamp = :startTime, w.status = :status, w.wfInstance = :wfInstance where w.id = :id"), @NamedQuery(name="DELETE_WORKFLOW", query="delete from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOWS", query="select OBJECT(w) from WorkflowJobBean w order by w.startTimestamp desc"), @NamedQuery(name="GET_WORKFLOWS_COLUMNS", query="select w.id, w.appName, w.status, w.run, w.user, w.group, w.createdTimestamp, w.startTimestamp, w.lastModifiedTimestamp, w.endTimestamp from WorkflowJobBean w order by w.createdTimestamp desc"), @NamedQuery(name="GET_WORKFLOWS_COUNT", query="select count(w) from WorkflowJobBean w"), @NamedQuery(name="GET_COMPLETED_WORKFLOWS_OLDER_THAN", query="select w from WorkflowJobBean w where w.endTimestamp < :endTime"), @NamedQuery(name="GET_WORKFLOW", query="select OBJECT(w) from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_FOR_UPDATE", query="select OBJECT(w) from WorkflowJobBean w where w.id = :id"), @NamedQuery(name="GET_WORKFLOW_ID_FOR_EXTERNAL_ID", query="select  w.id from WorkflowJobBean w where w.externalId = :externalId"), @NamedQuery(name="GET_WORKFLOWS_COUNT_WITH_STATUS", query="select count(w) from WorkflowJobBean w where w.status = :status"), @NamedQuery(name="GET_WORKFLOWS_COUNT_WITH_STATUS_IN_LAST_N_SECS", query="select count(w) from WorkflowJobBean w where w.status = :status and w.lastModifiedTimestamp > :lastModTime")})
public class WorkflowJobBean
extends JsonWorkflowJob
implements Writable,
PersistenceCapable {
    @Column(name="proto_action_conf")
    @Lob
    private String protoActionConf = null;
    @Basic
    @Column(name="log_token")
    private String logToken = null;
    @Basic
    @Index
    @Column(name="external_id")
    private String externalId = null;
    @Basic
    @Index
    @Column(name="status")
    private String status = WorkflowJob.Status.PREP.toString();
    @Basic
    @Column(name="created_time")
    private Timestamp createdTimestamp = null;
    @Basic
    @Column(name="start_time")
    private Timestamp startTimestamp = null;
    @Basic
    @Index
    @Column(name="end_time")
    private Timestamp endTimestamp = null;
    @Column(name="auth_token")
    @Lob
    private String authToken = null;
    @Basic
    @Index
    @Column(name="last_modified_time")
    private Timestamp lastModifiedTimestamp = null;
    @Column(name="wf_instance")
    @Lob
    private byte[] wfInstance = null;
    @Column(name="sla_xml")
    @Lob
    private String slaXml = null;
    private static int pcInheritedFieldCount = JsonWorkflowJob.pcGetManagedFieldCount();
    private static String[] pcFieldNames;
    private static Class[] pcFieldTypes;
    private static byte[] pcFieldFlags;
    private static Class pcPCSuperclass;
    static /* synthetic */ Class class$Lorg$apache$oozie$client$rest$JsonWorkflowJob;
    static /* synthetic */ Class class$Ljava$lang$String;
    static /* synthetic */ Class class$Ljava$sql$Timestamp;
    static /* synthetic */ Class class$L$B;
    static /* synthetic */ Class class$Lorg$apache$oozie$WorkflowJobBean;

    public void write(DataOutput dataOutput) throws IOException {
        WritableUtils.writeStr(dataOutput, this.getAppPath());
        WritableUtils.writeStr(dataOutput, this.getAppName());
        WritableUtils.writeStr(dataOutput, this.getId());
        WritableUtils.writeStr(dataOutput, this.getParentId());
        WritableUtils.writeStr(dataOutput, this.getConf());
        WritableUtils.writeStr(dataOutput, this.getStatusStr());
        dataOutput.writeLong(this.getCreatedTime() != null ? this.getCreatedTime().getTime() : -1L);
        dataOutput.writeLong(this.getStartTime() != null ? this.getStartTime().getTime() : -1L);
        dataOutput.writeLong(this.getLastModifiedTime() != null ? this.getLastModifiedTime().getTime() : -1L);
        dataOutput.writeLong(this.getEndTime() != null ? this.getEndTime().getTime() : -1L);
        WritableUtils.writeStr(dataOutput, this.getUser());
        WritableUtils.writeStr(dataOutput, this.getGroup());
        dataOutput.writeInt(this.getRun());
        WritableUtils.writeStr(dataOutput, WorkflowJobBean.pcGetauthToken(this));
        WritableUtils.writeStr(dataOutput, WorkflowJobBean.pcGetlogToken(this));
        WritableUtils.writeStr(dataOutput, WorkflowJobBean.pcGetprotoActionConf(this));
    }

    public void readFields(DataInput dataInput) throws IOException {
        this.setAppPath(WritableUtils.readStr(dataInput));
        this.setAppName(WritableUtils.readStr(dataInput));
        this.setId(WritableUtils.readStr(dataInput));
        this.setParentId(WritableUtils.readStr(dataInput));
        this.setConf(WritableUtils.readStr(dataInput));
        this.setStatus(WorkflowJob.Status.valueOf((String)WritableUtils.readStr(dataInput)));
        long d = dataInput.readLong();
        if (d != -1L) {
            this.setCreatedTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            // empty if block
        }
        this.setStartTime(new Date(d));
        d = dataInput.readLong();
        if (d != -1L) {
            this.setLastModifiedTime(new Date(d));
        }
        if ((d = dataInput.readLong()) != -1L) {
            this.setEndTime(new Date(d));
        }
        this.setUser(WritableUtils.readStr(dataInput));
        this.setGroup(WritableUtils.readStr(dataInput));
        this.setRun(dataInput.readInt());
        WorkflowJobBean.pcSetauthToken(this, WritableUtils.readStr(dataInput));
        WorkflowJobBean.pcSetlogToken(this, WritableUtils.readStr(dataInput));
        WorkflowJobBean.pcSetprotoActionConf(this, WritableUtils.readStr(dataInput));
        this.setExternalId(this.getExternalId());
        this.setProtoActionConf(WorkflowJobBean.pcGetprotoActionConf(this));
    }

    public String getAuthToken() {
        return WorkflowJobBean.pcGetauthToken(this);
    }

    public void setAuthToken(String authToken) {
        WorkflowJobBean.pcSetauthToken(this, authToken);
    }

    public String getLogToken() {
        return WorkflowJobBean.pcGetlogToken(this);
    }

    public void setLogToken(String logToken) {
        WorkflowJobBean.pcSetlogToken(this, logToken);
    }

    public String getSlaXml() {
        return WorkflowJobBean.pcGetslaXml(this);
    }

    public void setSlaXml(String slaXml) {
        WorkflowJobBean.pcSetslaXml(this, slaXml);
    }

    public WorkflowInstance getWorkflowInstance() {
        return this.get(WorkflowJobBean.pcGetwfInstance(this));
    }

    public byte[] getWfInstance() {
        return WorkflowJobBean.pcGetwfInstance(this);
    }

    public void setWorkflowInstance(WorkflowInstance workflowInstance) {
        this.setWfInstance(workflowInstance);
    }

    public void setWfInstance(byte[] wfInstance) {
        WorkflowJobBean.pcSetwfInstance(this, wfInstance);
    }

    public void setWfInstance(WorkflowInstance wfInstance) {
        WorkflowJobBean.pcSetwfInstance(this, WritableUtils.toByteArray((LiteWorkflowInstance)wfInstance));
    }

    public String getProtoActionConf() {
        return WorkflowJobBean.pcGetprotoActionConf(this);
    }

    public void setProtoActionConf(String protoActionConf) {
        WorkflowJobBean.pcSetprotoActionConf(this, protoActionConf);
    }

    public String getprotoActionConf() {
        return WorkflowJobBean.pcGetprotoActionConf(this);
    }

    public String getlogToken() {
        return WorkflowJobBean.pcGetlogToken(this);
    }

    public String getStatusStr() {
        return WorkflowJobBean.pcGetstatus(this);
    }

    public Timestamp getLastModifiedTimestamp() {
        return WorkflowJobBean.pcGetlastModifiedTimestamp(this);
    }

    public Timestamp getStartTimestamp() {
        return WorkflowJobBean.pcGetstartTimestamp(this);
    }

    public Timestamp getCreatedTimestamp() {
        return WorkflowJobBean.pcGetcreatedTimestamp(this);
    }

    public Timestamp getEndTimestamp() {
        return WorkflowJobBean.pcGetendTimestamp(this);
    }

    @Override
    public void setAppName(String val) {
        super.setAppName(val);
    }

    @Override
    public void setAppPath(String val) {
        super.setAppPath(val);
    }

    @Override
    public void setConf(String val) {
        super.setConf(val);
    }

    @Override
    public void setStatus(WorkflowJob.Status val) {
        super.setStatus(val);
        WorkflowJobBean.pcSetstatus(this, val.toString());
    }

    @Override
    public WorkflowJob.Status getStatus() {
        return WorkflowJob.Status.valueOf((String)WorkflowJobBean.pcGetstatus(this));
    }

    @Override
    public void setExternalId(String externalId) {
        super.setExternalId(externalId);
        WorkflowJobBean.pcSetexternalId(this, externalId);
    }

    @Override
    public String getExternalId() {
        return WorkflowJobBean.pcGetexternalId(this);
    }

    @Override
    public void setLastModifiedTime(Date lastModifiedTime) {
        super.setLastModifiedTime(lastModifiedTime);
        WorkflowJobBean.pcSetlastModifiedTimestamp(this, DateUtils.convertDateToTimestamp(lastModifiedTime));
    }

    @Override
    public Date getLastModifiedTime() {
        return DateUtils.toDate(WorkflowJobBean.pcGetlastModifiedTimestamp(this));
    }

    @Override
    public Date getCreatedTime() {
        return DateUtils.toDate(WorkflowJobBean.pcGetcreatedTimestamp(this));
    }

    @Override
    public void setCreatedTime(Date createdTime) {
        super.setCreatedTime(createdTime);
        WorkflowJobBean.pcSetcreatedTimestamp(this, DateUtils.convertDateToTimestamp(createdTime));
    }

    @Override
    public Date getStartTime() {
        return DateUtils.toDate(WorkflowJobBean.pcGetstartTimestamp(this));
    }

    @Override
    public void setStartTime(Date startTime) {
        super.setStartTime(startTime);
        WorkflowJobBean.pcSetstartTimestamp(this, DateUtils.convertDateToTimestamp(startTime));
    }

    @Override
    public Date getEndTime() {
        return DateUtils.toDate(WorkflowJobBean.pcGetendTimestamp(this));
    }

    @Override
    public void setEndTime(Date endTime) {
        super.setEndTime(endTime);
        WorkflowJobBean.pcSetendTimestamp(this, DateUtils.convertDateToTimestamp(endTime));
    }

    private WorkflowInstance get(byte[] array) {
        LiteWorkflowInstance pInstance = WritableUtils.fromByteArray(array, LiteWorkflowInstance.class);
        return pInstance;
    }

    @Override
    public int pcGetEnhancementContractVersion() {
        return 1055128;
    }

    static {
        Class clazz = class$Lorg$apache$oozie$client$rest$JsonWorkflowJob != null ? class$Lorg$apache$oozie$client$rest$JsonWorkflowJob : (class$Lorg$apache$oozie$client$rest$JsonWorkflowJob = WorkflowJobBean.class$("org.apache.oozie.client.rest.JsonWorkflowJob"));
        pcPCSuperclass = clazz;
        pcFieldNames = new String[]{"authToken", "createdTimestamp", "endTimestamp", "externalId", "lastModifiedTimestamp", "logToken", "protoActionConf", "slaXml", "startTimestamp", "status", "wfInstance"};
        Class[] classArray = new Class[11];
        Class clazz2 = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        classArray[0] = clazz2;
        Class clazz3 = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowJobBean.class$("java.sql.Timestamp"));
        classArray[1] = clazz3;
        classArray[2] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowJobBean.class$("java.sql.Timestamp"));
        classArray[3] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        classArray[4] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowJobBean.class$("java.sql.Timestamp"));
        classArray[5] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        classArray[6] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        classArray[7] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        classArray[8] = class$Ljava$sql$Timestamp != null ? class$Ljava$sql$Timestamp : (class$Ljava$sql$Timestamp = WorkflowJobBean.class$("java.sql.Timestamp"));
        classArray[9] = class$Ljava$lang$String != null ? class$Ljava$lang$String : (class$Ljava$lang$String = WorkflowJobBean.class$("java.lang.String"));
        Class clazz4 = class$L$B != null ? class$L$B : (class$L$B = WorkflowJobBean.class$("[B"));
        classArray[10] = clazz4;
        pcFieldTypes = classArray;
        pcFieldFlags = new byte[]{26, 26, 26, 26, 26, 26, 26, 26, 26, 26, 26};
        Class clazz5 = class$Lorg$apache$oozie$WorkflowJobBean != null ? class$Lorg$apache$oozie$WorkflowJobBean : (class$Lorg$apache$oozie$WorkflowJobBean = WorkflowJobBean.class$("org.apache.oozie.WorkflowJobBean"));
        PCRegistry.register((Class)clazz5, (String[])pcFieldNames, (Class[])pcFieldTypes, (byte[])pcFieldFlags, (Class)pcPCSuperclass, (String)"WorkflowJobBean", (PersistenceCapable)new WorkflowJobBean());
    }

    static /* synthetic */ Class class$(String string) {
        try {
            return Class.forName(string);
        }
        catch (ClassNotFoundException classNotFoundException) {
            throw new NoClassDefFoundError(classNotFoundException.getMessage());
        }
    }

    @Override
    protected void pcClearFields() {
        super.pcClearFields();
        this.authToken = null;
        this.createdTimestamp = null;
        this.endTimestamp = null;
        this.externalId = null;
        this.lastModifiedTimestamp = null;
        this.logToken = null;
        this.protoActionConf = null;
        this.slaXml = null;
        this.startTimestamp = null;
        this.status = null;
        this.wfInstance = null;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, Object object, boolean bl) {
        WorkflowJobBean workflowJobBean = new WorkflowJobBean();
        if (bl) {
            workflowJobBean.pcClearFields();
        }
        workflowJobBean.pcStateManager = stateManager;
        workflowJobBean.pcCopyKeyFieldsFromObjectId(object);
        return workflowJobBean;
    }

    @Override
    public PersistenceCapable pcNewInstance(StateManager stateManager, boolean bl) {
        WorkflowJobBean workflowJobBean = new WorkflowJobBean();
        if (bl) {
            workflowJobBean.pcClearFields();
        }
        workflowJobBean.pcStateManager = stateManager;
        return workflowJobBean;
    }

    protected static int pcGetManagedFieldCount() {
        return 11 + JsonWorkflowJob.pcGetManagedFieldCount();
    }

    @Override
    public void pcReplaceField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcReplaceField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.authToken = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 1: {
                this.createdTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 2: {
                this.endTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 3: {
                this.externalId = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 4: {
                this.lastModifiedTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 5: {
                this.logToken = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 6: {
                this.protoActionConf = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 7: {
                this.slaXml = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 8: {
                this.startTimestamp = (Timestamp)this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
            case 9: {
                this.status = this.pcStateManager.replaceStringField((PersistenceCapable)this, n);
                return;
            }
            case 10: {
                this.wfInstance = (byte[])this.pcStateManager.replaceObjectField((PersistenceCapable)this, n);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcReplaceFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcReplaceField(nArray[n]);
            ++n;
        }
    }

    @Override
    public void pcProvideField(int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcProvideField(n);
            return;
        }
        switch (n2) {
            case 0: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.authToken);
                return;
            }
            case 1: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.createdTimestamp);
                return;
            }
            case 2: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.endTimestamp);
                return;
            }
            case 3: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.externalId);
                return;
            }
            case 4: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.lastModifiedTimestamp);
                return;
            }
            case 5: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.logToken);
                return;
            }
            case 6: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.protoActionConf);
                return;
            }
            case 7: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.slaXml);
                return;
            }
            case 8: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.startTimestamp);
                return;
            }
            case 9: {
                this.pcStateManager.providedStringField((PersistenceCapable)this, n, this.status);
                return;
            }
            case 10: {
                this.pcStateManager.providedObjectField((PersistenceCapable)this, n, (Object)this.wfInstance);
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcProvideFields(int[] nArray) {
        int n = 0;
        while (n < nArray.length) {
            this.pcProvideField(nArray[n]);
            ++n;
        }
    }

    protected void pcCopyField(WorkflowJobBean workflowJobBean, int n) {
        int n2 = n - pcInheritedFieldCount;
        if (n2 < 0) {
            super.pcCopyField(workflowJobBean, n);
            return;
        }
        switch (n2) {
            case 0: {
                this.authToken = workflowJobBean.authToken;
                return;
            }
            case 1: {
                this.createdTimestamp = workflowJobBean.createdTimestamp;
                return;
            }
            case 2: {
                this.endTimestamp = workflowJobBean.endTimestamp;
                return;
            }
            case 3: {
                this.externalId = workflowJobBean.externalId;
                return;
            }
            case 4: {
                this.lastModifiedTimestamp = workflowJobBean.lastModifiedTimestamp;
                return;
            }
            case 5: {
                this.logToken = workflowJobBean.logToken;
                return;
            }
            case 6: {
                this.protoActionConf = workflowJobBean.protoActionConf;
                return;
            }
            case 7: {
                this.slaXml = workflowJobBean.slaXml;
                return;
            }
            case 8: {
                this.startTimestamp = workflowJobBean.startTimestamp;
                return;
            }
            case 9: {
                this.status = workflowJobBean.status;
                return;
            }
            case 10: {
                this.wfInstance = workflowJobBean.wfInstance;
                return;
            }
        }
        throw new IllegalArgumentException();
    }

    @Override
    public void pcCopyFields(Object object, int[] nArray) {
        WorkflowJobBean workflowJobBean = (WorkflowJobBean)object;
        if (workflowJobBean.pcStateManager != this.pcStateManager) {
            throw new IllegalArgumentException();
        }
        if (this.pcStateManager == null) {
            throw new IllegalStateException();
        }
        int n = 0;
        while (n < nArray.length) {
            this.pcCopyField(workflowJobBean, nArray[n]);
            ++n;
        }
    }

    private static final String pcGetauthToken(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.authToken;
        }
        int n = pcInheritedFieldCount + 0;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.authToken;
    }

    private static final void pcSetauthToken(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.authToken = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 0, workflowJobBean.authToken, string, 0);
    }

    private static final Timestamp pcGetcreatedTimestamp(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.createdTimestamp;
        }
        int n = pcInheritedFieldCount + 1;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.createdTimestamp;
    }

    private static final void pcSetcreatedTimestamp(WorkflowJobBean workflowJobBean, Timestamp timestamp) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.createdTimestamp = timestamp;
            return;
        }
        workflowJobBean.pcStateManager.settingObjectField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 1, (Object)workflowJobBean.createdTimestamp, (Object)timestamp, 0);
    }

    private static final Timestamp pcGetendTimestamp(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.endTimestamp;
        }
        int n = pcInheritedFieldCount + 2;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.endTimestamp;
    }

    private static final void pcSetendTimestamp(WorkflowJobBean workflowJobBean, Timestamp timestamp) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.endTimestamp = timestamp;
            return;
        }
        workflowJobBean.pcStateManager.settingObjectField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 2, (Object)workflowJobBean.endTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetexternalId(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.externalId;
        }
        int n = pcInheritedFieldCount + 3;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.externalId;
    }

    private static final void pcSetexternalId(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.externalId = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 3, workflowJobBean.externalId, string, 0);
    }

    private static final Timestamp pcGetlastModifiedTimestamp(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.lastModifiedTimestamp;
        }
        int n = pcInheritedFieldCount + 4;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.lastModifiedTimestamp;
    }

    private static final void pcSetlastModifiedTimestamp(WorkflowJobBean workflowJobBean, Timestamp timestamp) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.lastModifiedTimestamp = timestamp;
            return;
        }
        workflowJobBean.pcStateManager.settingObjectField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 4, (Object)workflowJobBean.lastModifiedTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetlogToken(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.logToken;
        }
        int n = pcInheritedFieldCount + 5;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.logToken;
    }

    private static final void pcSetlogToken(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.logToken = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 5, workflowJobBean.logToken, string, 0);
    }

    private static final String pcGetprotoActionConf(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.protoActionConf;
        }
        int n = pcInheritedFieldCount + 6;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.protoActionConf;
    }

    private static final void pcSetprotoActionConf(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.protoActionConf = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 6, workflowJobBean.protoActionConf, string, 0);
    }

    private static final String pcGetslaXml(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.slaXml;
        }
        int n = pcInheritedFieldCount + 7;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.slaXml;
    }

    private static final void pcSetslaXml(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.slaXml = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 7, workflowJobBean.slaXml, string, 0);
    }

    private static final Timestamp pcGetstartTimestamp(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.startTimestamp;
        }
        int n = pcInheritedFieldCount + 8;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.startTimestamp;
    }

    private static final void pcSetstartTimestamp(WorkflowJobBean workflowJobBean, Timestamp timestamp) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.startTimestamp = timestamp;
            return;
        }
        workflowJobBean.pcStateManager.settingObjectField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 8, (Object)workflowJobBean.startTimestamp, (Object)timestamp, 0);
    }

    private static final String pcGetstatus(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.status;
        }
        int n = pcInheritedFieldCount + 9;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.status;
    }

    private static final void pcSetstatus(WorkflowJobBean workflowJobBean, String string) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.status = string;
            return;
        }
        workflowJobBean.pcStateManager.settingStringField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 9, workflowJobBean.status, string, 0);
    }

    private static final byte[] pcGetwfInstance(WorkflowJobBean workflowJobBean) {
        if (workflowJobBean.pcStateManager == null) {
            return workflowJobBean.wfInstance;
        }
        int n = pcInheritedFieldCount + 10;
        workflowJobBean.pcStateManager.accessingField(n);
        return workflowJobBean.wfInstance;
    }

    private static final void pcSetwfInstance(WorkflowJobBean workflowJobBean, byte[] byArray) {
        if (workflowJobBean.pcStateManager == null) {
            workflowJobBean.wfInstance = byArray;
            return;
        }
        workflowJobBean.pcStateManager.settingObjectField((PersistenceCapable)workflowJobBean, pcInheritedFieldCount + 10, (Object)workflowJobBean.wfInstance, (Object)byArray, 0);
    }
}

