/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.oozie;

import org.apache.oozie.client.OozieClient;
import org.apache.oozie.client.OozieClientException;
import org.apache.oozie.client.WorkflowJob;
import org.pentaho.hadoop.shim.api.internal.oozie.OozieJob;

public class OozieJobInfoImpl
implements OozieJob {
    private final String id;
    private final OozieClient oozieClient;

    public OozieJobInfoImpl(String id, OozieClient oozieClient) {
        this.id = id;
        this.oozieClient = oozieClient;
    }

    @Override
    public boolean didSucceed() throws org.pentaho.hadoop.shim.api.internal.oozie.OozieClientException {
        try {
            return this.oozieClient.getJobInfo(this.id).getStatus().equals((Object)WorkflowJob.Status.SUCCEEDED);
        }
        catch (OozieClientException e) {
            throw new org.pentaho.hadoop.shim.api.internal.oozie.OozieClientException(e, e.getErrorCode());
        }
    }

    @Override
    public String getId() {
        return this.id;
    }

    @Override
    public String getJobLog() throws org.pentaho.hadoop.shim.api.internal.oozie.OozieClientException {
        try {
            return this.oozieClient.getJobLog(this.id);
        }
        catch (OozieClientException e) {
            throw new org.pentaho.hadoop.shim.api.internal.oozie.OozieClientException(e, e.getErrorCode());
        }
    }

    @Override
    public boolean isRunning() throws org.pentaho.hadoop.shim.api.internal.oozie.OozieClientException {
        try {
            return this.oozieClient.getJobInfo(this.id).getStatus().equals((Object)WorkflowJob.Status.RUNNING);
        }
        catch (OozieClientException e) {
            throw new org.pentaho.hadoop.shim.api.internal.oozie.OozieClientException(e, e.getErrorCode());
        }
    }
}

