/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.big.data.impl.shim.mapreduce;

import com.google.common.annotations.VisibleForTesting;
import com.thoughtworks.xstream.XStream;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.net.URI;
import java.nio.file.Files;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Optional;
import java.util.Properties;
import org.apache.commons.io.FileUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemConfigBuilder;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.security.UserGroupInformation;
import org.pentaho.big.data.impl.shim.mapreduce.MapReduceJobBuilderImpl;
import org.pentaho.big.data.impl.shim.mapreduce.TransformationVisitorService;
import org.pentaho.bigdata.api.mapreduce.MapReduceTransformations;
import org.pentaho.bigdata.api.mapreduce.PentahoMapReduceOutputStepMetaInterface;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.logging.ChannelLogTable;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.logging.LogLevel;
import org.pentaho.di.core.logging.MetricsLogTable;
import org.pentaho.di.core.logging.PerformanceLogTable;
import org.pentaho.di.core.logging.StepLogTable;
import org.pentaho.di.core.logging.TransLogTable;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransConfiguration;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.version.BuildVersion;
import org.pentaho.hadoop.PluginPropertiesUtil;
import org.pentaho.hadoop.shim.ShimConfigsLoader;
import org.pentaho.hadoop.shim.ShimRuntimeException;
import org.pentaho.hadoop.shim.api.cluster.NamedCluster;
import org.pentaho.hadoop.shim.api.internal.Configuration;
import org.pentaho.hadoop.shim.api.internal.fs.FileSystem;
import org.pentaho.hadoop.shim.api.mapreduce.MapReduceJobAdvanced;
import org.pentaho.hadoop.shim.api.mapreduce.PentahoMapReduceJobBuilder;
import org.pentaho.hadoop.shim.spi.HadoopShim;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.stores.xml.XmlMetaStore;

public class PentahoMapReduceJobBuilderImpl
extends MapReduceJobBuilderImpl
implements PentahoMapReduceJobBuilder {
    public static final Class<?> PKG = PentahoMapReduceJobBuilderImpl.class;
    public static final String MAPREDUCE_APPLICATION_CLASSPATH = "mapreduce.application.classpath";
    public static final String DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH = "$HADOOP_MAPRED_HOME/share/hadoop/mapreduce/*,$HADOOP_MAPRED_HOME/share/hadoop/mapreduce/lib/*";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_USE_DISTRIBUTED_CACHE = "pmr.use.distributed.cache";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_CREATE_UNIQUE_METASTORE_DIR = "pmr.create.unique.metastore.dir";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_PMR_LIBRARIES_ARCHIVE_FILE = "pmr.libraries.archive.file";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_KETTLE_HDFS_INSTALL_DIR = "pmr.kettle.dfs.install.dir";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_KETTLE_INSTALLATION_ID = "pmr.kettle.installation.id";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_ADDITIONAL_PLUGINS = "pmr.kettle.additional.plugins";
    public static final String PENTAHO_MAPREDUCE_PROPERTY_EXCLUDE_FILES = "pmr.kettle.exclude.plugin.files";
    public static final String PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_INPUT_STEP_NOT_SPECIFIED = "PentahoMapReduceJobBuilderImpl.InputStepNotSpecified";
    public static final String PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_INPUT_STEP_NOT_FOUND = "PentahoMapReduceJobBuilderImpl.InputStepNotFound";
    public static final String PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_NO_KEY_ORDINAL = "PentahoMapReduceJobBuilderImpl.NoKeyOrdinal";
    public static final String PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_NO_VALUE_ORDINAL = "PentahoMapReduceJobBuilderImpl.NoValueOrdinal";
    public static final String PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_INPUT_HOP_DISABLED = "PentahoMapReduceJobBuilderImpl.InputHopDisabled";
    public static final String PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_OUTPUT_STEP_NOT_SPECIFIED = "PentahoMapReduceJobBuilderImpl.OutputStepNotSpecified";
    public static final String PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_OUTPUT_STEP_NOT_FOUND = "PentahoMapReduceJobBuilderImpl.OutputStepNotFound";
    public static final String ORG_PENTAHO_BIG_DATA_KETTLE_PLUGINS_MAPREDUCE_STEP_HADOOP_EXIT_META = "org.pentaho.big.data.kettle.plugins.mapreduce.step.HadoopExitMeta";
    public static final String PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_VALIDATION_ERROR = "PentahoMapReduceJobBuilderImpl.ValidationError";
    public static final String PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_NO_OUTPUT_KEY_ORDINAL = "PentahoMapReduceJobBuilderImpl.NoOutputKeyOrdinal";
    public static final String PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_NO_OUTPUT_VALUE_ORDINAL = "PentahoMapReduceJobBuilderImpl.NoOutputValueOrdinal";
    public static final String TRANSFORMATION_MAP_XML = "transformation-map-xml";
    public static final String TRANSFORMATION_MAP_INPUT_STEPNAME = "transformation-map-input-stepname";
    public static final String TRANSFORMATION_MAP_OUTPUT_STEPNAME = "transformation-map-output-stepname";
    public static final String LOG_LEVEL = "logLevel";
    public static final String TRANSFORMATION_COMBINER_XML = "transformation-combiner-xml";
    public static final String TRANSFORMATION_COMBINER_INPUT_STEPNAME = "transformation-combiner-input-stepname";
    public static final String TRANSFORMATION_COMBINER_OUTPUT_STEPNAME = "transformation-combiner-output-stepname";
    public static final String TRANSFORMATION_REDUCE_XML = "transformation-reduce-xml";
    public static final String TRANSFORMATION_REDUCE_INPUT_STEPNAME = "transformation-reduce-input-stepname";
    public static final String TRANSFORMATION_REDUCE_OUTPUT_STEPNAME = "transformation-reduce-output-stepname";
    public static final String JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_CLEANING_OUTPUT_PATH = "JobEntryHadoopTransJobExecutor.CleaningOutputPath";
    public static final String JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_FAILED_TO_CLEAN_OUTPUT_PATH = "JobEntryHadoopTransJobExecutor.FailedToCleanOutputPath";
    public static final String JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_ERROR_CLEANING_OUTPUT_PATH = "JobEntryHadoopTransJobExecutor.ErrorCleaningOutputPath";
    public static final String JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_KETTLE_HDFS_INSTALL_DIR_MISSING = "JobEntryHadoopTransJobExecutor.KettleHdfsInstallDirMissing";
    public static final String JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_INSTALLATION_OF_KETTLE_FAILED = "JobEntryHadoopTransJobExecutor.InstallationOfKettleFailed";
    public static final String JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_CONFIGURING_JOB_WITH_KETTLE_AT = "JobEntryHadoopTransJobExecutor.ConfiguringJobWithKettleAt";
    public static final String CLASSES = "classes/,";
    public static final String JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_UNABLE_TO_LOCATE_ARCHIVE = "JobEntryHadoopTransJobExecutor.UnableToLocateArchive";
    public static final String JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_KETTLE_INSTALLATION_MISSING_FROM = "JobEntryHadoopTransJobExecutor.KettleInstallationMissingFrom";
    private static final String KEYTAB_AUTHENTICATION_LOCATION = "pentaho.authentication.default.kerberos.keytabLocation";
    private static final String KEYTAB_IMPERSONATION_LOCATION = "pentaho.authentication.default.mapping.server.credentials.kerberos.keytabLocation";
    public static final String VARIABLE_SPACE = "variableSpace";
    private final HadoopShim hadoopShim;
    private final LogChannelInterface log;
    private final FileObject vfsPluginDirectory;
    private final Properties pmrProperties;
    private final List<TransformationVisitorService> visitorServices;
    private final TransFactory transFactory;
    private final PMRArchiveGetter pmrArchiveGetter;
    private final String installId;
    private boolean cleanOutputPath;
    private LogLevel logLevel;
    private String mapperTransformationXml;
    private String mapperInputStep;
    private String mapperOutputStep;
    private String combinerTransformationXml;
    private String combinerInputStep;
    private String combinerOutputStep;
    private String reducerTransformationXml;
    private String reducerInputStep;
    private String reducerOutputStep;

    public PentahoMapReduceJobBuilderImpl(NamedCluster namedCluster, HadoopShim hadoopShim, LogChannelInterface log, VariableSpace variableSpace, PluginInterface pluginInterface, Properties pmrProperties, List<TransformationVisitorService> visitorServices) throws KettleFileException {
        this(namedCluster, hadoopShim, log, variableSpace, pluginInterface, KettleVFS.getFileObject((String)pluginInterface.getPluginDirectory().getPath()), pmrProperties, new TransFactory(), new PMRArchiveGetter(pluginInterface, pmrProperties), visitorServices);
    }

    @VisibleForTesting
    PentahoMapReduceJobBuilderImpl(NamedCluster namedCluster, HadoopShim hadoopShim, LogChannelInterface log, VariableSpace variableSpace, PluginInterface pluginInterface, FileObject vfsPluginDirectory, Properties pmrProperties, TransFactory transFactory, PMRArchiveGetter pmrArchiveGetter, List<TransformationVisitorService> visitorServices) {
        super(namedCluster, hadoopShim, log, variableSpace);
        this.hadoopShim = hadoopShim;
        this.log = log;
        this.vfsPluginDirectory = vfsPluginDirectory;
        this.pmrProperties = pmrProperties;
        this.transFactory = transFactory;
        this.installId = PentahoMapReduceJobBuilderImpl.buildInstallIdBase(hadoopShim);
        this.pmrArchiveGetter = pmrArchiveGetter;
        this.visitorServices = this.addDefaultVisitors(visitorServices);
    }

    @VisibleForTesting
    List<TransformationVisitorService> addDefaultVisitors(List<TransformationVisitorService> visitorServices) {
        String ignoreTableLogging = System.getProperty("KETTLE_COMPATIBILITY_IGNORE_TABLE_LOGGING", "Y");
        Boolean notIgnore = "N".equalsIgnoreCase(ignoreTableLogging);
        if (notIgnore.booleanValue()) {
            return visitorServices;
        }
        ArrayList<TransformationVisitorService> editableList = new ArrayList<TransformationVisitorService>(visitorServices);
        editableList.add(new TransformationVisitorService(){

            @Override
            public void visit(MapReduceTransformations transformations, NamedCluster namedCluster) {
                PentahoMapReduceJobBuilderImpl.this.deleteLogging(transformations.getCombiner());
                PentahoMapReduceJobBuilderImpl.this.deleteLogging(transformations.getMapper());
                PentahoMapReduceJobBuilderImpl.this.deleteLogging(transformations.getReducer());
            }
        });
        return editableList;
    }

    private void deleteLogging(Optional<TransConfiguration> transConfiguration) {
        if (!transConfiguration.isPresent()) {
            return;
        }
        TransMeta meta = transConfiguration.get().getTransMeta();
        if (meta == null) {
            return;
        }
        StepLogTable table = meta.getStepLogTable();
        table.setConnectionName(null);
        meta.setStepLogTable(table);
        table = meta.getMetricsLogTable();
        table.setConnectionName(null);
        meta.setMetricsLogTable((MetricsLogTable)table);
        table = meta.getPerformanceLogTable();
        table.setConnectionName(null);
        meta.setPerformanceLogTable((PerformanceLogTable)table);
        table = meta.getTransLogTable();
        table.setConnectionName(null);
        meta.setTransLogTable((TransLogTable)table);
        table = meta.getChannelLogTable();
        table.setConnectionName(null);
        meta.setChannelLogTable((ChannelLogTable)table);
    }

    private VariableSpace removeLogging(VariableSpace variableSpace) {
        String ignoreTableLogging = System.getProperty("KETTLE_COMPATIBILITY_IGNORE_TABLE_LOGGING", "Y");
        Boolean notIgnore = "N".equalsIgnoreCase(ignoreTableLogging);
        if (notIgnore.booleanValue()) {
            return variableSpace;
        }
        Variables vs = new Variables();
        vs.copyVariablesFrom(variableSpace);
        vs.setVariable("KETTLE_STEP_LOG_DB", null);
        vs.setVariable("KETTLE_TRANS_LOG_DB", null);
        vs.setVariable("KETTLE_JOB_LOG_DB", null);
        vs.setVariable("KETTLE_TRANS_PERFORMANCE_LOG_DB", null);
        vs.setVariable("KETTLE_JOBENTRY_LOG_DB", null);
        vs.setVariable("KETTLE_CHANNEL_LOG_DB", null);
        vs.setVariable("KETTLE_METRICS_LOG_DB", null);
        vs.setVariable("KETTLE_CHECKPOINT_LOG_DB", null);
        return vs;
    }

    private static String buildInstallIdBase(HadoopShim hadoopShim) {
        String pluginVersion = new PluginPropertiesUtil().getVersion();
        String installId = BuildVersion.getInstance().getVersion();
        if (pluginVersion != null) {
            installId = installId + "-" + pluginVersion;
        }
        return installId + "-" + hadoopShim.getHadoopVersion();
    }

    public static String getProperty(Configuration conf, Properties properties, String propertyName, String defaultValue) {
        String fromConf = conf.get(propertyName);
        if (Utils.isEmpty((CharSequence)fromConf)) {
            Object objectValue = properties.get(propertyName);
            if (objectValue != null) {
                if (objectValue instanceof String) {
                    return objectValue.toString();
                }
                if (objectValue instanceof List) {
                    String strObjectValue = String.join((CharSequence)",", (List)objectValue);
                    if (strObjectValue.equals("")) {
                        return defaultValue;
                    }
                    return strObjectValue;
                }
                return defaultValue;
            }
            return defaultValue;
        }
        return fromConf;
    }

    public String getHadoopWritableCompatibleClassName(ValueMetaInterface valueMetaInterface) {
        Class<?> hadoopWritableCompatibleClass = this.hadoopShim.getHadoopWritableCompatibleClass(valueMetaInterface);
        if (hadoopWritableCompatibleClass == null) {
            return null;
        }
        return hadoopWritableCompatibleClass.getCanonicalName();
    }

    public void setLogLevel(LogLevel logLevel) {
        this.logLevel = logLevel;
    }

    public void setCleanOutputPath(boolean cleanOutputPath) {
        this.cleanOutputPath = cleanOutputPath;
    }

    public void verifyTransMeta(TransMeta transMeta, String inputStepName, String outputStepName) throws KettleException {
        if (Utils.isEmpty((CharSequence)inputStepName)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_INPUT_STEP_NOT_SPECIFIED, (String[])new String[0]));
        }
        StepMeta inputStepMeta = transMeta.findStep(inputStepName);
        if (inputStepMeta == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_INPUT_STEP_NOT_FOUND, (String[])new String[]{inputStepName}));
        }
        RowMetaInterface injectorRowMeta = transMeta.getStepFields(inputStepMeta);
        if (!this.containsCaseInsensitive("key", Arrays.asList(injectorRowMeta.getFieldNames()))) {
            throw new KettleException(BaseMessages.getString(PKG, (String)PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_NO_KEY_ORDINAL, (String[])new String[]{inputStepName}));
        }
        if (!this.containsCaseInsensitive("value", Arrays.asList(injectorRowMeta.getFieldNames()))) {
            throw new KettleException(BaseMessages.getString(PKG, (String)PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_NO_VALUE_ORDINAL, (String[])new String[]{inputStepName}));
        }
        Trans t = this.transFactory.create(transMeta);
        t.prepareExecution(null);
        if (t.getStepInterface(inputStepName, 0) == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_INPUT_HOP_DISABLED, (String[])new String[]{inputStepName}));
        }
        if (Utils.isEmpty((CharSequence)outputStepName)) {
            throw new KettleException(BaseMessages.getString(PKG, (String)PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_OUTPUT_STEP_NOT_SPECIFIED, (String[])new String[0]));
        }
        StepMeta outputStepMeta = transMeta.findStep(outputStepName);
        if (outputStepMeta == null) {
            throw new KettleException(BaseMessages.getString(PKG, (String)PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_OUTPUT_STEP_NOT_FOUND, (String[])new String[]{outputStepName}));
        }
        if (outputStepMeta.getStepMetaInterface() instanceof PentahoMapReduceOutputStepMetaInterface) {
            RowMetaInterface outputRowMeta = transMeta.getPrevStepFields(outputStepMeta);
            StepMetaInterface exitMeta = outputStepMeta.getStepMetaInterface();
            ArrayList<CheckResultInterface> remarks = new ArrayList<CheckResultInterface>();
            ((PentahoMapReduceOutputStepMetaInterface)exitMeta).checkPmr(remarks, transMeta, outputStepMeta, outputRowMeta);
            StringBuilder message = new StringBuilder();
            for (CheckResultInterface remark : remarks) {
                if (remark.getType() != 4) continue;
                message.append(message.toString()).append(Const.CR);
            }
            if (message.length() > 0) {
                throw new KettleException(BaseMessages.getString(PKG, (String)PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_VALIDATION_ERROR, (String[])new String[0]) + Const.CR + message);
            }
        } else {
            RowMetaInterface outputRowMeta = transMeta.getStepFields(outputStepMeta);
            List<String> fieldNames = Arrays.asList(outputRowMeta.getFieldNames());
            if (!this.containsCaseInsensitive("outKey", fieldNames)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_NO_OUTPUT_KEY_ORDINAL, (String[])new String[]{outputStepName}));
            }
            if (!this.containsCaseInsensitive("outValue", fieldNames)) {
                throw new KettleException(BaseMessages.getString(PKG, (String)PENTAHO_MAP_REDUCE_JOB_BUILDER_IMPL_NO_OUTPUT_VALUE_ORDINAL, (String[])new String[]{outputStepName}));
            }
        }
    }

    private boolean containsCaseInsensitive(String s, List<String> l) {
        return l.stream().anyMatch(x -> x.equalsIgnoreCase(s));
    }

    public void setCombinerInfo(String combinerTransformationXml, String combinerInputStep, String combinerOutputStep) {
        this.combinerTransformationXml = combinerTransformationXml;
        this.combinerInputStep = combinerInputStep;
        this.combinerOutputStep = combinerOutputStep;
    }

    public void setReducerInfo(String reducerTransformationXml, String reducerInputStep, String reducerOutputStep) {
        this.reducerTransformationXml = reducerTransformationXml;
        this.reducerInputStep = reducerInputStep;
        this.reducerOutputStep = reducerOutputStep;
    }

    public void setMapperInfo(String mapperTransformationXml, String mapperInputStep, String mapperOutputStep) {
        this.mapperTransformationXml = mapperTransformationXml;
        this.mapperInputStep = mapperInputStep;
        this.mapperOutputStep = mapperOutputStep;
    }

    @Override
    protected void configure(Configuration conf) throws Exception {
        this.callVisitors();
        this.setMapRunnerClass(this.hadoopShim.getPentahoMapReduceMapRunnerClass());
        conf.set(TRANSFORMATION_MAP_XML, this.mapperTransformationXml);
        conf.set(TRANSFORMATION_MAP_INPUT_STEPNAME, this.mapperInputStep);
        conf.set(TRANSFORMATION_MAP_OUTPUT_STEPNAME, this.mapperOutputStep);
        if (this.combinerTransformationXml != null) {
            conf.set(TRANSFORMATION_COMBINER_XML, this.combinerTransformationXml);
            conf.set(TRANSFORMATION_COMBINER_INPUT_STEPNAME, this.combinerInputStep);
            conf.set(TRANSFORMATION_COMBINER_OUTPUT_STEPNAME, this.combinerOutputStep);
            this.setCombinerClass(this.hadoopShim.getPentahoMapReduceCombinerClass());
        }
        if (this.reducerTransformationXml != null) {
            conf.set(TRANSFORMATION_REDUCE_XML, this.reducerTransformationXml);
            conf.set(TRANSFORMATION_REDUCE_INPUT_STEPNAME, this.reducerInputStep);
            conf.set(TRANSFORMATION_REDUCE_OUTPUT_STEPNAME, this.reducerOutputStep);
            this.setReducerClass(this.hadoopShim.getPentahoMapReduceReducerClass());
        }
        conf.setJarByClass(Class.forName("org.pentaho.hadoop.mapreduce.PentahoMapReduceJarMarker"));
        conf.set(LOG_LEVEL, this.logLevel.toString());
        this.configureVariableSpace(conf);
        super.configure(conf);
    }

    @Override
    protected MapReduceJobAdvanced submit(Configuration conf, String shimIdentifier) throws IOException {
        this.cleanOutputPath(conf);
        FileSystem fs = this.hadoopShim.getFileSystem(conf);
        if (Boolean.parseBoolean(PentahoMapReduceJobBuilderImpl.getProperty(conf, this.pmrProperties, PENTAHO_MAPREDUCE_PROPERTY_USE_DISTRIBUTED_CACHE, Boolean.toString(true)))) {
            String installPath = PentahoMapReduceJobBuilderImpl.getProperty(conf, this.pmrProperties, PENTAHO_MAPREDUCE_PROPERTY_KETTLE_HDFS_INSTALL_DIR, null);
            String mInstallId = PentahoMapReduceJobBuilderImpl.getProperty(conf, this.pmrProperties, PENTAHO_MAPREDUCE_PROPERTY_KETTLE_INSTALLATION_ID, null);
            try {
                if (Utils.isEmpty((CharSequence)installPath)) {
                    throw new IllegalArgumentException(BaseMessages.getString(PKG, (String)JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_KETTLE_HDFS_INSTALL_DIR_MISSING, (String[])new String[0]));
                }
                if (Utils.isEmpty((CharSequence)mInstallId)) {
                    mInstallId = this.installId;
                }
                if (!installPath.endsWith(Const.FILE_SEPARATOR)) {
                    installPath = installPath + Const.FILE_SEPARATOR;
                }
                org.pentaho.hadoop.shim.api.internal.fs.Path kettleEnvInstallDir = fs.asPath(installPath, mInstallId);
                FileObject pmrLibArchive = this.pmrArchiveGetter.getPmrArchive(conf);
                if (this.hadoopShim.getDistributedCacheUtil().isKettleEnvironmentInstalledAt(fs, kettleEnvInstallDir)) {
                    this.log.logDetailed(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.UsingKettleInstallationFrom", (String[])new String[]{kettleEnvInstallDir.toUri().getPath()}));
                } else {
                    String additionalPluginNames = PentahoMapReduceJobBuilderImpl.getProperty(conf, this.pmrProperties, PENTAHO_MAPREDUCE_PROPERTY_ADDITIONAL_PLUGINS, null);
                    String excludePluginFileNames = PentahoMapReduceJobBuilderImpl.getProperty(conf, this.pmrProperties, PENTAHO_MAPREDUCE_PROPERTY_EXCLUDE_FILES, null);
                    if (pmrLibArchive == null) {
                        throw new KettleException(BaseMessages.getString(PKG, (String)JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_UNABLE_TO_LOCATE_ARCHIVE, (String[])new String[]{this.pmrArchiveGetter.getVfsFilename(conf)}));
                    }
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.InstallingKettleAt", (Object[])new Object[]{kettleEnvInstallDir}));
                    FileObject bigDataPluginFolder = this.vfsPluginDirectory;
                    this.hadoopShim.getDistributedCacheUtil().installKettleEnvironment(pmrLibArchive, fs, kettleEnvInstallDir, bigDataPluginFolder, additionalPluginNames, excludePluginFileNames, shimIdentifier);
                    this.log.logBasic(BaseMessages.getString(PKG, (String)"JobEntryHadoopTransJobExecutor.InstallationOfKettleSuccessful", (Object[])new Object[]{kettleEnvInstallDir}));
                }
                this.stageMetaStoreForHadoop(conf, fs, installPath);
                this.log.logBasic(BaseMessages.getString(PKG, (String)JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_CONFIGURING_JOB_WITH_KETTLE_AT, (String[])new String[]{kettleEnvInstallDir.toUri().getPath()}));
                String mapreduceClasspath = conf.get(MAPREDUCE_APPLICATION_CLASSPATH, DEFAULT_MAPREDUCE_APPLICATION_CLASSPATH);
                conf.set(MAPREDUCE_APPLICATION_CLASSPATH, CLASSES + mapreduceClasspath);
                this.hadoopShim.getDistributedCacheUtil().configureWithKettleEnvironment(conf, fs, kettleEnvInstallDir);
                this.log.logBasic("mapreduce.application.classpath: " + conf.get(MAPREDUCE_APPLICATION_CLASSPATH));
            }
            catch (Exception ex) {
                throw new IOException(BaseMessages.getString(PKG, (String)JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_INSTALLATION_OF_KETTLE_FAILED, (String[])new String[0]), ex);
            }
        }
        JobConf jobConf = conf.getAsDelegateConf(JobConf.class);
        jobConf.getCredentials().addAll(UserGroupInformation.getCurrentUser().getCredentials());
        return super.submit(conf, shimIdentifier);
    }

    protected void stageMetaStoreForHadoop(Configuration conf, FileSystem fs, String installPath) throws Exception {
        boolean overwrite;
        org.pentaho.hadoop.shim.api.internal.fs.Path hdfsMetaStoreDirForCurrentJobPath;
        Path localMetaStoreSnapshotDirPath = Files.createTempDirectory("metastore", new FileAttribute[0]);
        FileObject localMetaStoreSnapshotDirObject = KettleVFS.getFileObject((String)localMetaStoreSnapshotDirPath.toString());
        if (Boolean.parseBoolean(PentahoMapReduceJobBuilderImpl.getProperty(conf, this.pmrProperties, PENTAHO_MAPREDUCE_PROPERTY_CREATE_UNIQUE_METASTORE_DIR, Boolean.toString(true)))) {
            hdfsMetaStoreDirForCurrentJobPath = fs.asPath(installPath, localMetaStoreSnapshotDirObject.getName().getBaseName());
            overwrite = false;
        } else {
            hdfsMetaStoreDirForCurrentJobPath = fs.asPath(installPath, "metastore");
            overwrite = true;
        }
        this.snapshotMetaStore(localMetaStoreSnapshotDirPath.toString());
        this.hadoopShim.getDistributedCacheUtil().stageForCache(localMetaStoreSnapshotDirObject, fs, hdfsMetaStoreDirForCurrentJobPath, "", overwrite, true);
        this.hadoopShim.getDistributedCacheUtil().addCachedFiles(conf, fs, hdfsMetaStoreDirForCurrentJobPath, null);
    }

    private void snapshotMetaStore(String metaStoreSnapshotDir) throws MetaStoreException {
        XmlMetaStore snapshot = new XmlMetaStore(metaStoreSnapshotDir);
        try {
            FileSystemConfigBuilder nc = KettleVFS.getInstance().getFileSystemManager().getFileSystemConfigBuilder("hc");
            Method snapshotMethod = nc.getClass().getMethod("snapshotNamedClusterToMetaStore", IMetaStore.class);
            snapshotMethod.invoke((Object)nc, snapshot);
            this.stageConfigurationFiles(metaStoreSnapshotDir);
        }
        catch (IllegalAccessException | NoSuchMethodException | InvocationTargetException | FileSystemException e) {
            this.log.logError("Error in snapshotNamedClusterToMetaStore.", e);
        }
    }

    private void stageConfigurationFiles(String metaStoreSnapshotDir) {
        String keytabImpersFilePath;
        File configFilesStagingLocation = new File(metaStoreSnapshotDir + File.separator + ShimConfigsLoader.CONFIGS_DIR_PREFIX + File.separator + this.getClusterName());
        ShimConfigsLoader.ClusterConfigNames[] configFilesNames = ShimConfigsLoader.ClusterConfigNames.values();
        Properties configProps = ShimConfigsLoader.loadConfigProperties(this.getClusterName());
        String keytabAuthFilePath = configProps.getProperty(KEYTAB_AUTHENTICATION_LOCATION, "");
        if (!keytabAuthFilePath.isEmpty()) {
            this.copyConfigFileToStaging(configFilesStagingLocation, Paths.get(keytabAuthFilePath, new String[0]).getFileName().toString());
        }
        if (!(keytabImpersFilePath = configProps.getProperty(KEYTAB_IMPERSONATION_LOCATION, "")).isEmpty()) {
            this.copyConfigFileToStaging(configFilesStagingLocation, Paths.get(keytabImpersFilePath, new String[0]).getFileName().toString());
        }
    }

    private void copyConfigFileToStaging(File configFilesStagingLocation, String configFileName) {
        try {
            URI configFileLocation = ShimConfigsLoader.getURLToResourceFile(configFileName, this.getClusterName()).toURI();
            File configFileSource = new File(configFileLocation);
            boolean stagingExists = true;
            if (!configFilesStagingLocation.exists()) {
                stagingExists = configFilesStagingLocation.mkdirs();
            }
            if (configFileSource.exists() && stagingExists) {
                FileUtils.copyFileToDirectory((File)configFileSource, (File)configFilesStagingLocation);
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    protected void configureVariableSpace(Configuration conf) {
        XStream xStream = new XStream();
        xStream.alias(VARIABLE_SPACE, VariableSpace.class);
        String xmlVariableSpace = xStream.toXML((Object)this.removeLogging(this.getVariableSpace()));
        conf.setStrings(VARIABLE_SPACE, xmlVariableSpace);
    }

    @VisibleForTesting
    void cleanOutputPath(Configuration conf) throws IOException {
        if (this.cleanOutputPath) {
            FileSystem fs = this.hadoopShim.getFileSystem(conf);
            org.pentaho.hadoop.shim.api.internal.fs.Path path = this.getOutputPath(conf, fs);
            String outputPath = path.toUri().toString();
            if (this.log.isBasic()) {
                this.log.logBasic(BaseMessages.getString(PKG, (String)JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_CLEANING_OUTPUT_PATH, (String[])new String[]{outputPath}));
            }
            try {
                if (!fs.exists(path)) {
                    return;
                }
                if (!fs.delete(path, true) && this.log.isBasic()) {
                    this.log.logBasic(BaseMessages.getString(PKG, (String)JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_FAILED_TO_CLEAN_OUTPUT_PATH, (String[])new String[]{outputPath}));
                }
            }
            catch (IOException ex) {
                throw new IOException(BaseMessages.getString(PKG, (String)JOB_ENTRY_HADOOP_TRANS_JOB_EXECUTOR_ERROR_CLEANING_OUTPUT_PATH, (String[])new String[]{outputPath}), ex);
            }
        }
    }

    private void callVisitors() {
        MapReduceTransformations transformations = new MapReduceTransformations();
        transformations.setCombiner(this.convert(this.combinerTransformationXml));
        transformations.setMapper(this.convert(this.mapperTransformationXml));
        transformations.setReducer(this.convert(this.reducerTransformationXml));
        for (TransformationVisitorService visitorService : this.visitorServices) {
            visitorService.visit(transformations, this.getNamedCluster());
        }
        this.combinerTransformationXml = this.convert(transformations.getCombiner());
        this.mapperTransformationXml = this.convert(transformations.getMapper());
        this.reducerTransformationXml = this.convert(transformations.getReducer());
    }

    private Optional<TransConfiguration> convert(String xmlString) {
        try {
            if (xmlString == null) {
                return Optional.empty();
            }
            TransConfiguration transConfiguration = TransConfiguration.fromXML((String)xmlString);
            return Optional.of(transConfiguration);
        }
        catch (KettleException e) {
            throw new ShimRuntimeException("Unable to convert string to object", (Exception)((Object)e));
        }
    }

    private String convert(Optional<TransConfiguration> transConfiguration) {
        try {
            if (transConfiguration.isPresent()) {
                return transConfiguration.get().getXML();
            }
            return null;
        }
        catch (IOException | KettleException e) {
            throw new ShimRuntimeException("Unable to convert object to string.", (Exception)e);
        }
    }

    @VisibleForTesting
    String getInstallId() {
        return this.installId;
    }

    @VisibleForTesting
    static class PMRArchiveGetter {
        private final PluginInterface pluginInterface;
        private final Properties pmrProperties;

        public PMRArchiveGetter(PluginInterface pluginInterface, Properties pmrProperties) {
            this.pluginInterface = pluginInterface;
            this.pmrProperties = pmrProperties;
        }

        public FileObject getPmrArchive(Configuration conf) throws KettleFileException {
            return KettleVFS.getFileObject((String)this.getVfsFilename(conf));
        }

        public String getVfsFilename(Configuration conf) {
            return this.pluginInterface.getPluginDirectory().getPath() + Const.FILE_SEPARATOR + PentahoMapReduceJobBuilderImpl.getProperty(conf, this.pmrProperties, PentahoMapReduceJobBuilderImpl.PENTAHO_MAPREDUCE_PROPERTY_PMR_LIBRARIES_ARCHIVE_FILE, null);
        }
    }

    @VisibleForTesting
    static class TransFactory {
        TransFactory() {
        }

        public Trans create(TransMeta transMeta) {
            return new Trans(transMeta);
        }
    }
}

