/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.namedcluster.model;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.exception.KettleValueException;
import org.pentaho.di.core.osgi.api.NamedClusterSiteFile;
import org.pentaho.di.core.osgi.impl.NamedClusterSiteFileImpl;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.metastore.api.security.Base64TwoWayPasswordEncoder;
import org.pentaho.metastore.api.security.ITwoWayPasswordEncoder;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.pentaho.metastore.persist.MetaStoreElementType;
import org.w3c.dom.Node;

@MetaStoreElementType(name="NamedCluster", description="A NamedCluster")
public class NamedCluster
implements Cloneable,
VariableSpace {
    private VariableSpace variables = new Variables();
    public static final String HDFS_SCHEME = "hdfs";
    public static final String MAPRFS_SCHEME = "maprfs";
    public static final String WASB_SCHEME = "wasb";
    @MetaStoreAttribute
    private String name;
    @MetaStoreAttribute
    private String shimIdentifier;
    @MetaStoreAttribute
    private String storageScheme;
    @MetaStoreAttribute
    private String hdfsHost;
    @MetaStoreAttribute
    private String hdfsPort;
    @MetaStoreAttribute
    private String hdfsUsername;
    @MetaStoreAttribute
    private String hdfsPassword;
    @MetaStoreAttribute
    private String jobTrackerHost;
    @MetaStoreAttribute
    private String jobTrackerPort;
    @MetaStoreAttribute
    private String zooKeeperHost;
    @MetaStoreAttribute
    private String zooKeeperPort;
    @MetaStoreAttribute
    private String oozieUrl;
    @MetaStoreAttribute
    private boolean mapr;
    @MetaStoreAttribute
    private String gatewayUrl;
    @MetaStoreAttribute
    private String gatewayUsername;
    @MetaStoreAttribute
    private String gatewayPassword;
    @MetaStoreAttribute
    private boolean useGateway;
    @MetaStoreAttribute
    private String kafkaBootstrapServers;
    @MetaStoreAttribute
    private long lastModifiedDate = System.currentTimeMillis();
    @MetaStoreAttribute
    private List<NamedClusterSiteFile> siteFiles;
    private ITwoWayPasswordEncoder passwordEncoder = new Base64TwoWayPasswordEncoder();
    public static final Comparator<NamedCluster> comparator = (c1, c2) -> c1.getName().compareToIgnoreCase(c2.getName());

    public NamedCluster() {
        this.siteFiles = new ArrayList<NamedClusterSiteFile>();
        this.initializeVariablesFrom(null);
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public void copyVariablesFrom(VariableSpace space) {
        this.variables.copyVariablesFrom(space);
    }

    public String environmentSubstitute(String aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String[] environmentSubstitute(String[] aString) {
        return this.variables.environmentSubstitute(aString);
    }

    public String fieldSubstitute(String aString, RowMetaInterface rowMeta, Object[] rowData) throws KettleValueException {
        return this.variables.fieldSubstitute(aString, rowMeta, rowData);
    }

    public VariableSpace getParentVariableSpace() {
        return this.variables.getParentVariableSpace();
    }

    public void setParentVariableSpace(VariableSpace parent) {
        this.variables.setParentVariableSpace(parent);
    }

    public String getVariable(String variableName, String defaultValue) {
        return this.variables.getVariable(variableName, defaultValue);
    }

    public String getVariable(String variableName) {
        return this.variables.getVariable(variableName);
    }

    public boolean getBooleanValueOfVariable(String variableName, boolean defaultValue) {
        String value;
        if (!Utils.isEmpty((CharSequence)variableName) && !Utils.isEmpty((CharSequence)(value = this.environmentSubstitute(variableName)))) {
            return ValueMetaBase.convertStringToBoolean((String)value);
        }
        return defaultValue;
    }

    public void initializeVariablesFrom(VariableSpace parent) {
        this.variables.initializeVariablesFrom(parent);
    }

    public String[] listVariables() {
        return this.variables.listVariables();
    }

    public void setVariable(String variableName, String variableValue) {
        this.variables.setVariable(variableName, variableValue);
    }

    public void shareVariablesWith(VariableSpace space) {
        this.variables = space;
    }

    public void injectVariables(Map<String, String> prop) {
        this.variables.injectVariables(prop);
    }

    public void replaceMeta(NamedCluster nc) {
        this.setName(nc.getName());
        this.setShimIdentifier(nc.getShimIdentifier());
        this.setStorageScheme(nc.getStorageScheme());
        this.setHdfsHost(nc.getHdfsHost());
        this.setHdfsPort(nc.getHdfsPort());
        this.setHdfsUsername(nc.getHdfsUsername());
        this.setHdfsPassword(nc.getHdfsPassword());
        this.setJobTrackerHost(nc.getJobTrackerHost());
        this.setJobTrackerPort(nc.getJobTrackerPort());
        this.setZooKeeperHost(nc.getZooKeeperHost());
        this.setZooKeeperPort(nc.getZooKeeperPort());
        this.setOozieUrl(nc.getOozieUrl());
        this.setMapr(nc.isMapr());
        this.lastModifiedDate = System.currentTimeMillis();
        this.setGatewayUrl(nc.getGatewayUrl());
        this.setGatewayUsername(nc.getGatewayUsername());
        this.setGatewayPassword(nc.getGatewayPassword());
        this.setUseGateway(nc.isUseGateway());
        this.setKafkaBootstrapServers(nc.getKafkaBootstrapServers());
        for (NamedClusterSiteFile ncsf : nc.getSiteFiles()) {
            this.siteFiles.add(ncsf.copy());
        }
    }

    public NamedCluster clone() {
        NamedCluster nc = new NamedCluster();
        nc.replaceMeta(this);
        return nc;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        NamedCluster other = (NamedCluster)obj;
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }

    public int hashCode() {
        return Objects.hash(this.name);
    }

    public String getHdfsHost() {
        return this.hdfsHost;
    }

    public void setHdfsHost(String hdfsHost) {
        this.hdfsHost = hdfsHost;
    }

    public String getHdfsPort() {
        return this.hdfsPort;
    }

    public void setHdfsPort(String hdfsPort) {
        this.hdfsPort = hdfsPort;
    }

    public String getHdfsUsername() {
        return this.hdfsUsername;
    }

    public void setHdfsUsername(String hdfsUsername) {
        this.hdfsUsername = hdfsUsername;
    }

    public String getHdfsPassword() {
        return this.hdfsPassword;
    }

    public void setHdfsPassword(String hdfsPassword) {
        this.hdfsPassword = hdfsPassword;
    }

    public String getJobTrackerHost() {
        return this.jobTrackerHost;
    }

    public void setJobTrackerHost(String jobTrackerHost) {
        this.jobTrackerHost = jobTrackerHost;
    }

    public String getJobTrackerPort() {
        return this.jobTrackerPort;
    }

    public void setJobTrackerPort(String jobTrackerPort) {
        this.jobTrackerPort = jobTrackerPort;
    }

    public String getZooKeeperHost() {
        return this.zooKeeperHost;
    }

    public void setZooKeeperHost(String zooKeeperHost) {
        this.zooKeeperHost = zooKeeperHost;
    }

    public String getZooKeeperPort() {
        return this.zooKeeperPort;
    }

    public void setZooKeeperPort(String zooKeeperPort) {
        this.zooKeeperPort = zooKeeperPort;
    }

    public String getOozieUrl() {
        return this.oozieUrl;
    }

    public void setOozieUrl(String oozieUrl) {
        this.oozieUrl = oozieUrl;
    }

    public long getLastModifiedDate() {
        return this.lastModifiedDate;
    }

    public void setLastModifiedDate(long lastModifiedDate) {
        this.lastModifiedDate = lastModifiedDate;
    }

    public void setMapr(boolean mapr) {
        if (mapr) {
            this.setStorageScheme(MAPRFS_SCHEME);
        }
    }

    public boolean isMapr() {
        if (this.storageScheme == null) {
            return this.mapr;
        }
        return this.storageScheme.equals(MAPRFS_SCHEME);
    }

    public String getShimIdentifier() {
        return this.shimIdentifier;
    }

    public void setShimIdentifier(String shimIdentifier) {
        this.shimIdentifier = shimIdentifier;
    }

    public String toString() {
        return "Named cluster: " + this.getName();
    }

    public String getStorageScheme() {
        if (this.storageScheme == null) {
            this.storageScheme = this.isMapr() ? MAPRFS_SCHEME : HDFS_SCHEME;
        }
        return this.storageScheme;
    }

    public void setStorageScheme(String storageScheme) {
        this.storageScheme = storageScheme;
    }

    public String toXmlForEmbed(String rootTag) {
        return null;
    }

    public NamedCluster fromXmlForEmbed(Node node) {
        return null;
    }

    public String getGatewayUrl() {
        return this.gatewayUrl;
    }

    public void setGatewayUrl(String gatewayUrl) {
        this.gatewayUrl = gatewayUrl;
    }

    public String getGatewayUsername() {
        return this.gatewayUsername;
    }

    public void setGatewayUsername(String gatewayUsername) {
        this.gatewayUsername = gatewayUsername;
    }

    public String getGatewayPassword() {
        return this.gatewayPassword;
    }

    public void setGatewayPassword(String gatewayPassword) {
        this.gatewayPassword = gatewayPassword;
    }

    public boolean isUseGateway() {
        return this.useGateway;
    }

    public void setUseGateway(boolean useGateway) {
        this.useGateway = useGateway;
    }

    public String getKafkaBootstrapServers() {
        return this.kafkaBootstrapServers;
    }

    public void setKafkaBootstrapServers(String kafkaBootstrapServers) {
        this.kafkaBootstrapServers = kafkaBootstrapServers;
    }

    public String decodePassword(String password) {
        if (password == null || password.startsWith("Encrypted ")) {
            return Encr.decryptPasswordOptionallyEncrypted((String)password);
        }
        if (!StringUtil.isVariable((String)password)) {
            return this.passwordEncoder.decode((CharSequence)password);
        }
        return password;
    }

    public String encodePassword(String password) {
        return Encr.encryptPasswordIfNotUsingVariables((String)password);
    }

    public List<NamedClusterSiteFile> getSiteFiles() {
        return this.siteFiles;
    }

    public void setSiteFiles(List<NamedClusterSiteFile> siteFiles) {
        this.siteFiles = siteFiles;
    }

    public void addSiteFile(String fileName, String content) {
        this.siteFiles.add((NamedClusterSiteFile)new NamedClusterSiteFileImpl(fileName, content));
    }

    public InputStream getSiteFileInputStream(String siteFileName) {
        NamedClusterSiteFile n = this.siteFiles.stream().filter(sf -> sf.getSiteFileName().equals(siteFileName)).findFirst().orElse(null);
        return n == null ? null : new ByteArrayInputStream(n.getSiteFileContents().getBytes());
    }
}

