/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.s3.provider;

import com.amazonaws.ClientConfiguration;
import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.AWSCredentialsProvider;
import com.amazonaws.auth.AWSStaticCredentialsProvider;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.auth.profile.ProfileCredentialsProvider;
import com.amazonaws.auth.profile.ProfilesConfigFile;
import com.amazonaws.client.builder.AwsClientBuilder;
import com.amazonaws.regions.Regions;
import com.amazonaws.services.s3.AmazonS3;
import com.amazonaws.services.s3.AmazonS3ClientBuilder;
import com.amazonaws.services.s3.model.AmazonS3Exception;
import com.amazonaws.services.s3.model.Bucket;
import java.io.BufferedReader;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.function.Supplier;
import org.apache.commons.vfs2.FileSystemOptions;
import org.pentaho.amazon.s3.S3Details;
import org.pentaho.amazon.s3.S3Util;
import org.pentaho.di.connections.ConnectionDetails;
import org.pentaho.di.connections.ConnectionManager;
import org.pentaho.di.connections.vfs.BaseVFSConnectionProvider;
import org.pentaho.di.connections.vfs.VFSRoot;
import org.pentaho.di.core.encryption.Encr;
import org.pentaho.di.core.logging.LogChannel;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.s3common.S3CommonFileSystemConfigBuilder;

public class S3Provider
extends BaseVFSConnectionProvider<S3Details> {
    private static final String ACCESS_KEY_SECRET_KEY = "0";
    private static final String CREDENTIALS_FILE = "1";
    public static final String NAME = "Amazon S3";
    private Supplier<ConnectionManager> connectionManagerSupplier = ConnectionManager::getInstance;
    private Supplier<VariableSpace> variableSpace = Variables::getADefaultVariableSpace;
    private LogChannelInterface log = new LogChannel((Object)this);

    public Class<S3Details> getClassType() {
        return S3Details.class;
    }

    public FileSystemOptions getOpts(S3Details s3Details) {
        S3CommonFileSystemConfigBuilder s3CommonFileSystemConfigBuilder = new S3CommonFileSystemConfigBuilder(new FileSystemOptions());
        s3CommonFileSystemConfigBuilder.setName(s3Details.getName());
        s3CommonFileSystemConfigBuilder.setAccessKey(s3Details.getAccessKey());
        s3CommonFileSystemConfigBuilder.setSecretKey(s3Details.getSecretKey());
        s3CommonFileSystemConfigBuilder.setSessionToken(s3Details.getSessionToken());
        s3CommonFileSystemConfigBuilder.setRegion(s3Details.getRegion());
        s3CommonFileSystemConfigBuilder.setCredentialsFile(s3Details.getCredentialsFilePath());
        s3CommonFileSystemConfigBuilder.setProfileName(s3Details.getProfileName());
        s3CommonFileSystemConfigBuilder.setEndpoint(s3Details.getEndpoint());
        s3CommonFileSystemConfigBuilder.setPathStyleAccess(s3Details.getPathStyleAccess());
        s3CommonFileSystemConfigBuilder.setSignatureVersion(s3Details.getSignatureVersion());
        s3CommonFileSystemConfigBuilder.setDefaultS3Config(s3Details.getDefaultS3Config());
        s3CommonFileSystemConfigBuilder.setConnectionType(s3Details.getConnectionType());
        return s3CommonFileSystemConfigBuilder.getFileSystemOptions();
    }

    public List<S3Details> getConnectionDetails() {
        return this.connectionManagerSupplier.get().getConnectionDetailsByScheme(this.getKey());
    }

    public List<VFSRoot> getLocations(S3Details s3Details) {
        ArrayList<VFSRoot> buckets = new ArrayList<VFSRoot>();
        try {
            AmazonS3 s3 = this.getAmazonS3(s3Details);
            if (s3 != null) {
                for (Bucket bucket : s3.listBuckets()) {
                    buckets.add(new VFSRoot(bucket.getName(), bucket.getCreationDate()));
                }
            }
        }
        catch (Exception e) {
            this.log.logError(e.getMessage(), (Throwable)e);
        }
        return buckets;
    }

    public String getName() {
        return NAME;
    }

    public String getKey() {
        return "s3";
    }

    public String getProtocol(S3Details s3Details) {
        return "s3";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean test(S3Details s3Details) {
        s3Details = this.prepare(s3Details);
        AmazonS3 amazonS3 = this.getAmazonS3(s3Details);
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        try {
            Thread.currentThread().setContextClassLoader(((Object)((Object)this)).getClass().getClassLoader());
            Objects.requireNonNull(amazonS3).getS3AccountOwner();
            List connections = this.connectionManagerSupplier.get().getConnectionDetailsByScheme("s3");
            if (s3Details.getDefaultS3Config() != null && s3Details.getDefaultS3Config().equalsIgnoreCase("true")) {
                for (ConnectionDetails details : connections) {
                    if (s3Details.getName().equalsIgnoreCase(details.getName())) continue;
                    S3Details removeDefault = (S3Details)details;
                    removeDefault.setAccessKey(Encr.decryptPasswordOptionallyEncrypted((String)removeDefault.getAccessKey()));
                    removeDefault.setSecretKey(Encr.decryptPasswordOptionallyEncrypted((String)removeDefault.getSecretKey()));
                    removeDefault.setSessionToken(Encr.decryptPasswordOptionallyEncrypted((String)removeDefault.getSessionToken()));
                    removeDefault.setCredentialsFile(Encr.decryptPasswordOptionallyEncrypted((String)removeDefault.getCredentialsFile()));
                    removeDefault.setDefaultS3Config("false");
                    this.connectionManagerSupplier.get().save((ConnectionDetails)removeDefault);
                }
            }
            boolean bl = true;
            return bl;
        }
        catch (AmazonS3Exception e) {
            this.log.logError(e.getMessage());
            boolean bl = false;
            return bl;
        }
        catch (Exception e) {
            this.log.logError(e.getMessage(), (Throwable)e);
            boolean bl = false;
            return bl;
        }
        finally {
            Thread.currentThread().setContextClassLoader(cl);
        }
    }

    public S3Details prepare(S3Details s3Details) {
        String credetialsFilePath;
        if (s3Details.getAuthType().equals(CREDENTIALS_FILE) && (credetialsFilePath = this.getVar(s3Details.getCredentialsFilePath(), this.variableSpace.get())) != null) {
            try (BufferedReader reader = Files.newBufferedReader(Paths.get(credetialsFilePath, new String[0]));){
                String currentLine;
                StringBuilder builder = new StringBuilder();
                while ((currentLine = reader.readLine()) != null) {
                    builder.append(currentLine).append("\n");
                }
                s3Details.setCredentialsFile(builder.toString());
            }
            catch (IOException e) {
                return null;
            }
        }
        return s3Details;
    }

    private AmazonS3 getAmazonS3(S3Details s3Details) {
        Regions regions;
        boolean access;
        AWSStaticCredentialsProvider awsCredentialsProvider = null;
        String accessKey = this.getVar(s3Details.getAccessKey(), this.variableSpace.get());
        String secretKey = this.getVar(s3Details.getSecretKey(), this.variableSpace.get());
        String sessionToken = this.getVar(s3Details.getSessionToken(), this.variableSpace.get());
        String credentialsFilePath = this.getVar(s3Details.getCredentialsFilePath(), this.variableSpace.get());
        String profileName = this.getVar(s3Details.getProfileName(), this.variableSpace.get());
        String endpoint = this.getVar(s3Details.getEndpoint(), this.variableSpace.get());
        String pathStyleAccess = this.getVar(s3Details.getPathStyleAccess(), this.variableSpace.get());
        String signatureVersion = this.getVar(s3Details.getSignatureVersion(), this.variableSpace.get());
        boolean bl = access = pathStyleAccess == null || Boolean.parseBoolean(pathStyleAccess);
        if (s3Details.getAuthType().equals(ACCESS_KEY_SECRET_KEY)) {
            Object awsCredentials = S3Util.isEmpty(s3Details.getSessionToken()) ? new BasicAWSCredentials(accessKey, secretKey) : new BasicSessionCredentials(accessKey, secretKey, sessionToken);
            awsCredentialsProvider = new AWSStaticCredentialsProvider((AWSCredentials)awsCredentials);
        }
        if (s3Details.getAuthType().equals(CREDENTIALS_FILE)) {
            ProfilesConfigFile profilesConfigFile = new ProfilesConfigFile(credentialsFilePath);
            awsCredentialsProvider = new ProfileCredentialsProvider(profilesConfigFile, profileName);
        }
        Regions regions2 = regions = !S3Util.isEmpty(s3Details.getRegion()) ? Regions.fromName((String)s3Details.getRegion()) : Regions.DEFAULT_REGION;
        if (awsCredentialsProvider != null && S3Util.isEmpty(s3Details.getEndpoint())) {
            return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).enableForceGlobalBucketAccess()).withRegion(regions)).build();
        }
        if (awsCredentialsProvider != null && !S3Util.isEmpty(s3Details.getEndpoint())) {
            ClientConfiguration clientConfiguration = new ClientConfiguration();
            clientConfiguration.setSignerOverride(S3Util.isEmpty(signatureVersion) ? "aws.endpoint" : signatureVersion);
            return (AmazonS3)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)((AmazonS3ClientBuilder)AmazonS3ClientBuilder.standard().withEndpointConfiguration(new AwsClientBuilder.EndpointConfiguration(endpoint, regions.getName()))).withPathStyleAccessEnabled(Boolean.valueOf(access))).withClientConfiguration(clientConfiguration)).withCredentials((AWSCredentialsProvider)awsCredentialsProvider)).build();
        }
        return null;
    }

    private String getVar(String value, VariableSpace variableSpace) {
        if (variableSpace != null) {
            return variableSpace.environmentSubstitute(value);
        }
        return value;
    }
}

