/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.s3;

import com.amazonaws.SdkClientException;
import com.amazonaws.auth.AWSCredentials;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.amazon.s3.S3CredentialsProvider;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.Props;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.di.core.util.EnvUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.vfs.ui.CustomVfsUiPanel;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public abstract class S3VfsFileChooserBaseDialog
extends CustomVfsUiPanel {
    protected FileObject rootFile;
    protected FileObject initialFile;
    protected VfsFileChooserDialog vfsFileChooserDialog;

    public S3VfsFileChooserBaseDialog(VfsFileChooserDialog vfsFileChooserDialog, FileObject rootFile, FileObject initialFile, String schema, String fileSystemDisplayText) {
        super(schema, fileSystemDisplayText, vfsFileChooserDialog, 0);
        this.vfsFileChooserDialog = vfsFileChooserDialog;
        this.rootFile = rootFile;
        this.initialFile = initialFile;
        this.setLayout((Layout)new GridLayout());
    }

    public String buildS3FileSystemUrlString() {
        return "s3n://s3n/";
    }

    public void activate() {
        this.vfsFileChooserDialog.setRootFile(this.rootFile);
        this.vfsFileChooserDialog.setInitialFile(this.initialFile);
        this.vfsFileChooserDialog.vfsBrowser.fileSystemTree.removeAll();
        super.activate();
        try {
            String filename = Props.getInstance().getCustomParameter("S3VfsFileChooserDialog.Filename", this.buildS3FileSystemUrlString());
            FileObject newRoot = this.resolveFile(filename);
            this.vfsFileChooserDialog.vfsBrowser.resetVfsRoot(newRoot);
        }
        catch (FileSystemException fileSystemException) {
            // empty catch block
        }
    }

    public FileObject resolveFile(String fileUri) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)this.getFileSystemOptions());
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    public FileObject resolveFile(String fileUri, FileSystemOptions opts) throws FileSystemException {
        try {
            return KettleVFS.getFileObject((String)fileUri, (VariableSpace)this.getVariableSpace(), (FileSystemOptions)opts);
        }
        catch (KettleFileException e) {
            throw new FileSystemException((Throwable)e);
        }
    }

    private FileSystemOptions getFileSystemOptions() throws FileSystemException {
        FileSystemOptions opts = new FileSystemOptions();
        try {
            String accessKey = "";
            String secretKey = "";
            if (!ValueMetaBase.convertStringToBoolean((String)Const.NVL((String)EnvUtil.getSystemProperty((String)"KETTLE_USE_AWS_DEFAULT_CREDENTIALS"), (String)"N")).booleanValue()) {
                accessKey = System.getProperty("aws.accessKeyId");
                secretKey = System.getProperty("aws.secretKey");
            } else {
                AWSCredentials credentials = S3CredentialsProvider.getAWSCredentials();
                if (credentials != null) {
                    accessKey = credentials.getAWSAccessKeyId();
                    secretKey = credentials.getAWSSecretKey();
                }
            }
            StaticUserAuthenticator userAuthenticator = new StaticUserAuthenticator(null, secretKey, accessKey);
            DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)userAuthenticator);
        }
        catch (SdkClientException e) {
            throw new FileSystemException((Throwable)e);
        }
        return opts;
    }

    private VariableSpace getVariableSpace() {
        if (Spoon.getInstance().getActiveTransformation() != null) {
            return Spoon.getInstance().getActiveTransformation();
        }
        if (Spoon.getInstance().getActiveJob() != null) {
            return Spoon.getInstance().getActiveJob();
        }
        return new Variables();
    }
}

