/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.s3;

import com.amazonaws.regions.Regions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.pentaho.di.connections.annotations.Encrypted;
import org.pentaho.di.connections.vfs.VFSConnectionDetails;
import org.pentaho.metastore.persist.MetaStoreAttribute;
import org.pentaho.metastore.persist.MetaStoreElementType;

@MetaStoreElementType(name="Amazon S3 Connection", description="Defines the connection details for an Amazon S3 connection")
public class S3Details
implements VFSConnectionDetails {
    public static final String CONNECTION_TYPE_AWS = "0";
    public static final String CONNECTION_TYPE_MINIO = "1";
    @MetaStoreAttribute
    private String name;
    @MetaStoreAttribute
    private String description;
    @MetaStoreAttribute
    @Encrypted
    private String accessKey;
    @MetaStoreAttribute
    @Encrypted
    private String secretKey;
    @MetaStoreAttribute
    @Encrypted
    private String sessionToken;
    @MetaStoreAttribute
    private String credentialsFilePath;
    @MetaStoreAttribute
    @Encrypted
    private String credentialsFile;
    @MetaStoreAttribute
    private String authType;
    @MetaStoreAttribute
    private String region;
    @MetaStoreAttribute
    private String profileName;
    @MetaStoreAttribute
    private String endpoint;
    @MetaStoreAttribute
    private String pathStyleAccess;
    @MetaStoreAttribute
    private String signatureVersion;
    @MetaStoreAttribute
    private String defaultS3Config;
    @MetaStoreAttribute
    private String connectionType;

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getType() {
        return "s3";
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        this.secretKey = secretKey;
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        this.sessionToken = sessionToken;
    }

    public String getCredentialsFilePath() {
        return this.credentialsFilePath;
    }

    public void setCredentialsFilePath(String credentialsFilePath) {
        this.credentialsFilePath = credentialsFilePath;
    }

    public String getCredentialsFile() {
        return this.credentialsFile;
    }

    public void setCredentialsFile(String credentialsFile) {
        this.credentialsFile = credentialsFile;
    }

    public String getAuthType() {
        return this.authType;
    }

    public void setAuthType(String authType) {
        this.authType = authType;
    }

    public List<String> getRegions() {
        ArrayList<String> names = new ArrayList<String>();
        for (Regions reg : Regions.values()) {
            names.add(reg.getName());
        }
        return names;
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        this.region = region;
    }

    public String getProfileName() {
        return this.profileName;
    }

    public void setProfileName(String profileName) {
        this.profileName = profileName;
    }

    public String getEndpoint() {
        return this.endpoint;
    }

    public void setEndpoint(String endpoint) {
        this.endpoint = endpoint;
    }

    public String getSignatureVersion() {
        return this.signatureVersion;
    }

    public void setSignatureVersion(String signatureVersion) {
        this.signatureVersion = signatureVersion;
    }

    public String getPathStyleAccess() {
        return this.pathStyleAccess;
    }

    public void setPathStyleAccess(String pathStyleAccess) {
        this.pathStyleAccess = pathStyleAccess;
    }

    public String getDefaultS3Config() {
        return this.defaultS3Config;
    }

    public void setDefaultS3Config(String defaultS3Config) {
        this.defaultS3Config = defaultS3Config;
    }

    public String getConnectionType() {
        return this.connectionType;
    }

    public void setConnectionType(String connectionType) {
        this.connectionType = connectionType;
    }

    public Map<String, String> getProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        props.put("name", this.getName());
        props.put("description", this.getDescription());
        props.put("accessKey", this.getAccessKey());
        props.put("secretKey", this.getSecretKey());
        props.put("sessionToken", this.getSessionToken());
        props.put("credentialsFilePath", this.getCredentialsFilePath());
        props.put("credentialsFile", this.getCredentialsFile());
        props.put("authType", this.getAuthType());
        props.put("region", this.getRegion());
        props.put("profileName", this.getProfileName());
        props.put("endpoint", this.getEndpoint());
        props.put("signatureVersion", this.getSignatureVersion());
        props.put("pathStyleAccess", this.getPathStyleAccess());
        props.put("defaultS3Config", this.getDefaultS3Config());
        props.put("connectionType", this.getConnectionType());
        return props;
    }
}

