/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.client;

import java.util.HashMap;
import java.util.Map;
import org.pentaho.amazon.client.AbstractClientFactory;
import org.pentaho.amazon.client.ClientType;
import org.pentaho.amazon.client.impl.AimClientFactory;
import org.pentaho.amazon.client.impl.EmrClientFactory;
import org.pentaho.amazon.client.impl.PricingClientFactory;
import org.pentaho.amazon.client.impl.S3ClientFactory;

public class ClientFactoriesManager {
    private Map<ClientType, AbstractClientFactory> clientFactoryMap = new HashMap<ClientType, AbstractClientFactory>();
    private static ClientFactoriesManager instance;

    private ClientFactoriesManager() {
        this.clientFactoryMap.put(ClientType.S3, new S3ClientFactory());
        this.clientFactoryMap.put(ClientType.EMR, new EmrClientFactory());
        this.clientFactoryMap.put(ClientType.AIM, new AimClientFactory());
        this.clientFactoryMap.put(ClientType.PRICING, new PricingClientFactory());
    }

    public static ClientFactoriesManager getInstance() {
        if (instance == null) {
            instance = new ClientFactoriesManager();
        }
        return instance;
    }

    public <T> T createClient(String accessKey, String secretKey, String sessionToken, String region, ClientType clientType) {
        AbstractClientFactory clientFactory = this.getClientFactory(clientType);
        Object amazonClient = clientFactory.createClient(accessKey, secretKey, sessionToken, region);
        return amazonClient;
    }

    private AbstractClientFactory getClientFactory(ClientType clientType) {
        if (this.clientFactoryMap.containsKey((Object)clientType)) {
            return this.clientFactoryMap.get((Object)clientType);
        }
        return null;
    }
}

