/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon.client;

import com.amazonaws.auth.AWSCredentials;
import com.amazonaws.auth.BasicAWSCredentials;
import com.amazonaws.auth.BasicSessionCredentials;
import com.amazonaws.regions.RegionUtils;
import org.pentaho.amazon.AmazonRegion;
import org.pentaho.di.core.util.StringUtil;

public class AmazonClientCredentials {
    private AWSCredentials credentials;
    private String region;

    public AmazonClientCredentials(String accessKey, String secretKey, String sessionToken, String region) {
        this.credentials = !StringUtil.isEmpty((String)sessionToken) ? new BasicSessionCredentials(accessKey, secretKey, sessionToken) : new BasicAWSCredentials(accessKey, secretKey);
        this.region = this.extractRegion(region);
    }

    public AWSCredentials getAWSCredentials() {
        return this.credentials;
    }

    public String getRegion() {
        return this.region;
    }

    private String extractRegion(String region) {
        return RegionUtils.getRegion((String)AmazonRegion.extractRegionFromDescription(region)).getName();
    }
}

