/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.amazon;

import com.google.common.base.Strings;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.commons.lang.exception.ExceptionUtils;
import org.apache.commons.vfs2.FileObject;
import org.apache.commons.vfs2.FileSystemException;
import org.apache.commons.vfs2.FileSystemOptions;
import org.apache.commons.vfs2.UserAuthenticator;
import org.apache.commons.vfs2.auth.StaticUserAuthenticator;
import org.apache.commons.vfs2.impl.DefaultFileSystemConfigBuilder;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.MessageBox;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.amazon.AbstractAmazonJobEntry;
import org.pentaho.amazon.AmazonEmrReleases;
import org.pentaho.amazon.AmazonRegion;
import org.pentaho.amazon.client.ClientFactoriesManager;
import org.pentaho.amazon.client.ClientType;
import org.pentaho.amazon.client.api.AimClient;
import org.pentaho.amazon.client.api.PricingClient;
import org.pentaho.amazon.s3.S3VfsFileChooserHelper;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.plugins.JobEntryPluginType;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.plugins.PluginRegistry;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.job.entry.JobEntryInterface;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.database.dialog.tags.ExtTextbox;
import org.pentaho.di.ui.core.gui.WindowProperty;
import org.pentaho.di.ui.spoon.Spoon;
import org.pentaho.di.ui.util.HelpUtils;
import org.pentaho.ui.xul.XulDomContainer;
import org.pentaho.ui.xul.XulException;
import org.pentaho.ui.xul.binding.Binding;
import org.pentaho.ui.xul.binding.BindingConvertor;
import org.pentaho.ui.xul.binding.BindingFactory;
import org.pentaho.ui.xul.components.XulButton;
import org.pentaho.ui.xul.components.XulMenuList;
import org.pentaho.ui.xul.components.XulRadio;
import org.pentaho.ui.xul.components.XulRadioGroup;
import org.pentaho.ui.xul.components.XulTextbox;
import org.pentaho.ui.xul.containers.XulDeck;
import org.pentaho.ui.xul.containers.XulDialog;
import org.pentaho.ui.xul.impl.AbstractXulEventHandler;
import org.pentaho.ui.xul.swt.tags.SwtDialog;
import org.pentaho.ui.xul.util.AbstractModelList;
import org.pentaho.vfs.ui.VfsFileChooserDialog;

public abstract class AbstractAmazonJobExecutorController
extends AbstractXulEventHandler {
    private static final Class<?> PKG = AbstractAmazonJobExecutorController.class;
    public static final String JOB_ENTRY_NAME = "jobEntryName";
    public static final String HADOOP_JOB_NAME = "hadoopJobName";
    public static final String HADOOP_JOB_FLOW_ID = "hadoopJobFlowId";
    public static final String JAR_URL = "jarUrl";
    public static final String ACCESS_KEY = "accessKey";
    public static final String SECRET_KEY = "secretKey";
    public static final String SESSION_TOKEN = "sessionToken";
    public static final String STAGING_DIR = "stagingDir";
    public static final String STAGING_DIR_FILE = "stagingDirFile";
    public static final String NUM_INSTANCES = "numInstances";
    public static final String REGION = "region";
    public static final String MASTER_INSTANCE_TYPE = "masterInstanceType";
    public static final String SLAVE_INSTANCE_TYPE = "slaveInstanceType";
    public static final String EC2_ROLE = "ec2Role";
    public static final String EMR_ROLE = "emrRole";
    public static final String CMD_LINE_ARGS = "commandLineArgs";
    public static final String BLOCKING = "blocking";
    public static final String RUN_ON_NEW_CLUSTER = "runOnNewCluster";
    public static final String LOGGING_INTERVAL = "loggingInterval";
    public static final String ALIVE = "alive";
    public static final String XUL_JOBENTRY_NAME = "jobentry-name";
    public static final String XUL_JOBENTRY_HADOOPJOB_NAME = "jobentry-hadoopjob-name";
    public static final String XUL_ACCESS_KEY = "access-key";
    public static final String XUL_SECRET_KEY = "secret-key";
    public static final String XUL_SESSION_TOKEN = "session-token";
    public static final String XUL_EMR_SETTINGS = "emr-settings";
    public static final String XUL_REGION = "region";
    public static final String XUL_EC2_ROLE = "ec2-role";
    public static final String XUL_EMR_ROLE = "emr-role";
    public static final String XUL_MASTER_INSTANCE_TYPE = "master-instance-type";
    public static final String XUL_SLAVE_INSTANCE_TYPE = "slave-instance-type";
    public static final String XUL_EMR_RELEASE = "emr-release";
    public static final String XUL_JOBENTRY_HADOOPJOB_FLOW_ID = "jobentry-hadoopjob-flow-id";
    public static final String XUL_S3_STAGING_DIRECTORY = "s3-staging-directory";
    public static final String XUL_COMMAND_LINE_ARGUMENTS = "command-line-arguments";
    public static final String XUL_NUM_INSTANCES = "num-instances";
    public static final String XUL_BLOCKING = "blocking";
    public static final String XUL_LOGGING_INTERVAL1 = "logging-interval";
    public static final String XUL_ALIVE = "alive";
    public static final String XUL_AMAZON_EMR_JOB_ENTRY_DIALOG = "amazon-emr-job-entry-dialog";
    public static final String XUL_AMAZON_EMR_ERROR_DIALOG = "amazon-emr-error-dialog";
    public static final String XUL_AMAZON_EMR_ERROR_MESSAGE = "amazon-emr-error-message";
    public static final String XUL_CLUSTER_TAB = "cluster-tab";
    public static final String XUL_NEW_CLUSTER_DECK = "new-cluster";
    public static final String XUL_EXISTING_CLUSTER_DECK = "existing-cluster";
    public static final String XUL_CLUSTER_MODE = "cluster-mode";
    private static final String EC2_DEFAULT_ROLE = "EMR_EC2_DefaultRole";
    private static final String EMR_DEFAULT_ROLE = "EMR_DefaultRole";
    private static final String DISABLED_FLAG = "disabled";
    private static final String BOOLEAN_TO_STR_CONVERSION_ERROR = "Boolean to String conversion is not supported";
    protected static final String[] XUL_EMR_MENU_ID_ARRAY = new String[]{"ec2-role", "emr-role", "master-instance-type", "slave-instance-type", "emr-release"};
    protected String jobEntryName;
    protected String hadoopJobName;
    protected String hadoopJobFlowId;
    protected String accessKey = "";
    protected String secretKey = "";
    protected String sessionToken = "";
    protected String stagingDir = "";
    protected FileObject stagingDirFile = null;
    protected String jarUrl = "";
    protected boolean alive = false;
    protected String numInstances = "2";
    protected String masterInstanceType;
    protected String slaveInstanceType;
    protected String region;
    protected String emrRelease;
    protected String ec2Role;
    protected String emrRole;
    protected String commandLineArgs;
    protected boolean blocking;
    protected boolean runOnNewCluster;
    protected String loggingInterval = "60";
    protected VfsFileChooserDialog fileChooserDialog;
    protected S3VfsFileChooserHelper helper;
    protected AbstractAmazonJobEntry jobEntry;
    protected XulDomContainer container;
    protected BindingFactory bindingFactory;
    protected List<Binding> bindings;
    private AbstractModelList<String> masterInstanceTypes;
    private AbstractModelList<String> slaveInstanceTypes;
    private AbstractModelList<String> regions;
    private AbstractModelList<String> ec2Roles;
    private AbstractModelList<String> emrRoles;
    private AbstractModelList<String> releases;
    protected boolean suppressEventHandling = false;

    public AbstractAmazonJobExecutorController(XulDomContainer container, AbstractAmazonJobEntry jobEntry, BindingFactory bindingFactory) {
        this.jobEntry = jobEntry;
        this.container = container;
        this.bindingFactory = bindingFactory;
        this.regions = new AbstractModelList();
        this.ec2Roles = new AbstractModelList();
        this.emrRoles = new AbstractModelList();
        this.masterInstanceTypes = new AbstractModelList();
        this.slaveInstanceTypes = new AbstractModelList();
        this.releases = new AbstractModelList();
        this.bindings = new ArrayList<Binding>();
    }

    public AbstractAmazonJobExecutorController() {
    }

    protected void initializeEmrSettingsGroupMenuFields() {
        this.populateRegions();
        this.populateEc2Roles();
        this.populateEmrRoles();
        this.populateMasterInstanceTypes();
        this.populateSlaveInstanceTypes();
        this.populateReleases();
    }

    protected void initializeTextFields() {
        XulTextbox numInstances = (XulTextbox)this.container.getDocumentRoot().getElementById(XUL_NUM_INSTANCES);
        numInstances.setValue(this.getNumInstances());
        XulTextbox loggingInterval = (XulTextbox)this.container.getDocumentRoot().getElementById(XUL_LOGGING_INTERVAL1);
        loggingInterval.setValue(this.getLoggingInterval());
        ExtTextbox tempBox = (ExtTextbox)this.container.getDocumentRoot().getElementById(XUL_ACCESS_KEY);
        tempBox.setVariableSpace(this.getVariableSpace());
        tempBox = (ExtTextbox)this.container.getDocumentRoot().getElementById(XUL_SECRET_KEY);
        tempBox.setVariableSpace(this.getVariableSpace());
        tempBox = (ExtTextbox)this.container.getDocumentRoot().getElementById(XUL_SESSION_TOKEN);
        tempBox.setVariableSpace(this.getVariableSpace());
        tempBox = (ExtTextbox)this.container.getDocumentRoot().getElementById(XUL_JOBENTRY_HADOOPJOB_NAME);
        tempBox.setVariableSpace(this.getVariableSpace());
        tempBox = (ExtTextbox)this.container.getDocumentRoot().getElementById(XUL_JOBENTRY_HADOOPJOB_FLOW_ID);
        tempBox.setVariableSpace(this.getVariableSpace());
        tempBox = (ExtTextbox)this.container.getDocumentRoot().getElementById(XUL_S3_STAGING_DIRECTORY);
        tempBox.setVariableSpace(this.getVariableSpace());
        tempBox = (ExtTextbox)this.container.getDocumentRoot().getElementById(XUL_COMMAND_LINE_ARGUMENTS);
        tempBox.setVariableSpace(this.getVariableSpace());
        tempBox = (ExtTextbox)this.container.getDocumentRoot().getElementById(XUL_NUM_INSTANCES);
        tempBox.setVariableSpace(this.getVariableSpace());
        tempBox = (ExtTextbox)this.container.getDocumentRoot().getElementById(XUL_LOGGING_INTERVAL1);
        tempBox.setVariableSpace(this.getVariableSpace());
    }

    protected void createBindings() {
        this.bindingFactory.setBindingType(Binding.Type.BI_DIRECTIONAL);
        this.bindings.add(this.bindingFactory.createBinding(this.regions, "children", "region", "elements", new BindingConvertor[0]));
        this.bindingFactory.createBinding("region", "selectedIndex", (Object)this, "selectedRegion", new BindingConvertor[]{new BindingConvertor<Integer, String>(){

            public String sourceToTarget(Integer index) {
                if (index == -1) {
                    return null;
                }
                return (String)AbstractAmazonJobExecutorController.this.regions.get(index.intValue());
            }

            public Integer targetToSource(String str) {
                return AbstractAmazonJobExecutorController.this.regions.indexOf((Object)str);
            }
        }});
        this.bindings.add(this.bindingFactory.createBinding(this.ec2Roles, "children", XUL_EC2_ROLE, "elements", new BindingConvertor[0]));
        this.bindingFactory.createBinding(XUL_EC2_ROLE, "selectedIndex", (Object)this, "selectedEc2Role", new BindingConvertor[]{new BindingConvertor<Integer, String>(){

            public String sourceToTarget(Integer index) {
                if (index == -1) {
                    return null;
                }
                return (String)AbstractAmazonJobExecutorController.this.ec2Roles.get(index.intValue());
            }

            public Integer targetToSource(String role) {
                return AbstractAmazonJobExecutorController.this.ec2Roles.indexOf((Object)role);
            }
        }});
        this.bindings.add(this.bindingFactory.createBinding(this.emrRoles, "children", XUL_EMR_ROLE, "elements", new BindingConvertor[0]));
        this.bindingFactory.createBinding(XUL_EMR_ROLE, "selectedIndex", (Object)this, "selectedEmrRole", new BindingConvertor[]{new BindingConvertor<Integer, String>(){

            public String sourceToTarget(Integer index) {
                if (index == -1) {
                    return null;
                }
                return (String)AbstractAmazonJobExecutorController.this.emrRoles.get(index.intValue());
            }

            public Integer targetToSource(String role) {
                return AbstractAmazonJobExecutorController.this.emrRoles.indexOf((Object)role);
            }
        }});
        this.bindings.add(this.bindingFactory.createBinding(this.masterInstanceTypes, "children", XUL_MASTER_INSTANCE_TYPE, "elements", new BindingConvertor[0]));
        this.bindingFactory.createBinding(XUL_MASTER_INSTANCE_TYPE, "selectedIndex", (Object)this, "selectedMasterInstanceType", new BindingConvertor[]{new BindingConvertor<Integer, String>(){

            public String sourceToTarget(Integer index) {
                if (index == -1) {
                    return null;
                }
                return (String)AbstractAmazonJobExecutorController.this.masterInstanceTypes.get(index.intValue());
            }

            public Integer targetToSource(String str) {
                return AbstractAmazonJobExecutorController.this.masterInstanceTypes.indexOf((Object)str);
            }
        }});
        this.bindings.add(this.bindingFactory.createBinding(this.slaveInstanceTypes, "children", XUL_SLAVE_INSTANCE_TYPE, "elements", new BindingConvertor[0]));
        this.bindingFactory.createBinding(XUL_SLAVE_INSTANCE_TYPE, "selectedIndex", (Object)this, "selectedSlaveInstanceType", new BindingConvertor[]{new BindingConvertor<Integer, String>(){

            public String sourceToTarget(Integer index) {
                if (index == -1) {
                    return null;
                }
                return (String)AbstractAmazonJobExecutorController.this.slaveInstanceTypes.get(index.intValue());
            }

            public Integer targetToSource(String str) {
                return AbstractAmazonJobExecutorController.this.slaveInstanceTypes.indexOf((Object)str);
            }
        }});
        this.bindings.add(this.bindingFactory.createBinding(this.releases, "children", XUL_EMR_RELEASE, "elements", new BindingConvertor[0]));
        this.bindingFactory.createBinding(XUL_EMR_RELEASE, "selectedIndex", (Object)this, "emrRelease", new BindingConvertor[]{new BindingConvertor<Integer, String>(){

            public String sourceToTarget(Integer index) {
                if (index == -1) {
                    return null;
                }
                return (String)AbstractAmazonJobExecutorController.this.releases.get(index.intValue());
            }

            public Integer targetToSource(String str) {
                return AbstractAmazonJobExecutorController.this.releases.indexOf((Object)str);
            }
        }});
        this.bindingFactory.createBinding(XUL_JOBENTRY_NAME, "value", (Object)this, JOB_ENTRY_NAME, new BindingConvertor[0]);
        this.bindingFactory.createBinding(XUL_JOBENTRY_HADOOPJOB_NAME, "value", (Object)this, HADOOP_JOB_NAME, new BindingConvertor[0]);
        this.bindingFactory.createBinding(XUL_JOBENTRY_HADOOPJOB_FLOW_ID, "value", (Object)this, HADOOP_JOB_FLOW_ID, new BindingConvertor[0]);
        this.bindingFactory.createBinding(XUL_ACCESS_KEY, "value", (Object)this, ACCESS_KEY, new BindingConvertor[0]);
        this.bindingFactory.createBinding(XUL_SECRET_KEY, "value", (Object)this, SECRET_KEY, new BindingConvertor[0]);
        this.bindingFactory.createBinding(XUL_SESSION_TOKEN, "value", (Object)this, SESSION_TOKEN, new BindingConvertor[0]);
        this.bindingFactory.createBinding(XUL_S3_STAGING_DIRECTORY, "value", (Object)this, STAGING_DIR, new BindingConvertor[0]);
        this.bindingFactory.createBinding(XUL_COMMAND_LINE_ARGUMENTS, "value", (Object)this, CMD_LINE_ARGS, new BindingConvertor[0]);
        this.bindingFactory.createBinding(XUL_NUM_INSTANCES, "value", (Object)this, NUM_INSTANCES, new BindingConvertor[0]);
        this.bindingFactory.createBinding("alive", "selected", (Object)this, "alive", new BindingConvertor[0]);
        this.bindingFactory.createBinding("blocking", "selected", (Object)this, "blocking", new BindingConvertor[0]);
        this.bindingFactory.createBinding(XUL_LOGGING_INTERVAL1, "value", (Object)this, LOGGING_INTERVAL, new BindingConvertor[0]);
        this.bindingFactory.setBindingType(Binding.Type.ONE_WAY);
        this.bindingFactory.createBinding(XUL_ACCESS_KEY, "value", XUL_EMR_SETTINGS, DISABLED_FLAG, new BindingConvertor[]{AbstractAmazonJobExecutorController.secretKeyIsEmpty(this.container)});
        this.bindingFactory.createBinding(XUL_SECRET_KEY, "value", XUL_EMR_SETTINGS, DISABLED_FLAG, new BindingConvertor[]{AbstractAmazonJobExecutorController.accessKeyIsEmpty(this.container)});
        this.bindingFactory.createBinding(XUL_SESSION_TOKEN, "value", XUL_EMR_SETTINGS, DISABLED_FLAG, new BindingConvertor[]{AbstractAmazonJobExecutorController.sessionTokenIsEmpty(this.container)});
    }

    private static void disableAwsConnection(XulDomContainer container) {
        XulButton connectButton = (XulButton)container.getDocumentRoot().getElementById(XUL_EMR_SETTINGS);
        connectButton.setDisabled(AbstractAmazonJobExecutorController.disableConnectButton(container));
    }

    public void updateClusterState() {
        XulRadioGroup clusterModes = (XulRadioGroup)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_CLUSTER_MODE);
        XulRadio newClusterMode = (XulRadio)clusterModes.getFirstChild();
        XulDeck clusterModeTab = (XulDeck)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_CLUSTER_TAB);
        AbstractAmazonJobExecutorController.disableAwsConnection(this.getXulDomContainer());
        if (newClusterMode.isSelected()) {
            this.runOnNewCluster = true;
            clusterModeTab.setSelectedIndex(0);
        } else {
            this.fixFocusLostOnTab();
            clusterModeTab.setSelectedIndex(1);
            this.runOnNewCluster = false;
        }
    }

    private void fixFocusLostOnTab() {
        XulTextbox jobEntryName = (XulTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_JOBENTRY_NAME);
        jobEntryName.setFocus();
    }

    private static String getTextBoxValueById(XulDomContainer container, String xulTextBoxName) {
        ExtTextbox textbox = (ExtTextbox)container.getDocumentRoot().getElementById(xulTextBoxName);
        return textbox.getValue();
    }

    private static boolean disableConnectButton(XulDomContainer container) {
        String secretKeyValue = AbstractAmazonJobExecutorController.getTextBoxValueById(container, XUL_SECRET_KEY);
        String accessKeyValue = AbstractAmazonJobExecutorController.getTextBoxValueById(container, XUL_ACCESS_KEY);
        XulRadio existingClusterMode = (XulRadio)container.getDocumentRoot().getElementById(XUL_EXISTING_CLUSTER_DECK);
        if (existingClusterMode.isSelected()) {
            return true;
        }
        return Strings.isNullOrEmpty((String)accessKeyValue) || Strings.isNullOrEmpty((String)secretKeyValue);
    }

    private static BindingConvertor<String, Boolean> accessKeyIsEmpty(final XulDomContainer container) {
        return new BindingConvertor<String, Boolean>(){

            public Boolean sourceToTarget(String value) {
                return AbstractAmazonJobExecutorController.disableConnectButton(container);
            }

            public String targetToSource(Boolean value) {
                throw new AbstractMethodError(AbstractAmazonJobExecutorController.BOOLEAN_TO_STR_CONVERSION_ERROR);
            }
        };
    }

    private static BindingConvertor<String, Boolean> secretKeyIsEmpty(final XulDomContainer container) {
        return new BindingConvertor<String, Boolean>(){

            public Boolean sourceToTarget(String value) {
                return AbstractAmazonJobExecutorController.disableConnectButton(container);
            }

            public String targetToSource(Boolean value) {
                throw new AbstractMethodError(AbstractAmazonJobExecutorController.BOOLEAN_TO_STR_CONVERSION_ERROR);
            }
        };
    }

    private static BindingConvertor<String, Boolean> sessionTokenIsEmpty(final XulDomContainer container) {
        return new BindingConvertor<String, Boolean>(){

            public Boolean sourceToTarget(String value) {
                return AbstractAmazonJobExecutorController.disableConnectButton(container);
            }

            public String targetToSource(Boolean value) {
                throw new AbstractMethodError(AbstractAmazonJobExecutorController.BOOLEAN_TO_STR_CONVERSION_ERROR);
            }
        };
    }

    protected AbstractModelList<String> populateEc2Roles() {
        String ec2Role = this.getJobEntry().getEc2Role();
        if (ec2Role != null) {
            this.ec2Roles.add((Object)ec2Role);
        }
        return this.ec2Roles;
    }

    protected AbstractModelList<String> populateEmrRoles() {
        String emrRole = this.getJobEntry().getEmrRole();
        if (emrRole != null) {
            this.emrRoles.add((Object)emrRole);
        }
        return this.emrRoles;
    }

    protected AbstractModelList<String> populateMasterInstanceTypes() {
        String masterInstanceType = this.getJobEntry().getMasterInstanceType();
        if (masterInstanceType != null) {
            this.masterInstanceTypes.add((Object)masterInstanceType);
        }
        return this.masterInstanceTypes;
    }

    protected AbstractModelList<String> populateSlaveInstanceTypes() {
        String slaveInstanceType = this.getJobEntry().getSlaveInstanceType();
        if (slaveInstanceType != null) {
            this.slaveInstanceTypes.add((Object)slaveInstanceType);
        }
        return this.slaveInstanceTypes;
    }

    protected void setRolesFromAmazonAccount(AimClient amiClient) throws Exception {
        this.setEc2RolesFromAmazonAccount(amiClient);
        this.setEmrRolesFromAmazonAccount(amiClient);
    }

    private void setEc2RolesFromAmazonAccount(AimClient amiClient) {
        AbstractModelList<String> ec2List = amiClient.getEc2RolesFromAmazonAccount();
        if (ec2List.isEmpty()) {
            ec2List.add((Object)EC2_DEFAULT_ROLE);
        }
        this.ec2Roles.clear();
        this.ec2Roles.addAll(ec2List);
    }

    private void setEmrRolesFromAmazonAccount(AimClient amiClient) {
        AbstractModelList<String> emrList = amiClient.getEmrRolesFromAmazonAccount();
        if (emrList.isEmpty()) {
            emrList.add((Object)EMR_DEFAULT_ROLE);
        }
        this.emrRoles.clear();
        this.emrRoles.addAll(emrList);
    }

    protected List<String> populateInstanceTypesForSelectedRegion(PricingClient pricingClient) throws Exception {
        List<String> instanceTypes = null;
        try {
            instanceTypes = pricingClient.populateInstanceTypesForSelectedRegion();
        }
        catch (IOException e) {
            e.printStackTrace();
            this.showErrorDialog(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.JobEntry.Instance.error.title", (String[])new String[0]), e.getMessage());
        }
        this.masterInstanceTypes.clear();
        this.slaveInstanceTypes.clear();
        if (instanceTypes != null) {
            this.masterInstanceTypes.addAll(instanceTypes);
            this.slaveInstanceTypes.addAll(instanceTypes);
        }
        return instanceTypes;
    }

    protected AbstractModelList<String> populateRegions() {
        this.regions.clear();
        this.regions = Arrays.stream(AmazonRegion.values()).map(v -> v.getHumanReadableRegion()).collect(Collectors.toCollection(AbstractModelList::new));
        String region = this.getJobEntry().getRegion();
        if (region == null && this.regions.size() > 0) {
            this.getJobEntry().setRegion((String)this.regions.get(0));
        }
        return this.regions;
    }

    protected AbstractModelList<String> populateReleases() {
        this.releases.clear();
        this.releases = Arrays.stream(AmazonEmrReleases.values()).map(v -> v.getEmrRelease()).collect(Collectors.toCollection(AbstractModelList::new));
        String emrRelease = this.getJobEntry().getEmrRelease();
        if (emrRelease != null && !this.releases.contains((Object)emrRelease)) {
            this.releases.add(0, (Object)emrRelease);
        }
        if (emrRelease == null && this.releases.size() > 0) {
            this.getJobEntry().setEmrRelease((String)this.releases.get(0));
        }
        return this.releases;
    }

    public AbstractModelList<String> getReleases() {
        return this.releases;
    }

    private XulMenuList<String> getXulMenu(String elementMenuId) {
        return (XulMenuList)this.getXulDomContainer().getDocumentRoot().getElementById(elementMenuId);
    }

    private void setXulMenuDisabled(String elementMenuId, boolean isDisable) {
        XulMenuList<String> xulMenu = this.getXulMenu(elementMenuId);
        xulMenu.setDisabled(isDisable);
    }

    protected void setXulMenusDisabled(boolean isDisable) {
        Arrays.stream(XUL_EMR_MENU_ID_ARRAY).forEach(e -> this.setXulMenuDisabled((String)e, isDisable));
    }

    protected void setSelectedItemForEachMenu() {
        this.getXulMenu(XUL_EC2_ROLE).setSelectedItem((Object)this.getJobEntry().getEc2Role());
        this.getXulMenu(XUL_EMR_ROLE).setSelectedItem((Object)this.getJobEntry().getEmrRole());
        this.getXulMenu(XUL_MASTER_INSTANCE_TYPE).setSelectedItem((Object)this.getJobEntry().getMasterInstanceType());
        this.getXulMenu(XUL_SLAVE_INSTANCE_TYPE).setSelectedItem((Object)this.getJobEntry().getSlaveInstanceType());
    }

    private List<String> initRolesAndTypes(String accessKey, String secretKey, String sessionToken) throws Exception {
        ClientFactoriesManager manager = ClientFactoriesManager.getInstance();
        AimClient aimClient = (AimClient)manager.createClient(accessKey, secretKey, sessionToken, this.getJobEntry().getRegion(), ClientType.AIM);
        this.setRolesFromAmazonAccount(aimClient);
        PricingClient pricingClient = (PricingClient)manager.createClient(accessKey, secretKey, sessionToken, this.getJobEntry().getRegion(), ClientType.PRICING);
        return this.populateInstanceTypesForSelectedRegion(pricingClient);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void getEmrSettings() {
        ExtTextbox accessKeyBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_ACCESS_KEY);
        ExtTextbox secretKeyBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_SECRET_KEY);
        ExtTextbox sessionTokenBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_SESSION_TOKEN);
        XulButton connectButton = (XulButton)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_EMR_SETTINGS);
        connectButton.setDisabled(true);
        String ec2Role = this.getJobEntry().getEc2Role();
        String emrRole = this.getJobEntry().getEmrRole();
        String masterSelectedInstanceType = this.getJobEntry().getMasterInstanceType();
        String slaveSelectedInstanceType = this.getJobEntry().getSlaveInstanceType();
        try {
            List<String> instanceTypes = this.initRolesAndTypes(accessKeyBox.getValue(), secretKeyBox.getValue(), sessionTokenBox.getValue());
            if (ec2Role != null && this.ec2Roles.contains((Object)ec2Role)) {
                this.ec2Role = ec2Role;
            }
            if (emrRole != null && this.emrRoles.contains((Object)emrRole)) {
                this.emrRole = emrRole;
            }
            if (masterSelectedInstanceType != null && instanceTypes.contains(masterSelectedInstanceType)) {
                this.masterInstanceType = masterSelectedInstanceType;
            }
            if (slaveSelectedInstanceType != null && instanceTypes.contains(slaveSelectedInstanceType)) {
                this.slaveInstanceType = slaveSelectedInstanceType;
            }
            this.setXulMenusDisabled(false);
            ExtTextbox numInstances = (ExtTextbox)this.container.getDocumentRoot().getElementById(XUL_NUM_INSTANCES);
            numInstances.setDisabled(false);
            this.setSelectedItemForEachMenu();
        }
        catch (Exception e) {
            e.printStackTrace();
            String errorMessage = e.getMessage() == null ? ExceptionUtils.getStackTrace((Throwable)e) : e.getMessage();
            this.showErrorDialog(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.JobEntry.Connection.error.title", (String[])new String[0]), errorMessage);
        }
        finally {
            connectButton.setDisabled(false);
        }
    }

    public AbstractModelList<String> getEc2Roles() {
        return this.ec2Roles;
    }

    public AbstractModelList<String> getEmrRoles() {
        return this.emrRoles;
    }

    public AbstractModelList<String> getMasterInstanceTypes() {
        return this.masterInstanceTypes;
    }

    public AbstractModelList<String> getSlaveInstanceTypes() {
        return this.slaveInstanceTypes;
    }

    public AbstractModelList<String> getRegions() {
        return this.regions;
    }

    public void setBindings(List<Binding> bindings) {
        this.bindings = bindings;
    }

    public void accept() {
        this.syncModel();
        String validationErrors = this.buildValidationErrorMessages();
        if (!StringUtil.isEmpty((String)validationErrors)) {
            this.openErrorDialog(BaseMessages.getString(PKG, (String)"Dialog.Error", (String[])new String[0]), validationErrors);
            return;
        }
        this.configureJobEntry();
        this.cancel();
    }

    protected void syncModel() {
        XulMenuList tempMenu = (XulMenuList)this.getXulDomContainer().getDocumentRoot().getElementById("region");
        this.region = tempMenu.getValue();
        tempMenu = (XulMenuList)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_EC2_ROLE);
        this.ec2Role = tempMenu.getValue();
        tempMenu = (XulMenuList)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_EMR_ROLE);
        this.emrRole = tempMenu.getValue();
        tempMenu = (XulMenuList)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_MASTER_INSTANCE_TYPE);
        this.masterInstanceType = tempMenu.getValue();
        tempMenu = (XulMenuList)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_SLAVE_INSTANCE_TYPE);
        this.slaveInstanceType = tempMenu.getValue();
        tempMenu = (XulMenuList)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_EMR_RELEASE);
        this.emrRelease = tempMenu.getValue();
        ExtTextbox tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_JOBENTRY_HADOOPJOB_NAME);
        this.hadoopJobName = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_ACCESS_KEY);
        this.accessKey = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_SECRET_KEY);
        this.secretKey = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_SESSION_TOKEN);
        this.sessionToken = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_JOBENTRY_HADOOPJOB_FLOW_ID);
        this.hadoopJobFlowId = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_S3_STAGING_DIRECTORY);
        this.stagingDir = ((Text)tempBox.getTextControl()).getText();
        try {
            this.stagingDirFile = this.resolveFile(this.stagingDir);
        }
        catch (Exception e) {
            this.stagingDirFile = null;
        }
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_COMMAND_LINE_ARGUMENTS);
        this.commandLineArgs = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_NUM_INSTANCES);
        this.numInstances = ((Text)tempBox.getTextControl()).getText();
        tempBox = (ExtTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_LOGGING_INTERVAL1);
        this.loggingInterval = ((Text)tempBox.getTextControl()).getText();
    }

    public List<String> getValidationWarnings() {
        ArrayList<String> warnings = new ArrayList<String>();
        if (StringUtil.isEmpty((String)this.getJobEntryName())) {
            warnings.add(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.JobEntryName.Error", (String[])new String[0]));
        }
        if (StringUtil.isEmpty((String)this.getAccessKey())) {
            warnings.add(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.AccessKey.Error", (String[])new String[0]));
        }
        if (StringUtil.isEmpty((String)this.getSecretKey())) {
            warnings.add(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.SecretKey.Error", (String[])new String[0]));
        }
        if (StringUtil.isEmpty((String)this.getRegion())) {
            warnings.add(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.Region.Error", (String[])new String[0]));
        }
        warnings.addAll(this.collectClusterWarnings());
        if (StringUtil.isEmpty((String)this.getHadoopJobName())) {
            warnings.add(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.JobFlowName.Error", (String[])new String[0]));
        }
        String s3Protocol = "s3://";
        String sdir = this.getVariableSpace().environmentSubstitute(this.stagingDir);
        if (StringUtil.isEmpty((String)this.getStagingDir())) {
            warnings.add(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.StagingDir.Error", (String[])new String[0]));
        } else if (!sdir.startsWith(s3Protocol)) {
            warnings.add(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.StagingDir.Error", (String[])new String[0]));
        }
        return warnings;
    }

    private List<String> collectClusterWarnings() {
        ArrayList<String> newClusterWarnings = new ArrayList<String>();
        ArrayList<String> existingClusterWarnings = new ArrayList<String>();
        if (StringUtil.isEmpty((String)this.getEc2Role())) {
            newClusterWarnings.add(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.Ec2Role.Error", (String[])new String[0]));
        }
        if (StringUtil.isEmpty((String)this.getEmrRole())) {
            newClusterWarnings.add(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.EmrRole.Error", (String[])new String[0]));
        }
        if (StringUtil.isEmpty((String)this.getMasterInstanceType())) {
            newClusterWarnings.add(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.MasterInstanceType.Error", (String[])new String[0]));
        }
        if (StringUtil.isEmpty((String)this.getSlaveInstanceType())) {
            newClusterWarnings.add(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.SlaveInstanceType.Error", (String[])new String[0]));
        }
        if (StringUtil.isEmpty((String)this.getEmrRelease())) {
            newClusterWarnings.add(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.EmrRelease.Error", (String[])new String[0]));
        }
        if (StringUtil.isEmpty((String)this.getHadoopJobFlowId())) {
            existingClusterWarnings.add(BaseMessages.getString(PKG, (String)"AbstractAmazonJobExecutorController.JobFlowId.Error", (String[])new String[0]));
        }
        if (this.isRunOnNewCluster()) {
            return newClusterWarnings;
        }
        return existingClusterWarnings;
    }

    protected String buildValidationErrorMessages() {
        StringBuilder sb = new StringBuilder();
        List<String> warnings = this.getValidationWarnings();
        if (!warnings.isEmpty()) {
            for (String warning : warnings) {
                sb.append(warning).append("\n");
            }
        }
        return sb.toString();
    }

    protected void configureJobEntry() {
        this.getJobEntry().setName(this.getJobEntryName());
        this.getJobEntry().setHadoopJobName(this.getHadoopJobName());
        this.getJobEntry().setHadoopJobFlowId(this.getHadoopJobFlowId());
        this.getJobEntry().setAccessKey(this.getAccessKey());
        this.getJobEntry().setSecretKey(this.getSecretKey());
        this.getJobEntry().setSessionToken(this.getSessionToken());
        this.getJobEntry().setStagingDir(this.getStagingDir());
        this.getJobEntry().setNumInstances(this.getNumInstances());
        this.getJobEntry().setMasterInstanceType(this.getMasterInstanceType());
        this.getJobEntry().setSlaveInstanceType(this.getSlaveInstanceType());
        this.getJobEntry().setRegion(this.getRegion());
        this.getJobEntry().setEmrRelease(this.getEmrRelease());
        this.getJobEntry().setEc2Role(this.getEc2Role());
        this.getJobEntry().setEmrRole(this.getEmrRole());
        this.getJobEntry().setCmdLineArgs(this.getCommandLineArgs());
        this.getJobEntry().setAlive(this.isAlive());
        this.getJobEntry().setRunOnNewCluster(this.isRunOnNewCluster());
        this.getJobEntry().setBlocking(this.getBlocking());
        this.getJobEntry().setLoggingInterval(this.getLoggingInterval());
        this.getJobEntry().setChanged();
    }

    public String getSelectedEc2Role() {
        return this.ec2Role;
    }

    public String getSelectedEmrRole() {
        return this.emrRole;
    }

    public String getSelectedMasterInstanceType() {
        return this.masterInstanceType;
    }

    public String getSelectedSlaveInstanceType() {
        return this.slaveInstanceType;
    }

    public void setSelectedEc2Role(String selectedEc2Role) {
        if (!this.suppressEventHandling) {
            if (this.ec2Role == null && this.ec2Roles.contains((Object)EC2_DEFAULT_ROLE)) {
                selectedEc2Role = EC2_DEFAULT_ROLE;
            }
            this.suppressEventHandling = true;
            try {
                this.firePropertyChange("selectedEc2Role", this.ec2Role, selectedEc2Role);
                this.ec2Role = selectedEc2Role;
            }
            finally {
                this.suppressEventHandling = false;
            }
        }
    }

    public void setSelectedEmrRole(String selectedEmrRole) {
        if (!this.suppressEventHandling) {
            if (this.emrRole == null && this.emrRoles.contains((Object)EMR_DEFAULT_ROLE)) {
                selectedEmrRole = EMR_DEFAULT_ROLE;
            }
            this.suppressEventHandling = true;
            try {
                this.firePropertyChange("selectedEmrRole", this.emrRole, selectedEmrRole);
                this.emrRole = selectedEmrRole;
            }
            finally {
                this.suppressEventHandling = false;
            }
        }
    }

    public void setSelectedMasterInstanceType(String selectedMasterInstanceType) {
        if (!this.suppressEventHandling) {
            this.suppressEventHandling = true;
            try {
                this.firePropertyChange("selectedMasterInstanceType", this.masterInstanceType, selectedMasterInstanceType);
                this.masterInstanceType = selectedMasterInstanceType;
            }
            finally {
                this.suppressEventHandling = false;
            }
        }
    }

    public void setSelectedSlaveInstanceType(String selectedSlaveInstanceType) {
        if (!this.suppressEventHandling) {
            this.suppressEventHandling = true;
            try {
                this.firePropertyChange("selectedSlaveInstanceType", this.slaveInstanceType, selectedSlaveInstanceType);
                this.slaveInstanceType = selectedSlaveInstanceType;
            }
            finally {
                this.suppressEventHandling = false;
            }
        }
    }

    public String getSelectedRegion() {
        return this.getRegion();
    }

    public void setSelectedRegion(String selectedRegion) {
        if (!this.suppressEventHandling) {
            if (!selectedRegion.equals(this.region)) {
                this.setXulMenusDisabled(true);
                this.ec2Roles.clear();
                this.emrRoles.clear();
                this.masterInstanceTypes.clear();
                this.slaveInstanceTypes.clear();
            }
            this.region = selectedRegion;
            this.getJobEntry().setRegion(this.region);
            this.suppressEventHandling = true;
            try {
                this.firePropertyChange("selectedRegion", null, this.region);
            }
            finally {
                this.suppressEventHandling = false;
            }
        }
    }

    protected void initializeEc2RoleSelection() {
        XulMenuList<String> ec2RoleMenu = this.getXulMenu(XUL_EC2_ROLE);
        String selectedEc2Role = this.getJobEntry().getEc2Role();
        ec2RoleMenu.setSelectedItem((Object)selectedEc2Role);
    }

    protected void initializeEmrRoleSelection() {
        XulMenuList<String> emrRoleMenu = this.getXulMenu(XUL_EMR_ROLE);
        String selectedEmrRole = this.getJobEntry().getEmrRole();
        emrRoleMenu.setSelectedItem((Object)selectedEmrRole);
    }

    protected void initializeMasterInstanceSelection() {
        XulMenuList<String> namedClusterMenu = this.getXulMenu(XUL_MASTER_INSTANCE_TYPE);
        String selectedMasterInstanceType = this.getJobEntry().getMasterInstanceType();
        namedClusterMenu.setSelectedItem((Object)selectedMasterInstanceType);
    }

    protected void initializeSlaveInstanceSelection() {
        XulMenuList<String> namedClusterMenu = this.getXulMenu(XUL_SLAVE_INSTANCE_TYPE);
        String selectedSlaveInstanceType = this.getJobEntry().getSlaveInstanceType();
        namedClusterMenu.setSelectedItem((Object)selectedSlaveInstanceType);
    }

    protected void initializeRegionSelection() {
        XulMenuList<String> namedClusterMenu = this.getXulMenu("region");
        String selectedRegion = this.getJobEntry().getRegion();
        namedClusterMenu.setSelectedItem((Object)selectedRegion);
    }

    protected void initializeReleaseSelection() {
        XulMenuList<String> namedClusterMenu = this.getXulMenu(XUL_EMR_RELEASE);
        String selectedRelease = this.getJobEntry().getEmrRelease();
        namedClusterMenu.setSelectedItem((Object)selectedRelease);
    }

    protected void initializeClusterSelection() {
        XulRadio newCluster = (XulRadio)this.container.getDocumentRoot().getElementById(XUL_NEW_CLUSTER_DECK);
        XulRadio existingCluster = (XulRadio)this.container.getDocumentRoot().getElementById(XUL_EXISTING_CLUSTER_DECK);
        newCluster.setSelected(this.runOnNewCluster);
        existingCluster.setSelected(!this.runOnNewCluster);
        this.updateClusterState();
    }

    protected void beforeInit() {
        this.suppressEventHandling = true;
        if (this.getJobEntry() != null) {
            this.setName(this.getJobEntry().getName());
            this.setJobEntryName(this.getJobEntry().getName());
            this.setHadoopJobName(this.getJobEntry().getHadoopJobName());
            this.setHadoopJobFlowId(this.getJobEntry().getHadoopJobFlowId());
            this.setAccessKey(this.getJobEntry().getAccessKey());
            this.setSecretKey(this.getJobEntry().getSecretKey());
            this.setSessionToken(this.getJobEntry().getSessionToken());
            this.setStagingDir(this.getJobEntry().getStagingDir());
            this.setNumInstances(this.getJobEntry().getNumInstances());
            this.setMasterInstanceType(this.getJobEntry().getMasterInstanceType());
            this.setSlaveInstanceType(this.getJobEntry().getSlaveInstanceType());
            this.setRegion(this.getJobEntry().getRegion());
            this.setEmrRelease(this.getJobEntry().getEmrRelease());
            this.setEc2Role(this.getJobEntry().getEc2Role());
            this.setEmrRole(this.getJobEntry().getEmrRole());
            this.setCommandLineArgs(this.getJobEntry().getCmdLineArgs());
            this.setRunOnNewCluster(this.getJobEntry().isRunOnNewCluster());
            this.setBlocking(this.getJobEntry().getBlocking());
            this.setAlive(this.getJobEntry().getAlive());
            this.setLoggingInterval(this.getJobEntry().getLoggingInterval());
        }
    }

    protected void afterInit() {
        this.suppressEventHandling = false;
        this.initializeRegionSelection();
        this.initializeEc2RoleSelection();
        this.initializeEmrRoleSelection();
        this.initializeMasterInstanceSelection();
        this.initializeSlaveInstanceSelection();
        this.initializeReleaseSelection();
        this.initializeClusterSelection();
    }

    protected abstract String getDialogElementId();

    protected SwtDialog getDialog() {
        return (SwtDialog)this.getXulDomContainer().getDocumentRoot().getElementById(this.getDialogElementId());
    }

    protected Shell getShell() {
        return this.getDialog().getShell();
    }

    public JobEntryInterface open() {
        SwtDialog dialog = this.getDialog();
        dialog.show();
        return this.getJobEntry();
    }

    protected void showErrorDialog(String title, String message) {
        MessageBox mb = new MessageBox(this.getShell(), 33);
        mb.setText(title);
        mb.setMessage(message);
        mb.open();
    }

    public void init() throws XulException, InvocationTargetException {
        this.beforeInit();
        try {
            for (Binding binding : this.bindings) {
                binding.fireSourceChanged();
            }
        }
        finally {
            this.afterInit();
        }
    }

    public void cancel() {
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_AMAZON_EMR_JOB_ENTRY_DIALOG);
        Shell shell = (Shell)xulDialog.getRootObject();
        if (!shell.isDisposed()) {
            WindowProperty winprop = new WindowProperty(shell);
            PropsUI.getInstance().setScreen(winprop);
            ((Composite)xulDialog.getManagedObject()).dispose();
            shell.dispose();
        }
    }

    public void openErrorDialog(String title, String message) {
        XulDialog errorDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_AMAZON_EMR_ERROR_DIALOG);
        errorDialog.setTitle(title);
        XulTextbox errorMessage = (XulTextbox)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_AMAZON_EMR_ERROR_MESSAGE);
        errorMessage.setValue(message);
        errorDialog.show();
    }

    public void closeErrorDialog() {
        XulDialog errorDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_AMAZON_EMR_ERROR_DIALOG);
        errorDialog.hide();
    }

    protected VfsFileChooserDialog getFileChooserDialog() throws KettleFileException {
        if (this.fileChooserDialog == null) {
            VfsFileChooserDialog fileChooserDialog;
            FileObject initialFile = null;
            FileObject defaultInitialFile = KettleVFS.getFileObject((String)"file:///c:/");
            this.fileChooserDialog = fileChooserDialog = Spoon.getInstance().getVfsFileChooserDialog(defaultInitialFile, initialFile);
        }
        return this.fileChooserDialog;
    }

    protected FileSystemOptions getFileSystemOptions() throws FileSystemException {
        FileSystemOptions opts = new FileSystemOptions();
        if (!Const.isEmpty((String)this.getAccessKey()) || !Const.isEmpty((String)this.getSecretKey())) {
            StaticUserAuthenticator userAuthenticator = new StaticUserAuthenticator(null, this.getVariableSpace().environmentSubstitute(this.getAccessKey()), this.getVariableSpace().environmentSubstitute(this.getSecretKey()));
            DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)userAuthenticator);
        }
        return opts;
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, new FileSystemOptions());
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, int fileDialogMode) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, new FileSystemOptions(), fileDialogMode);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, FileSystemOptions opts) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, opts, 1);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, FileSystemOptions opts, int fileDialogMode) throws KettleException, FileSystemException {
        return this.browse(fileFilters, fileFilterNames, fileUri, opts, fileDialogMode, false);
    }

    public FileObject browse(String[] fileFilters, String[] fileFilterNames, String fileUri, FileSystemOptions opts, int fileDialogMode, boolean showFileScheme) throws KettleException, FileSystemException {
        this.getFileChooserHelper().setShowFileScheme(showFileScheme);
        return this.getFileChooserHelper().browse(fileFilters, fileFilterNames, fileUri, opts, fileDialogMode);
    }

    public void browseS3StagingDir() throws KettleException, FileSystemException {
        FileSystemOptions opts;
        String[] fileFilters = new String[]{"*.*"};
        String[] fileFilterNames = new String[]{"All"};
        String stagingDirText = this.getVariableSpace().environmentSubstitute(this.stagingDir);
        FileObject selectedFile = this.browse(fileFilters, fileFilterNames, stagingDirText, opts = this.getFileSystemOptions());
        if (selectedFile != null) {
            this.setStagingDir(selectedFile.getName().getURI());
        }
    }

    public VariableSpace getVariableSpace() {
        if (Spoon.getInstance().getActiveTransformation() != null) {
            return Spoon.getInstance().getActiveTransformation();
        }
        if (Spoon.getInstance().getActiveJob() != null) {
            return Spoon.getInstance().getActiveJob();
        }
        return new Variables();
    }

    public String getName() {
        return "jobEntryController";
    }

    public String getJobEntryName() {
        return this.jobEntryName;
    }

    public void setJobEntryName(String jobEntryName) {
        String previousVal = this.jobEntryName;
        String newVal = jobEntryName;
        this.jobEntryName = jobEntryName;
        this.firePropertyChange(JOB_ENTRY_NAME, previousVal, newVal);
    }

    public String getHadoopJobName() {
        return this.hadoopJobName;
    }

    public void setHadoopJobName(String hadoopJobName) {
        String previousVal = this.hadoopJobName;
        String newVal = hadoopJobName;
        this.hadoopJobName = hadoopJobName;
        this.firePropertyChange(HADOOP_JOB_NAME, previousVal, newVal);
    }

    public String getHadoopJobFlowId() {
        return this.hadoopJobFlowId;
    }

    public void setHadoopJobFlowId(String hadoopJobFlowId) {
        String previousVal = this.hadoopJobFlowId;
        String newVal = hadoopJobFlowId;
        this.hadoopJobFlowId = hadoopJobFlowId;
        this.firePropertyChange(HADOOP_JOB_FLOW_ID, previousVal, newVal);
    }

    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        String previousVal = this.accessKey;
        String newVal = accessKey;
        this.accessKey = accessKey;
        this.firePropertyChange(ACCESS_KEY, previousVal, newVal);
    }

    public String getSecretKey() {
        return this.secretKey;
    }

    public void setSecretKey(String secretKey) {
        String previousVal = this.secretKey;
        String newVal = secretKey;
        this.secretKey = secretKey;
        this.firePropertyChange(SECRET_KEY, previousVal, newVal);
    }

    public String getSessionToken() {
        return this.sessionToken;
    }

    public void setSessionToken(String sessionToken) {
        String previousVal = this.sessionToken;
        String newVal = sessionToken;
        this.sessionToken = sessionToken;
        this.firePropertyChange(SESSION_TOKEN, previousVal, newVal);
    }

    public String getRegion() {
        return this.region;
    }

    public void setRegion(String region) {
        String previousVal = this.region;
        String newVal = region;
        this.region = region;
        this.firePropertyChange("region", previousVal, newVal);
    }

    public String getStagingDir() {
        return this.stagingDir;
    }

    public void setStagingDir(String stagingDir) {
        String previousVal = this.stagingDir;
        String newVal = stagingDir;
        this.stagingDir = stagingDir;
        this.firePropertyChange(STAGING_DIR, previousVal, newVal);
    }

    public FileObject getStagingDirFile() {
        return this.stagingDirFile;
    }

    public void setStagingDirFile(FileObject stagingDirFile) {
        FileObject previousVal = this.stagingDirFile;
        FileObject newVal = stagingDirFile;
        this.stagingDirFile = stagingDirFile;
        this.firePropertyChange(STAGING_DIR_FILE, previousVal, newVal);
    }

    public String getJarUrl() {
        return this.jarUrl;
    }

    public void setJarUrl(String jarUrl) {
        String previousVal = this.jarUrl;
        String newVal = jarUrl;
        this.jarUrl = jarUrl;
        this.firePropertyChange(JAR_URL, previousVal, newVal);
    }

    public String getNumInstances() {
        return this.numInstances;
    }

    public void setNumInstances(String numInstances) {
        String previousVal = this.numInstances;
        String newVal = numInstances;
        this.numInstances = numInstances;
        this.firePropertyChange(NUM_INSTANCES, previousVal, newVal);
    }

    public String getMasterInstanceType() {
        return this.masterInstanceType;
    }

    public void setMasterInstanceType(String masterInstanceType) {
        String previousVal = this.masterInstanceType;
        String newVal = masterInstanceType;
        this.masterInstanceType = masterInstanceType;
        this.firePropertyChange(MASTER_INSTANCE_TYPE, previousVal, newVal);
    }

    public String getSlaveInstanceType() {
        return this.slaveInstanceType;
    }

    public void setSlaveInstanceType(String slaveInstanceType) {
        String previousVal = this.slaveInstanceType;
        String newVal = slaveInstanceType;
        this.slaveInstanceType = slaveInstanceType;
        this.firePropertyChange(SLAVE_INSTANCE_TYPE, previousVal, newVal);
    }

    public String getEc2Role() {
        return this.ec2Role;
    }

    public void setEc2Role(String ec2Role) {
        String previousVal = this.ec2Role;
        String newVal = ec2Role;
        this.ec2Role = ec2Role;
        this.firePropertyChange(EC2_ROLE, previousVal, newVal);
    }

    public String getEmrRole() {
        return this.emrRole;
    }

    public void setEmrRole(String emrRole) {
        String previousVal = this.emrRole;
        String newVal = emrRole;
        this.emrRole = emrRole;
        this.firePropertyChange(EMR_ROLE, previousVal, newVal);
    }

    public void invertBlocking() {
        this.setBlocking(!this.getBlocking());
    }

    public abstract AbstractAmazonJobEntry getJobEntry();

    public abstract void setJobEntry(AbstractAmazonJobEntry var1);

    public String getCommandLineArgs() {
        return this.commandLineArgs;
    }

    public void setCommandLineArgs(String commandLineArgs) {
        String previousVal = this.commandLineArgs;
        String newVal = commandLineArgs;
        this.commandLineArgs = commandLineArgs;
        this.firePropertyChange(CMD_LINE_ARGS, previousVal, newVal);
    }

    public boolean isRunOnNewCluster() {
        return this.runOnNewCluster;
    }

    public void setRunOnNewCluster(boolean selected) {
        boolean previousVal = this.runOnNewCluster;
        boolean newVal = selected;
        this.runOnNewCluster = selected;
        this.firePropertyChange(RUN_ON_NEW_CLUSTER, previousVal, newVal);
    }

    public boolean getBlocking() {
        return this.blocking;
    }

    public void setBlocking(boolean blocking) {
        boolean previousVal = this.blocking;
        boolean newVal = blocking;
        this.blocking = blocking;
        this.firePropertyChange("blocking", previousVal, newVal);
    }

    public String getLoggingInterval() {
        return this.loggingInterval;
    }

    public void setLoggingInterval(String loggingInterval) {
        String previousVal = this.loggingInterval;
        String newVal = loggingInterval;
        this.loggingInterval = loggingInterval;
        this.firePropertyChange(LOGGING_INTERVAL, previousVal, newVal);
    }

    public String getEmrRelease() {
        return this.emrRelease;
    }

    public void setEmrRelease(String emrRelease) {
        if (!this.suppressEventHandling) {
            this.emrRelease = emrRelease;
            this.getJobEntry().setEmrRelease(this.emrRelease);
            this.suppressEventHandling = true;
            try {
                this.firePropertyChange("emrRelease", null, this.emrRelease);
            }
            finally {
                this.suppressEventHandling = false;
            }
        }
    }

    public boolean isAlive() {
        return this.alive;
    }

    public void setAlive(boolean alive) {
        boolean previousVal = this.alive;
        this.alive = alive;
        this.firePropertyChange("alive", previousVal, alive);
    }

    public void invertAlive() {
        this.setAlive(!this.isAlive());
    }

    public FileObject resolveFile(String fileUri) throws FileSystemException, KettleFileException {
        VariableSpace vs = this.getVariableSpace();
        FileSystemOptions opts = new FileSystemOptions();
        DefaultFileSystemConfigBuilder.getInstance().setUserAuthenticator(opts, (UserAuthenticator)new StaticUserAuthenticator(null, this.getAccessKey(), this.getSecretKey()));
        FileObject file = KettleVFS.getFileObject((String)fileUri, (VariableSpace)vs, (FileSystemOptions)opts);
        return file;
    }

    protected S3VfsFileChooserHelper getFileChooserHelper() throws KettleFileException, FileSystemException {
        if (this.helper == null) {
            XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_AMAZON_EMR_JOB_ENTRY_DIALOG);
            Shell shell = (Shell)xulDialog.getRootObject();
            this.helper = new S3VfsFileChooserHelper(shell, this.getFileChooserDialog(), this.getVariableSpace(), this.getFileSystemOptions());
        }
        return this.helper;
    }

    public void help() {
        AbstractAmazonJobEntry jobEntry = this.getJobEntry();
        XulDialog xulDialog = (XulDialog)this.getXulDomContainer().getDocumentRoot().getElementById(XUL_AMAZON_EMR_JOB_ENTRY_DIALOG);
        Shell shell = (Shell)xulDialog.getRootObject();
        PluginInterface plugin = PluginRegistry.getInstance().findPluginWithId(JobEntryPluginType.class, jobEntry.getPluginId());
        HelpUtils.openHelpDialog((Shell)shell, (PluginInterface)plugin);
    }
}

