/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.client;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.hadoop.hbase.HRegionLocation;
import org.apache.hadoop.hbase.client.AsyncRegionLocator;
import org.apache.hadoop.hbase.client.AsyncRegistry;
import org.apache.yetus.audience.InterfaceAudience;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@InterfaceAudience.Private
class AsyncMetaRegionLocator {
    private static final Logger LOG = LoggerFactory.getLogger(AsyncMetaRegionLocator.class);
    private final AsyncRegistry registry;
    private final AtomicReference<HRegionLocation> metaRegionLocation = new AtomicReference();
    private final AtomicReference<CompletableFuture<HRegionLocation>> metaRelocateFuture = new AtomicReference();

    AsyncMetaRegionLocator(AsyncRegistry registry) {
        this.registry = registry;
    }

    CompletableFuture<HRegionLocation> getRegionLocation(boolean reload) {
        CompletableFuture<HRegionLocation> future;
        while (true) {
            HRegionLocation metaRegionLocation;
            if (!reload && (metaRegionLocation = this.metaRegionLocation.get()) != null) {
                return CompletableFuture.completedFuture(metaRegionLocation);
            }
            if (LOG.isTraceEnabled()) {
                LOG.trace("Meta region location cache is null, try fetching from registry.");
            }
            if (this.metaRelocateFuture.compareAndSet(null, new CompletableFuture())) {
                if (LOG.isDebugEnabled()) {
                    LOG.debug("Start fetching meta region location from registry.");
                }
                future = this.metaRelocateFuture.get();
                this.registry.getMetaRegionLocation().whenComplete((locs, error) -> {
                    if (error != null) {
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Failed to fetch meta region location from registry", error);
                        }
                        ((CompletableFuture)this.metaRelocateFuture.getAndSet(null)).completeExceptionally((Throwable)error);
                        return;
                    }
                    HRegionLocation loc = locs.getDefaultRegionLocation();
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("The fetched meta region location is " + loc);
                    }
                    this.metaRegionLocation.set(loc);
                    this.metaRelocateFuture.set(null);
                    future.complete(loc);
                });
                continue;
            }
            future = this.metaRelocateFuture.get();
            if (future != null) break;
        }
        return future;
    }

    void updateCachedLocation(HRegionLocation loc, Throwable exception) {
        AsyncRegionLocator.updateCachedLocation(loc, exception, l -> this.metaRegionLocation.get(), newLoc -> {
            HRegionLocation oldLoc;
            do {
                if ((oldLoc = this.metaRegionLocation.get()) == null || oldLoc.getSeqNum() <= newLoc.getSeqNum() && !oldLoc.getServerName().equals((Object)newLoc.getServerName())) continue;
                return;
            } while (!this.metaRegionLocation.compareAndSet(oldLoc, (HRegionLocation)newLoc));
        }, l -> {
            HRegionLocation oldLoc;
            while (AsyncRegionLocator.canUpdate(l, oldLoc = this.metaRegionLocation.get()) && !this.metaRegionLocation.compareAndSet(oldLoc, null)) {
            }
        });
    }

    void clearCache() {
        this.metaRegionLocation.set(null);
    }
}

