/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.zookeeper;

import java.util.List;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.zookeeper.ZKUtil;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperListener;
import org.apache.hadoop.hbase.zookeeper.ZooKeeperWatcher;
import org.apache.zookeeper.KeeperException;

@InterfaceAudience.Private
public class MasterMaintenanceModeTracker
extends ZooKeeperListener {
    private boolean hasChildren = false;

    public MasterMaintenanceModeTracker(ZooKeeperWatcher watcher) {
        super(watcher);
    }

    public boolean isInMaintenanceMode() {
        return this.hasChildren;
    }

    private void update(String path) {
        if (path.startsWith(ZooKeeperWatcher.masterMaintZNode)) {
            this.update();
        }
    }

    private void update() {
        try {
            List children = ZKUtil.listChildrenAndWatchForNewChildren((ZooKeeperWatcher)this.watcher, (String)ZooKeeperWatcher.masterMaintZNode);
            this.hasChildren = children != null && children.size() > 0;
        }
        catch (KeeperException e) {
            this.hasChildren = false;
        }
    }

    public void start() {
        this.watcher.registerListener((ZooKeeperListener)this);
        this.update();
    }

    public void nodeCreated(String path) {
        this.update(path);
    }

    public void nodeDeleted(String path) {
        this.update(path);
    }

    public void nodeChildrenChanged(String path) {
        this.update(path);
    }
}

