/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.protobuf.Message;
import com.google.protobuf.Service;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.NavigableSet;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.regex.Matcher;
import org.apache.commons.collections.map.ReferenceMap;
import org.apache.commons.lang.ClassUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.hbase.Cell;
import org.apache.hadoop.hbase.Coprocessor;
import org.apache.hadoop.hbase.CoprocessorEnvironment;
import org.apache.hadoop.hbase.HBaseConfiguration;
import org.apache.hadoop.hbase.HConstants;
import org.apache.hadoop.hbase.HRegionInfo;
import org.apache.hadoop.hbase.HTableDescriptor;
import org.apache.hadoop.hbase.classification.InterfaceAudience;
import org.apache.hadoop.hbase.classification.InterfaceStability;
import org.apache.hadoop.hbase.client.Append;
import org.apache.hadoop.hbase.client.Delete;
import org.apache.hadoop.hbase.client.Durability;
import org.apache.hadoop.hbase.client.Get;
import org.apache.hadoop.hbase.client.Increment;
import org.apache.hadoop.hbase.client.Mutation;
import org.apache.hadoop.hbase.client.Put;
import org.apache.hadoop.hbase.client.Result;
import org.apache.hadoop.hbase.client.Scan;
import org.apache.hadoop.hbase.coprocessor.BaseRegionObserver;
import org.apache.hadoop.hbase.coprocessor.CoprocessorHost;
import org.apache.hadoop.hbase.coprocessor.CoprocessorService;
import org.apache.hadoop.hbase.coprocessor.EndpointObserver;
import org.apache.hadoop.hbase.coprocessor.MetricsCoprocessor;
import org.apache.hadoop.hbase.coprocessor.ObserverContext;
import org.apache.hadoop.hbase.coprocessor.RegionCoprocessorEnvironment;
import org.apache.hadoop.hbase.coprocessor.RegionObserver;
import org.apache.hadoop.hbase.filter.ByteArrayComparable;
import org.apache.hadoop.hbase.filter.CompareFilter;
import org.apache.hadoop.hbase.io.FSDataInputStreamWrapper;
import org.apache.hadoop.hbase.io.ImmutableBytesWritable;
import org.apache.hadoop.hbase.io.Reference;
import org.apache.hadoop.hbase.io.hfile.CacheConfig;
import org.apache.hadoop.hbase.metrics.MetricRegistry;
import org.apache.hadoop.hbase.regionserver.DeleteTracker;
import org.apache.hadoop.hbase.regionserver.InternalScanner;
import org.apache.hadoop.hbase.regionserver.KeyValueScanner;
import org.apache.hadoop.hbase.regionserver.MiniBatchOperationInProgress;
import org.apache.hadoop.hbase.regionserver.Region;
import org.apache.hadoop.hbase.regionserver.RegionScanner;
import org.apache.hadoop.hbase.regionserver.RegionServerServices;
import org.apache.hadoop.hbase.regionserver.ScanType;
import org.apache.hadoop.hbase.regionserver.Store;
import org.apache.hadoop.hbase.regionserver.StoreFile;
import org.apache.hadoop.hbase.regionserver.StoreFileScanner;
import org.apache.hadoop.hbase.regionserver.compactions.CompactionRequest;
import org.apache.hadoop.hbase.regionserver.wal.HLogKey;
import org.apache.hadoop.hbase.regionserver.wal.WALEdit;
import org.apache.hadoop.hbase.util.Bytes;
import org.apache.hadoop.hbase.util.CoprocessorClassLoader;
import org.apache.hadoop.hbase.util.Pair;
import org.apache.hadoop.hbase.wal.WALKey;

@InterfaceAudience.LimitedPrivate(value={"Coprocesssor"})
@InterfaceStability.Evolving
public class RegionCoprocessorHost
extends CoprocessorHost<RegionEnvironment> {
    private static final Log LOG = LogFactory.getLog(RegionCoprocessorHost.class);
    private static ReferenceMap sharedDataMap = new ReferenceMap(0, 2);
    private final boolean hasCustomPostScannerFilterRow;
    RegionServerServices rsServices;
    Region region;

    public RegionCoprocessorHost(Region region, RegionServerServices rsServices, Configuration conf) {
        super(rsServices);
        this.conf = conf;
        this.rsServices = rsServices;
        this.region = region;
        this.pathPrefix = Integer.toString(this.region.getRegionInfo().hashCode());
        this.loadSystemCoprocessors(conf, "hbase.coprocessor.region.classes");
        if (!region.getRegionInfo().getTable().isSystemTable()) {
            this.loadSystemCoprocessors(conf, "hbase.coprocessor.user.region.classes");
        }
        this.loadTableCoprocessors(conf);
        boolean hasCustomPostScannerFilterRow = false;
        block2: for (RegionEnvironment env : this.coprocessors) {
            if (!(env.getInstance() instanceof RegionObserver)) continue;
            Class<?> clazz = env.getInstance().getClass();
            while (true) {
                if (clazz == null) {
                    hasCustomPostScannerFilterRow = true;
                    break block2;
                }
                if (clazz == BaseRegionObserver.class) continue block2;
                try {
                    clazz.getDeclaredMethod("postScannerFilterRow", ObserverContext.class, InternalScanner.class, byte[].class, Integer.TYPE, Short.TYPE, Boolean.TYPE);
                    hasCustomPostScannerFilterRow = true;
                    break block2;
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    clazz = clazz.getSuperclass();
                    continue;
                }
                break;
            }
        }
        this.hasCustomPostScannerFilterRow = hasCustomPostScannerFilterRow;
    }

    static List<TableCoprocessorAttribute> getTableCoprocessorAttrsFromSchema(Configuration conf, HTableDescriptor htd) {
        ArrayList result = Lists.newArrayList();
        for (Map.Entry e : htd.getValues().entrySet()) {
            String key = Bytes.toString((byte[])((ImmutableBytesWritable)e.getKey()).get()).trim();
            if (!HConstants.CP_HTD_ATTR_KEY_PATTERN.matcher(key).matches()) continue;
            String spec = Bytes.toString((byte[])((ImmutableBytesWritable)e.getValue()).get()).trim();
            try {
                Matcher matcher = HConstants.CP_HTD_ATTR_VALUE_PATTERN.matcher(spec);
                if (matcher.matches()) {
                    Configuration ourConf;
                    Path path = matcher.group(1).trim().isEmpty() ? null : new Path(matcher.group(1).trim());
                    String className = matcher.group(2).trim();
                    if (className.isEmpty()) {
                        LOG.error((Object)("Malformed table coprocessor specification: key=" + key + ", spec: " + spec));
                        continue;
                    }
                    int priority = matcher.group(3).trim().isEmpty() ? 0x3FFFFFFF : Integer.parseInt(matcher.group(3));
                    String cfgSpec = null;
                    try {
                        cfgSpec = matcher.group(4);
                    }
                    catch (IndexOutOfBoundsException indexOutOfBoundsException) {
                        // empty catch block
                    }
                    if (cfgSpec != null && !cfgSpec.trim().equals("|")) {
                        cfgSpec = cfgSpec.substring(cfgSpec.indexOf(124) + 1);
                        ourConf = new Configuration(false);
                        HBaseConfiguration.merge((Configuration)ourConf, (Configuration)conf);
                        Matcher m = HConstants.CP_HTD_ATTR_VALUE_PARAM_PATTERN.matcher(cfgSpec);
                        while (m.find()) {
                            ourConf.set(m.group(1), m.group(2));
                        }
                    } else {
                        ourConf = conf;
                    }
                    result.add(new TableCoprocessorAttribute(path, className, priority, ourConf));
                    continue;
                }
                LOG.error((Object)("Malformed table coprocessor specification: key=" + key + ", spec: " + spec));
            }
            catch (Exception ioe) {
                LOG.error((Object)("Malformed table coprocessor specification: key=" + key + ", spec: " + spec));
            }
        }
        return result;
    }

    public static void testTableCoprocessorAttrs(Configuration conf, HTableDescriptor htd) throws IOException {
        String pathPrefix = UUID.randomUUID().toString();
        for (TableCoprocessorAttribute attr : RegionCoprocessorHost.getTableCoprocessorAttrsFromSchema(conf, htd)) {
            if (attr.getPriority() < 0) {
                throw new IOException("Priority for coprocessor " + attr.getClassName() + " cannot be less than 0");
            }
            ClassLoader old = Thread.currentThread().getContextClassLoader();
            try {
                ClassLoader cl = attr.getPath() != null ? CoprocessorClassLoader.getClassLoader((Path)attr.getPath(), (ClassLoader)CoprocessorHost.class.getClassLoader(), (String)pathPrefix, (Configuration)conf) : CoprocessorHost.class.getClassLoader();
                Thread.currentThread().setContextClassLoader(cl);
                cl.loadClass(attr.getClassName());
            }
            catch (ClassNotFoundException e) {
                throw new IOException("Class " + attr.getClassName() + " cannot be loaded", e);
            }
            finally {
                Thread.currentThread().setContextClassLoader(old);
            }
        }
    }

    void loadTableCoprocessors(Configuration conf) {
        boolean coprocessorsEnabled = conf.getBoolean("hbase.coprocessor.enabled", true);
        boolean tableCoprocessorsEnabled = conf.getBoolean("hbase.coprocessor.user.enabled", true);
        if (!coprocessorsEnabled || !tableCoprocessorsEnabled) {
            return;
        }
        ArrayList<RegionEnvironment> configured = new ArrayList<RegionEnvironment>();
        for (TableCoprocessorAttribute attr : RegionCoprocessorHost.getTableCoprocessorAttrsFromSchema(conf, this.region.getTableDesc())) {
            try {
                RegionEnvironment env = (RegionEnvironment)this.load(attr.getPath(), attr.getClassName(), attr.getPriority(), attr.getConf());
                configured.add(env);
                LOG.info((Object)("Loaded coprocessor " + attr.getClassName() + " from HTD of " + this.region.getTableDesc().getTableName().getNameAsString() + " successfully."));
            }
            catch (Throwable t) {
                if (conf.getBoolean("hbase.coprocessor.abortonerror", true)) {
                    this.abortServer(attr.getClassName(), t);
                    continue;
                }
                LOG.error((Object)("Failed to load coprocessor " + attr.getClassName()), t);
            }
        }
        this.coprocessors.addAll(configured);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public RegionEnvironment createEnvironment(Class<?> implClass, Coprocessor instance, int priority, int seq, Configuration conf) {
        ConcurrentHashMap<String, Object> classData;
        for (Object itf : ClassUtils.getAllInterfaces(implClass)) {
            Class c = (Class)itf;
            if (!CoprocessorService.class.isAssignableFrom(c)) continue;
            this.region.registerService(((CoprocessorService)instance).getService());
        }
        ReferenceMap referenceMap = sharedDataMap;
        synchronized (referenceMap) {
            classData = (ConcurrentHashMap<String, Object>)sharedDataMap.get((Object)implClass.getName());
            if (classData == null) {
                classData = new ConcurrentHashMap<String, Object>();
                sharedDataMap.put((Object)implClass.getName(), classData);
            }
        }
        return new RegionEnvironment(instance, priority, seq, conf, this.region, this.rsServices, classData);
    }

    private void handleCoprocessorThrowableNoRethrow(CoprocessorEnvironment env, Throwable e) {
        try {
            this.handleCoprocessorThrowable(env, e);
        }
        catch (IOException ioe) {
            LOG.warn((Object)("handleCoprocessorThrowable() threw an IOException while attempting to handle Throwable " + e + ". Ignoring."), e);
        }
    }

    public void preOpen() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preOpen(ctx);
            }
        });
    }

    public void postOpen() {
        try {
            this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

                @Override
                public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                    oserver.postOpen(ctx);
                }
            });
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
    }

    public void postLogReplay() {
        try {
            this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

                @Override
                public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                    oserver.postLogReplay(ctx);
                }
            });
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
    }

    public void preClose(final boolean abortRequested) throws IOException {
        this.execOperation(false, new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preClose(ctx, abortRequested);
            }
        });
    }

    public void postClose(final boolean abortRequested) {
        try {
            this.execOperation(false, new RegionOperation(){

                @Override
                public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                    oserver.postClose(ctx, abortRequested);
                }

                @Override
                public void postEnvCall(RegionEnvironment env) {
                    RegionCoprocessorHost.this.shutdown(env);
                }
            });
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
    }

    public InternalScanner preCompactScannerOpen(final Store store, final List<StoreFileScanner> scanners, final ScanType scanType, final long earliestPutTs, final CompactionRequest request, final long readPoint) throws IOException {
        return this.execOperationWithResult(null, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<InternalScanner>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preCompactScannerOpen(ctx, store, scanners, scanType, earliestPutTs, (InternalScanner)this.getResult(), request, readPoint));
            }
        });
    }

    public boolean preCompactSelection(final Store store, final List<StoreFile> candidates, final CompactionRequest request) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preCompactSelection(ctx, store, candidates, request);
            }
        });
    }

    public void postCompactSelection(final Store store, final ImmutableList<StoreFile> selected, final CompactionRequest request) {
        try {
            this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

                @Override
                public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                    oserver.postCompactSelection(ctx, store, (ImmutableList<StoreFile>)selected, request);
                }
            });
        }
        catch (IOException e) {
            LOG.warn((Object)e);
        }
    }

    public InternalScanner preCompact(final Store store, InternalScanner scanner, final ScanType scanType, final CompactionRequest request) throws IOException {
        return this.execOperationWithResult(false, scanner, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<InternalScanner>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preCompact(ctx, store, (InternalScanner)this.getResult(), scanType, request));
            }
        });
    }

    public void postCompact(final Store store, final StoreFile resultFile, final CompactionRequest request) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCompact(ctx, store, resultFile, request);
            }
        });
    }

    public InternalScanner preFlush(final Store store, InternalScanner scanner) throws IOException {
        return this.execOperationWithResult(false, scanner, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<InternalScanner>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preFlush(ctx, store, (InternalScanner)this.getResult()));
            }
        });
    }

    public void preFlush() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preFlush(ctx);
            }
        });
    }

    public InternalScanner preFlushScannerOpen(final Store store, final KeyValueScanner memstoreScanner, final long readPoint) throws IOException {
        return this.execOperationWithResult(null, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<InternalScanner>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preFlushScannerOpen(ctx, store, memstoreScanner, (InternalScanner)this.getResult(), readPoint));
            }
        });
    }

    public void postFlush() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postFlush(ctx);
            }
        });
    }

    public void postFlush(final Store store, final StoreFile storeFile) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postFlush(ctx, store, storeFile);
            }
        });
    }

    public void preSplit() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSplit(ctx);
            }
        });
    }

    public void preSplit(final byte[] splitRow) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSplit(ctx, splitRow);
            }
        });
    }

    public void postSplit(final Region l, final Region r) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postSplit(ctx, l, r);
            }
        });
    }

    public boolean preSplitBeforePONR(final byte[] splitKey, final List<Mutation> metaEntries) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSplitBeforePONR(ctx, splitKey, metaEntries);
            }
        });
    }

    public void preSplitAfterPONR() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preSplitAfterPONR(ctx);
            }
        });
    }

    public void preRollBackSplit() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preRollBackSplit(ctx);
            }
        });
    }

    public void postRollBackSplit() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postRollBackSplit(ctx);
            }
        });
    }

    public void postCompleteSplit() throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCompleteSplit(ctx);
            }
        });
    }

    public boolean preGetClosestRowBefore(final byte[] row, final byte[] family, final Result result) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preGetClosestRowBefore(ctx, row, family, result);
            }
        });
    }

    public void postGetClosestRowBefore(final byte[] row, final byte[] family, final Result result) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postGetClosestRowBefore(ctx, row, family, result);
            }
        });
    }

    public boolean preGet(final Get get, final List<Cell> results) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preGetOp(ctx, get, results);
            }
        });
    }

    public void postGet(final Get get, final List<Cell> results) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postGetOp(ctx, get, results);
            }
        });
    }

    public Boolean preExists(final Get get) throws IOException {
        return this.execOperationWithResult(true, false, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Boolean>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preExists(ctx, get, (Boolean)this.getResult()));
            }
        });
    }

    public boolean postExists(final Get get, boolean exists) throws IOException {
        return this.execOperationWithResult(Boolean.valueOf(exists), this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Boolean>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.postExists(ctx, get, (Boolean)this.getResult()));
            }
        });
    }

    public boolean prePut(final Put put, final WALEdit edit, final Durability durability) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.prePut(ctx, put, edit, durability);
            }
        });
    }

    public boolean prePrepareTimeStampForDeleteVersion(final Mutation mutation, final Cell kv, final byte[] byteNow, final Get get) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.prePrepareTimeStampForDeleteVersion(ctx, mutation, kv, byteNow, get);
            }
        });
    }

    public void postPut(final Put put, final WALEdit edit, final Durability durability) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postPut(ctx, put, edit, durability);
            }
        });
    }

    public boolean preDelete(final Delete delete, final WALEdit edit, final Durability durability) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preDelete(ctx, delete, edit, durability);
            }
        });
    }

    public void postDelete(final Delete delete, final WALEdit edit, final Durability durability) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postDelete(ctx, delete, edit, durability);
            }
        });
    }

    public boolean preBatchMutate(final MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preBatchMutate(ctx, miniBatchOp);
            }
        });
    }

    public void postBatchMutate(final MiniBatchOperationInProgress<Mutation> miniBatchOp) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postBatchMutate(ctx, miniBatchOp);
            }
        });
    }

    public void postBatchMutateIndispensably(final MiniBatchOperationInProgress<Mutation> miniBatchOp, final boolean success) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postBatchMutateIndispensably(ctx, miniBatchOp, success);
            }
        });
    }

    public Boolean preCheckAndPut(final byte[] row, final byte[] family, final byte[] qualifier, final CompareFilter.CompareOp compareOp, final ByteArrayComparable comparator, final Put put) throws IOException {
        return this.execOperationWithResult(true, false, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Boolean>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preCheckAndPut(ctx, row, family, qualifier, compareOp, comparator, put, (Boolean)this.getResult()));
            }
        });
    }

    public Boolean preCheckAndPutAfterRowLock(final byte[] row, final byte[] family, final byte[] qualifier, final CompareFilter.CompareOp compareOp, final ByteArrayComparable comparator, final Put put) throws IOException {
        return this.execOperationWithResult(true, false, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Boolean>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preCheckAndPutAfterRowLock(ctx, row, family, qualifier, compareOp, comparator, put, (Boolean)this.getResult()));
            }
        });
    }

    public boolean postCheckAndPut(final byte[] row, final byte[] family, final byte[] qualifier, final CompareFilter.CompareOp compareOp, final ByteArrayComparable comparator, final Put put, boolean result) throws IOException {
        return this.execOperationWithResult(Boolean.valueOf(result), this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Boolean>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.postCheckAndPut(ctx, row, family, qualifier, compareOp, comparator, put, (Boolean)this.getResult()));
            }
        });
    }

    public Boolean preCheckAndDelete(final byte[] row, final byte[] family, final byte[] qualifier, final CompareFilter.CompareOp compareOp, final ByteArrayComparable comparator, final Delete delete) throws IOException {
        return this.execOperationWithResult(true, false, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Boolean>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preCheckAndDelete(ctx, row, family, qualifier, compareOp, comparator, delete, (Boolean)this.getResult()));
            }
        });
    }

    public Boolean preCheckAndDeleteAfterRowLock(final byte[] row, final byte[] family, final byte[] qualifier, final CompareFilter.CompareOp compareOp, final ByteArrayComparable comparator, final Delete delete) throws IOException {
        return this.execOperationWithResult(true, false, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Boolean>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preCheckAndDeleteAfterRowLock(ctx, row, family, qualifier, compareOp, comparator, delete, (Boolean)this.getResult()));
            }
        });
    }

    public boolean postCheckAndDelete(final byte[] row, final byte[] family, final byte[] qualifier, final CompareFilter.CompareOp compareOp, final ByteArrayComparable comparator, final Delete delete, boolean result) throws IOException {
        return this.execOperationWithResult(Boolean.valueOf(result), this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Boolean>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.postCheckAndDelete(ctx, row, family, qualifier, compareOp, comparator, delete, (Boolean)this.getResult()));
            }
        });
    }

    public Result preAppend(final Append append) throws IOException {
        return this.execOperationWithResult(true, null, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Result>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preAppend(ctx, append));
            }
        });
    }

    public Result preAppendAfterRowLock(final Append append) throws IOException {
        return this.execOperationWithResult(true, null, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Result>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preAppendAfterRowLock(ctx, append));
            }
        });
    }

    public Result preIncrement(final Increment increment) throws IOException {
        return this.execOperationWithResult(true, null, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Result>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preIncrement(ctx, increment));
            }
        });
    }

    public Result preIncrementAfterRowLock(final Increment increment) throws IOException {
        return this.execOperationWithResult(true, null, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Result>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preIncrementAfterRowLock(ctx, increment));
            }
        });
    }

    public Result postAppend(final Append append, final Result result) throws IOException {
        return this.execOperationWithResult(result, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Result>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.postAppend(ctx, append, result));
            }
        });
    }

    public Result postIncrement(final Increment increment, Result result) throws IOException {
        return this.execOperationWithResult(result, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Result>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.postIncrement(ctx, increment, (Result)this.getResult()));
            }
        });
    }

    public RegionScanner preScannerOpen(final Scan scan) throws IOException {
        return this.execOperationWithResult(true, null, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<RegionScanner>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preScannerOpen(ctx, scan, (RegionScanner)this.getResult()));
            }
        });
    }

    public KeyValueScanner preStoreScannerOpen(final Store store, final Scan scan, final NavigableSet<byte[]> targetCols) throws IOException {
        return this.execOperationWithResult(null, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<KeyValueScanner>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preStoreScannerOpen(ctx, store, scan, targetCols, (KeyValueScanner)this.getResult()));
            }
        });
    }

    public RegionScanner postScannerOpen(final Scan scan, RegionScanner s) throws IOException {
        return this.execOperationWithResult(s, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<RegionScanner>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.postScannerOpen(ctx, scan, (RegionScanner)this.getResult()));
            }
        });
    }

    public Boolean preScannerNext(final InternalScanner s, final List<Result> results, final int limit) throws IOException {
        return this.execOperationWithResult(true, false, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Boolean>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preScannerNext(ctx, s, results, limit, (Boolean)this.getResult()));
            }
        });
    }

    public boolean postScannerNext(final InternalScanner s, final List<Result> results, final int limit, boolean hasMore) throws IOException {
        return this.execOperationWithResult(Boolean.valueOf(hasMore), this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Boolean>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.postScannerNext(ctx, s, results, limit, (Boolean)this.getResult()));
            }
        });
    }

    public boolean postScannerFilterRow(final InternalScanner s, final byte[] currentRow, final int offset, final short length) throws IOException {
        if (!this.hasCustomPostScannerFilterRow) {
            return true;
        }
        return this.execOperationWithResult(Boolean.valueOf(true), this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Boolean>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.postScannerFilterRow(ctx, s, currentRow, offset, length, (Boolean)this.getResult()));
            }
        });
    }

    public boolean preScannerClose(final InternalScanner s) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preScannerClose(ctx, s);
            }
        });
    }

    public void postScannerClose(final InternalScanner s) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postScannerClose(ctx, s);
            }
        });
    }

    public boolean preWALRestore(final HRegionInfo info, final WALKey logKey, final WALEdit logEdit) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                RegionEnvironment env = (RegionEnvironment)ctx.getEnvironment();
                if (env.useLegacyPre) {
                    if (logKey instanceof HLogKey) {
                        oserver.preWALRestore(ctx, info, (HLogKey)logKey, logEdit);
                    } else {
                        RegionCoprocessorHost.this.legacyWarning(oserver.getClass(), "There are wal keys present that are not HLogKey.");
                    }
                } else {
                    oserver.preWALRestore(ctx, info, logKey, logEdit);
                }
            }
        });
    }

    @Deprecated
    public boolean preWALRestore(HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        return this.preWALRestore(info, (WALKey)logKey, logEdit);
    }

    public void postWALRestore(final HRegionInfo info, final WALKey logKey, final WALEdit logEdit) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                RegionEnvironment env = (RegionEnvironment)ctx.getEnvironment();
                if (env.useLegacyPost) {
                    if (logKey instanceof HLogKey) {
                        oserver.postWALRestore(ctx, info, (HLogKey)logKey, logEdit);
                    } else {
                        RegionCoprocessorHost.this.legacyWarning(oserver.getClass(), "There are wal keys present that are not HLogKey.");
                    }
                } else {
                    oserver.postWALRestore(ctx, info, logKey, logEdit);
                }
            }
        });
    }

    @Deprecated
    public void postWALRestore(HRegionInfo info, HLogKey logKey, WALEdit logEdit) throws IOException {
        this.postWALRestore(info, (WALKey)logKey, logEdit);
    }

    public boolean preCommitStoreFile(final byte[] family, final List<Pair<Path, Path>> pairs) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preCommitStoreFile(ctx, family, pairs);
            }
        });
    }

    public void postCommitStoreFile(final byte[] family, final Path srcPath, final Path dstPath) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCommitStoreFile(ctx, family, srcPath, dstPath);
            }
        });
    }

    public boolean preBulkLoadHFile(final List<Pair<byte[], String>> familyPaths) throws IOException {
        return this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.preBulkLoadHFile(ctx, familyPaths);
            }
        });
    }

    public boolean postBulkLoadHFile(final List<Pair<byte[], String>> familyPaths, boolean hasLoaded) throws IOException {
        return this.execOperationWithResult(Boolean.valueOf(hasLoaded), this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Boolean>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.postBulkLoadHFile(ctx, familyPaths, (Boolean)this.getResult()));
            }
        });
    }

    public void postStartRegionOperation(final Region.Operation op) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postStartRegionOperation(ctx, op);
            }
        });
    }

    public void postCloseRegionOperation(final Region.Operation op) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new RegionOperation(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postCloseRegionOperation(ctx, op);
            }
        });
    }

    public StoreFile.Reader preStoreFileReaderOpen(final FileSystem fs, final Path p, final FSDataInputStreamWrapper in, final long size, final CacheConfig cacheConf, final Reference r) throws IOException {
        return this.execOperationWithResult(null, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<StoreFile.Reader>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, (StoreFile.Reader)this.getResult()));
            }
        });
    }

    public StoreFile.Reader postStoreFileReaderOpen(final FileSystem fs, final Path p, final FSDataInputStreamWrapper in, final long size, final CacheConfig cacheConf, final Reference r, StoreFile.Reader reader) throws IOException {
        return this.execOperationWithResult(reader, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<StoreFile.Reader>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.postStoreFileReaderOpen(ctx, fs, p, in, size, cacheConf, r, (StoreFile.Reader)this.getResult()));
            }
        });
    }

    public Cell postMutationBeforeWAL(final RegionObserver.MutationType opType, final Mutation mutation, final Cell oldCell, Cell newCell) throws IOException {
        return this.execOperationWithResult(newCell, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<Cell>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.postMutationBeforeWAL(ctx, opType, mutation, oldCell, (Cell)this.getResult()));
            }
        });
    }

    public Message preEndpointInvocation(final Service service, final String methodName, Message request) throws IOException {
        return this.execOperationWithResult(request, this.coprocessors.isEmpty() ? null : new EndpointOperationWithResult<Message>(){

            @Override
            public void call(EndpointObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.preEndpointInvocation(ctx, service, methodName, (Message)this.getResult()));
            }
        });
    }

    public void postEndpointInvocation(final Service service, final String methodName, final Message request, final Message.Builder responseBuilder) throws IOException {
        this.execOperation(this.coprocessors.isEmpty() ? null : new EndpointOperation(){

            @Override
            public void call(EndpointObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                oserver.postEndpointInvocation(ctx, service, methodName, request, responseBuilder);
            }
        });
    }

    public DeleteTracker postInstantiateDeleteTracker(DeleteTracker tracker) throws IOException {
        return this.execOperationWithResult(tracker, this.coprocessors.isEmpty() ? null : new RegionOperationWithResult<DeleteTracker>(){

            @Override
            public void call(RegionObserver oserver, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
                this.setResult(oserver.postInstantiateDeleteTracker(ctx, (DeleteTracker)this.getResult()));
            }
        });
    }

    private boolean execOperation(CoprocessorOperation ctx) throws IOException {
        return this.execOperation(true, ctx);
    }

    private <T> T execOperationWithResult(T defaultValue, RegionOperationWithResult<T> ctx) throws IOException {
        if (ctx == null) {
            return defaultValue;
        }
        ctx.setResult(defaultValue);
        this.execOperation(true, ctx);
        return ctx.getResult();
    }

    private <T> T execOperationWithResult(boolean ifBypass, T defaultValue, RegionOperationWithResult<T> ctx) throws IOException {
        boolean bypass = false;
        T result = defaultValue;
        if (ctx != null) {
            ctx.setResult(defaultValue);
            bypass = this.execOperation(true, ctx);
            result = ctx.getResult();
        }
        return (T)(bypass == ifBypass ? result : null);
    }

    private <T> T execOperationWithResult(T defaultValue, EndpointOperationWithResult<T> ctx) throws IOException {
        if (ctx == null) {
            return defaultValue;
        }
        ctx.setResult(defaultValue);
        this.execOperation(true, ctx);
        return ctx.getResult();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean execOperation(boolean earlyExit, CoprocessorOperation ctx) throws IOException {
        boolean bypass = false;
        List envs = this.coprocessors.get();
        for (int i = 0; i < envs.size(); ++i) {
            RegionEnvironment env = (RegionEnvironment)envs.get(i);
            Coprocessor observer = env.getInstance();
            if (ctx.hasCall(observer)) {
                ctx.prepare(env);
                Thread currentThread = Thread.currentThread();
                ClassLoader cl = currentThread.getContextClassLoader();
                try {
                    currentThread.setContextClassLoader(env.getClassLoader());
                    ctx.call(observer, ctx);
                }
                catch (Throwable e) {
                    this.handleCoprocessorThrowable(env, e);
                }
                finally {
                    currentThread.setContextClassLoader(cl);
                }
                bypass |= ctx.shouldBypass();
                if (earlyExit && ctx.shouldComplete()) break;
            }
            ctx.postEnvCall(env);
        }
        return bypass;
    }

    private static abstract class EndpointOperationWithResult<T>
    extends EndpointOperation {
        private T result = null;

        private EndpointOperationWithResult() {
        }

        public void setResult(T result) {
            this.result = result;
        }

        public T getResult() {
            return this.result;
        }
    }

    private static abstract class EndpointOperation
    extends CoprocessorOperation {
        private EndpointOperation() {
        }

        public abstract void call(EndpointObserver var1, ObserverContext<RegionCoprocessorEnvironment> var2) throws IOException;

        @Override
        public boolean hasCall(Coprocessor observer) {
            return observer instanceof EndpointObserver;
        }

        @Override
        public void call(Coprocessor observer, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
            this.call((EndpointObserver)observer, ctx);
        }
    }

    private static abstract class RegionOperationWithResult<T>
    extends RegionOperation {
        private T result = null;

        private RegionOperationWithResult() {
        }

        public void setResult(T result) {
            this.result = result;
        }

        public T getResult() {
            return this.result;
        }
    }

    private static abstract class RegionOperation
    extends CoprocessorOperation {
        private RegionOperation() {
        }

        public abstract void call(RegionObserver var1, ObserverContext<RegionCoprocessorEnvironment> var2) throws IOException;

        @Override
        public boolean hasCall(Coprocessor observer) {
            return observer instanceof RegionObserver;
        }

        @Override
        public void call(Coprocessor observer, ObserverContext<RegionCoprocessorEnvironment> ctx) throws IOException {
            this.call((RegionObserver)observer, ctx);
        }
    }

    private static abstract class CoprocessorOperation
    extends ObserverContext<RegionCoprocessorEnvironment> {
        private CoprocessorOperation() {
        }

        public abstract void call(Coprocessor var1, ObserverContext<RegionCoprocessorEnvironment> var2) throws IOException;

        public abstract boolean hasCall(Coprocessor var1);

        public void postEnvCall(RegionEnvironment env) {
        }
    }

    static class TableCoprocessorAttribute {
        private Path path;
        private String className;
        private int priority;
        private Configuration conf;

        public TableCoprocessorAttribute(Path path, String className, int priority, Configuration conf) {
            this.path = path;
            this.className = className;
            this.priority = priority;
            this.conf = conf;
        }

        public Path getPath() {
            return this.path;
        }

        public String getClassName() {
            return this.className;
        }

        public int getPriority() {
            return this.priority;
        }

        public Configuration getConf() {
            return this.conf;
        }
    }

    static class RegionEnvironment
    extends CoprocessorHost.Environment
    implements RegionCoprocessorEnvironment {
        private Region region;
        private RegionServerServices rsServices;
        ConcurrentMap<String, Object> sharedData;
        private final boolean useLegacyPre;
        private final boolean useLegacyPost;
        private final MetricRegistry metricRegistry;

        public RegionEnvironment(Coprocessor impl, int priority, int seq, Configuration conf, Region region, RegionServerServices services, ConcurrentMap<String, Object> sharedData) {
            super(impl, priority, seq, conf);
            this.region = region;
            this.rsServices = services;
            this.sharedData = sharedData;
            this.useLegacyPre = RegionCoprocessorHost.useLegacyMethod(impl.getClass(), "preWALRestore", new Class[]{ObserverContext.class, HRegionInfo.class, WALKey.class, WALEdit.class});
            this.useLegacyPost = RegionCoprocessorHost.useLegacyMethod(impl.getClass(), "postWALRestore", new Class[]{ObserverContext.class, HRegionInfo.class, WALKey.class, WALEdit.class});
            this.metricRegistry = MetricsCoprocessor.createRegistryForRegionCoprocessor(impl.getClass().getName());
        }

        @Override
        public Region getRegion() {
            return this.region;
        }

        @Override
        public RegionServerServices getRegionServerServices() {
            return this.rsServices;
        }

        @Override
        public void shutdown() {
            super.shutdown();
            MetricsCoprocessor.removeRegistry(this.metricRegistry);
        }

        @Override
        public ConcurrentMap<String, Object> getSharedData() {
            return this.sharedData;
        }

        @Override
        public HRegionInfo getRegionInfo() {
            return this.region.getRegionInfo();
        }

        @Override
        public MetricRegistry getMetricRegistryForRegionServer() {
            return this.metricRegistry;
        }
    }
}

