/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop.shim.common.format.avro;

import java.math.BigDecimal;
import java.net.InetAddress;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Date;
import java.util.List;
import org.apache.avro.Conversions;
import org.apache.avro.LogicalType;
import org.apache.avro.LogicalTypes;
import org.apache.avro.Schema;
import org.apache.avro.generic.GenericData;
import org.apache.avro.util.Utf8;
import org.codehaus.jackson.node.NullNode;
import org.pentaho.di.core.row.value.ValueMetaBase;
import org.pentaho.hadoop.shim.api.format.AvroSpec;
import org.pentaho.hadoop.shim.api.format.IAvroInputField;
import org.pentaho.hadoop.shim.common.format.avro.AvroInputField;

public class AvroToPdiConverter {
    Schema avroSchema;
    AvroSpec.DataType avroDataType = null;

    public AvroToPdiConverter(Schema avroSchema) {
        this.avroSchema = avroSchema;
    }

    public Object converAvroToPdi(Object avroData, AvroInputField avroInputField, Schema avroField) {
        String avroFieldName = avroInputField.getPathParts().get(avroInputField.getPathParts().size() - 1);
        Schema.Type primitiveAvroType = avroField.getType();
        primitiveAvroType = avroField.getType();
        switch (primitiveAvroType) {
            case INT: {
                this.avroDataType = AvroSpec.DataType.INTEGER;
                break;
            }
            case LONG: {
                this.avroDataType = AvroSpec.DataType.LONG;
                break;
            }
            case BYTES: {
                this.avroDataType = AvroSpec.DataType.BYTES;
                break;
            }
            case FIXED: {
                this.avroDataType = AvroSpec.DataType.FIXED;
                break;
            }
            case FLOAT: {
                this.avroDataType = AvroSpec.DataType.FLOAT;
                break;
            }
            case DOUBLE: {
                this.avroDataType = AvroSpec.DataType.DOUBLE;
                break;
            }
            case STRING: {
                this.avroDataType = AvroSpec.DataType.STRING;
                break;
            }
            case BOOLEAN: {
                this.avroDataType = AvroSpec.DataType.BOOLEAN;
            }
        }
        Object pentahoData = null;
        if (this.isNotNull(avroData)) {
            if (avroData instanceof Utf8) {
                avroData = avroData.toString();
            }
            int pentahoType = avroInputField.getPentahoType();
            switch (this.avroDataType) {
                case BOOLEAN: {
                    pentahoData = this.convertToPentahoType(pentahoType, (Boolean)avroData);
                    break;
                }
                case DATE: {
                    pentahoData = this.convertToPentahoType(pentahoType, (Integer)avroData);
                    break;
                }
                case FLOAT: {
                    pentahoData = this.convertToPentahoType(pentahoType, (Float)avroData);
                    break;
                }
                case DOUBLE: {
                    pentahoData = this.convertToPentahoType(pentahoType, (Double)avroData);
                    break;
                }
                case LONG: {
                    pentahoData = this.convertToPentahoType(pentahoType, (Long)avroData);
                    break;
                }
                case DECIMAL: {
                    pentahoData = this.convertToPentahoType(pentahoType, (ByteBuffer)avroData, avroField);
                    break;
                }
                case INTEGER: {
                    pentahoData = this.convertToPentahoType(pentahoType, (Integer)avroData);
                    break;
                }
                case STRING: {
                    if (avroData instanceof GenericData.EnumSymbol) {
                        pentahoData = ((GenericData.EnumSymbol)avroData).toString();
                        break;
                    }
                    pentahoData = this.convertToPentahoType(pentahoType, (String)avroData, avroInputField);
                    break;
                }
                case BYTES: {
                    pentahoData = this.convertToPentahoType(pentahoType, (ByteBuffer)avroData, avroField);
                    break;
                }
                case FIXED: {
                    pentahoData = this.convertToPentahoType(pentahoType, ((GenericData.Fixed)avroData).bytes(), avroField);
                    break;
                }
                case TIMESTAMP_MILLIS: {
                    pentahoData = this.convertToPentahoType(pentahoType, (Long)avroData);
                }
            }
        }
        return pentahoData;
    }

    private Object convertToPentahoType(int pentahoType, Float avroData) {
        Object pentahoData = null;
        if (this.isNotNull(avroData)) {
            try {
                switch (pentahoType) {
                    case 2: {
                        pentahoData = avroData.toString();
                        break;
                    }
                    case 5: {
                        pentahoData = new Long(avroData.longValue());
                        break;
                    }
                    case 1: {
                        pentahoData = Double.parseDouble(avroData.toString());
                        break;
                    }
                    case 6: {
                        new BigDecimal(avroData.toString());
                        break;
                    }
                    case 9: {
                        pentahoData = new Timestamp(avroData.longValue());
                        break;
                    }
                    case 3: {
                        pentahoData = new Date(avroData.longValue());
                        break;
                    }
                    case 4: {
                        pentahoData = avroData.floatValue() == 0.0f ? Boolean.FALSE : Boolean.TRUE;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private Object convertToPentahoType(int pentahoType, ByteBuffer avroData, Schema field) {
        Object pentahoData = null;
        if (this.isNotNull(avroData)) {
            try {
                switch (pentahoType) {
                    case 6: {
                        Conversions.DecimalConversion converter = new Conversions.DecimalConversion();
                        Schema schema = field;
                        if (schema.getType().equals((Object)Schema.Type.UNION)) {
                            List schemas = field.getTypes();
                            for (Schema s : schemas) {
                                if (s.getName().equalsIgnoreCase("null")) continue;
                                schema = s;
                                break;
                            }
                        }
                        Object precision = schema.getObjectProp("precision");
                        Object scale = schema.getObjectProp("scale");
                        LogicalTypes.Decimal decimalType = LogicalTypes.decimal((int)Integer.parseInt(precision.toString()), (int)Integer.parseInt(scale.toString()));
                        pentahoData = converter.fromBytes(avroData, this.avroSchema, (LogicalType)decimalType);
                        break;
                    }
                    case 8: {
                        pentahoData = new byte[avroData.remaining()];
                        avroData.get((byte[])pentahoData);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private Object convertToPentahoType(int pentahoType, Long avroData) {
        Object pentahoData = null;
        if (this.isNotNull(avroData)) {
            try {
                switch (pentahoType) {
                    case 2: {
                        pentahoData = avroData.toString();
                        break;
                    }
                    case 5: {
                        pentahoData = (long)avroData;
                        break;
                    }
                    case 1: {
                        pentahoData = new Double(avroData.doubleValue());
                        break;
                    }
                    case 6: {
                        pentahoData = BigDecimal.valueOf(avroData);
                        break;
                    }
                    case 9: {
                        pentahoData = new Timestamp(avroData);
                        break;
                    }
                    case 3: {
                        pentahoData = new Date(avroData);
                        break;
                    }
                    case 4: {
                        pentahoData = avroData == 0L ? Boolean.FALSE : Boolean.TRUE;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private Object convertToPentahoType(int pentahoType, Integer avroData) {
        Object pentahoData = null;
        if (this.isNotNull(avroData)) {
            try {
                switch (pentahoType) {
                    case 2: {
                        pentahoData = avroData.toString();
                        break;
                    }
                    case 5: {
                        pentahoData = new Long(avroData.longValue());
                        break;
                    }
                    case 1: {
                        pentahoData = new Double(avroData.doubleValue());
                        break;
                    }
                    case 6: {
                        pentahoData = BigDecimal.valueOf(avroData.intValue());
                        break;
                    }
                    case 9: {
                        pentahoData = new Timestamp(avroData.intValue());
                        break;
                    }
                    case 3: {
                        LocalDate localDate = LocalDate.ofEpochDay(0L).plusDays(avroData.intValue());
                        pentahoData = Date.from(localDate.atStartOfDay(ZoneId.systemDefault()).toInstant());
                        break;
                    }
                    case 4: {
                        pentahoData = avroData == 0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private Object convertToPentahoType(int pentahoType, Double avroData) {
        Object pentahoData = null;
        if (this.isNotNull(avroData)) {
            try {
                switch (pentahoType) {
                    case 2: {
                        pentahoData = avroData.toString();
                        break;
                    }
                    case 5: {
                        pentahoData = new Long(avroData.longValue());
                        break;
                    }
                    case 1: {
                        pentahoData = avroData;
                        break;
                    }
                    case 6: {
                        pentahoData = BigDecimal.valueOf(avroData);
                        break;
                    }
                    case 9: {
                        pentahoData = new Timestamp(avroData.longValue());
                        break;
                    }
                    case 3: {
                        pentahoData = new Date(avroData.longValue());
                        break;
                    }
                    case 4: {
                        pentahoData = avroData == 0.0 ? Boolean.FALSE : Boolean.TRUE;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private Object convertToPentahoType(int pentahoType, Boolean avroData) {
        Object pentahoData = null;
        if (this.isNotNull(avroData)) {
            try {
                switch (pentahoType) {
                    case 2: {
                        pentahoData = avroData.toString();
                        break;
                    }
                    case 4: {
                        pentahoData = avroData;
                        break;
                    }
                    case 5: {
                        pentahoData = avroData != false ? new Long(1L) : new Long(0L);
                        break;
                    }
                    case 1: {
                        pentahoData = avroData != false ? new Double(1.0) : new Double(0.0);
                        break;
                    }
                    case 6: {
                        pentahoData = avroData != false ? new BigDecimal(1) : new BigDecimal(0);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private Object convertToPentahoType(int pentahoType, String avroData, IAvroInputField avroInputField) {
        Object pentahoData = null;
        if (this.isNotNull(avroData)) {
            try {
                switch (pentahoType) {
                    case 10: {
                        pentahoData = InetAddress.getByName(avroData.toString());
                        break;
                    }
                    case 2: {
                        pentahoData = avroData;
                        break;
                    }
                    case 5: {
                        pentahoData = Long.parseLong(avroData);
                        break;
                    }
                    case 1: {
                        pentahoData = Double.parseDouble(avroData);
                        break;
                    }
                    case 6: {
                        pentahoData = new BigDecimal(avroData);
                        break;
                    }
                    case 9: {
                        pentahoData = new Timestamp(Long.parseLong(avroData));
                        break;
                    }
                    case 3: {
                        String dateFormatStr = avroInputField.getStringFormat();
                        if (dateFormatStr == null || dateFormatStr.trim().length() == 0) {
                            dateFormatStr = ValueMetaBase.DEFAULT_DATE_FORMAT_MASK;
                        }
                        SimpleDateFormat datePattern = new SimpleDateFormat(dateFormatStr);
                        pentahoData = datePattern.parse(avroData);
                        break;
                    }
                    case 4: {
                        pentahoData = "Y".equalsIgnoreCase(avroData) || "TRUE".equalsIgnoreCase(avroData) || "YES".equalsIgnoreCase(avroData) || "1".equals(avroData);
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private Object convertToPentahoType(int pentahoType, byte[] avroData, Schema field) {
        byte[] pentahoData = null;
        if (this.isNotNull(avroData)) {
            try {
                switch (pentahoType) {
                    case 8: {
                        pentahoData = avroData;
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return pentahoData;
    }

    private boolean isLegacySchema(Schema schema) {
        if (schema.getFields().size() > 0) {
            Schema.Field field = (Schema.Field)schema.getFields().get(0);
            return field != null && field.name() != null && field.name().contains("_delimiter_");
        }
        return false;
    }

    private boolean isNotNull(Object avroData) {
        return avroData != null && !(avroData instanceof NullNode);
    }
}

