/*
 * Decompiled with CFR 0.152.
 */
package com.pentaho.big.data.bundles.impl.shim.hbase.table;

import com.pentaho.big.data.bundles.impl.shim.hbase.BatchHBaseConnectionOperation;
import com.pentaho.big.data.bundles.impl.shim.hbase.HBaseConnectionOperation;
import com.pentaho.big.data.bundles.impl.shim.hbase.HBaseConnectionWrapper;
import com.pentaho.big.data.bundles.impl.shim.hbase.connectionPool.HBaseConnectionHandle;
import java.io.IOException;
import org.pentaho.hadoop.shim.api.hbase.table.HBasePut;

public class HBasePutImpl
implements HBasePut {
    private final HBaseConnectionHandle hBaseConnectionHandle;
    private final BatchHBaseConnectionOperation batchHBaseConnectionOperation;
    private boolean writeToWAL;

    public HBasePutImpl(final byte[] key, HBaseConnectionHandle hBaseConnectionHandle) {
        this.hBaseConnectionHandle = hBaseConnectionHandle;
        this.batchHBaseConnectionOperation = new BatchHBaseConnectionOperation();
        this.batchHBaseConnectionOperation.addOperation(new HBaseConnectionOperation(){

            @Override
            public void perform(HBaseConnectionWrapper hBaseConnectionWrapper) throws IOException {
                try {
                    hBaseConnectionWrapper.newTargetTablePut(key, HBasePutImpl.this.writeToWAL);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        });
    }

    public void setWriteToWAL(boolean writeToWAL) {
        this.writeToWAL = writeToWAL;
    }

    public void addColumn(final String columnFamily, final String columnName, final boolean colNameIsBinary, final byte[] colValue) throws IOException {
        this.batchHBaseConnectionOperation.addOperation(new HBaseConnectionOperation(){

            @Override
            public void perform(HBaseConnectionWrapper hBaseConnectionWrapper) throws IOException {
                try {
                    hBaseConnectionWrapper.addColumnToTargetPut(columnFamily, columnName, colNameIsBinary, colValue);
                }
                catch (Exception e) {
                    throw new IOException(e);
                }
            }
        });
    }

    public String createColumnName(String ... parts) {
        StringBuilder result = new StringBuilder();
        for (String part : parts) {
            result.append(part);
            result.append(",");
        }
        if (result.length() > 0) {
            result.setLength(result.length() - ",".length());
        }
        return result.toString();
    }

    public void execute() throws IOException {
        HBaseConnectionWrapper connection = this.hBaseConnectionHandle.getConnection();
        this.batchHBaseConnectionOperation.perform(connection);
        try {
            connection.executeTargetTablePut();
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }
}

