/*
 * Decompiled with CFR 0.152.
 */
package org.apache.hadoop.hbase.regionserver;

import org.apache.hadoop.hbase.regionserver.MemStoreSize;
import org.apache.hadoop.hbase.regionserver.MemStoreSizing;
import org.apache.yetus.audience.InterfaceAudience;

@InterfaceAudience.Private
class NonThreadSafeMemStoreSizing
implements MemStoreSizing {
    private long dataSize = 0L;
    private long heapSize = 0L;
    private long offHeapSize = 0L;

    NonThreadSafeMemStoreSizing() {
        this(0L, 0L, 0L);
    }

    NonThreadSafeMemStoreSizing(MemStoreSize mss) {
        this(mss.getDataSize(), mss.getHeapSize(), mss.getOffHeapSize());
    }

    NonThreadSafeMemStoreSizing(long dataSize, long heapSize, long offHeapSize) {
        this.incMemStoreSize(dataSize, heapSize, offHeapSize);
    }

    @Override
    public MemStoreSize getMemStoreSize() {
        return new MemStoreSize(this.dataSize, this.heapSize, this.offHeapSize);
    }

    @Override
    public long incMemStoreSize(long dataSizeDelta, long heapSizeDelta, long offHeapSizeDelta) {
        this.offHeapSize += offHeapSizeDelta;
        this.heapSize += heapSizeDelta;
        this.dataSize += dataSizeDelta;
        return this.dataSize;
    }

    @Override
    public long getDataSize() {
        return this.dataSize;
    }

    @Override
    public long getHeapSize() {
        return this.heapSize;
    }

    @Override
    public long getOffHeapSize() {
        return this.offHeapSize;
    }

    public String toString() {
        return this.getMemStoreSize().toString();
    }
}

