/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.reporting.engine.classic.extensions.datasources.kettle;

import java.io.File;
import java.net.URISyntaxException;
import java.net.URL;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.reporting.engine.classic.extensions.datasources.kettle.KettleDataFactoryModuleInitializer;
import org.pentaho.reporting.libraries.base.boot.AbstractModule;
import org.pentaho.reporting.libraries.base.boot.ModuleInitializeException;
import org.pentaho.reporting.libraries.base.boot.SubSystem;
import org.pentaho.reporting.libraries.base.util.ObjectUtilities;

public class KettleDataFactoryModule
extends AbstractModule {
    public static final String NAMESPACE = "http://jfreereport.sourceforge.net/namespaces/datasources/kettle";
    public static final String TAG_DEF_PREFIX = "org.pentaho.reporting.engine.classic.extensions.datasources.kettle.tag-def.";
    private static final Log logger = LogFactory.getLog(KettleDataFactoryModule.class);

    public KettleDataFactoryModule() throws ModuleInitializeException {
        this.loadModuleInfo();
    }

    public void initialize(SubSystem subSystem) throws ModuleInitializeException {
        this.fixKettleLoggingAssumptions();
        this.fixKettlePluginSearchPath();
        this.performExternalInitialize(KettleDataFactoryModuleInitializer.class.getName(), ((Object)((Object)this)).getClass());
    }

    private void fixKettlePluginSearchPath() {
        block6: {
            String kettlePluginBaseFolders = System.getProperty("DI_HOME");
            if (kettlePluginBaseFolders != null) {
                return;
            }
            try {
                ClassLoader classLoader = ObjectUtilities.getClassLoader(((Object)((Object)this)).getClass());
                URL resource = classLoader.getResource(".kettle-plugin-directory-marker");
                if (resource == null) break block6;
                try {
                    File pluginsParent;
                    File f = new File(resource.toURI());
                    File parentFile = f.getParentFile();
                    if (parentFile != null && (pluginsParent = parentFile.getParentFile()) != null) {
                        String absPath = pluginsParent.getAbsolutePath();
                        System.setProperty("DI_HOME", absPath);
                    }
                }
                catch (URISyntaxException e) {
                    logger.debug((Object)("Failed to add reporting plugin " + resource), (Throwable)e);
                }
            }
            catch (Throwable t) {
                logger.debug((Object)"Failed to adjust DI_HOME", t);
            }
        }
        logger.debug((Object)("DI_HOME=" + System.getProperty("DI_HOME")));
    }

    private void fixKettleLoggingAssumptions() {
        try {
            if (System.getProperty("KETTLE_REDIRECT_STDOUT") == null) {
                System.setProperty("KETTLE_REDIRECT_STDOUT", "N");
            }
            if (System.getProperty("KETTLE_REDIRECT_STDERR") == null) {
                System.setProperty("KETTLE_REDIRECT_STDERR", "N");
            }
            if (System.getProperty("KETTLE_DISABLE_CONSOLE_LOGGING") == null) {
                System.setProperty("KETTLE_DISABLE_CONSOLE_LOGGING", "N");
            }
        }
        catch (SecurityException securityException) {
            // empty catch block
        }
    }
}

