/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.trans.steps.addxml;

import java.util.List;
import org.pentaho.di.core.CheckResult;
import org.pentaho.di.core.CheckResultInterface;
import org.pentaho.di.core.CheckResultSourceInterface;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.annotations.Step;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.di.core.exception.KettleException;
import org.pentaho.di.core.exception.KettleStepException;
import org.pentaho.di.core.exception.KettleXMLException;
import org.pentaho.di.core.injection.Injection;
import org.pentaho.di.core.injection.InjectionDeep;
import org.pentaho.di.core.injection.InjectionSupported;
import org.pentaho.di.core.row.RowMetaInterface;
import org.pentaho.di.core.row.ValueMeta;
import org.pentaho.di.core.row.ValueMetaInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.repository.ObjectId;
import org.pentaho.di.repository.Repository;
import org.pentaho.di.trans.Trans;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDataInterface;
import org.pentaho.di.trans.step.StepInterface;
import org.pentaho.di.trans.step.StepMeta;
import org.pentaho.di.trans.step.StepMetaInterface;
import org.pentaho.di.trans.steps.addxml.AddXML;
import org.pentaho.di.trans.steps.addxml.AddXMLData;
import org.pentaho.di.trans.steps.addxml.XMLField;
import org.pentaho.metastore.api.IMetaStore;
import org.w3c.dom.Node;

@Step(id="AddXML", image="add_xml.svg", i18nPackageName="org.pentaho.di.trans.steps.addxml", name="AddXML.name", description="AddXML.description", categoryDescription="AddXML.category", documentationUrl="http://wiki.pentaho.com/display/EAI/Add+XML")
@InjectionSupported(localizationPrefix="AddXMLMeta.Injection.", groups={"OUTPUT_FIELDS"})
public class AddXMLMeta
extends BaseStepMeta
implements StepMetaInterface {
    private static Class<?> PKG = AddXMLMeta.class;
    @Injection(name="OMIT_XML_HEADER")
    private boolean omitXMLheader;
    @Injection(name="OMIT_NULL_VALUES")
    private boolean omitNullValues;
    @Injection(name="ENCODING")
    private String encoding;
    @Injection(name="VALUE_NAME")
    private String valueName;
    @Injection(name="ROOT_NODE")
    private String rootNode;
    @InjectionDeep
    private XMLField[] outputFields;

    public boolean isOmitXMLheader() {
        return this.omitXMLheader;
    }

    public void setOmitXMLheader(boolean omitXMLheader) {
        this.omitXMLheader = omitXMLheader;
    }

    public void setOmitNullValues(boolean omitNullValues) {
        this.omitNullValues = omitNullValues;
    }

    public boolean isOmitNullValues() {
        return this.omitNullValues;
    }

    public XMLField[] getOutputFields() {
        return this.outputFields;
    }

    public void setOutputFields(XMLField[] outputFields) {
        this.outputFields = outputFields;
    }

    public void loadXML(Node stepnode, List<DatabaseMeta> databases, IMetaStore metaStore) throws KettleXMLException {
        this.readData(stepnode);
    }

    public void allocate(int nrfields) {
        this.outputFields = new XMLField[nrfields];
    }

    public Object clone() {
        AddXMLMeta retval = (AddXMLMeta)((Object)super.clone());
        int nrfields = this.outputFields.length;
        retval.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            retval.outputFields[i] = (XMLField)this.outputFields[i].clone();
        }
        return retval;
    }

    private void readData(Node stepnode) throws KettleXMLException {
        try {
            this.encoding = XMLHandler.getTagValue((Node)stepnode, (String)"encoding");
            this.valueName = XMLHandler.getTagValue((Node)stepnode, (String)"valueName");
            this.rootNode = XMLHandler.getTagValue((Node)stepnode, (String)"xml_repeat_element");
            this.omitXMLheader = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"omitXMLheader"));
            this.omitNullValues = "Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)stepnode, (String)"file", (String)"omitNullValues"));
            Node fields = XMLHandler.getSubNode((Node)stepnode, (String)"fields");
            int nrfields = XMLHandler.countNodes((Node)fields, (String)"field");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                Node fnode = XMLHandler.getSubNodeByNr((Node)fields, (String)"field", (int)i);
                this.outputFields[i] = new XMLField();
                this.outputFields[i].setFieldName(XMLHandler.getTagValue((Node)fnode, (String)"name"));
                this.outputFields[i].setElementName(XMLHandler.getTagValue((Node)fnode, (String)"element"));
                this.outputFields[i].setType(XMLHandler.getTagValue((Node)fnode, (String)"type"));
                this.outputFields[i].setFormat(XMLHandler.getTagValue((Node)fnode, (String)"format"));
                this.outputFields[i].setCurrencySymbol(XMLHandler.getTagValue((Node)fnode, (String)"currency"));
                this.outputFields[i].setDecimalSymbol(XMLHandler.getTagValue((Node)fnode, (String)"decimal"));
                this.outputFields[i].setGroupingSymbol(XMLHandler.getTagValue((Node)fnode, (String)"group"));
                this.outputFields[i].setNullString(XMLHandler.getTagValue((Node)fnode, (String)"nullif"));
                this.outputFields[i].setLength(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"length"), (int)-1));
                this.outputFields[i].setPrecision(Const.toInt((String)XMLHandler.getTagValue((Node)fnode, (String)"precision"), (int)-1));
                this.outputFields[i].setAttribute("Y".equalsIgnoreCase(XMLHandler.getTagValue((Node)fnode, (String)"attribute")));
                this.outputFields[i].setAttributeParentName(XMLHandler.getTagValue((Node)fnode, (String)"attributeParentName"));
            }
        }
        catch (Exception e) {
            throw new KettleXMLException("Unable to load step info from XML", (Throwable)e);
        }
    }

    public void setDefault() {
        this.omitXMLheader = true;
        this.omitNullValues = false;
        this.encoding = "UTF-8";
        this.valueName = "xmlvaluename";
        this.rootNode = "Row";
        int nrfields = 0;
        this.allocate(nrfields);
        for (int i = 0; i < nrfields; ++i) {
            this.outputFields[i] = new XMLField();
            this.outputFields[i].setFieldName("field" + i);
            this.outputFields[i].setElementName("field" + i);
            this.outputFields[i].setType("Number");
            this.outputFields[i].setFormat(" 0,000,000.00;-0,000,000.00");
            this.outputFields[i].setCurrencySymbol("");
            this.outputFields[i].setDecimalSymbol(",");
            this.outputFields[i].setGroupingSymbol(".");
            this.outputFields[i].setNullString("");
            this.outputFields[i].setLength(-1);
            this.outputFields[i].setPrecision(-1);
            this.outputFields[i].setAttribute(false);
            this.outputFields[i].setElementName("field" + i);
        }
    }

    public void getFields(RowMetaInterface row, String name, RowMetaInterface[] info, StepMeta nextStep, VariableSpace space, Repository repository, IMetaStore metaStore) throws KettleStepException {
        ValueMeta v = new ValueMeta(this.getValueName(), 2);
        v.setOrigin(name);
        row.addValueMeta((ValueMetaInterface)v);
    }

    public String getXML() {
        StringBuffer retval = new StringBuffer(500);
        retval.append("    ").append(XMLHandler.addTagValue((String)"encoding", (String)this.encoding));
        retval.append("    ").append(XMLHandler.addTagValue((String)"valueName", (String)this.valueName));
        retval.append("    ").append(XMLHandler.addTagValue((String)"xml_repeat_element", (String)this.rootNode));
        retval.append("    <file>").append(Const.CR);
        retval.append("      ").append(XMLHandler.addTagValue((String)"omitXMLheader", (boolean)this.omitXMLheader));
        retval.append("      ").append(XMLHandler.addTagValue((String)"omitNullValues", (boolean)this.omitNullValues));
        retval.append("    </file>").append(Const.CR);
        retval.append("    <fields>").append(Const.CR);
        for (int i = 0; i < this.outputFields.length; ++i) {
            XMLField field = this.outputFields[i];
            if (field.getFieldName() == null || field.getFieldName().length() == 0) continue;
            retval.append("      <field>").append(Const.CR);
            retval.append("        ").append(XMLHandler.addTagValue((String)"name", (String)field.getFieldName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"element", (String)field.getElementName()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"type", (String)field.getTypeDesc()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"format", (String)field.getFormat()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"currency", (String)field.getCurrencySymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"decimal", (String)field.getDecimalSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"group", (String)field.getGroupingSymbol()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"nullif", (String)field.getNullString()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"length", (int)field.getLength()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"precision", (int)field.getPrecision()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"attribute", (boolean)field.isAttribute()));
            retval.append("        ").append(XMLHandler.addTagValue((String)"attributeParentName", (String)field.getAttributeParentName()));
            retval.append("        </field>").append(Const.CR);
        }
        retval.append("    </fields>" + Const.CR);
        return retval.toString();
    }

    public void readRep(Repository rep, IMetaStore metaStore, ObjectId id_step, List<DatabaseMeta> databases) throws KettleException {
        try {
            this.encoding = rep.getStepAttributeString(id_step, "encoding");
            this.valueName = rep.getStepAttributeString(id_step, "valueName");
            this.rootNode = rep.getStepAttributeString(id_step, "xml_repeat_element");
            this.omitXMLheader = rep.getStepAttributeBoolean(id_step, "omitXMLheader");
            this.omitNullValues = rep.getStepAttributeBoolean(id_step, "omitNullValues");
            int nrfields = rep.countNrStepAttributes(id_step, "field_name");
            this.allocate(nrfields);
            for (int i = 0; i < nrfields; ++i) {
                this.outputFields[i] = new XMLField();
                this.outputFields[i].setFieldName(rep.getStepAttributeString(id_step, i, "field_name"));
                this.outputFields[i].setElementName(rep.getStepAttributeString(id_step, i, "field_element"));
                this.outputFields[i].setType(rep.getStepAttributeString(id_step, i, "field_type"));
                this.outputFields[i].setFormat(rep.getStepAttributeString(id_step, i, "field_format"));
                this.outputFields[i].setCurrencySymbol(rep.getStepAttributeString(id_step, i, "field_currency"));
                this.outputFields[i].setDecimalSymbol(rep.getStepAttributeString(id_step, i, "field_decimal"));
                this.outputFields[i].setGroupingSymbol(rep.getStepAttributeString(id_step, i, "field_group"));
                this.outputFields[i].setNullString(rep.getStepAttributeString(id_step, i, "field_nullif"));
                this.outputFields[i].setLength((int)rep.getStepAttributeInteger(id_step, i, "field_length"));
                this.outputFields[i].setPrecision((int)rep.getStepAttributeInteger(id_step, i, "field_precision"));
                this.outputFields[i].setAttribute(rep.getStepAttributeBoolean(id_step, i, "field_attribute"));
                this.outputFields[i].setAttributeParentName(rep.getStepAttributeString(id_step, i, "field_attributeName"));
            }
        }
        catch (Exception e) {
            throw new KettleException("Unexpected error reading step information from the repository", (Throwable)e);
        }
    }

    public void saveRep(Repository rep, IMetaStore metaStore, ObjectId id_transformation, ObjectId id_step) throws KettleException {
        try {
            rep.saveStepAttribute(id_transformation, id_step, "encoding", this.encoding);
            rep.saveStepAttribute(id_transformation, id_step, "valueName", this.valueName);
            rep.saveStepAttribute(id_transformation, id_step, "xml_repeat_element", this.rootNode);
            rep.saveStepAttribute(id_transformation, id_step, "omitXMLheader", this.omitXMLheader);
            rep.saveStepAttribute(id_transformation, id_step, "omitNullValues", this.omitNullValues);
            for (int i = 0; i < this.outputFields.length; ++i) {
                XMLField field = this.outputFields[i];
                rep.saveStepAttribute(id_transformation, id_step, i, "field_name", field.getFieldName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_element", field.getElementName());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_type", field.getTypeDesc());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_format", field.getFormat());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_currency", field.getCurrencySymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_decimal", field.getDecimalSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_group", field.getGroupingSymbol());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_nullif", field.getNullString());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_length", (long)field.getLength());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_precision", (long)field.getPrecision());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_attribute", field.isAttribute());
                rep.saveStepAttribute(id_transformation, id_step, i, "field_attributeName", field.getAttributeParentName());
            }
        }
        catch (Exception e) {
            throw new KettleException("Unable to save step information to the repository for id_step=" + id_step, (Throwable)e);
        }
    }

    public void check(List<CheckResultInterface> remarks, TransMeta transMeta, StepMeta stepMeta, RowMetaInterface prev, String[] input, String[] output, RowMetaInterface info, VariableSpace space, Repository repository, IMetaStore metaStore) {
        CheckResult cr;
        if (prev != null && prev.size() > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AddXMLMeta.CheckResult.FieldsReceived", (String[])new String[]{"" + prev.size()}), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
            String error_message = "";
            boolean error_found = false;
            for (int i = 0; i < this.outputFields.length; ++i) {
                int idx = prev.indexOfValue(this.outputFields[i].getFieldName());
                if (idx >= 0) continue;
                error_message = error_message + "\t\t" + this.outputFields[i].getFieldName() + Const.CR;
                error_found = true;
            }
            if (error_found) {
                error_message = BaseMessages.getString(PKG, (String)"AddXMLMeta.CheckResult.FieldsNotFound", (String[])new String[]{error_message});
                cr = new CheckResult(4, error_message, (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            } else {
                cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AddXMLMeta.CheckResult.AllFieldsFound", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
                remarks.add((CheckResultInterface)cr);
            }
        }
        if (input.length > 0) {
            cr = new CheckResult(1, BaseMessages.getString(PKG, (String)"AddXMLMeta.CheckResult.ExpectedInputOk", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        } else {
            cr = new CheckResult(4, BaseMessages.getString(PKG, (String)"AddXMLMeta.CheckResult.ExpectedInputError", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
            remarks.add((CheckResultInterface)cr);
        }
        cr = new CheckResult(2, BaseMessages.getString(PKG, (String)"AddXMLMeta.CheckResult.FilesNotChecked", (String[])new String[0]), (CheckResultSourceInterface)stepMeta);
        remarks.add((CheckResultInterface)cr);
    }

    public StepInterface getStep(StepMeta stepMeta, StepDataInterface stepDataInterface, int cnr, TransMeta transMeta, Trans trans) {
        return new AddXML(stepMeta, stepDataInterface, cnr, transMeta, trans);
    }

    public StepDataInterface getStepData() {
        return new AddXMLData();
    }

    public String getEncoding() {
        return this.encoding;
    }

    public void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    public String getRootNode() {
        return this.rootNode;
    }

    public void setRootNode(String rootNode) {
        this.rootNode = rootNode;
    }

    public String getValueName() {
        return this.valueName;
    }

    public void setValueName(String valueName) {
        this.valueName = valueName;
    }
}

