/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.hadoop;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Properties;
import org.apache.commons.vfs2.FileObject;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.exception.KettleFileException;
import org.pentaho.di.core.plugins.PluginInterface;
import org.pentaho.di.core.vfs.KettleVFS;
import org.pentaho.hadoop.PropertiesConfigurationProperties;

public class PluginPropertiesUtil {
    public static final String PLUGIN_PROPERTIES_FILE = "plugin.properties";
    public static final String VERSION_PROPERTIES_FILE = "META-INF/version.properties";
    private static final String VERSION_REPLACE_STR = "@VERSION@";
    private final String VERSION_PLACEHOLDER;

    public PluginPropertiesUtil() {
        this(VERSION_PROPERTIES_FILE);
    }

    public PluginPropertiesUtil(String versionPropertiesFile) {
        this.VERSION_PLACEHOLDER = PluginPropertiesUtil.getVersionPlaceholder(versionPropertiesFile);
    }

    private static String getVersionPlaceholder(String versionPropertiesFile) {
        String string;
        block8: {
            InputStream propertiesStream = PluginPropertiesUtil.class.getClassLoader().getResourceAsStream(versionPropertiesFile);
            try {
                Properties properties = new Properties();
                properties.load(propertiesStream);
                string = properties.getProperty("version", VERSION_REPLACE_STR);
                if (propertiesStream == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (propertiesStream != null) {
                        try {
                            propertiesStream.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    return VERSION_REPLACE_STR;
                }
            }
            propertiesStream.close();
        }
        return string;
    }

    protected Properties loadProperties(PluginInterface plugin, String relativeName) throws KettleFileException, IOException {
        if (plugin == null) {
            throw new NullPointerException();
        }
        FileObject propFile = KettleVFS.getFileObject((String)(plugin.getPluginDirectory().getPath() + Const.FILE_SEPARATOR + relativeName));
        if (!propFile.exists()) {
            throw new FileNotFoundException(propFile.toString());
        }
        try {
            return new PropertiesConfigurationProperties(propFile);
        }
        catch (Exception e) {
            throw new IOException(e);
        }
    }

    public Properties loadPluginProperties(PluginInterface plugin) throws KettleFileException, IOException {
        return this.loadProperties(plugin, PLUGIN_PROPERTIES_FILE);
    }

    public String getVersion() {
        return this.VERSION_PLACEHOLDER;
    }
}

