/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.core.namedcluster;

import com.google.common.annotations.VisibleForTesting;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import org.apache.commons.vfs2.FileName;
import org.apache.commons.vfs2.provider.url.UrlFileName;
import org.apache.commons.vfs2.provider.url.UrlFileNameParser;
import org.pentaho.di.core.namedcluster.model.NamedCluster;
import org.pentaho.di.core.util.StringUtil;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.metastore.api.IMetaStore;
import org.pentaho.metastore.api.exceptions.MetaStoreException;
import org.pentaho.metastore.persist.MetaStoreFactory;

public class NamedClusterManager {
    private static final NamedClusterManager instance = new NamedClusterManager(new MetaStoreFactoryFactory());
    private final MetaStoreFactoryFactory metaStoreFactoryFactory;
    private final Map<IMetaStore, MetaStoreFactory<NamedCluster>> factoryMap;
    private NamedCluster clusterTemplate;

    @VisibleForTesting
    NamedClusterManager(MetaStoreFactoryFactory metaStoreFactoryFactory) {
        this.metaStoreFactoryFactory = metaStoreFactoryFactory;
        this.factoryMap = new HashMap<IMetaStore, MetaStoreFactory<NamedCluster>>();
    }

    public static NamedClusterManager getInstance() {
        return instance;
    }

    private MetaStoreFactory<NamedCluster> getMetaStoreFactory(IMetaStore metastore) {
        return this.factoryMap.computeIfAbsent(metastore, k -> this.metaStoreFactoryFactory.createFactory(metastore));
    }

    public NamedCluster getClusterTemplate() {
        String localHost = "localhost";
        if (this.clusterTemplate == null) {
            this.clusterTemplate = new NamedCluster();
            this.clusterTemplate.setName("");
            this.clusterTemplate.setHdfsHost(localHost);
            this.clusterTemplate.setHdfsPort("8020");
            this.clusterTemplate.setHdfsUsername("user");
            this.clusterTemplate.setHdfsPassword(this.clusterTemplate.encodePassword("password"));
            this.clusterTemplate.setJobTrackerHost(localHost);
            this.clusterTemplate.setJobTrackerPort("8032");
            this.clusterTemplate.setZooKeeperHost(localHost);
            this.clusterTemplate.setZooKeeperPort("2181");
            this.clusterTemplate.setOozieUrl("http://localhost:8080/oozie");
        }
        return this.clusterTemplate.clone();
    }

    public void setClusterTemplate(NamedCluster clusterTemplate) {
        this.clusterTemplate = clusterTemplate;
    }

    public void create(NamedCluster namedCluster, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        factory.saveElement((Object)namedCluster);
    }

    public NamedCluster read(String clusterName, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        return (NamedCluster)factory.loadElement(clusterName);
    }

    public void update(NamedCluster namedCluster, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        List<NamedCluster> namedClusters = this.list(metastore);
        for (NamedCluster nc : namedClusters) {
            if (!namedCluster.getName().equals(nc.getName())) continue;
            factory.deleteElement(nc.getName());
            factory.saveElement((Object)namedCluster);
        }
    }

    public void delete(String clusterName, IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        factory.deleteElement(clusterName);
    }

    public List<NamedCluster> list(IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        ArrayList exceptionList = new ArrayList();
        return factory.getElements(true, exceptionList);
    }

    public List<NamedCluster> list(IMetaStore metastore, List<MetaStoreException> exceptionList) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        return factory.getElements(true, exceptionList);
    }

    public List<String> listNames(IMetaStore metastore) throws MetaStoreException {
        MetaStoreFactory<NamedCluster> factory = this.getMetaStoreFactory(metastore);
        return factory.getElementNames();
    }

    public boolean contains(String clusterName, IMetaStore metastore) throws MetaStoreException {
        if (metastore == null) {
            return false;
        }
        for (String name : this.listNames(metastore)) {
            if (!name.equals(clusterName)) continue;
            return true;
        }
        return false;
    }

    @VisibleForTesting
    String generateURL(String scheme, String clusterName, IMetaStore metastore, VariableSpace variableSpace) {
        String clusterURL = null;
        try {
            NamedCluster namedCluster;
            if (!Utils.isEmpty((CharSequence)scheme) && !Utils.isEmpty((CharSequence)clusterName) && metastore != null && (namedCluster = this.read(clusterName, metastore)) != null) {
                String ncHostname = Optional.ofNullable(namedCluster.getHdfsHost()).orElse("");
                String ncPort = Optional.ofNullable(namedCluster.getHdfsPort()).orElse("");
                String ncUsername = Optional.ofNullable(namedCluster.getHdfsUsername()).orElse("");
                String ncPassword = Optional.ofNullable(namedCluster.getHdfsPassword()).orElse("");
                if (variableSpace != null) {
                    variableSpace.initializeVariablesFrom(namedCluster.getParentVariableSpace());
                    scheme = this.getVariableValue(scheme, variableSpace);
                    ncHostname = this.getVariableValue(ncHostname, variableSpace);
                    ncPort = this.getVariableValue(ncPort, variableSpace);
                    ncUsername = this.getVariableValue(ncUsername, variableSpace);
                    ncPassword = this.getVariableValue(ncPassword, variableSpace);
                }
                ncHostname = Optional.ofNullable(ncHostname).orElse("").trim();
                if (ncPort == null || Utils.isEmpty((CharSequence)ncPort.trim())) {
                    ncPort = "-1";
                }
                ncPort = ncPort.trim();
                ncUsername = Optional.ofNullable(ncUsername).orElse("").trim();
                ncPassword = Optional.ofNullable(ncPassword).orElse("").trim();
                UrlFileName file = new UrlFileName(scheme, ncHostname, Integer.parseInt(ncPort), -1, ncUsername, ncPassword, null, null, null);
                clusterURL = file.getURI();
                if (clusterURL.endsWith("/")) {
                    clusterURL = clusterURL.substring(0, clusterURL.lastIndexOf(47));
                }
            }
        }
        catch (Exception e) {
            clusterURL = null;
        }
        return clusterURL;
    }

    private String getVariableValue(String variableName, VariableSpace variableSpace) {
        if (StringUtil.isVariable((String)variableName)) {
            return variableSpace.getVariable(StringUtil.getVariableName((String)variableName)) != null ? variableSpace.environmentSubstitute(variableName) : null;
        }
        return variableName;
    }

    public String processURLsubstitution(String clusterName, String incomingURL, String scheme, IMetaStore metastore, VariableSpace variableSpace) {
        String outgoingURL = null;
        String clusterURL = null;
        if (!scheme.equals("maprfs")) {
            clusterURL = this.generateURL(scheme, clusterName, metastore, variableSpace);
        }
        try {
            if (clusterURL == null) {
                outgoingURL = incomingURL;
            } else if (incomingURL.equals("/")) {
                outgoingURL = clusterURL;
            } else {
                String noVariablesURL = incomingURL.replaceAll("[${}]", "/");
                String fullyQualifiedIncomingURL = incomingURL;
                if (!incomingURL.startsWith(scheme)) {
                    fullyQualifiedIncomingURL = clusterURL + incomingURL;
                    noVariablesURL = clusterURL + incomingURL.replaceAll("[${}]", "/");
                }
                UrlFileNameParser parser = new UrlFileNameParser();
                FileName fileName = parser.parseUri(null, null, noVariablesURL);
                String root = fileName.getRootURI();
                String path = fullyQualifiedIncomingURL.substring(root.length() - 1);
                StringBuilder buffer = new StringBuilder();
                buffer.append(clusterURL);
                buffer.append(path);
                outgoingURL = buffer.toString();
            }
        }
        catch (Exception e) {
            outgoingURL = null;
        }
        return outgoingURL;
    }

    public NamedCluster getNamedClusterByName(String namedCluster, IMetaStore metastore) {
        if (metastore == null) {
            return null;
        }
        try {
            List<NamedCluster> namedClusters = this.list(metastore);
            for (NamedCluster nc : namedClusters) {
                if (!nc.getName().equals(namedCluster)) continue;
                return nc;
            }
        }
        catch (MetaStoreException e) {
            return null;
        }
        return null;
    }

    static class MetaStoreFactoryFactory {
        MetaStoreFactoryFactory() {
        }

        MetaStoreFactory<NamedCluster> createFactory(IMetaStore metaStore) {
            return new MetaStoreFactory(NamedCluster.class, metaStore, "pentaho");
        }
    }
}

