/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.ui.shapefilereader;

import java.nio.charset.Charset;
import java.util.ArrayList;
import org.apache.commons.lang.StringUtils;
import org.eclipse.swt.custom.CCombo;
import org.eclipse.swt.events.FocusEvent;
import org.eclipse.swt.events.FocusListener;
import org.eclipse.swt.events.ModifyEvent;
import org.eclipse.swt.events.ModifyListener;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.events.SelectionListener;
import org.eclipse.swt.events.ShellAdapter;
import org.eclipse.swt.events.ShellEvent;
import org.eclipse.swt.events.ShellListener;
import org.eclipse.swt.graphics.Cursor;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.Image;
import org.eclipse.swt.layout.FormAttachment;
import org.eclipse.swt.layout.FormData;
import org.eclipse.swt.layout.FormLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Event;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.eclipse.swt.widgets.Listener;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.swt.widgets.Text;
import org.pentaho.di.base.AbstractMeta;
import org.pentaho.di.core.Const;
import org.pentaho.di.core.logging.LogChannelInterface;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.shapefilereader.ShapeFileReaderMeta;
import org.pentaho.di.trans.TransMeta;
import org.pentaho.di.trans.step.BaseStepMeta;
import org.pentaho.di.trans.step.StepDialogInterface;
import org.pentaho.di.ui.core.events.dialog.FilterType;
import org.pentaho.di.ui.core.events.dialog.ProviderFilterType;
import org.pentaho.di.ui.core.events.dialog.SelectionAdapterFileDialogTextVar;
import org.pentaho.di.ui.core.events.dialog.SelectionAdapterOptions;
import org.pentaho.di.ui.core.events.dialog.SelectionOperation;
import org.pentaho.di.ui.core.widget.TextVar;
import org.pentaho.di.ui.shapefilereader.ShapeSelectionAdapterFileDialogTextVar;
import org.pentaho.di.ui.trans.step.BaseStepDialog;
import org.pentaho.di.ui.util.SwtSvgImageUtil;

public class ShapeFileReaderDialog
extends BaseStepDialog
implements StepDialogInterface {
    private static Class<?> PKG = ShapeFileReaderMeta.class;
    private Label wlShape;
    private Button wbShape;
    private TextVar wShape;
    private FormData fdlShape;
    private FormData fdbShape;
    private FormData fdbcShape;
    private FormData fdShape;
    private Label wlDbf;
    private Button wbDbf;
    private TextVar wDbf;
    private FormData fdlDbf;
    private FormData fdbDbf;
    private FormData fdbcDbf;
    private FormData fdDbf;
    private Label wlEncoding;
    private CCombo wEncoding;
    private FormData fdlEncoding;
    private FormData fdEncoding;
    private ShapeFileReaderMeta input;
    private boolean backup_changed;

    public ShapeFileReaderDialog(Shell parent, Object in, TransMeta tr, String sname) {
        super(parent, (BaseStepMeta)in, tr, sname);
        this.input = (ShapeFileReaderMeta)((Object)in);
    }

    public String open() {
        Shell parent = this.getParent();
        Display display = parent.getDisplay();
        if (StringUtils.isBlank((String)this.input.getEncoding())) {
            this.input.setEncoding(StringUtils.isNotBlank((String)this.transMeta.getVariable("ESRI.encoding")) ? this.transMeta.getVariable("ESRI.encoding") : "");
        }
        this.shell = new Shell(parent, 3312);
        this.props.setLook((Control)this.shell);
        this.setShellImage(this.shell, this.input);
        ModifyListener lsMod = new ModifyListener(){

            public void modifyText(ModifyEvent e) {
                ShapeFileReaderDialog.this.input.setChanged();
            }
        };
        this.backup_changed = this.input.hasChanged();
        FormLayout formLayout = new FormLayout();
        formLayout.marginWidth = 5;
        formLayout.marginHeight = 5;
        this.shell.setLayout((Layout)formLayout);
        this.shell.setText(BaseMessages.getString(PKG, (String)"ShapeFileReader.Step.Name", (String[])new String[0]));
        int middle = this.props.getMiddlePct();
        int margin = 4;
        this.wlStepname = new Label((Composite)this.shell, 131072);
        this.wlStepname.setText("Step name ");
        this.props.setLook((Control)this.wlStepname);
        this.fdlStepname = new FormData();
        this.fdlStepname.left = new FormAttachment(0, 0);
        this.fdlStepname.right = new FormAttachment(middle, -margin);
        this.fdlStepname.top = new FormAttachment(0, margin);
        this.wlStepname.setLayoutData((Object)this.fdlStepname);
        this.wStepname = new Text((Composite)this.shell, 18436);
        this.wStepname.setText(this.stepname);
        this.props.setLook((Control)this.wStepname);
        this.wStepname.addModifyListener(lsMod);
        this.fdStepname = new FormData();
        this.fdStepname.left = new FormAttachment(middle, 0);
        this.fdStepname.top = new FormAttachment(0, margin);
        this.fdStepname.right = new FormAttachment(100, 0);
        this.wStepname.setLayoutData((Object)this.fdStepname);
        this.wlShape = new Label((Composite)this.shell, 131072);
        this.wlShape.setText("Name of the shapefile (.shp) ");
        this.props.setLook((Control)this.wlShape);
        this.fdlShape = new FormData();
        this.fdlShape.left = new FormAttachment(0, 0);
        this.fdlShape.top = new FormAttachment((Control)this.wStepname, margin);
        this.fdlShape.right = new FormAttachment(middle, -margin);
        this.wlShape.setLayoutData((Object)this.fdlShape);
        this.wbShape = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbShape);
        this.wbShape.setText("&Browse...");
        this.fdbShape = new FormData();
        this.fdbShape.right = new FormAttachment(100, 0);
        this.fdbShape.top = new FormAttachment((Control)this.wStepname, margin);
        this.wbShape.setLayoutData((Object)this.fdbShape);
        this.wShape = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wShape);
        this.wShape.addModifyListener(lsMod);
        this.fdShape = new FormData();
        this.fdShape.left = new FormAttachment(middle, 0);
        this.fdShape.right = new FormAttachment((Control)this.wbShape, -margin);
        this.fdShape.top = new FormAttachment((Control)this.wStepname, margin);
        this.wShape.setLayoutData((Object)this.fdShape);
        this.wlDbf = new Label((Composite)this.shell, 131072);
        this.wlDbf.setText("Name of the DBF file (.dbf) ");
        this.props.setLook((Control)this.wlDbf);
        this.fdlDbf = new FormData();
        this.fdlDbf.left = new FormAttachment(0, 0);
        this.fdlDbf.top = new FormAttachment((Control)this.wShape, margin);
        this.fdlDbf.right = new FormAttachment(middle, -margin);
        this.wlDbf.setLayoutData((Object)this.fdlDbf);
        this.wbDbf = new Button((Composite)this.shell, 0x1000008);
        this.props.setLook((Control)this.wbDbf);
        this.wbDbf.setText("&Browse...");
        this.fdbDbf = new FormData();
        this.fdbDbf.right = new FormAttachment(100, 0);
        this.fdbDbf.top = new FormAttachment((Control)this.wShape, margin);
        this.wbDbf.setLayoutData((Object)this.fdbDbf);
        this.wDbf = new TextVar((VariableSpace)this.transMeta, (Composite)this.shell, 18436);
        this.props.setLook((Control)this.wDbf);
        this.wDbf.addModifyListener(lsMod);
        this.fdDbf = new FormData();
        this.fdDbf.left = new FormAttachment(middle, 0);
        this.fdDbf.right = new FormAttachment((Control)this.wbDbf, -margin);
        this.fdDbf.top = new FormAttachment((Control)this.wShape, margin);
        this.wDbf.setLayoutData((Object)this.fdDbf);
        this.wlEncoding = new Label((Composite)this.shell, 131072);
        this.wlEncoding.setText(BaseMessages.getString(PKG, (String)"ShapeFileReader.Encoding.Label", (String[])new String[0]));
        this.props.setLook((Control)this.wlEncoding);
        this.fdlEncoding = new FormData();
        this.fdlEncoding.left = new FormAttachment(0, 0);
        this.fdlEncoding.top = new FormAttachment((Control)this.wDbf, margin);
        this.fdlEncoding.right = new FormAttachment(middle, -margin);
        this.wlEncoding.setLayoutData((Object)this.fdlEncoding);
        this.wEncoding = new CCombo((Composite)this.shell, 2056);
        this.wEncoding.setEditable(false);
        this.props.setLook((Control)this.wEncoding);
        this.wEncoding.addModifyListener(lsMod);
        this.fdEncoding = new FormData();
        this.fdEncoding.left = new FormAttachment(middle, 0);
        this.fdEncoding.top = new FormAttachment((Control)this.wDbf, margin);
        this.fdEncoding.right = new FormAttachment(100, 0);
        this.wEncoding.setLayoutData((Object)this.fdEncoding);
        this.wEncoding.addFocusListener(new FocusListener(){

            public void focusLost(FocusEvent e) {
            }

            public void focusGained(FocusEvent e) {
                if (ShapeFileReaderDialog.this.wEncoding.getItemCount() == 0) {
                    Cursor busy = new Cursor((Device)ShapeFileReaderDialog.this.shell.getDisplay(), 1);
                    ShapeFileReaderDialog.this.shell.setCursor(busy);
                    ShapeFileReaderDialog.this.setEncodings();
                    ShapeFileReaderDialog.this.shell.setCursor(null);
                    busy.dispose();
                }
            }
        });
        this.wOK = new Button((Composite)this.shell, 8);
        this.wOK.setText("  &OK  ");
        this.wCancel = new Button((Composite)this.shell, 8);
        this.wCancel.setText("  &Cancel  ");
        this.setButtonPositions(new Button[]{this.wOK, this.wCancel}, margin, null);
        this.lsCancel = new Listener(){

            public void handleEvent(Event e) {
                ShapeFileReaderDialog.this.cancel();
            }
        };
        this.lsOK = new Listener(){

            public void handleEvent(Event e) {
                ShapeFileReaderDialog.this.ok();
            }
        };
        this.wCancel.addListener(13, this.lsCancel);
        this.wOK.addListener(13, this.lsOK);
        this.lsDef = new SelectionAdapter(){

            public void widgetDefaultSelected(SelectionEvent e) {
                ShapeFileReaderDialog.this.ok();
            }
        };
        this.wStepname.addSelectionListener((SelectionListener)this.lsDef);
        this.wShape.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ShapeFileReaderDialog.this.wShape.setToolTipText(ShapeFileReaderDialog.this.transMeta.environmentSubstitute(ShapeFileReaderDialog.this.wShape.getText()));
            }
        });
        this.wbShape.addSelectionListener((SelectionListener)new ShapeSelectionAdapterFileDialogTextVar((LogChannelInterface)this.log, this.wShape, (AbstractMeta)this.transMeta, new SelectionAdapterOptions(SelectionOperation.FILE, new FilterType[]{FilterType.SHP, FilterType.ALL}, FilterType.SHP, new ProviderFilterType[]{ProviderFilterType.LOCAL}), this.wDbf));
        this.wDbf.addModifyListener(new ModifyListener(){

            public void modifyText(ModifyEvent arg0) {
                ShapeFileReaderDialog.this.wDbf.setToolTipText(ShapeFileReaderDialog.this.transMeta.environmentSubstitute(ShapeFileReaderDialog.this.wDbf.getText()));
            }
        });
        this.wbDbf.addSelectionListener((SelectionListener)new SelectionAdapterFileDialogTextVar((LogChannelInterface)this.log, this.wDbf, (AbstractMeta)this.transMeta, new SelectionAdapterOptions(SelectionOperation.FILE, new FilterType[]{FilterType.DBF, FilterType.ALL}, FilterType.DBF, new ProviderFilterType[]{ProviderFilterType.LOCAL})));
        this.shell.addShellListener((ShellListener)new ShellAdapter(){

            public void shellClosed(ShellEvent e) {
                ShapeFileReaderDialog.this.cancel();
            }
        });
        this.getData();
        this.input.setChanged(this.changed);
        this.setSize();
        this.shell.open();
        while (!this.shell.isDisposed()) {
            if (display.readAndDispatch()) continue;
            display.sleep();
        }
        return this.stepname;
    }

    public void getData() {
        if (this.input.getShapeFilename() != null) {
            this.wShape.setText(this.input.getShapeFilename());
        }
        if (this.input.getDbfFilename() != null) {
            this.wDbf.setText(this.input.getDbfFilename());
        }
        if (StringUtils.isNotBlank((String)this.input.getEncoding())) {
            this.wEncoding.setText(this.input.getEncoding());
        }
        this.wStepname.selectAll();
    }

    private void setEncodings() {
        ArrayList<Charset> values = new ArrayList<Charset>(Charset.availableCharsets().values());
        for (Charset charSet : values) {
            this.wEncoding.add(charSet.displayName());
        }
        int idx = Const.indexOfString((String)this.input.getEncoding(), (String[])this.wEncoding.getItems());
        if (idx >= 0) {
            this.wEncoding.select(idx);
        }
    }

    private void cancel() {
        this.stepname = null;
        this.input.setChanged(this.backup_changed);
        this.dispose();
    }

    private void ok() {
        this.stepname = this.wStepname.getText();
        this.input.setShapeFilename(this.wShape.getText());
        this.input.setDbfFilename(this.wDbf.getText());
        this.input.setEncoding(StringUtils.isNotBlank((String)this.wEncoding.getText()) ? this.wEncoding.getText() : this.input.getEncoding());
        this.dispose();
    }

    private Image getImage() {
        return SwtSvgImageUtil.getImage((Display)this.shell.getDisplay(), (ClassLoader)((Object)((Object)this)).getClass().getClassLoader(), (String)"ESRI.svg", (int)32, (int)32);
    }
}

