/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.schema;

import org.pentaho.di.core.changed.ChangedFlagInterface;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.schema.BusinessColumn;
import org.pentaho.pms.schema.BusinessTable;
import org.pentaho.pms.schema.concept.ConceptInterface;
import org.pentaho.pms.schema.concept.ConceptUtilityBase;
import org.pentaho.pms.schema.concept.ConceptUtilityInterface;
import org.pentaho.pms.util.Const;
import org.pentaho.pms.util.ObjectAlreadyExistsException;
import org.pentaho.pms.util.Settings;
import org.pentaho.pms.util.UniqueArrayList;
import org.pentaho.pms.util.UniqueList;

public class BusinessCategory
extends ConceptUtilityBase
implements ChangedFlagInterface,
ConceptUtilityInterface,
Cloneable {
    private UniqueList<BusinessCategory> businessCategories = new UniqueArrayList<BusinessCategory>();
    private UniqueList<BusinessColumn> businessColumns = new UniqueArrayList<BusinessColumn>();
    private boolean rootCategory;

    public boolean isRootCategory() {
        return this.rootCategory;
    }

    public void setRootCategory(boolean rootCategory) {
        this.rootCategory = rootCategory;
    }

    public BusinessCategory() {
        this(null);
    }

    public BusinessCategory(String id) {
        super(id);
    }

    @Override
    public String getModelElementDescription() {
        return Messages.getString("BusinessCategory.USER_DESCRIPTION");
    }

    public Object clone() {
        int i;
        BusinessCategory businessCategory = new BusinessCategory();
        try {
            businessCategory.setId(this.getId());
        }
        catch (ObjectAlreadyExistsException objectAlreadyExistsException) {
            // empty catch block
        }
        businessCategory.setRootCategory(this.rootCategory);
        businessCategory.getBusinessColumns().clear();
        for (i = 0; i < this.nrBusinessColumns(); ++i) {
            try {
                businessCategory.addBusinessColumn(this.getBusinessColumn(i));
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                throw new RuntimeException(e);
            }
        }
        businessCategory.getBusinessCategories().clear();
        for (i = 0; i < this.nrBusinessCategories(); ++i) {
            try {
                businessCategory.addBusinessCategory((BusinessCategory)this.getBusinessCategory(i).clone());
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                throw new RuntimeException(e);
            }
        }
        businessCategory.setConcept((ConceptInterface)this.getConcept().clone());
        return businessCategory;
    }

    public BusinessCategory cloneUnique(String locale, UniqueList categories) {
        BusinessCategory businessCategory = (BusinessCategory)this.clone();
        businessCategory.getBusinessColumns().clear();
        for (int i = 0; i < this.nrBusinessColumns(); ++i) {
            try {
                businessCategory.addBusinessColumn(this.getBusinessColumn(i));
                continue;
            }
            catch (ObjectAlreadyExistsException e) {
                throw new RuntimeException(e);
            }
        }
        String newId = BusinessCategory.proposeId(locale, null, this, categories);
        try {
            businessCategory.setId(newId);
        }
        catch (ObjectAlreadyExistsException e) {
            return null;
        }
        return businessCategory;
    }

    public static final String proposeId(String locale, BusinessTable table, BusinessCategory category) {
        String baseID = table != null ? Const.toID(table.getTargetTable()) : "";
        String namePart = category != null && category.getDisplayName(locale) != null ? "_" + Const.toID(category.getDisplayName(locale)) : "";
        String id = Settings.getBusinessCategoryIDPrefix() + baseID + namePart;
        if (Settings.isAnIdUppercase()) {
            id = id.toUpperCase();
        }
        return id;
    }

    public static final String proposeId(String locale, BusinessTable businessTable, BusinessCategory category, UniqueList categories) {
        boolean gotNew = false;
        boolean found = false;
        String id = BusinessCategory.proposeId(locale, businessTable, category);
        int catNr = 1;
        String newId = id;
        while (!gotNew) {
            for (ConceptUtilityBase element : categories) {
                if (!element.getId().equalsIgnoreCase(newId)) continue;
                found = true;
                break;
            }
            if (found) {
                newId = id + "_" + ++catNr;
                found = false;
                continue;
            }
            gotNew = true;
        }
        if (Settings.isAnIdUppercase()) {
            newId = newId.toUpperCase();
        }
        return newId;
    }

    public UniqueList<BusinessCategory> getBusinessCategories() {
        return this.businessCategories;
    }

    public void setBusinessCategories(UniqueList<BusinessCategory> businessCategories) {
        this.businessCategories = businessCategories;
    }

    public int nrBusinessCategories() {
        return this.businessCategories.size();
    }

    public BusinessCategory getBusinessCategory(int index) {
        return this.businessCategories.get(index);
    }

    public void removeBusinessCategory(int index) {
        this.businessCategories.remove(index);
        this.setChanged();
    }

    public void removeBusinessCategory(BusinessCategory category) {
        this.businessCategories.remove(category);
        this.setChanged();
    }

    public void addBusinessCategory(BusinessCategory businessCategory) throws ObjectAlreadyExistsException {
        this.businessCategories.add(businessCategory);
        this.setChanged();
    }

    public void addBusinessCategory(int index, BusinessCategory businessCategory) throws ObjectAlreadyExistsException {
        this.businessCategories.add(index, businessCategory);
        this.setChanged();
    }

    public int indexOfBusinessCategory(BusinessCategory businessCategory) {
        return this.businessCategories.indexOf(businessCategory);
    }

    public UniqueList getBusinessColumns() {
        return this.businessColumns;
    }

    public void setBusinessColumns(UniqueList<BusinessColumn> businessColumns) {
        this.businessColumns = businessColumns;
    }

    public int nrBusinessColumns() {
        return this.businessColumns.size();
    }

    public BusinessColumn getBusinessColumn(int i) {
        return this.businessColumns.get(i);
    }

    public void addBusinessColumn(BusinessColumn businessColumn) throws ObjectAlreadyExistsException {
        this.businessColumns.add(businessColumn);
        this.setChanged();
    }

    public void addBusinessColumn(int i, BusinessColumn businessColumn) throws ObjectAlreadyExistsException {
        this.businessColumns.add(i, businessColumn);
        this.setChanged();
    }

    public int indexOfBusinessColumn(BusinessColumn businessColumn) {
        return this.businessColumns.indexOf(businessColumn);
    }

    public void removeBusinessColumn(int index) {
        this.businessColumns.remove(index);
        this.setChanged();
    }

    public void removeBusinessColumn(BusinessColumn obj) {
        this.businessColumns.remove(obj);
        this.setChanged();
    }

    public BusinessColumn findBusinessColumn(String id) {
        return this.findBusinessColumn(id, true);
    }

    public BusinessColumn findBusinessColumn(String id, boolean searchRecursive) {
        int i;
        if (searchRecursive) {
            for (i = 0; i < this.nrBusinessCategories(); ++i) {
                BusinessCategory businessCategory = this.getBusinessCategory(i);
                BusinessColumn businessColumn = businessCategory.findBusinessColumn(id, true);
                if (businessColumn == null) continue;
                return businessColumn;
            }
        }
        for (i = 0; i < this.nrBusinessColumns(); ++i) {
            BusinessColumn businessColumn = this.getBusinessColumn(i);
            if (!businessColumn.getId().equalsIgnoreCase(id)) continue;
            return businessColumn;
        }
        return null;
    }

    public BusinessColumn findBusinessColumn(String name, String locale) {
        return this.findBusinessColumn(name, true, locale);
    }

    public BusinessColumn findBusinessColumn(String name, boolean searchRecursive, String locale) {
        int i;
        if (searchRecursive) {
            for (i = 0; i < this.nrBusinessCategories(); ++i) {
                BusinessCategory businessCategory = this.getBusinessCategory(i);
                BusinessColumn businessColumn = businessCategory.findBusinessColumn(name, true, locale);
                if (businessColumn == null) continue;
                return businessColumn;
            }
        }
        for (i = 0; i < this.nrBusinessColumns(); ++i) {
            BusinessColumn businessColumn = this.getBusinessColumn(i);
            if (!businessColumn.getDisplayName(locale).equalsIgnoreCase(name)) continue;
            return businessColumn;
        }
        return this.findBusinessColumn(name, searchRecursive);
    }

    @Override
    public boolean hasChanged() {
        int i;
        if (super.hasChanged()) {
            return true;
        }
        for (i = 0; i < this.nrBusinessCategories(); ++i) {
            if (!this.getBusinessCategory(i).hasChanged()) continue;
            return true;
        }
        for (i = 0; i < this.nrBusinessColumns(); ++i) {
            if (!this.getBusinessColumn(i).hasChanged()) continue;
            return true;
        }
        return false;
    }

    @Override
    public void clearChanged() {
        int i;
        super.clearChanged();
        for (i = 0; i < this.nrBusinessCategories(); ++i) {
            this.getBusinessCategory(i).clearChanged();
        }
        for (i = 0; i < this.nrBusinessColumns(); ++i) {
            this.getBusinessColumn(i).clearChanged();
        }
    }

    public BusinessCategory findBusinessCategory(String id) {
        for (int i = 0; i < this.nrBusinessCategories(); ++i) {
            BusinessCategory businessCategory = this.getBusinessCategory(i);
            if (!businessCategory.getId().equalsIgnoreCase(id)) continue;
            return businessCategory;
        }
        return null;
    }

    public BusinessCategory findBusinessCategory(String locale, String categoryName) {
        for (int i = 0; i < this.nrBusinessCategories(); ++i) {
            BusinessCategory businessCategory = this.getBusinessCategory(i);
            if (!businessCategory.getDisplayName(locale).equalsIgnoreCase(categoryName)) continue;
            return businessCategory;
        }
        return this.findBusinessCategory(categoryName);
    }

    public BusinessCategory findBusinessCategoryForBusinessColumn(String id) {
        if (!this.isRootCategory()) {
            return null;
        }
        UniqueList<BusinessCategory> subCats = this.getBusinessCategories();
        BusinessCategory cat = null;
        Object bc = null;
        Object bcList = null;
        for (int i = 0; i < subCats.size(); ++i) {
            cat = subCats.get(i);
            if (cat == null || cat.findBusinessColumn(id) == null) continue;
            return cat;
        }
        return null;
    }

    public BusinessCategory findBusinessCategoryForBusinessColumn(BusinessColumn businessColumn) {
        return this.isRootCategory() && businessColumn != null ? this.findBusinessCategoryForBusinessColumn(businessColumn.getId()) : null;
    }
}

