/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.pms.mql;

import java.util.List;
import org.pentaho.di.core.database.DatabaseMeta;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.pms.messages.Messages;
import org.pentaho.pms.mql.PMSFormula;
import org.pentaho.pms.mql.Selection;
import org.pentaho.pms.schema.BusinessModel;
import org.pentaho.pms.schema.concept.ConceptUtilityBase;
import org.pentaho.pms.schema.concept.ConceptUtilityInterface;
import org.pentaho.pms.util.Const;

public class WhereCondition
extends ConceptUtilityBase
implements ConceptUtilityInterface {
    public static final String[] operators = new String[]{"AND", "OR", "AND NOT", "OR NOT"};
    public static final String[] comparators = new String[]{"=", "<>", "<", "<=", ">", ">="};
    private String operator = null;
    private String condition = null;
    private Boolean hasAgg = null;
    private PMSFormula formula = null;

    public WhereCondition(PMSFormula formula, String operator, String condition) throws PentahoMetadataException {
        this.operator = operator;
        this.condition = condition;
        this.formula = formula;
        formula.parseAndValidate();
    }

    public WhereCondition(BusinessModel model, DatabaseMeta databaseMeta, String operator, String condition) throws PentahoMetadataException {
        this.operator = operator;
        this.condition = condition;
        this.formula = new PMSFormula(model, databaseMeta, condition, null);
        this.formula.parseAndValidate();
    }

    public WhereCondition(BusinessModel model, String operator, String condition) throws PentahoMetadataException {
        this.operator = operator;
        this.condition = condition;
        this.formula = new PMSFormula(model, condition, null);
        this.formula.parseAndValidate();
    }

    public String getOperator() {
        return this.operator;
    }

    public PMSFormula getPMSFormula() {
        return this.formula;
    }

    public String getCondition() {
        return this.condition;
    }

    public List<Selection> getBusinessColumns() {
        return this.formula.getBusinessColumns();
    }

    @Override
    public boolean hasAggregate() {
        if (this.hasAgg == null) {
            this.hasAgg = Boolean.FALSE;
            for (Selection col : this.formula.getBusinessColumns()) {
                if (!col.hasAggregate()) continue;
                this.hasAgg = Boolean.TRUE;
                return this.hasAgg;
            }
        }
        return this.hasAgg;
    }

    @Override
    public String getModelElementDescription() {
        return Messages.getString("WhereCondition.USER_DESCRIPTION");
    }

    public String getWhereClause(String locale, boolean useOperator) throws PentahoMetadataException {
        String retval = "";
        if (this.condition != null) {
            retval = Const.isEmpty(this.operator) || !useOperator ? retval + Const.rightPad(" ", 9) + " " : retval + Const.rightPad(this.operator, 9) + " ";
            retval = retval + " ( " + this.formula.generateSQL(locale) + " ) ";
        }
        return retval;
    }
}

