/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.repository;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FilenameFilter;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.IConcept;
import org.pentaho.metadata.repository.DomainAlreadyExistsException;
import org.pentaho.metadata.repository.DomainIdNullException;
import org.pentaho.metadata.repository.DomainStorageException;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metadata.util.SecurityHelper;
import org.pentaho.metadata.util.SerializationService;

public class FileBasedMetadataDomainRepository
implements IMetadataDomainRepository {
    private static final Log logger = LogFactory.getLog(FileBasedMetadataDomainRepository.class);
    private static final String DOMAIN_SUFFIX = ".domain.xml";
    private static final String DEFAULT_DOMAIN_FOLDER = "domains";
    protected Map<String, Domain> domains = Collections.synchronizedMap(new HashMap());
    private String domainFolder = null;

    public void setDomainFolder(String folder) {
        this.domainFolder = folder;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void storeDomain(Domain domain, boolean overwrite) throws DomainIdNullException, DomainAlreadyExistsException, DomainStorageException {
        if (domain.getId() == null) {
            throw new DomainIdNullException(Messages.getErrorString("IMetadataDomainRepository.ERROR_0001_DOMAIN_ID_NULL", new Object[0]));
        }
        File folder = this.getDomainsFolder();
        if (!folder.exists()) {
            folder.mkdirs();
        }
        Map<String, Domain> map = this.domains;
        synchronized (map) {
            if (!overwrite && this.domains.get(domain.getId()) != null) {
                throw new DomainAlreadyExistsException(Messages.getErrorString("IMetadataDomainRepository.ERROR_0002_DOMAIN_OBJECT_EXISTS", domain.getId()));
            }
            File domainFile = new File(folder, this.getDomainFilename(domain.getId()));
            if (!overwrite && domainFile.exists()) {
                throw new DomainAlreadyExistsException(Messages.getErrorString("FileBasedMetadataDomainRepository.ERROR_0003_DOMAIN_FILE_EXISTS", domain.getId()));
            }
            SerializationService service = new SerializationService();
            FileOutputStream output = null;
            try {
                output = new FileOutputStream(domainFile);
                service.serializeDomain(domain, output);
            }
            catch (FileNotFoundException e) {
                throw new DomainStorageException(Messages.getErrorString("FileBasedMetadataDomainRepository.ERROR_0004_DOMAIN_STORAGE_EXCEPTION", new Object[0]), e);
            }
            finally {
                try {
                    if (output != null) {
                        output.close();
                    }
                }
                catch (IOException e) {
                    throw new DomainStorageException(Messages.getErrorString("FileBasedMetadataDomainRepository.ERROR_0004_DOMAIN_STORAGE_EXCEPTION", new Object[0]), e);
                }
            }
            this.domains.put(domain.getId(), domain);
        }
    }

    private String getDomainFilename(String id) {
        String cleansedName = id.replaceAll("[^a-zA-Z0-9_]", "_");
        return cleansedName + DOMAIN_SUFFIX;
    }

    @Override
    public Domain getDomain(String id) {
        Domain domain;
        if (this.domains.size() == 0) {
            this.reloadDomains();
        }
        if ((domain = this.domains.get(id)) == null) {
            domain = this.domains.get(id + "/metadata.xmi");
        }
        if (domain != null) {
            SecurityHelper helper = new SecurityHelper();
            Domain clone = helper.createSecureDomain(this, domain);
            return clone;
        }
        logger.error((Object)Messages.getErrorString("FileBasedMetadataDomainRepository.ERROR_0006_DOMAIN_NOT_FOUND", id));
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Set<String> getDomainIds() {
        if (this.domains.size() == 0) {
            this.reloadDomains();
        }
        TreeSet<String> set = null;
        Map<String, Domain> map = this.domains;
        synchronized (map) {
            set = new TreeSet<String>(this.domains.keySet());
        }
        return set;
    }

    protected File getDomainsFolder() {
        String domainsFolder = DEFAULT_DOMAIN_FOLDER;
        if (this.domainFolder != null) {
            domainsFolder = this.domainFolder;
        }
        File folder = new File(domainsFolder);
        return folder;
    }

    @Override
    public void flushDomains() {
        this.domains.clear();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void reloadDomains() {
        HashMap<String, Domain> localDomains = new HashMap<String, Domain>();
        SerializationService service = new SerializationService();
        File folder = this.getDomainsFolder();
        if (folder.exists()) {
            for (File file : folder.listFiles(new DomainFileNameFilter())) {
                FileInputStream fis = null;
                fis = new FileInputStream(file);
                Domain domain = service.deserializeDomain(fis);
                localDomains.put(domain.getId(), domain);
                if (fis == null) continue;
                try {
                    if (fis == null) continue;
                    fis.close();
                }
                catch (IOException e) {
                    logger.error((Object)Messages.getErrorString("FileBasedMetadataDomainRepository.ERROR_0005_FAILED_TO_LOAD_DOMAIN", file.getName()), (Throwable)e);
                }
                continue;
                catch (FileNotFoundException e) {
                    try {
                        logger.error((Object)Messages.getErrorString("FileBasedMetadataDomainRepository.ERROR_0005_FAILED_TO_LOAD_DOMAIN", file.getName()), (Throwable)e);
                        if (fis == null) continue;
                    }
                    catch (Throwable throwable) {
                        if (fis != null) {
                            try {
                                if (fis != null) {
                                    fis.close();
                                }
                            }
                            catch (IOException e2) {
                                logger.error((Object)Messages.getErrorString("FileBasedMetadataDomainRepository.ERROR_0005_FAILED_TO_LOAD_DOMAIN", file.getName()), (Throwable)e2);
                            }
                        }
                        throw throwable;
                    }
                    try {
                        if (fis == null) continue;
                        fis.close();
                    }
                    catch (IOException e3) {
                        logger.error((Object)Messages.getErrorString("FileBasedMetadataDomainRepository.ERROR_0005_FAILED_TO_LOAD_DOMAIN", file.getName()), (Throwable)e3);
                    }
                }
            }
        }
        File[] fileArray = this.domains;
        synchronized (this.domains) {
            this.domains.clear();
            this.domains.putAll(localDomains);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeDomain(String domainId) {
        Map<String, Domain> map = this.domains;
        synchronized (map) {
            File folder = this.getDomainsFolder();
            File domainFile = new File(folder, this.getDomainFilename(domainId));
            this.domains.remove(domainId);
            domainFile.delete();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void removeModel(String domainId, String modelId) throws DomainIdNullException, DomainStorageException {
        Map<String, Domain> map = this.domains;
        synchronized (map) {
            Domain domain = this.domains.get(domainId);
            if (domain == null) {
                throw new DomainIdNullException(Messages.getErrorString("IMetadataDomainRepository.ERROR_0001_DOMAIN_ID_NULL", new Object[0]));
            }
            Iterator<LogicalModel> iter = domain.getLogicalModels().iterator();
            while (iter.hasNext()) {
                LogicalModel model = iter.next();
                if (!modelId.equals(model.getId())) continue;
                iter.remove();
                break;
            }
            if (domain.getLogicalModels().size() == 0) {
                this.removeDomain(domainId);
            } else {
                try {
                    this.storeDomain(domain, true);
                }
                catch (DomainAlreadyExistsException e) {
                    logger.error((Object)Messages.getErrorString("FileBasedMetadataDomainRepository.ERROR_0007_DOMAIN_ALREADY_EXISTS", domain.getId()), (Throwable)e);
                }
            }
        }
    }

    @Override
    public String generateRowLevelSecurityConstraint(LogicalModel model) {
        return null;
    }

    @Override
    public boolean hasAccess(int accessType, IConcept aclHolder) {
        return true;
    }

    private static class DomainFileNameFilter
    implements FilenameFilter {
        private DomainFileNameFilter() {
        }

        @Override
        public boolean accept(File dir, String name) {
            return name.endsWith(FileBasedMetadataDomainRepository.DOMAIN_SUFFIX);
        }
    }
}

