/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.query.model.util;

import java.io.IOException;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.ArrayList;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.apache.commons.lang.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.pentaho.di.core.xml.XMLHandler;
import org.pentaho.metadata.messages.Messages;
import org.pentaho.metadata.model.Category;
import org.pentaho.metadata.model.Domain;
import org.pentaho.metadata.model.LogicalColumn;
import org.pentaho.metadata.model.LogicalModel;
import org.pentaho.metadata.model.concept.types.AggregationType;
import org.pentaho.metadata.model.concept.types.DataType;
import org.pentaho.metadata.query.model.CombinationType;
import org.pentaho.metadata.query.model.Constraint;
import org.pentaho.metadata.query.model.Order;
import org.pentaho.metadata.query.model.Parameter;
import org.pentaho.metadata.query.model.Query;
import org.pentaho.metadata.query.model.Selection;
import org.pentaho.metadata.repository.IMetadataDomainRepository;
import org.pentaho.metadata.util.XmiParser;
import org.pentaho.pms.core.exception.PentahoMetadataException;
import org.pentaho.reporting.libraries.base.util.CSVTokenizer;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

public class QueryXmlHelper {
    private static final Log logger = LogFactory.getLog(QueryXmlHelper.class);

    public String toXML(Query query) {
        if (query == null) {
            logger.error((Object)Messages.getErrorString("QueryXmlHelper.ERROR_0000_QUERY_MUST_NOT_BE_NULL", new Object[0]));
            return null;
        }
        try {
            StringWriter stringWriter = new StringWriter();
            StreamResult result = new StreamResult();
            result.setWriter(stringWriter);
            TransformerFactory factory = TransformerFactory.newInstance();
            Document doc = this.toDocument(query);
            if (doc != null) {
                factory.newTransformer().transform(new DOMSource(doc), result);
                return stringWriter.getBuffer().toString();
            }
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("QueryXmlHelper.ERROR_0001_TO_XML_FAILED", new Object[0]), (Throwable)e);
        }
        return null;
    }

    public Document toDocument(Query query) {
        if (query == null) {
            logger.error((Object)Messages.getErrorString("QueryXmlHelper.ERROR_0000_QUERY_MUST_NOT_BE_NULL", new Object[0]));
            return null;
        }
        try {
            DocumentBuilderFactory dbf = XmiParser.createSecureDocBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document doc = db.newDocument();
            Element mqlElement = doc.createElement("mql");
            doc.appendChild(mqlElement);
            if (this.addToDocument(mqlElement, doc, query)) {
                return doc;
            }
            return null;
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("QueryXmlHelper.ERROR_0002_TO_DOCUMENT_FAILED", new Object[0]), (Throwable)e);
            return null;
        }
    }

    protected boolean addToDocument(Element mqlElement, Document doc, Query query) {
        try {
            if (query.getDomain() == null) {
                logger.error((Object)Messages.getErrorString("QueryXmlHelper.ERROR_0003_META_SCHEMA_NULL", new Object[0]));
                return false;
            }
            if (query.getLogicalModel() == null) {
                logger.error((Object)Messages.getErrorString("QueryXmlHelper.ERROR_0004_BUSINESS_MODEL_NULL", new Object[0]));
                return false;
            }
            String data = query.getDomain().getId();
            if (data == null) {
                logger.error((Object)Messages.getErrorString("QueryXmlHelper.ERROR_0005_DOMAIN_ID_NULL", new Object[0]));
                return false;
            }
            this.addTextElement(doc, mqlElement, "domain_id", data);
            data = query.getLogicalModel().getId();
            if (data == null) {
                logger.error((Object)Messages.getErrorString("QueryXmlHelper.ERROR_0006_MODEL_ID_NULL", new Object[0]));
                return false;
            }
            this.addTextElement(doc, mqlElement, "model_id", data);
            Element optionsElement = doc.createElement("options");
            mqlElement.appendChild(optionsElement);
            this.addOptionsToDocument(doc, optionsElement, query);
            if (query.getParameters() != null && query.getParameters().size() > 0) {
                Element parametersElement = doc.createElement("parameters");
                mqlElement.appendChild(parametersElement);
                this.addParametersToDocument(doc, parametersElement, query);
            }
            Element selectionsElement = doc.createElement("selections");
            for (Selection selection : query.getSelections()) {
                Element selectionElement = doc.createElement("selection");
                this.addSelectionToDocument(doc, selection, selectionElement);
                selectionsElement.appendChild(selectionElement);
            }
            mqlElement.appendChild(selectionsElement);
            Element constraintsElement = doc.createElement("constraints");
            for (Constraint condition : query.getConstraints()) {
                Element constraintElement = doc.createElement("constraint");
                this.addConstraintToDocument(doc, condition, constraintElement);
                constraintsElement.appendChild(constraintElement);
            }
            mqlElement.appendChild(constraintsElement);
            Element element = doc.createElement("orders");
            for (Order order : query.getOrders()) {
                Element orderElement = doc.createElement("order");
                this.addOrderByToDocument(doc, order, orderElement);
                element.appendChild(orderElement);
            }
            mqlElement.appendChild(element);
        }
        catch (Exception e) {
            logger.error((Object)Messages.getErrorString("QueryXmlHelper.ERROR_0007_ADD_TO_DOCUMENT_FAILED", new Object[0]), (Throwable)e);
        }
        return true;
    }

    protected void addOptionsToDocument(Document doc, Element optionsElement, Query query) {
        this.addTextElement(doc, optionsElement, "disable_distinct", Boolean.toString(query.getDisableDistinct()));
        this.addTextElement(doc, optionsElement, "limit", String.valueOf(query.getLimit()));
    }

    protected void addParametersToDocument(Document doc, Element parametersElement, Query query) {
        for (Parameter param : query.getParameters()) {
            Element paramElement = doc.createElement("parameter");
            paramElement.setAttribute("name", param.getName());
            paramElement.setAttribute("type", param.getType().toString());
            paramElement.setAttribute("defaultValue", param.getDefaultValue() == null ? "" : param.getDefaultValue().toString());
            parametersElement.appendChild(paramElement);
        }
    }

    protected void addParameterFromXmlNode(Query query, Element paramElement) {
        String name = paramElement.getAttribute("name");
        String type = paramElement.getAttribute("type");
        String defaultValue = paramElement.getAttribute("defaultValue");
        Object defaultVal = null;
        if (name != null && type != null && StringUtils.isNotEmpty((String)defaultValue)) {
            DataType dataType = DataType.valueOf(type.toUpperCase());
            defaultVal = this.parseDefaultValue(defaultValue, dataType);
        }
        Parameter param = new Parameter(name, DataType.valueOf(type.toUpperCase()), defaultVal);
        query.getParameters().add(param);
    }

    protected Object parseDefaultValue(String defaultValue, DataType dataType) {
        if (defaultValue == null) {
            return null;
        }
        CSVTokenizer csvt = new CSVTokenizer(defaultValue, "|", "\"", true);
        switch (dataType) {
            case BOOLEAN: {
                return this.parseBooleanDefaultParam(defaultValue, csvt);
            }
            case NUMERIC: {
                return this.parseDoubleDefaultParam(defaultValue, csvt);
            }
        }
        return this.parseStringDefaultParam(defaultValue, csvt);
    }

    private Object parseBooleanDefaultParam(String defaultValue, CSVTokenizer csvt) {
        if (csvt.countTokens() == 1) {
            return Boolean.parseBoolean(csvt.nextToken());
        }
        ArrayList<Boolean> vals = new ArrayList<Boolean>();
        while (csvt.hasMoreTokens()) {
            String token = csvt.nextToken();
            vals.add(Boolean.parseBoolean(token));
        }
        return vals.toArray(new Boolean[0]);
    }

    private Object parseDoubleDefaultParam(String defaultValue, CSVTokenizer csvt) {
        if (csvt.countTokens() == 1) {
            return Double.parseDouble(csvt.nextToken());
        }
        ArrayList<Double> vals = new ArrayList<Double>();
        while (csvt.hasMoreTokens()) {
            String token = csvt.nextToken();
            vals.add(Double.parseDouble(token));
        }
        return vals.toArray(new Double[0]);
    }

    private Object parseStringDefaultParam(String defaultValue, CSVTokenizer csvt) {
        if (csvt.countTokens() == 1) {
            return csvt.nextToken();
        }
        ArrayList<String> vals = new ArrayList<String>();
        while (csvt.hasMoreTokens()) {
            String token = csvt.nextToken();
            vals.add(token);
        }
        return vals.toArray(new String[0]);
    }

    protected void addSelectionToDocument(Document doc, Selection selection, Element selectionElement) {
        this.addTextElement(doc, selectionElement, "view", selection.getCategory().getId());
        this.addTextElement(doc, selectionElement, "column", selection.getLogicalColumn().getId());
        if (selection.getAggregationType() != null) {
            this.addTextElement(doc, selectionElement, "aggregation", selection.getAggregationType().toString());
        }
    }

    protected void addConstraintToDocument(Document doc, Constraint constraint, Element constraintElement) {
        this.addTextElement(doc, constraintElement, "operator", constraint.getCombinationType() == null ? "" : constraint.getCombinationType().toString());
        this.addTextElement(doc, constraintElement, "condition", constraint.getFormula());
    }

    protected void addOrderByToDocument(Document doc, Order order, Element orderElement) {
        this.addTextElement(doc, orderElement, "direction", order.getType().toString());
        this.addTextElement(doc, orderElement, "view_id", order.getSelection().getCategory().getId());
        this.addTextElement(doc, orderElement, "column_id", order.getSelection().getLogicalColumn().getId());
        if (order.getSelection().getAggregationType() != null) {
            this.addTextElement(doc, orderElement, "aggregation", order.getSelection().getAggregationType().toString());
        }
    }

    protected void addTextElement(Document doc, Element element, String elementName, String text) {
        Element childElement = doc.createElement(elementName);
        childElement.appendChild(doc.createTextNode(text));
        element.appendChild(childElement);
    }

    public Query fromXML(IMetadataDomainRepository repo, String XML) throws PentahoMetadataException {
        Document doc;
        if (XML == null) {
            throw new PentahoMetadataException(Messages.getErrorString("QueryXmlHelper.ERROR_0008_XML_NULL", new Object[0]));
        }
        try {
            DocumentBuilderFactory dbf = XmiParser.createSecureDocBuilderFactory();
            DocumentBuilder db = dbf.newDocumentBuilder();
            doc = db.parse(new InputSource(new StringReader(XML)));
        }
        catch (ParserConfigurationException pcx) {
            throw new PentahoMetadataException(pcx);
        }
        catch (SAXException sex) {
            throw new PentahoMetadataException(sex);
        }
        catch (IOException iex) {
            throw new PentahoMetadataException(iex);
        }
        return this.fromXML(repo, doc);
    }

    public Query fromXML(IMetadataDomainRepository repo, Document doc) throws PentahoMetadataException {
        String domainId = this.getElementText(doc, "domain_id");
        Domain domain = repo.getDomain(domainId);
        if (domain == null) {
            if (domainId != null && !domainId.contains(".xmi")) {
                domain = repo.getDomain(domainId + ".xmi");
            }
            if (domain != null) {
                logger.warn((Object)String.format("Metadata model [%1$s] was requested, but the model doesn't exist. Substituting [%1$s.xmi] instead as a legacy fallback. Please change your reports to reference %1$s.xmi instead", domainId));
            }
        }
        if (domain == null) {
            logger.error((Object)String.format("Metadata model [%1$s] doesn't exist. Please check the existence of the model", domainId));
            throw new PentahoMetadataException(Messages.getErrorString("QueryXmlHelper.ERROR_0009_DOMAIN_INSTANCE_NULL", domainId));
        }
        return this.fromXML(doc, domain);
    }

    protected Query fromXML(Document doc, Domain domain) throws PentahoMetadataException {
        String modelId = this.getElementText(doc, "model_id");
        LogicalModel model = domain.findLogicalModel(modelId);
        if (model == null) {
            throw new PentahoMetadataException(Messages.getErrorString("QueryXmlHelper.ERROR_0010_MODEL_NOT_FOUND", modelId));
        }
        Query query = new Query(domain, model);
        NodeList nList = doc.getElementsByTagName("options");
        if (nList != null) {
            for (int i = 0; i < nList.getLength(); ++i) {
                Element optionElement = (Element)nList.item(i);
                this.setOptionsFromXmlNode(query, optionElement);
            }
        }
        NodeList paramNodes = doc.getElementsByTagName("parameter");
        for (int idx = 0; idx < paramNodes.getLength(); ++idx) {
            Element paramElement = (Element)paramNodes.item(idx);
            this.addParameterFromXmlNode(query, paramElement);
        }
        NodeList nodes = doc.getElementsByTagName("selection");
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element selectionElement = (Element)nodes.item(idx);
            this.addSelectionFromXmlNode(query, selectionElement);
        }
        nodes = doc.getElementsByTagName("constraint");
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element constraintElement = (Element)nodes.item(idx);
            this.addConstraintFromXmlNode(query, constraintElement);
        }
        nodes = doc.getElementsByTagName("order");
        for (int idx = 0; idx < nodes.getLength(); ++idx) {
            Element orderElement = (Element)nodes.item(idx);
            this.addOrderByFromXmlNode(query, orderElement);
        }
        return query;
    }

    protected void setOptionsFromXmlNode(Query query, Element optionElement) throws PentahoMetadataException {
        query.setDisableDistinct(false);
        query.setLimit(-1);
        if (optionElement != null) {
            String limitStr;
            String disableStr = this.getElementText(optionElement, "disable_distinct");
            if (disableStr != null) {
                query.setDisableDistinct(disableStr.equalsIgnoreCase("true"));
            }
            if ((limitStr = this.getElementText(optionElement, "limit")) != null) {
                try {
                    query.setLimit(Integer.parseInt(limitStr));
                }
                catch (NumberFormatException e) {
                    throw new PentahoMetadataException(Messages.getErrorString("QueryXmlHelper.ERROR_0017_CANNOT_PARSE_LIMIT", new Object[0]));
                }
            }
        }
    }

    protected void addSelectionFromXmlNode(Query query, Element selectionElement) {
        NodeList viewnodes = selectionElement.getElementsByTagName("view");
        NodeList nodes = selectionElement.getElementsByTagName("column");
        if (nodes.getLength() == 0) {
            return;
        }
        String columnId = XMLHandler.getNodeValue((Node)nodes.item(0));
        String viewId = null;
        Category category = null;
        if (viewnodes.getLength() != 0) {
            viewId = XMLHandler.getNodeValue((Node)viewnodes.item(0));
            category = query.getLogicalModel().findCategory(viewId);
        }
        LogicalColumn column = null;
        column = category != null ? category.findLogicalColumn(columnId) : query.getLogicalModel().findLogicalColumnInCategories(columnId);
        if (column != null) {
            AggregationType aggsetting = null;
            NodeList aggnodes = selectionElement.getElementsByTagName("aggregation");
            if (aggnodes.getLength() > 0) {
                String aggvalue = XMLHandler.getNodeValue((Node)aggnodes.item(0));
                AggregationType setting = AggregationType.valueOf(aggvalue.toUpperCase());
                if (setting == null) {
                    Messages.getErrorString("QueryXmlHelper.ERROR_0011_AGG_NOT_RECOGNIZED", columnId, aggvalue);
                } else if (column.getAggregationType() == setting || column.getAggregationList() != null && column.getAggregationList().contains((Object)setting)) {
                    aggsetting = setting;
                } else {
                    Messages.getErrorString("QueryXmlHelper.ERROR_0012_INVALID_AGG_FOR_BUSINESS_COL", columnId, aggvalue);
                }
            }
            query.getSelections().add(new Selection(category, column, aggsetting));
        } else {
            Messages.getErrorString("QueryXmlHelper.ERROR_0013_BUSINESS_COL_NOT_FOUND", viewId, columnId);
        }
    }

    protected void addConstraintFromXmlNode(Query query, Element constraintElement) throws PentahoMetadataException {
        NodeList nodes = constraintElement.getElementsByTagName("operator");
        String operator = null;
        if (nodes.getLength() > 0) {
            operator = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if (operator == null || operator.trim().equals("")) {
            operator = "AND";
        }
        nodes = constraintElement.getElementsByTagName("condition");
        String cond = null;
        if (nodes.getLength() > 0) {
            cond = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        nodes = constraintElement.getElementsByTagName("view_id");
        String view_id = null;
        if (nodes.getLength() > 0) {
            view_id = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        nodes = constraintElement.getElementsByTagName("column_id");
        String column_id = null;
        if (nodes.getLength() > 0) {
            column_id = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if (cond == null) {
            throw new PentahoMetadataException(Messages.getErrorString("QueryXmlHelper.ERROR_0014_NULL_CONDITION", new Object[0]));
        }
        if (view_id == null || column_id == null) {
            query.getConstraints().add(new Constraint(CombinationType.getCombinationType(operator.toUpperCase()), cond));
        } else {
            query.getConstraints().add(new Constraint(CombinationType.getCombinationType(operator.toUpperCase()), "[" + view_id + "." + column_id + "] " + cond));
        }
    }

    protected void addOrderByFromXmlNode(Query query, Element orderElement) throws PentahoMetadataException {
        String orderTypeStr;
        String view_id = null;
        String column_id = null;
        String aggregation = null;
        Order.Type orderType = Order.Type.ASC;
        NodeList nodes = orderElement.getElementsByTagName("direction");
        if (nodes.getLength() > 0 && (orderTypeStr = XMLHandler.getNodeValue((Node)nodes.item(0))) != null) {
            orderType = Order.Type.valueOf(orderTypeStr.toUpperCase());
        }
        if ((nodes = orderElement.getElementsByTagName("view_id")).getLength() > 0) {
            view_id = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if ((nodes = orderElement.getElementsByTagName("column_id")).getLength() > 0) {
            column_id = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if ((nodes = orderElement.getElementsByTagName("aggregation")).getLength() > 0) {
            aggregation = XMLHandler.getNodeValue((Node)nodes.item(0));
        }
        if (view_id != null && column_id != null) {
            this.addOrderBy(query, view_id, column_id, aggregation, orderType);
        }
    }

    protected void addOrderBy(Query query, String categoryId, String columnId, String aggregation, Order.Type orderType) throws PentahoMetadataException {
        Category category = query.getLogicalModel().findCategory(categoryId);
        if (category == null) {
            throw new PentahoMetadataException(Messages.getErrorString("QueryXmlHelper.ERROR_0015_BUSINESS_CATEGORY_NOT_FOUND", categoryId));
        }
        this.addOrderBy(query, category, columnId, aggregation, orderType);
    }

    protected void addOrderBy(Query query, Category category, String columnId, String aggregation, Order.Type orderType) throws PentahoMetadataException {
        if (category == null) {
            throw new PentahoMetadataException(Messages.getErrorString("QueryXmlHelper.ERROR_0016_BUSINESS_CATEGORY_NULL", new Object[0]));
        }
        LogicalColumn column = category.findLogicalColumn(columnId);
        if (column == null) {
            throw new PentahoMetadataException(Messages.getErrorString("QueryXmlHelper.ERROR_0013_BUSINESS_COL_NOT_FOUND", category.getId(), columnId));
        }
        AggregationType aggsetting = null;
        if (aggregation != null) {
            AggregationType setting = AggregationType.valueOf(aggregation.toUpperCase());
            if (column.getAggregationType() == setting || column.getAggregationList() != null && column.getAggregationList().contains((Object)setting)) {
                aggsetting = setting;
            }
        }
        query.getOrders().add(new Order(new Selection(category, column, aggsetting), orderType));
    }

    protected String getElementText(Element ele, String name) {
        try {
            return ele.getElementsByTagName(name).item(0).getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            return null;
        }
    }

    protected String getElementText(Document doc, String name) {
        try {
            return doc.getElementsByTagName(name).item(0).getFirstChild().getNodeValue();
        }
        catch (Exception e) {
            return null;
        }
    }
}

