/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.metadata.model.concept.util;

import java.text.DecimalFormat;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;
import org.pentaho.di.core.util.DateDetector;
import org.pentaho.metadata.model.concept.types.DataType;

public class DataFormatter {
    static final Logger log = LogManager.getLogger(DataFormatter.class);

    public static String getFormatedString(String datatype, String mask, Object data) {
        return DataFormatter.getFormatedString(DataType.valueOf(datatype), mask, data);
    }

    public static String getFormatedString(DataType dataType, String mask, Object data) {
        try {
            switch (dataType) {
                case NUMERIC: {
                    DecimalFormat decimalFormat = new DecimalFormat(mask);
                    decimalFormat.setParseBigDecimal(true);
                    return decimalFormat.format(data);
                }
                case DATE: {
                    SimpleDateFormat simpleDateFormat = new SimpleDateFormat(mask);
                    if (data instanceof Date) {
                        return simpleDateFormat.format(data);
                    }
                    Date dateFromstring = DateDetector.getDateFromString((String)String.valueOf(data));
                    return simpleDateFormat.format(dateFromstring);
                }
            }
            return String.valueOf(data);
        }
        catch (Exception e) {
            log.debug(DataFormatter.class.getName() + " could not apply mask to data. The original data was returned");
            return String.valueOf(data);
        }
    }
}

