/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.webpackage.core.impl;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.net.URL;
import java.net.URLConnection;
import java.util.Collections;
import java.util.Map;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;
import org.pentaho.webpackage.core.IPentahoWebPackage;

public final class PentahoWebPackageImpl
implements IPentahoWebPackage {
    private final String name;
    private final String version;
    private final String resourceRootPath;
    private final URL packageJsonUrl;

    public PentahoWebPackageImpl(String resourceRootPath, URL packageJsonUrl) {
        this.resourceRootPath = resourceRootPath;
        this.packageJsonUrl = packageJsonUrl;
        Map<String, Object> packageJson = this.getPackageJson();
        this.name = (String)packageJson.get("name");
        this.version = (String)packageJson.get("version");
        if (this.name == null || this.version == null) {
            throw new IllegalArgumentException("Cannot create WebPackage with null Name or Version.");
        }
    }

    public String getName() {
        return this.name;
    }

    public String getVersion() {
        return this.version;
    }

    public String getResourceRootPath() {
        return this.resourceRootPath;
    }

    public String getWebRootPath() {
        return "/" + this.getName() + "@" + this.getVersion();
    }

    public Map<String, Object> getPackageJson() {
        try {
            URLConnection urlConnection = this.packageJsonUrl.openConnection();
            urlConnection.connect();
            InputStream inputStream = urlConnection.getInputStream();
            InputStreamReader inputStreamReader = new InputStreamReader(inputStream);
            BufferedReader bufferedReader = new BufferedReader(inputStreamReader);
            return (Map)new JSONParser().parse((Reader)bufferedReader);
        }
        catch (IOException | ParseException throwable) {
            return Collections.emptyMap();
        }
    }
}

