/*
 * Decompiled with CFR 0.152.
 */
package org.pentaho.di.engine.configuration.impl.spark;

import java.util.ArrayList;
import org.eclipse.swt.events.SelectionAdapter;
import org.eclipse.swt.events.SelectionEvent;
import org.eclipse.swt.layout.GridData;
import org.eclipse.swt.layout.GridLayout;
import org.eclipse.swt.widgets.Button;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Label;
import org.eclipse.swt.widgets.Layout;
import org.pentaho.di.core.util.Utils;
import org.pentaho.di.core.variables.VariableSpace;
import org.pentaho.di.core.variables.Variables;
import org.pentaho.di.engine.configuration.api.RunConfigurationDialog;
import org.pentaho.di.engine.configuration.api.RunConfigurationUI;
import org.pentaho.di.engine.configuration.impl.spark.SparkRunConfiguration;
import org.pentaho.di.i18n.BaseMessages;
import org.pentaho.di.ui.core.PropsUI;
import org.pentaho.di.ui.core.widget.ComboVar;
import org.pentaho.di.ui.core.widget.TextVar;

public class SparkRunConfigurationUI
implements RunConfigurationUI {
    private static Class<?> PKG = SparkRunConfigurationUI.class;
    private PropsUI props = PropsUI.getInstance();
    private SparkRunConfiguration sparkRunConfiguration;

    public SparkRunConfigurationUI(SparkRunConfiguration sparkRunConfiguration) {
        this.sparkRunConfiguration = sparkRunConfiguration;
    }

    public void attach(RunConfigurationDialog runConfigurationDialog) {
        ArrayList<String> schemas = new ArrayList<String>();
        schemas.add("http://");
        schemas.add("https://");
        GridData protocolLabelData = new GridData(0, 4, false, false);
        GridData urlLabelData = new GridData(4, 4, true, false);
        GridLayout gridLayout = new GridLayout(2, false);
        runConfigurationDialog.getGroup().setLayout((Layout)gridLayout);
        Label schemaLabel = new Label((Composite)runConfigurationDialog.getGroup(), 16384);
        this.props.setLook((Control)schemaLabel);
        schemaLabel.setText(BaseMessages.getString(PKG, (String)"SparkRunConfigurationDialog.Label.Schema", (String[])new String[0]));
        schemaLabel.setLayoutData((Object)protocolLabelData);
        Label optionLabel = new Label((Composite)runConfigurationDialog.getGroup(), 16384);
        this.props.setLook((Control)optionLabel);
        optionLabel.setText(BaseMessages.getString(PKG, (String)"SparkRunConfigurationDialog.Label.URL", (String[])new String[0]));
        optionLabel.setLayoutData((Object)urlLabelData);
        Variables variableSpace = new Variables();
        variableSpace.initializeVariablesFrom(null);
        final ComboVar schemaCombo = new ComboVar((VariableSpace)variableSpace, (Composite)runConfigurationDialog.getGroup(), 2060);
        schemaCombo.setEditable(true);
        for (String schema : schemas) {
            schemaCombo.add(schema);
        }
        schemaCombo.addSelectionListener(new SelectionAdapter(){

            public void widgetSelected(SelectionEvent selectionEvent) {
                String schema = schemaCombo.getText();
                SparkRunConfigurationUI.this.sparkRunConfiguration.setSchema(schema);
            }
        });
        int selected = schemas.indexOf(this.sparkRunConfiguration.getSchema());
        schemaCombo.select(selected);
        GridData protocolData = new GridData(0, 4, false, false);
        schemaCombo.setLayoutData((Object)protocolData);
        TextVar urlText = new TextVar((VariableSpace)variableSpace, (Composite)runConfigurationDialog.getGroup(), 18436);
        this.props.setLook((Control)urlText);
        urlText.setText(this.sparkRunConfiguration.getUrl());
        GridData urlData = new GridData(4, 4, true, false);
        urlText.setLayoutData((Object)urlData);
        urlText.addModifyListener(modifyEvent -> {
            this.sparkRunConfiguration.setUrl(urlText.getText());
            Button okButton = runConfigurationDialog.getOKButton();
            okButton.setEnabled(!Utils.isEmpty((CharSequence)this.sparkRunConfiguration.getUrl()));
        });
    }
}

